"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateAttachmentRequest = void 0;
const ExtensionMethods_1 = require("../../ExtensionMethods");
const EwsUtilities_1 = require("../EwsUtilities");
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const ItemAttachment_1 = require("../../ComplexProperties/ItemAttachment");
const XmlAttributeNames_1 = require("../XmlAttributeNames");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const CreateAttachmentResponse_1 = require("../Responses/CreateAttachmentResponse");
const MultiResponseServiceRequest_1 = require("./MultiResponseServiceRequest");
/**
 * @internal Represents a CreateAttachment request.
 * @sealed
 */
class CreateAttachmentRequest extends MultiResponseServiceRequest_1.MultiResponseServiceRequest {
    /**
     * @internal Initializes a new instance of the **CreateAttachmentRequest** class.
     *
     * @param   {ExchangeService}       service             The service.
     * @param   {ServiceErrorHandling}  errorHandlingMode   Indicates how errors should be handled.
     */
    constructor(service, errorHandlingMode) {
        super(service, errorHandlingMode);
        this.parentItemId = null;
        this.attachments = [];
    }
    /**
     * @internal Gets a value indicating whether the TimeZoneContext SOAP header should be emitted.
     */
    get EmitTimeZoneHeader() {
        for (let itemAttachment of ExtensionMethods_1.ArrayHelper.OfType(this.attachments, (item) => item instanceof ItemAttachment_1.ItemAttachment)) {
            if ((itemAttachment.Item != null) && itemAttachment.Item.GetIsTimeZoneHeaderRequired(false /* isUpdateOperation */)) {
                return true;
            }
        }
        return false;
    }
    /**
     * Gets the attachments.
     */
    get Attachments() {
        return this.attachments;
    }
    set ParentItemId(value) {
        this.parentItemId = value;
    }
    /**
     * Gets or sets the parent item id.
     * @value   The parent item id.
     */
    get ParentItemId() {
        return this.parentItemId;
    }
    /**
     * @internal Creates the service response.
     *
     * @param   {ExchangeService}   service         The service.
     * @param   {number}            responseIndex   Index of the response.
     * @return  {CreateAttachmentResponse}     Service response.
     */
    CreateServiceResponse(service, responseIndex) {
        return new CreateAttachmentResponse_1.CreateAttachmentResponse(this.Attachments[responseIndex]);
    }
    /**
     * @internal Gets the expected response message count.
     *
     * @return  {number}      Number of expected response messages.
     */
    GetExpectedResponseMessageCount() {
        return this.Attachments.length;
    }
    /**
     * @internal Gets the request version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this request is supported.
     */
    GetMinimumRequiredServerVersion() {
        return ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1;
    }
    /**
     * @internal Gets the name of the response message XML element.
     *
     * @return  {string}      XML element name,
     */
    GetResponseMessageXmlElementName() {
        return XmlElementNames_1.XmlElementNames.CreateAttachmentResponseMessage;
    }
    /**
     * @internal Gets the name of the response XML element.
     *
     * @return  {string}      XML element name,
     */
    GetResponseXmlElementName() {
        return XmlElementNames_1.XmlElementNames.CreateAttachmentResponse;
    }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      XML element name,
     */
    GetXmlElementName() {
        return XmlElementNames_1.XmlElementNames.CreateAttachment;
    }
    /**
     * @internal Validate request.
     */
    Validate() {
        super.Validate();
        EwsUtilities_1.EwsUtilities.ValidateParam(this.ParentItemId, "ParentItemId");
    }
    /**
     * @internal Writes the elements to XML writer.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.ParentItemId);
        writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.Id, this.ParentItemId);
        writer.WriteEndElement();
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.Attachments);
        for (let attachment of this.Attachments) {
            attachment.WriteToXml(writer, attachment.GetXmlElementName());
        }
        writer.WriteEndElement();
    }
}
exports.CreateAttachmentRequest = CreateAttachmentRequest;
//# sourceMappingURL=CreateAttachmentRequest.js.map