"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EwsServiceJsonReader = void 0;
const ServiceLocalException_1 = require("../Exceptions/ServiceLocalException");
const ExtensionMethods_1 = require("../ExtensionMethods");
class EwsServiceJsonReader {
    //Service: ExchangeService;
    // constructor(service: ExchangeService){
    // 	this.Service = service;
    // }
    static ReadAsArray(jsObject, xmlElementName) {
        if (!jsObject || !jsObject[xmlElementName]) {
            return [];
            //throw new Error("EwsServiceJsonReader - ReadAsArray - json property not found");
        }
        var collectionItems = jsObject[xmlElementName];
        if (!Array.isArray(collectionItems)) {
            collectionItems = [collectionItems];
        }
        return collectionItems;
    }
    static ReadBase64ElementValue(obj) {
        return ExtensionMethods_1.base64Helper.atob(obj);
    }
    static ReadServiceObjectsCollectionFromJson(jsonResponse /*JsonObject*/, service, collectionJsonElementName, getObjectInstanceDelegate, clearPropertyBag, requestedPropertySet, summaryPropertiesOnly) {
        var serviceObjects = [];
        var serviceObject = null;
        var collectionItems = jsonResponse[collectionJsonElementName];
        for (var key in collectionItems) {
            if (key.indexOf("__") === 0)
                continue;
            var jsonServiceObjects = collectionItems[key];
            if (!Array.isArray(jsonServiceObjects)) {
                jsonServiceObjects = [jsonServiceObjects];
            }
            for (var jsonServiceObject of jsonServiceObjects) {
                if (jsonServiceObject != null) {
                    var typeName = ExtensionMethods_1.TypeSystem.GetJsObjectTypeName(jsonServiceObject);
                    if (ExtensionMethods_1.StringHelper.IsNullOrEmpty(typeName))
                        debugger; //check why typeName is empty - may be invalid xml parsing by xml2js
                    serviceObject = getObjectInstanceDelegate(service, typeName || key);
                    if (serviceObject != null) {
                        if ((typeName || key) !== serviceObject.GetXmlElementName()) { //string.Compare(jsonServiceObject.ReadTypeString(), serviceObject.GetXmlElementName(), StringComparison.Ordinal) != 0)                        
                            throw new ServiceLocalException_1.ServiceLocalException(ExtensionMethods_1.StringHelper.Format("The type of the object in the store ({0}) does not match that of the local object ({1}).", typeName, serviceObject.GetXmlElementName()));
                        }
                        serviceObject.LoadFromXmlJsObject(jsonServiceObject, service, clearPropertyBag, requestedPropertySet, summaryPropertiesOnly);
                        serviceObjects.push(serviceObject);
                    }
                    // else
                    //     debugger;
                }
            }
        }
        return serviceObjects;
    }
}
exports.EwsServiceJsonReader = EwsServiceJsonReader;
//# sourceMappingURL=EwsServiceJsonReader.js.map