"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VotingOptionData = void 0;
const SendPrompt_1 = require("../Enumerations/SendPrompt");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const ComplexProperty_1 = require("./ComplexProperty");
/**
 * Represents voting option information.
 * @sealed
 */
class VotingOptionData extends ComplexProperty_1.ComplexProperty {
    /**
     * @internal Initializes a new instance of the **VotingOptionData** class.
     */
    constructor() {
        super();
        this.displayName = null;
        this.sendPrompt = SendPrompt_1.SendPrompt.None;
    }
    /**
     * Gets the display name for the voting option.
     */
    get DisplayName() {
        return this.displayName;
    }
    /**
     * Gets the send prompt.
     */
    get SendPrompt() {
        return this.sendPrompt;
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}				jsObject	Json Object converted from XML.
     * @param   {ExchangeService}	service	The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        for (let key in jsObject) {
            switch (key) {
                case XmlElementNames_1.XmlElementNames.VotingOptionDisplayName:
                    this.displayName = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.SendPrompt:
                    this.sendPrompt = SendPrompt_1.SendPrompt[jsObject[key]];
                    break;
                default:
                    break;
            }
        }
    }
}
exports.VotingOptionData = VotingOptionData;
//# sourceMappingURL=VotingOptionData.js.map