"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UrlEntityCollection = void 0;
const XmlElementNames_1 = require("../Core/XmlElementNames");
const UrlEntity_1 = require("./UrlEntity");
const ComplexPropertyCollection_1 = require("./ComplexPropertyCollection");
/**
 * Represents a collection of UrlEntity objects.
 */
class UrlEntityCollection extends ComplexPropertyCollection_1.ComplexPropertyCollection {
    constructor(collection = null) {
        super();
        if (collection != null) {
            collection.forEach((entity) => { this.InternalAdd(entity); });
        }
    }
    /**
     * @internal Creates the complex property.
     *
     * @param   {string}        xmlElementName   Name of the XML element.
     * @return  {UrlEntity}     UrlEntity.
     */
    CreateComplexProperty(xmlElementName) { return new UrlEntity_1.UrlEntity(); }
    /**
     * @internal Creates the default complex property.
     *
     * @return  {UrlEntity}      UrlEntity.
     */
    CreateDefaultComplexProperty() { return new UrlEntity_1.UrlEntity(); }
    /**
     * @internal Gets the name of the collection item XML element.
     *
     * @param   {UrlEntity}     complexProperty   The complex property.
     * @return  {string}        XML element name.
     */
    GetCollectionItemXmlElementName(complexProperty) { return XmlElementNames_1.XmlElementNames.NlgUrl; }
}
exports.UrlEntityCollection = UrlEntityCollection;
//# sourceMappingURL=UrlEntityCollection.js.map