"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TaskSuggestionCollection = void 0;
const XmlElementNames_1 = require("../Core/XmlElementNames");
const TaskSuggestion_1 = require("./TaskSuggestion");
const ComplexPropertyCollection_1 = require("./ComplexPropertyCollection");
/**
 * Represents a collection of TaskSuggestion objects.
 */
class TaskSuggestionCollection extends ComplexPropertyCollection_1.ComplexPropertyCollection {
    constructor(collection = null) {
        super();
        if (collection != null) {
            collection.forEach((suggestion) => { this.InternalAdd(suggestion); });
        }
    }
    /**
     * @internal Creates the complex property.
     *
     * @param   {string}            xmlElementName   Name of the XML element.
     * @return  {TaskSuggestion}    TaskSuggestion.
     */
    CreateComplexProperty(xmlElementName) { return new TaskSuggestion_1.TaskSuggestion(); }
    /**
     * @internal Creates the default complex property.
     *
     * @return  {TaskSuggestion}      TaskSuggestion.
     */
    CreateDefaultComplexProperty() { return new TaskSuggestion_1.TaskSuggestion(); }
    /**
     * @internal Gets the name of the collection item XML element.
     *
     * @param   {TaskSuggestion}    complexProperty   The complex property.
     * @return  {string}            XML element name.
     */
    GetCollectionItemXmlElementName(complexProperty) { return XmlElementNames_1.XmlElementNames.NlgTaskSuggestion; }
}
exports.TaskSuggestionCollection = TaskSuggestionCollection;
//# sourceMappingURL=TaskSuggestionCollection.js.map