"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RuleErrorCollection = void 0;
const XmlElementNames_1 = require("../Core/XmlElementNames");
const RuleError_1 = require("./RuleError");
const ComplexPropertyCollection_1 = require("./ComplexPropertyCollection");
/**
 * @internal Represents a collection of rule validation errors.
 *
 * @sealed
 */
class RuleErrorCollection extends ComplexPropertyCollection_1.ComplexPropertyCollection {
    /**
     * @internal Initializes a new instance of the **RuleErrorCollection** class.
     */
    constructor() {
        super();
    }
    /**
     * @internal Creates an RuleError object from an XML element name.
     *
     * @param   {string}   xmlElementName   The XML element name from which to create the RuleError object.
     * @return  {RuleError}        A RuleError object.
     */
    CreateComplexProperty(xmlElementName) {
        if (xmlElementName == XmlElementNames_1.XmlElementNames.Error) {
            return new RuleError_1.RuleError();
        }
        else {
            return null;
        }
    }
    /**
     * @internal Creates the default complex property.
     *
     * @return  {RuleError}      A RuleError object.
     */
    CreateDefaultComplexProperty() {
        return new RuleError_1.RuleError();
    }
    /**
     * @internal Retrieves the XML element name corresponding to the provided RuleError object.
     *
     * @param   {RuleError}		ruleValidationError   The RuleError object from which to determine the XML element name.
     * @return  {string}		The XML element name corresponding to the provided RuleError object.
     */
    GetCollectionItemXmlElementName(ruleValidationError) {
        return XmlElementNames_1.XmlElementNames.Error;
    }
}
exports.RuleErrorCollection = RuleErrorCollection;
//# sourceMappingURL=RuleErrorCollection.js.map