"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RetentionTagBase = void 0;
const Guid_1 = require("../Guid");
const ExtensionMethods_1 = require("../ExtensionMethods");
const XmlAttributeNames_1 = require("../Core/XmlAttributeNames");
const ComplexProperty_1 = require("./ComplexProperty");
/**
 * Represents the retention tag of an item.
 */
class RetentionTagBase extends ComplexProperty_1.ComplexProperty {
    /**
     * Initializes a new instance of the **RetentionTagBase** class.
     *
     * @param {string}  xmlElementName   Xml element name.
     */
    constructor(xmlElementName) {
        super();
        /**
         * Xml element name.
         */
        this.xmlElementName = null;
        /**
         * Is explicit.
         */
        this.isExplicit = false;
        /**
         * Retention id.
         */
        this.retentionId = null;
        this.xmlElementName = xmlElementName;
    }
    /**
     * Gets or sets if the tag is explicit.
     */
    get IsExplicit() {
        return this.isExplicit;
    }
    set IsExplicit(value) {
        this.SetFieldValue({ getValue: () => this.isExplicit, setValue: (updateValue) => { this.isExplicit = updateValue; } }, value);
    }
    /**
     * Gets or sets the retention id.
     */
    get RetentionId() {
        return this.retentionId;
    }
    set RetentionId(value) {
        this.SetFieldValue({ getValue: () => this.retentionId, setValue: (updateValue) => { this.retentionId = updateValue; } }, value);
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}				jsObject	Json Object converted from XML.
     * @param   {ExchangeService}	service	The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        for (let key in jsObject) {
            switch (key) {
                case XmlAttributeNames_1.XmlAttributeNames.IsExplicit:
                    this.isExplicit = ExtensionMethods_1.Convert.toBool(jsObject[key]);
                    break;
                case this.xmlElementName:
                    this.retentionId = new Guid_1.Guid(jsObject[key]);
                    break;
                default:
                    break;
            }
        }
    }
    /**
     * Returns a **String** that represents the current **Object**.
     *
     * @return  {string}      A **String** that represents the current **Object**.
     */
    ToString() {
        if (this.retentionId == null || this.retentionId == Guid_1.Guid.Empty) {
            return ExtensionMethods_1.StringHelper.Empty;
        }
        else {
            return this.retentionId.ToString();
        }
    }
    toString() { return this.ToString(); }
    /**
     * @internal Writes attributes to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteAttributesToXml(writer) {
        writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.IsExplicit, this.isExplicit);
    }
    /**
     * @internal Writes elements to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        if (this.retentionId != null && this.retentionId != Guid_1.Guid.Empty) {
            writer.WriteValue(this.retentionId.ToString(), this.xmlElementName);
        }
    }
}
exports.RetentionTagBase = RetentionTagBase;
//# sourceMappingURL=RetentionTagBase.js.map