"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EndDateRecurrenceRange = void 0;
const EwsUtilities_1 = require("../../../Core/EwsUtilities");
const XmlElementNames_1 = require("../../../Core/XmlElementNames");
const XmlNamespace_1 = require("../../../Enumerations/XmlNamespace");
const RecurrenceRange_1 = require("./RecurrenceRange");
/**
 * @internal Represents recurrent range with an end date.
 */
class EndDateRecurrenceRange extends RecurrenceRange_1.RecurrenceRange {
    constructor(startDate, endDate = null) {
        if (arguments.length === 0) {
            super();
        }
        else {
            super(startDate);
        }
        this.endDate = endDate;
    }
    /**
     * @internal Gets the name of the XML element.
     *
     * @value   The name of the XML element.
     */
    get XmlElementName() {
        return XmlElementNames_1.XmlElementNames.EndDateRecurrence;
    }
    /**
     * Gets or sets the end date.
     *
     * @value   The end date.
     */
    get EndDate() {
        return this.endDate;
    }
    set EndDate(value) {
        this.SetFieldValue({ getValue: () => this.endDate, setValue: (updateValue) => { this.endDate = updateValue; } }, value);
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}                 jsObject                Json Object converted from XML.
     * @param   {ExchangeService}     service                 The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        super.LoadFromXmlJsObject(jsObject, service);
        for (let key in jsObject) {
            switch (key) {
                case XmlElementNames_1.XmlElementNames.EndDate:
                    this.endDate = service.ConvertStartDateToUnspecifiedDateTime(jsObject[key]);
                    break;
                default:
                    break;
            }
        }
    }
    /**
     * @internal Setups the recurrence.
     *
     * @param   {Recurrence}   recurrence   The recurrence.
     */
    SetupRecurrence(recurrence) {
        super.SetupRecurrence(recurrence);
        recurrence.EndDate = this.EndDate;
    }
    /**
     * @internal Writes the elements to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        super.WriteElementsToXml(writer);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.EndDate, EwsUtilities_1.EwsUtilities.DateTimeToXSDate(this.EndDate));
    }
}
exports.EndDateRecurrenceRange = EndDateRecurrenceRange;
//# sourceMappingURL=EndDateRecurrenceRange.js.map