"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RelativeMonthlyPattern = void 0;
const DayOfTheWeekIndex_1 = require("../../../Enumerations/DayOfTheWeekIndex");
const DayOfTheWeek_1 = require("../../../Enumerations/DayOfTheWeek");
const ServiceValidationException_1 = require("../../../Exceptions/ServiceValidationException");
const Strings_1 = require("../../../Strings");
const XmlElementNames_1 = require("../../../Core/XmlElementNames");
const XmlNamespace_1 = require("../../../Enumerations/XmlNamespace");
const Recurrence_IntervalPattern_1 = require("./Recurrence.IntervalPattern");
/**
 * Represents a recurrence pattern where each occurrence happens on a relative day a specific number of months after the previous one.
*/
class RelativeMonthlyPattern extends Recurrence_IntervalPattern_1.IntervalPattern {
    constructor(startDate, interval, dayOfTheWeek = null, dayOfTheWeekIndex = null) {
        if (arguments.length === 0) {
            super();
            this.dayOfTheWeek = null;
            this.dayOfTheWeekIndex = null;
            return;
        }
        super(startDate, interval);
        this.DayOfTheWeek = dayOfTheWeek;
        this.DayOfTheWeekIndex = dayOfTheWeekIndex;
    }
    /**
     * @internal Gets the name of the XML element.
     *
     * @value   The name of the XML element.
     */
    get XmlElementName() {
        return XmlElementNames_1.XmlElementNames.RelativeMonthlyRecurrence;
    }
    /**
     * Gets or sets the relative position of the day specified in DayOfTheWeek within the month.
     */
    get DayOfTheWeekIndex() {
        return super.GetFieldValueOrThrowIfNull(this.dayOfTheWeekIndex, "DayOfTheWeekIndex");
    }
    set DayOfTheWeekIndex(value) {
        this.SetFieldValue({ getValue: () => this.dayOfTheWeekIndex, setValue: (updateValue) => { this.dayOfTheWeekIndex = updateValue; } }, value);
    }
    /**
     * The day of the week when each occurrence happens.
     */
    get DayOfTheWeek() {
        return super.GetFieldValueOrThrowIfNull(this.dayOfTheWeek, "DayOfTheWeek");
    }
    set DayOfTheWeek(value) {
        this.SetFieldValue({ getValue: () => this.dayOfTheWeek, setValue: (updateValue) => { this.dayOfTheWeek = updateValue; } }, value);
    }
    /**
     * @internal Validates this instance.
     */
    InternalValidate() {
        super.InternalValidate();
        if (this.dayOfTheWeek === null) {
            throw new ServiceValidationException_1.ServiceValidationException(Strings_1.Strings.DayOfTheWeekMustBeSpecifiedForRecurrencePattern);
        }
        if (this.dayOfTheWeekIndex === null) {
            throw new ServiceValidationException_1.ServiceValidationException(Strings_1.Strings.DayOfWeekIndexMustBeSpecifiedForRecurrencePattern);
        }
    }
    /**
     * @internal Write properties to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    InternalWritePropertiesToXml(writer) {
        super.InternalWritePropertiesToXml(writer);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.DaysOfWeek, DayOfTheWeek_1.DayOfTheWeek[this.DayOfTheWeek]);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.DayOfWeekIndex, DayOfTheWeekIndex_1.DayOfTheWeekIndex[this.DayOfTheWeekIndex]);
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}                 jsObject                Json Object converted from XML.
     * @param   {ExchangeService}     service                 The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        super.LoadFromXmlJsObject(jsObject, service);
        for (let key in jsObject) {
            switch (key) {
                case XmlElementNames_1.XmlElementNames.DaysOfWeek:
                    this.dayOfTheWeek = DayOfTheWeek_1.DayOfTheWeek[jsObject[key]];
                    break;
                case XmlElementNames_1.XmlElementNames.DayOfWeekIndex:
                    this.dayOfTheWeekIndex = DayOfTheWeekIndex_1.DayOfTheWeekIndex[jsObject[key]];
                    break;
                default:
                    break;
            }
        }
    }
}
exports.RelativeMonthlyPattern = RelativeMonthlyPattern;
//# sourceMappingURL=Recurrence.RelativeMonthlyPattern.js.map