"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntervalPattern = void 0;
const ArgumentException_1 = require("../../../Exceptions/ArgumentException");
const Strings_1 = require("../../../Strings");
const XmlElementNames_1 = require("../../../Core/XmlElementNames");
const XmlNamespace_1 = require("../../../Enumerations/XmlNamespace");
const Recurrence_1 = require("./Recurrence");
/**
 * Represents a recurrence pattern where each occurrence happens at a specific interval after the previous one.
 */
class IntervalPattern extends Recurrence_1.Recurrence {
    constructor(startDate, interval = 1) {
        if (arguments.length === 0) {
            super();
            this.interval = 1;
            return;
        }
        super(startDate);
        if (interval < 1) {
            throw new ArgumentException_1.ArgumentOutOfRangeException("interval", Strings_1.Strings.IntervalMustBeGreaterOrEqualToOne);
        }
        this.Interval = interval;
    }
    /**
     * Gets or sets the interval between occurrences.
     */
    get Interval() {
        return this.interval;
    }
    set Interval(value) {
        if (value < 1) {
            throw new ArgumentException_1.ArgumentOutOfRangeException("value", Strings_1.Strings.IntervalMustBeGreaterOrEqualToOne);
        }
        this.SetFieldValue({ getValue: () => this.interval, setValue: (updateValue) => { this.interval = updateValue; } }, value);
    }
    /**
     * @internal Write properties to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    InternalWritePropertiesToXml(writer) {
        super.InternalWritePropertiesToXml(writer);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.Interval, this.Interval);
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}                 jsObject                Json Object converted from XML.
     * @param   {ExchangeService}     service                 The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        super.LoadFromXmlJsObject(jsObject, service);
        for (let key in jsObject) {
            switch (key) {
                case XmlElementNames_1.XmlElementNames.Interval:
                    this.interval = jsObject[key];
                    break;
                default:
                    break;
            }
        }
    }
}
exports.IntervalPattern = IntervalPattern;
//# sourceMappingURL=Recurrence.IntervalPattern.js.map