"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhoneNumberEntry = void 0;
const XmlAttributeNames_1 = require("../Core/XmlAttributeNames");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const PhoneNumberKey_1 = require("../Enumerations/PhoneNumberKey");
const DictionaryEntryProperty_1 = require("./DictionaryEntryProperty");
class PhoneNumberEntry extends DictionaryEntryProperty_1.DictionaryEntryProperty {
    constructor(key = PhoneNumberKey_1.PhoneNumberKey.AssistantPhone, phoneNumber = null) {
        super(key);
        this.phoneNumber = null;
        this.keyType = PhoneNumberKey_1.PhoneNumberKey;
        this.phoneNumber = phoneNumber;
    }
    get PhoneNumber() {
        return this.phoneNumber;
    }
    set PhoneNumber(value) {
        this.SetFieldValue({ getValue: () => this.phoneNumber, setValue: (address) => { this.phoneNumber = address; } }, value);
    }
    LoadFromXmlJsObject(jsonProperty, service) {
        this.Key = PhoneNumberKey_1.PhoneNumberKey[jsonProperty[XmlAttributeNames_1.XmlAttributeNames.Key]];
        this.phoneNumber = jsonProperty[XmlElementNames_1.XmlElementNames.Entry]; //PhoneNumber
    }
    /**@internal */
    WriteElementsToXml(writer) { writer.WriteValue(this.PhoneNumber, XmlElementNames_1.XmlElementNames.PhoneNumber); }
}
exports.PhoneNumberEntry = PhoneNumberEntry;
//# sourceMappingURL=PhoneNumberEntry.js.map