"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhoneEntity = void 0;
const XmlElementNames_1 = require("../Core/XmlElementNames");
const ExtractedEntity_1 = require("./ExtractedEntity");
/**
 * Represents an PhoneEntity object.
 */
class PhoneEntity extends ExtractedEntity_1.ExtractedEntity {
    /**
     * @internal Initializes a new instance of the **PhoneEntity** class.
     */
    constructor() {
        super();
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}				jsObject	Json Object converted from XML.
     * @param   {ExchangeService}	service	The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        super.LoadFromXmlJsObject(jsObject, service);
        for (let key in jsObject) {
            switch (key) {
                case XmlElementNames_1.XmlElementNames.NlgOriginalPhoneString:
                    this.OriginalPhoneString = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.NlgPhoneString:
                    this.PhoneString = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.NlgType:
                    this.Type = jsObject[key];
                    break;
                default:
                    break;
            }
        }
    }
}
exports.PhoneEntity = PhoneEntity;
//# sourceMappingURL=PhoneEntity.js.map