"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ItemIdCollection = void 0;
const ExtensionMethods_1 = require("../ExtensionMethods");
const EwsLogging_1 = require("../Core/EwsLogging");
const EwsServiceJsonReader_1 = require("../Core/EwsServiceJsonReader");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const ItemId_1 = require("./ItemId");
const ComplexPropertyCollection_1 = require("./ComplexPropertyCollection");
/**
 * Represents a collection of item Ids.
 *
 * @sealed
 */
class ItemIdCollection extends ComplexPropertyCollection_1.ComplexPropertyCollection {
    /**
     * @internal Initializes a new instance of the **ItemIdCollection** class.
     */
    constructor() {
        super();
    }
    /**
     * @internal Creates the complex property.
     *
     * @param   {string}    xmlElementName   Name of the XML element.
     * @return  {ItemId}    ItemId.
     */
    CreateComplexProperty(xmlElementName) {
        return new ItemId_1.ItemId();
    }
    /**
     * @internal Creates the default complex property.
     *
     * @return  {ItemId}      ItemId.
     */
    CreateDefaultComplexProperty() {
        return new ItemId_1.ItemId();
    }
    /**
     * @internal Loads from XMLJsObject collection to create a new collection item.
     *
     * @interface   IJsonCollectionDeserializer
     *
     * @param   {any}               jsObjectCollection   The json collection.
     * @param   {ExchangeService}   service          The service.
     */
    CreateFromXmlJsObjectCollection(jsObjectCollection, service) {
        let collection = jsObjectCollection;
        if (!ExtensionMethods_1.ArrayHelper.isArray(collection)) {
            if (jsObjectCollection[XmlElementNames_1.XmlElementNames.OccurrenceItemId]) {
                EwsLogging_1.EwsLogging.Log("Fix needed for ItemIdCollection for element OccurrenceItemId", true, true);
                EwsLogging_1.EwsLogging.Log(jsObjectCollection[XmlElementNames_1.XmlElementNames.OccurrenceItemId], true, true);
            }
            if (jsObjectCollection[XmlElementNames_1.XmlElementNames.RecurringMasterItemId]) {
                EwsLogging_1.EwsLogging.Log("Fix needed for ItemIdCollection for element RecurringMasterItemId", true, true);
                EwsLogging_1.EwsLogging.Log(jsObjectCollection[XmlElementNames_1.XmlElementNames.RecurringMasterItemId], true, true);
            }
            collection = EwsServiceJsonReader_1.EwsServiceJsonReader.ReadAsArray(collection, XmlElementNames_1.XmlElementNames.ItemId);
        }
        super.CreateFromXmlJsObjectCollection(collection, service);
    }
    /**
     * @internal Gets the name of the collection item XML element.
     *
     * @param   {ItemId}   complexProperty   The complex property.
     * @return  {string}                     XML element name.
     */
    GetCollectionItemXmlElementName(complexProperty) {
        return complexProperty.GetXmlElementName();
    }
    /**
     * @internal Loads from XMLJsObject collection to update collection Items.
     *
     * @interface   IJsonCollectionDeserializer
     *
     * @param   {any}               jsObjectCollection   The XMLJsObject collection.
     * @param   {ExchangeService}   service          The service.
     */
    UpdateFromXmlJsObjectCollection(jsObjectCollection, service) {
        let collection = jsObjectCollection;
        if (!ExtensionMethods_1.ArrayHelper.isArray(collection)) {
            collection = EwsServiceJsonReader_1.EwsServiceJsonReader.ReadAsArray(collection, XmlElementNames_1.XmlElementNames.ItemId);
        }
        super.UpdateFromXmlJsObjectCollection(collection, service);
    }
}
exports.ItemIdCollection = ItemIdCollection;
//# sourceMappingURL=ItemIdCollection.js.map