"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ItemAttachmentOf = void 0;
const ItemAttachment_1 = require("./ItemAttachment");
/**
 * Represents a strongly typed item attachment. **Workaround of ItemAttachment<TItem>** - not allowed in typescript to have two class, one generic and one non-generic
 */
class ItemAttachmentOf extends ItemAttachment_1.ItemAttachment {
    /**
     * Gets the item associated with the attachment.
     */
    get Item() { return this.item; }
    set Item(value) { /** this.Item = value; */ super._setItem(value); }
    /**
     * @internal Initializes a new instance of the **ItemAttachmentOf** class.
     *
     * @param   {Item}   owner   The owner of the attachment.
     */
    constructor(owner) {
        super(owner);
    }
}
exports.ItemAttachmentOf = ItemAttachmentOf;
//# sourceMappingURL=ItemAttachmentOf.js.map