"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InternetMessageHeaderCollection = void 0;
const XmlElementNames_1 = require("../Core/XmlElementNames");
const InternetMessageHeader_1 = require("./InternetMessageHeader");
const ComplexPropertyCollection_1 = require("./ComplexPropertyCollection");
/**
 * Represents a collection of Internet message headers.
 */
class InternetMessageHeaderCollection extends ComplexPropertyCollection_1.ComplexPropertyCollection {
    /**
     * @internal Initializes a new instance of the **InternetMessageHeaderCollection** class.
     */
    constructor() {
        super();
    }
    /**
     * @internal Creates the complex property.
     *
     * @param   {string}   xmlElementName   Name of the XML element.
     * @return  {InternetMessageHeader}     InternetMessageHeader instance.
     */
    CreateComplexProperty(xmlElementName) { return new InternetMessageHeader_1.InternetMessageHeader(); }
    /**
     * @internal Creates the default complex property.
     *
     * @return  {InternetMessageHeader}      InternetMessageHeader instance.
     */
    CreateDefaultComplexProperty() { return new InternetMessageHeader_1.InternetMessageHeader(); }
    /**
     * Find a specific header in the collection.
     *
     * @param   {string}   name   The name of the header to locate.
     * @return  {InternetMessageHeader}     An InternetMessageHeader representing the header with the specified name; null if no header with the specified name was found.
     */
    Find(name) {
        for (let internetMessageHeader of this.Items) {
            if (name.toUpperCase() === internetMessageHeader.Name.toUpperCase()) {
                return internetMessageHeader;
            }
        }
        return null;
    }
    /**
     * @internal Gets the name of the collection item XML element.
     *
     * @param   {InternetMessageHeader}     complexProperty   The complex property.
     * @return  {string}                    XML element name.
     */
    GetCollectionItemXmlElementName(complexProperty) { return XmlElementNames_1.XmlElementNames.InternetMessageHeader; }
}
exports.InternetMessageHeaderCollection = InternetMessageHeaderCollection;
//# sourceMappingURL=InternetMessageHeaderCollection.js.map