"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ImAddressDictionary = void 0;
const DictionaryKeyType_1 = require("../Enumerations/DictionaryKeyType");
const ImAddressEntry_1 = require("./ImAddressEntry");
const DictionaryProperty_1 = require("./DictionaryProperty");
class ImAddressDictionary extends DictionaryProperty_1.DictionaryProperty {
    constructor() {
        super(DictionaryKeyType_1.DictionaryKeyType.ImAddressKey);
    }
    _getItem(key) {
        return this.Entries.get(key).ImAddress;
    }
    _setItem(key, value) {
        if (value == null) {
            this.InternalRemove(key);
        }
        else {
            var entry = { outValue: null };
            if (this.Entries.tryGetValue(key, entry)) {
                entry.outValue.ImAddress = value;
                this.Changed();
            }
            else {
                let newEntry = new ImAddressEntry_1.ImAddressEntry(key, value);
                this.InternalAdd(newEntry);
            }
        }
    }
    CreateEntryInstance() { return new ImAddressEntry_1.ImAddressEntry(); }
    GetFieldURI() { return "contacts:ImAddress"; }
    TryGetValue(key, imAddress) {
        var entry = { outValue: null };
        if (this.Entries.tryGetValue(key, entry)) {
            imAddress.outValue = entry.outValue.ImAddress;
            return true;
        }
        else {
            imAddress.outValue = null;
            return false;
        }
    }
}
exports.ImAddressDictionary = ImAddressDictionary;
//# sourceMappingURL=ImAddressDictionary.js.map