"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HighlightTerm = void 0;
const XmlElementNames_1 = require("../Core/XmlElementNames");
const ComplexProperty_1 = require("./ComplexProperty");
/**
 * Represents an AQS highlight term.
 *
 * @sealed
 */
class HighlightTerm extends ComplexProperty_1.ComplexProperty {
    /**
     * @internal Initializes a new instance of the **HighlightTerm** class.
     */
    constructor() {
        super();
        /**
         * Term scope.
         */
        this.scope = null;
        /**
         * Term value.
         */
        this.value = null;
    }
    /**
     * Gets term scope.
     */
    get Scope() {
        return this.scope;
    }
    /**
     * Gets term value.
     */
    get Value() {
        return this.value;
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}				jsObject	Json Object converted from XML.
     * @param   {ExchangeService}	service	The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        if (jsObject[XmlElementNames_1.XmlElementNames.HighlightTermScope]) {
            this.scope = jsObject[XmlElementNames_1.XmlElementNames.HighlightTermScope];
        }
        if (jsObject[XmlElementNames_1.XmlElementNames.HighlightTermValue]) {
            this.value = jsObject[XmlElementNames_1.XmlElementNames.HighlightTermValue];
        }
    }
}
exports.HighlightTerm = HighlightTerm;
//# sourceMappingURL=HighlightTerm.js.map