"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FolderIdCollection = void 0;
const ArgumentException_1 = require("../Exceptions/ArgumentException");
const ExtensionMethods_1 = require("../ExtensionMethods");
const EwsUtilities_1 = require("../Core/EwsUtilities");
const Strings_1 = require("../Strings");
const FolderId_1 = require("./FolderId");
const ComplexPropertyCollection_1 = require("./ComplexPropertyCollection");
/**
 * Represents a collection of folder Ids.
 *
 * @sealed
 */
class FolderIdCollection extends ComplexPropertyCollection_1.ComplexPropertyCollection {
    constructor(folderIds = null) {
        super();
        if (folderIds != null) {
            folderIds.forEach((folderId) => this.InternalAdd(folderId));
        }
    }
    Add(folderIdOrName) {
        let folderId = null;
        if (typeof folderIdOrName === 'number') {
            folderId = new FolderId_1.FolderId(folderIdOrName);
            if (ExtensionMethods_1.ArrayHelper.Find(this.Items, (item) => item.FolderName === folderIdOrName)) { //if (this.Contains(folderIdOrName)) { // can not use in JavaScript
                throw new ArgumentException_1.ArgumentException(Strings_1.Strings.IdAlreadyInList, "folderName");
            }
        }
        else {
            EwsUtilities_1.EwsUtilities.ValidateParam(folderId, "folderId");
            folderId = folderIdOrName;
            if (this.Contains(folderId)) {
                throw new ArgumentException_1.ArgumentException(Strings_1.Strings.IdAlreadyInList, "folderId");
            }
        }
        this.InternalAdd(folderId);
        return folderId;
    }
    /**
     * Clears the collection.
     */
    Clear() {
        this.InternalClear();
    }
    /**
     * @internal Instantiate the appropriate attachment type depending on the current XML element name.
     *
     * @param   {string}   xmlElementName   Name of the XML element.
     * @return  {FolderId}        FolderId.
     */
    CreateComplexProperty(xmlElementName) {
        return new FolderId_1.FolderId();
    }
    /**
     * @internal Creates the default complex property.
     *
     * @return  {FolderId}      FolderId.
     */
    CreateDefaultComplexProperty() {
        return new FolderId_1.FolderId();
    }
    /**
     * @internal Gets the name of the collection item XML element.
     *
     * @param   {FolderId}  complexProperty   The complex property.
     * @return  {string}    XML element name.
     */
    GetCollectionItemXmlElementName(complexProperty) {
        return complexProperty.GetXmlElementName();
    }
    Remove(folderIdOrName) {
        if (typeof folderIdOrName === 'number') {
            // can not simply use InternalRemove as javascript does not have c# List functionality
            let index = ExtensionMethods_1.ArrayHelper.IndexOf(this.Items, (item) => item.FolderName === folderIdOrName);
            if (index >= 0) {
                this.InternalRemoveAt(index);
                return true;
            }
        }
        else {
            EwsUtilities_1.EwsUtilities.ValidateParam(folderIdOrName, "folderId");
            return this.InternalRemove(folderIdOrName);
        }
        return false;
    }
    /**
     * Removes the folder Id at the specified index.
     *
     * @param   {number}   index   The zero-based index of the folder Id to remove.
     */
    RemoveAt(index) {
        if (index < 0 || index >= this.Count) {
            throw new ArgumentException_1.ArgumentOutOfRangeException("index", Strings_1.Strings.IndexIsOutOfRange);
        }
        this.InternalRemoveAt(index);
    }
}
exports.FolderIdCollection = FolderIdCollection;
//# sourceMappingURL=FolderIdCollection.js.map