"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExtendedPropertyCollection = void 0;
const ExtensionMethods_1 = require("../ExtensionMethods");
const ExtendedProperty_1 = require("./ExtendedProperty");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const XmlNamespace_1 = require("../Enumerations/XmlNamespace");
const ComplexPropertyCollection_1 = require("./ComplexPropertyCollection");
class ExtendedPropertyCollection extends ComplexPropertyCollection_1.ComplexPropertyCollection {
    CreateComplexProperty(xmlElementName) { return new ExtendedProperty_1.ExtendedProperty(); }
    CreateDefaultComplexProperty() { return new ExtendedProperty_1.ExtendedProperty(); }
    GetCollectionItemXmlElementName(complexProperty) { return null; }
    GetOrAddExtendedProperty(propertyDefinition) {
        var extendedProperty = { outValue: null };
        if (!this.TryGetProperty(propertyDefinition, extendedProperty)) {
            extendedProperty.outValue = new ExtendedProperty_1.ExtendedProperty(propertyDefinition);
            this.InternalAdd(extendedProperty.outValue);
        }
        return extendedProperty.outValue;
    }
    LoadFromXmlJsObject(jsObject, service) {
        var extendedProperty = new ExtendedProperty_1.ExtendedProperty();
        //debugger; //debug: //todo: check for need of local element -not tested
        extendedProperty.LoadFromXmlJsObject(jsObject, service);
        this.InternalAdd(extendedProperty);
    }
    RemoveExtendedProperty(propertyDefinition) {
        //EwsUtilities.ValidateParam(propertyDefinition, "propertyDefinition");
        var extendedProperty = { outValue: null };
        if (this.TryGetProperty(propertyDefinition, extendedProperty)) {
            return this.InternalRemove(extendedProperty.outValue);
        }
        else {
            return false;
        }
    }
    SetExtendedProperty(propertyDefinition, value) {
        var extendedProperty = this.GetOrAddExtendedProperty(propertyDefinition);
        extendedProperty.Value = value;
    }
    TryGetProperty(propertyDefinition, extendedProperty) {
        extendedProperty.outValue = ExtensionMethods_1.ArrayHelper.Find(this.Items, (prop) => prop.PropertyDefinition.Equals(propertyDefinition));
        return extendedProperty.outValue != null;
    }
    TryGetValue(propertyDefinition, propertyValue) {
        var extendedProperty = { outValue: null };
        if (this.TryGetProperty(propertyDefinition, extendedProperty)) {
            //debug: Verify that the type parameter and property definition's type are compatible.
            //if (!typeof (T).IsAssignableFrom(propertyDefinition.Type)) {
            // var errorMessage = StringHelper.Format(
            //     Strings.PropertyDefinitionTypeMismatch,
            //     EwsUtilities.GetPrintableTypeName(propertyDefinition.Type),
            //     EwsUtilities.GetPrintableTypeName("Y"));
            // throw new ArgumentException(errorMessage +  " - propertyDefinition");
            //}
            propertyValue.outValue = extendedProperty.outValue.Value;
            return true;
        }
        else {
            propertyValue.outValue = null; // default(T);
            return false;
        }
    }
    /**
     * @internal Writes the deletion update to XML.
     * ICustomUpdateSerializer.WriteDeleteUpdateToXml
     *
     * @param   {EwsServiceXmlWriter}   writer      The writer.
     * @param   {ServiceObject}         ewsObject   The ews object.
     * @return  {boolean}               True if property generated serialization.
     */
    WriteDeleteUpdateToXml(writer, ewsObject) {
        // Use the default XML serializer.
        for (let extendedProperty of this.Items) {
            writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Types, ewsObject.GetDeleteFieldXmlElementName());
            extendedProperty.PropertyDefinition.WriteToXml(writer);
            writer.WriteEndElement();
        }
        return true;
    }
    /**
     * @internal Writes the update to XML.
     * ICustomUpdateSerializer.WriteSetUpdateToXml
     *
     * @param   {EwsServiceXmlWriter}   writer               The writer.
     * @param   {ServiceObject}         ewsObject            The ews object.
     * @param   {PropertyDefinition}    propertyDefinition   Property definition.
     * @return  {boolean}               True if property generated serialization.
     */
    WriteSetUpdateToXml(writer, ewsObject, propertyDefinition) {
        let propertiesToSet = [];
        ExtensionMethods_1.ArrayHelper.AddRange(propertiesToSet, this.AddedItems);
        ExtensionMethods_1.ArrayHelper.AddRange(propertiesToSet, this.ModifiedItems);
        for (let extendedProperty of propertiesToSet) {
            writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Types, ewsObject.GetSetFieldXmlElementName());
            extendedProperty.PropertyDefinition.WriteToXml(writer);
            writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Types, ewsObject.GetXmlElementName());
            extendedProperty.WriteToXml(writer, XmlElementNames_1.XmlElementNames.ExtendedProperty);
            writer.WriteEndElement();
            writer.WriteEndElement();
        }
        for (let extendedProperty of this.RemovedItems) {
            writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Types, ewsObject.GetDeleteFieldXmlElementName());
            extendedProperty.PropertyDefinition.WriteToXml(writer);
            writer.WriteEndElement();
        }
        return true;
    }
    /**@internal */
    WriteToXml(writer, xmlElementName) {
        for (var extendedProperty of this.Items) {
            extendedProperty.WriteToXml(writer, XmlElementNames_1.XmlElementNames.ExtendedProperty);
        }
    }
}
exports.ExtendedPropertyCollection = ExtendedPropertyCollection;
//# sourceMappingURL=ExtendedPropertyCollection.js.map