"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExtendedProperty = void 0;
const EwsUtilities_1 = require("../Core/EwsUtilities");
const XmlNamespace_1 = require("../Enumerations/XmlNamespace");
const MapiTypeConverter_1 = require("../Misc/MapiTypeConverter");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const EwsLogging_1 = require("../Core/EwsLogging");
const ExtendedPropertyDefinition_1 = require("../PropertyDefinitions/ExtendedPropertyDefinition");
const StringList_1 = require("./StringList");
const ComplexProperty_1 = require("./ComplexProperty");
class ExtendedProperty extends ComplexProperty_1.ComplexProperty {
    constructor(propertyDefinition) {
        super();
        this.propertyDefinition = null;
        this.value = null;
        //EwsUtilities.ValidateParam(propertyDefinition, "propertyDefinition");
        if (typeof propertyDefinition !== 'undefined')
            this.propertyDefinition = propertyDefinition;
    }
    get PropertyDefinition() {
        return this.propertyDefinition;
    }
    get Value() {
        return this.value;
    }
    set Value(value) {
        EwsUtilities_1.EwsUtilities.ValidateParam(value, "value");
        this.SetFieldValue({ getValue: () => this.value, setValue: (val) => this.value = val }, value);
    }
    Equals(obj) { throw new Error("ExtendedProperty.ts - Equals : Not implemented."); }
    GetHashCode() { throw new Error("ExtendedProperty.ts - GetHashCode : Not implemented."); }
    GetStringValue() { throw new Error("ExtendedProperty.ts - GetStringValue : Not implemented."); }
    LoadFromXmlJsObject(jsonProperty, service) {
        if (jsonProperty[XmlElementNames_1.XmlElementNames.ExtendedFieldURI]) {
            this.propertyDefinition = new ExtendedPropertyDefinition_1.ExtendedPropertyDefinition();
            this.propertyDefinition.LoadPropertyValueFromXmlJsObject(jsonProperty[XmlElementNames_1.XmlElementNames.ExtendedFieldURI]);
        }
        for (var key in jsonProperty) {
            switch (key) {
                case XmlElementNames_1.XmlElementNames.ExtendedFieldURI:
                    //pre processed above
                    break;
                case XmlElementNames_1.XmlElementNames.Value:
                    EwsLogging_1.EwsLogging.Assert(this.PropertyDefinition != null, "ExtendedProperty.TryReadElementFromXml", "PropertyDefintion is missing");
                    var stringValue = jsonProperty[key];
                    this.value = MapiTypeConverter_1.MapiTypeConverter.ConvertToValue(this.PropertyDefinition.MapiType, stringValue);
                    break;
                case XmlElementNames_1.XmlElementNames.Values:
                    EwsLogging_1.EwsLogging.Assert(this.PropertyDefinition != null, "ExtendedProperty.TryReadElementFromXml", "PropertyDefintion is missing");
                    var stringList = new StringList_1.StringList(XmlElementNames_1.XmlElementNames.Value);
                    stringList.CreateFromXmlJsObjectCollection(jsonProperty[key], service);
                    this.value = MapiTypeConverter_1.MapiTypeConverter.ConvertToValue(this.PropertyDefinition.MapiType, stringList.GetEnumerator());
                    break;
                default:
                    break;
            }
        }
    }
    /**@internal */
    WriteElementsToXml(writer) {
        this.PropertyDefinition.WriteToXml(writer);
        if (MapiTypeConverter_1.MapiTypeConverter.IsArrayType(this.PropertyDefinition.MapiType)) {
            var array = this.Value;
            writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.Values);
            for (var index = 0; index < array.length; index++) {
                writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.Value, MapiTypeConverter_1.MapiTypeConverter.ConvertToString(this.PropertyDefinition.MapiType, array[index]));
            }
            writer.WriteEndElement();
        }
        else {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.Value, MapiTypeConverter_1.MapiTypeConverter.ConvertToString(this.PropertyDefinition.MapiType, this.Value));
        }
    }
}
exports.ExtendedProperty = ExtendedProperty;
//# sourceMappingURL=ExtendedProperty.js.map