"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EntityExtractionResult = void 0;
const AddressEntityCollection_1 = require("./AddressEntityCollection");
const ContactEntityCollection_1 = require("./ContactEntityCollection");
const EmailAddressEntityCollection_1 = require("./EmailAddressEntityCollection");
const MeetingSuggestionCollection_1 = require("./MeetingSuggestionCollection");
const PhoneEntityCollection_1 = require("./PhoneEntityCollection");
const TaskSuggestionCollection_1 = require("./TaskSuggestionCollection");
const UrlEntityCollection_1 = require("./UrlEntityCollection");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const XmlNamespace_1 = require("../Enumerations/XmlNamespace");
const ComplexProperty_1 = require("./ComplexProperty");
/**
 * Represents an EntityExtractionResult object.
 */
class EntityExtractionResult extends ComplexProperty_1.ComplexProperty {
    /**
     * @internal Initializes a new instance of the **EntityExtractionResult** class.
     */
    constructor() {
        super();
        /**
         * Gets the extracted Addresses.
         */
        this.Addresses = null;
        /**
         * Gets the extracted MeetingSuggestions.
         */
        this.MeetingSuggestions = null;
        /**
         * Gets the extracted TaskSuggestions.
         */
        this.TaskSuggestions = null;
        /**
         * Gets the extracted EmailAddresses.
         */
        this.EmailAddresses = null;
        /**
         * Gets the extracted Contacts.
         */
        this.Contacts = null;
        /**
         * Gets the extracted Urls.
         */
        this.Urls = null;
        /**
         * Gets the extracted PhoneNumbers
         */
        this.PhoneNumbers = null;
        this.Namespace = XmlNamespace_1.XmlNamespace.Types;
    }
    /**
     * @internal Read element from XMLJsObject.
     *
     * @param   {any}   jsObject   xmljsonObject
     * @return  {ExchangeService} the ExchangeService
     */
    LoadFromXmlJsObject(jsObject, service) {
        for (let key in jsObject) {
            if (jsObject.hasOwnProperty(key)) {
                switch (key) {
                    case XmlElementNames_1.XmlElementNames.NlgAddresses:
                        this.Addresses = new AddressEntityCollection_1.AddressEntityCollection();
                        this.Addresses.LoadFromXmlJsObject(jsObject[key], service);
                        break;
                    case XmlElementNames_1.XmlElementNames.NlgMeetingSuggestions:
                        this.MeetingSuggestions = new MeetingSuggestionCollection_1.MeetingSuggestionCollection();
                        this.MeetingSuggestions.LoadFromXmlJsObject(jsObject[key], service);
                        break;
                    case XmlElementNames_1.XmlElementNames.NlgTaskSuggestions:
                        this.TaskSuggestions = new TaskSuggestionCollection_1.TaskSuggestionCollection();
                        this.TaskSuggestions.LoadFromXmlJsObject(jsObject[key], service);
                        break;
                    case XmlElementNames_1.XmlElementNames.NlgEmailAddresses:
                        this.EmailAddresses = new EmailAddressEntityCollection_1.EmailAddressEntityCollection();
                        this.EmailAddresses.LoadFromXmlJsObject(jsObject[key], service);
                        break;
                    case XmlElementNames_1.XmlElementNames.NlgContacts:
                        this.Contacts = new ContactEntityCollection_1.ContactEntityCollection();
                        this.Contacts.LoadFromXmlJsObject(jsObject[key], service);
                        break;
                    case XmlElementNames_1.XmlElementNames.NlgUrls:
                        this.Urls = new UrlEntityCollection_1.UrlEntityCollection();
                        this.Urls.LoadFromXmlJsObject(jsObject[key], service);
                        break;
                    case XmlElementNames_1.XmlElementNames.NlgPhoneNumbers:
                        this.PhoneNumbers = new PhoneEntityCollection_1.PhoneEntityCollection();
                        this.PhoneNumbers.LoadFromXmlJsObject(jsObject[key], service);
                        break;
                    default:
                        break;
                }
            }
        }
    }
}
exports.EntityExtractionResult = EntityExtractionResult;
//# sourceMappingURL=EntityExtractionResult.js.map