"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EnhancedLocation = void 0;
const ExtensionMethods_1 = require("../ExtensionMethods");
const EwsUtilities_1 = require("../Core/EwsUtilities");
const PersonaPostalAddress_1 = require("./PersonaPostalAddress");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const XmlNamespace_1 = require("../Enumerations/XmlNamespace");
const ComplexProperty_1 = require("./ComplexProperty");
/**
 * Represents Enhanced Location.
 */
class EnhancedLocation extends ComplexProperty_1.ComplexProperty {
    constructor(displayName, annotation = ExtensionMethods_1.StringHelper.Empty, personaPostalAddress = new PersonaPostalAddress_1.PersonaPostalAddress()) {
        super();
        this.displayName = null;
        this.annotation = null;
        this.personaPostalAddress = null;
        this.displayName = displayName;
        this.annotation = annotation;
        this.personaPostalAddress = personaPostalAddress;
        this.personaPostalAddress.OnChange.push(this.PersonaPostalAddress_OnChange.bind(this));
    }
    /**
     * Gets or sets the Location DisplayName.
     */
    get DisplayName() {
        return this.displayName;
    }
    set DisplayName(value) {
        this.SetFieldValue({ getValue: () => this.displayName, setValue: (fieldValue) => { this.displayName = fieldValue; } }, value);
    }
    /**
     * Gets or sets the Location Annotation.
     */
    get Annotation() {
        return this.annotation;
    }
    set Annotation(value) {
        this.SetFieldValue({ getValue: () => this.annotation, setValue: (fieldValue) => { this.annotation = fieldValue; } }, value);
    }
    /**
     * Gets or sets the Persona Postal Address.
     */
    get PersonaPostalAddress() {
        return this.personaPostalAddress;
    }
    set PersonaPostalAddress(value) {
        if (this.personaPostalAddress !== value) {
            if (this.personaPostalAddress !== null) {
                ExtensionMethods_1.ArrayHelper.RemoveEntry(this.personaPostalAddress.OnChange, this.PersonaPostalAddress_OnChange);
            }
            this.SetFieldValue({ getValue: () => this.personaPostalAddress, setValue: (fieldValue) => { this.personaPostalAddress = fieldValue; } }, value);
            this.personaPostalAddress.OnChange.push(this.PersonaPostalAddress_OnChange.bind(this));
        }
    }
    /**
     * @internal Validates this instance.
     */
    InternalValidate() {
        super.InternalValidate();
        EwsUtilities_1.EwsUtilities.ValidateParam(this.displayName, "DisplayName");
        EwsUtilities_1.EwsUtilities.ValidateParamAllowNull(this.annotation, "Annotation");
        EwsUtilities_1.EwsUtilities.ValidateParamAllowNull(this.personaPostalAddress, "PersonaPostalAddress");
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}                 jsObject                Json Object converted from XML.
     * @param   {ExchangeService}     service                 The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        for (let key in jsObject) {
            switch (key) {
                case XmlElementNames_1.XmlElementNames.LocationDisplayName:
                    this.displayName = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.LocationAnnotation:
                    this.annotation = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.PersonaPostalAddress:
                    this.personaPostalAddress = new PersonaPostalAddress_1.PersonaPostalAddress();
                    this.personaPostalAddress.LoadFromXmlJsObject(jsObject[key], service);
                    this.personaPostalAddress.OnChange.push(this.PersonaPostalAddress_OnChange.bind(this));
                    break;
                default:
                    break;
            }
        }
    }
    /**
     * PersonaPostalAddress OnChange.
     *
     * @param   {ComplexProperty}   complexProperty   ComplexProperty object.
     */
    PersonaPostalAddress_OnChange(complexProperty) { this.Changed(); }
    /**
     * @internal Writes elements to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.LocationDisplayName, this.displayName);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.LocationAnnotation, this.annotation);
        this.personaPostalAddress.WriteToXml(writer);
    }
}
exports.EnhancedLocation = EnhancedLocation;
//# sourceMappingURL=EnhancedLocation.js.map