"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmailUserEntityCollection = void 0;
const XmlElementNames_1 = require("../Core/XmlElementNames");
const EmailUserEntity_1 = require("./EmailUserEntity");
const ComplexPropertyCollection_1 = require("./ComplexPropertyCollection");
/**
 * Represents a collection of EmailUserEntity objects.
 */
class EmailUserEntityCollection extends ComplexPropertyCollection_1.ComplexPropertyCollection {
    constructor(collection = null) {
        super();
        if (collection != null) {
            collection.forEach((entity) => { this.InternalAdd(entity); });
        }
    }
    /**
     * @internal Creates the complex property.
     *
     * @param   {string}              xmlElementName   Name of the XML element.
     * @return  {EmailUserEntity}     EmailUserEntity.
     */
    CreateComplexProperty(xmlElementName) { return new EmailUserEntity_1.EmailUserEntity(); }
    /**
     * @internal Creates the default complex property.
     *
     * @return  {EmailUserEntity}      EmailUserEntity.
     */
    CreateDefaultComplexProperty() { return new EmailUserEntity_1.EmailUserEntity(); }
    /**
     * @internal Gets the name of the collection item XML element.
     *
     * @param   {EmailUserEntity}       complexProperty   The complex property.
     * @return  {string}                XML element name.
     */
    GetCollectionItemXmlElementName(complexProperty) { return XmlElementNames_1.XmlElementNames.NlgEmailUser; }
}
exports.EmailUserEntityCollection = EmailUserEntityCollection;
//# sourceMappingURL=EmailUserEntityCollection.js.map