"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DictionaryEntryProperty = void 0;
const ComplexProperty_1 = require("./ComplexProperty");
const XmlAttributeNames_1 = require("../Core/XmlAttributeNames");
/**
 * Represents an entry of a DictionaryProperty object.
 * @remarks All descendants of DictionaryEntryProperty must implement a parameterless constructor. That constructor does not have to be public.
 * @typeparam   {TKey}     The type of the key used by this dictionary.
 * [EditorBrowsable(EditorBrowsableState.Never)]
 */
class DictionaryEntryProperty extends ComplexProperty_1.ComplexProperty {
    constructor(key) {
        super();
        this.key = null;
        this.key = key;
    }
    /**
     * Gets or sets the key.
     * @value   The key.
     */
    get Key() {
        return this.key;
    }
    set Key(value) {
        this.key = value;
    }
    /**@internal */
    ReadAttributesFromXmlJsObject(reader) { throw new Error("DictionaryEntryProperty.ts - ReadAttributesFromXml : Not used."); }
    /**
     * @internal Writes attributes to XML.
     * @override
     * @param {EwsServiceXmlWriter} writer  The writer.
     */
    WriteAttributesToXml(writer) {
        writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.Key, this.keyType[this.Key]);
    }
    /**
     * @internal Writes the delete update to XML.
     * @virtual
     * @param   {EwsServiceXmlWriter}   writer      The writer.
     * @param   {ServiceObject}         ewsObject   The ews object.
     * @return  {boolean}               True if update XML was written.
     */
    WriteDeleteUpdateToXml(writer, ewsObject) {
        return false;
    }
    /**
     * @internal Writes the set update to XML.
     * @virtual
     * @param   {EwsServiceXmlWriter}   writer                          The writer.
     * @param   {ServiceObject}         ewsObject                       The ews object.
     * @param   {string}                ownerDictionaryXmlElementName   Name of the owner dictionary XML element.
     * @return  {boolean}               True if update XML was written.
     */
    WriteSetUpdateToXml(writer, ewsObject, ownerDictionaryXmlElementName) {
        return false;
    }
}
exports.DictionaryEntryProperty = DictionaryEntryProperty;
//# sourceMappingURL=DictionaryEntryProperty.js.map