"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateRuleOperation = void 0;
const EwsUtilities_1 = require("../Core/EwsUtilities");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const RuleOperation_1 = require("./RuleOperation");
/**
 * Represents an operation to create a new rule.
 *
 * @sealed
 */
class CreateRuleOperation extends RuleOperation_1.RuleOperation {
    constructor(rule = null) {
        super();
        this.rule = rule;
    }
    /**
     * Gets or sets the rule to be created.
     */
    get Rule() {
        return this.rule;
    }
    set Rule(value) {
        this.SetFieldValue({ getValue: () => this.rule, setValue: (updateValue) => { this.rule = updateValue; } }, value);
    }
    /**
     * @internal Gets the Xml element name of the CreateRuleOperation object.
     */
    get XmlElementName() {
        return XmlElementNames_1.XmlElementNames.CreateRuleOperation;
    }
    /**
     * @internal Validates this instance.
     */
    InternalValidate() {
        EwsUtilities_1.EwsUtilities.ValidateParam(this.rule, "Rule");
    }
    /**
     * @internal Writes the elements to XML writer.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        this.Rule.WriteToXml(writer, XmlElementNames_1.XmlElementNames.Rule);
    }
}
exports.CreateRuleOperation = CreateRuleOperation;
//# sourceMappingURL=CreateRuleOperation.js.map