"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConversationNodeCollection = void 0;
const ExtensionMethods_1 = require("../ExtensionMethods");
const ConversationNode_1 = require("./ConversationNode");
const ComplexPropertyCollection_1 = require("./ComplexPropertyCollection");
/**
 * Represents a collection of conversation items.
 *
 * @sealed
 */
class ConversationNodeCollection extends ComplexPropertyCollection_1.ComplexPropertyCollection {
    /**
     * @internal Initializes a new instance of the **ConversationNodeCollection** class.
     *
     * @param   {PropertySet}   propertySet   The property set.
     */
    constructor(propertySet) {
        super();
        this.propertySet = null;
        this.propertySet = propertySet;
    }
    /**
     * @internal Gets the name of the collection item XML element.
     *
     * @param   {string}   complexProperty   The complex property.
     * @return  {ConversationNode}           XML element name.
     */
    CreateComplexProperty(xmlElementName) {
        return new ConversationNode_1.ConversationNode(this.propertySet);
    }
    /**
     * @internal Creates the default complex property.
     *
     * @return  {ConversationNode}      ConversationItem.
     */
    CreateDefaultComplexProperty() {
        return new ConversationNode_1.ConversationNode(this.propertySet);
    }
    /**
     * @internal Loads from XMLjsObject.
     *
     * @interface   IJsonCollectionDeserializer
     *
     * @param   {any}               jsObjectCollection   The json collection.
     * @param   {ExchangeService}   service          The service.
     */
    LoadFromXmlJsObject(jsObjectCollection, service) {
        let jsCollection = jsObjectCollection;
        if (!ExtensionMethods_1.ArrayHelper.isArray(jsCollection)) {
            jsCollection = [jsObjectCollection];
        }
        for (let jsObject of jsCollection) {
            let jsEntry = jsObject;
            if (jsEntry != null) {
                let node = new ConversationNode_1.ConversationNode(this.propertySet);
                node.LoadFromXmlJsObject(jsEntry, service);
                this.InternalAdd(node);
            }
        }
    }
    /**
     * @internal Gets the name of the collection item XML element.
     *
     * @param   {ConversationNode}  complexProperty   The complex property.
     * @return  {string}            XML element name.
     */
    GetCollectionItemXmlElementName(complexProperty) {
        return complexProperty.GetXmlElementName();
    }
}
exports.ConversationNodeCollection = ConversationNodeCollection;
//# sourceMappingURL=ConversationNodeCollection.js.map