"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContactPhoneEntityCollection = void 0;
const XmlElementNames_1 = require("../Core/XmlElementNames");
const ContactPhoneEntity_1 = require("./ContactPhoneEntity");
const ComplexPropertyCollection_1 = require("./ComplexPropertyCollection");
/**
 * Represents a collection of ContactPhoneEntity objects.
 */
class ContactPhoneEntityCollection extends ComplexPropertyCollection_1.ComplexPropertyCollection {
    constructor(collection = null) {
        super();
        if (collection != null) {
            collection.forEach((phone) => { this.InternalAdd(phone); });
        }
    }
    /**
     * @internal Creates the complex property.
     *
     * @param   {string}                xmlElementName   Name of the XML element.
     * @return  {ContactPhoneEntity}    ContactPhoneEntity.
     */
    CreateComplexProperty(xmlElementName) { return new ContactPhoneEntity_1.ContactPhoneEntity(); }
    /**
     * @internal Creates the default complex property.
     *
     * @return  {ContactPhoneEntity}    ContactPhoneEntity.
     */
    CreateDefaultComplexProperty() { return new ContactPhoneEntity_1.ContactPhoneEntity(); }
    /**
     * @internal Gets the name of the collection item XML element.
     *
     * @param   {ContactPhoneEntity}    complexProperty   The complex property.
     * @return  {string}                XML element name.
     */
    GetCollectionItemXmlElementName(complexProperty) { return XmlElementNames_1.XmlElementNames.NlgPhone; }
}
exports.ContactPhoneEntityCollection = ContactPhoneEntityCollection;
//# sourceMappingURL=ContactPhoneEntityCollection.js.map