"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClientAppMetadata = void 0;
const XmlElementNames_1 = require("../Core/XmlElementNames");
const XmlNamespace_1 = require("../Enumerations/XmlNamespace");
const ComplexProperty_1 = require("./ComplexProperty");
/**
 * Represents a ClientAppMetadata object.
 *
 * @sealed
 */
class ClientAppMetadata extends ComplexProperty_1.ComplexProperty {
    /**
     * Initializes a new instance of the **ClientAppMetadata** class.
     */
    constructor() {
        super();
        this.Namespace = XmlNamespace_1.XmlNamespace.Types;
    }
    /**
     * @internal Reads response elements from Xml JsObject.
     *
     * @param   {any}               jsObject   The response object.
     * @param   {ExchangeService}   service    The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        for (let key in jsObject) {
            switch (key) {
                case XmlElementNames_1.XmlElementNames.EndNodeUrl:
                    this.EndNodeUrl = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.ActionUrl:
                    this.ActionUrl = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.AppStatus:
                    this.AppStatus = jsObject[key];
                    break;
                default:
                    break;
            }
        }
    }
}
exports.ClientAppMetadata = ClientAppMetadata;
//# sourceMappingURL=ClientAppMetadata.js.map