"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClientAccessTokenRequest = void 0;
const ClientAccessTokenType_1 = require("../Enumerations/ClientAccessTokenType");
const ComplexProperty_1 = require("./ComplexProperty");
/**
 * Represents a client token access request
 */
class ClientAccessTokenRequest extends ComplexProperty_1.ComplexProperty {
    constructor(id = null, tokenType = ClientAccessTokenType_1.ClientAccessTokenType.CallerIdentity, scope = null) {
        super();
        this.id = id;
        this.tokenType = tokenType;
        this.scope = scope;
    }
    /**
     * Gets the App Id.
     */
    get Id() {
        return this.id;
    }
    /**
     * Gets token type.
     */
    get TokenType() {
        return this.tokenType;
    }
    /**
     * Gets the token scope.
     */
    get Scope() {
        return this.scope;
    }
}
exports.ClientAccessTokenRequest = ClientAccessTokenRequest;
//# sourceMappingURL=ClientAccessTokenRequest.js.map