"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ByteArrayArray = void 0;
const XmlNamespace_1 = require("../Enumerations/XmlNamespace");
const EwsServiceJsonReader_1 = require("../Core/EwsServiceJsonReader");
const ComplexProperty_1 = require("./ComplexProperty");
class ByteArrayArray extends ComplexProperty_1.ComplexProperty {
    constructor() {
        super(...arguments);
        //ref: bytearray not implemented here, storing base64 value instead
        this.content = []; // System.Byte[][];//System.Collections.Generic.List<T>;
    }
    get Content() {
        return this.content;
    }
    InternalToJson(service) { throw new Error("ByteArrayArray.ts - InternalToJson : Not implemented."); }
    LoadFromXmlJsObject(jsonCollection, serviceExchangeService) {
        if (jsonCollection !== null && jsonCollection[ByteArrayArray.ItemXmlElementName]) {
            var binarydata = EwsServiceJsonReader_1.EwsServiceJsonReader.ReadAsArray(jsonCollection, ByteArrayArray.ItemXmlElementName);
            for (var blob of binarydata) {
                this.content.push(blob); //ref: storing original base64 content //EwsServiceJsonReader.ReadBase64ElementValue(blob));
            }
        }
    }
    /**@internal */
    WriteElementsToXml(writer) {
        for (var item of this.content) {
            writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Types, ByteArrayArray.ItemXmlElementName);
            writer.WriteValue(item, null);
            //writer.WriteBase64ElementValue(item);
            writer.WriteEndElement();
        }
    }
}
exports.ByteArrayArray = ByteArrayArray;
ByteArrayArray.ItemXmlElementName = "Base64Binary";
//# sourceMappingURL=ByteArrayArray.js.map