"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeSuggestion = void 0;
const XmlElementNames_1 = require("../../Core/XmlElementNames");
const SuggestionQuality_1 = require("../../Enumerations/SuggestionQuality");
const ConflictType_1 = require("../../Enumerations/ConflictType");
const Conflict_1 = require("./Conflict");
const EwsServiceJsonReader_1 = require("../../Core/EwsServiceJsonReader");
const EwsUtilities_1 = require("../../Core/EwsUtilities");
const EwsLogging_1 = require("../../Core/EwsLogging");
const ExtensionMethods_1 = require("../../ExtensionMethods");
const ComplexProperty_1 = require("../ComplexProperty");
class TimeSuggestion extends ComplexProperty_1.ComplexProperty {
    constructor() {
        super();
        this.meetingTime = null;
        this.isWorkTime = false;
        this.quality = SuggestionQuality_1.SuggestionQuality.Excellent;
        this.conflicts = []; // System.Collections.ObjectModel.Collection<Conflict>;
    }
    get MeetingTime() {
        return this.meetingTime;
    }
    get IsWorkTime() {
        return this.isWorkTime;
    }
    get Quality() {
        return this.quality;
    }
    get Conflicts() {
        return this.conflicts;
    }
    //LoadFromJson(jsonProperty: any, service: ExchangeService): any { throw new Error("TimeSuggestion.ts - LoadFromJson : Not implemented."); }
    LoadFromXmlJsObject(jsonProperty, service) {
        for (var key in jsonProperty) {
            switch (key) {
                case XmlElementNames_1.XmlElementNames.MeetingTime:
                    this.meetingTime = EwsUtilities_1.EwsUtilities.ParseAsUnbiasedDatetimescopedToServicetimeZone(jsonProperty[key], service);
                    break;
                case XmlElementNames_1.XmlElementNames.IsWorkTime:
                    this.isWorkTime = ExtensionMethods_1.Convert.toBool(jsonProperty[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.SuggestionQuality:
                    this.quality = SuggestionQuality_1.SuggestionQuality[jsonProperty[key]];
                    break;
                case XmlElementNames_1.XmlElementNames.AttendeeConflictDataArray:
                    var jsConflictDataArray = jsonProperty[key];
                    for (var conflictKey in jsConflictDataArray) {
                        if (conflictKey.indexOf("__") === 0)
                            continue;
                        var conflictType = ConflictType_1.ConflictType.IndividualAttendeeConflict;
                        var jsConflicts = EwsServiceJsonReader_1.EwsServiceJsonReader.ReadAsArray(jsConflictDataArray, conflictKey);
                        switch (conflictKey) {
                            case XmlElementNames_1.XmlElementNames.UnknownAttendeeConflictData:
                                conflictType = ConflictType_1.ConflictType.UnknownAttendeeConflict;
                                break;
                            case XmlElementNames_1.XmlElementNames.TooBigGroupAttendeeConflictData:
                                conflictType = ConflictType_1.ConflictType.GroupTooBigConflict;
                                break;
                            case XmlElementNames_1.XmlElementNames.IndividualAttendeeConflictData:
                                conflictType = ConflictType_1.ConflictType.IndividualAttendeeConflict;
                                break;
                            case XmlElementNames_1.XmlElementNames.GroupAttendeeConflictData:
                                conflictType = ConflictType_1.ConflictType.GroupConflict;
                                break;
                            default:
                                EwsLogging_1.EwsLogging.Assert(false, "TimeSuggestion.TryReadElementFromJson", ExtensionMethods_1.StringHelper.Format("The {0} element name does not map to any AttendeeConflict descendant.", ExtensionMethods_1.TypeSystem.GetJsObjectTypeName(jsConflicts)));
                                // The following line to please the compiler
                                break;
                        }
                        for (var conflictItem of jsConflicts) {
                            var conflict = new Conflict_1.Conflict(conflictType);
                            conflict.LoadFromXmlJsObject(conflictItem, service);
                            this.conflicts.push(conflict);
                        }
                    }
                    break;
                default:
                    break;
            }
        }
    }
}
exports.TimeSuggestion = TimeSuggestion;
//# sourceMappingURL=TimeSuggestion.js.map