"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Conflict = void 0;
const XmlElementNames_1 = require("../../Core/XmlElementNames");
const ConflictType_1 = require("../../Enumerations/ConflictType");
const LegacyFreeBusyStatus_1 = require("../../Enumerations/LegacyFreeBusyStatus");
const ComplexProperty_1 = require("../ComplexProperty");
class Conflict extends ComplexProperty_1.ComplexProperty {
    constructor(conflictType) {
        super();
        this.conflictType = ConflictType_1.ConflictType.IndividualAttendeeConflict;
        this.numberOfMembers = 0;
        this.numberOfMembersAvailable = 0;
        this.numberOfMembersWithConflict = 0;
        this.numberOfMembersWithNoData = 0;
        this.freeBusyStatus = LegacyFreeBusyStatus_1.LegacyFreeBusyStatus.Free;
        this.conflictType = conflictType;
    }
    get ConflictType() {
        return this.conflictType;
    }
    get NumberOfMembers() {
        return this.numberOfMembers;
    }
    get NumberOfMembersAvailable() {
        return this.numberOfMembersAvailable;
    }
    get NumberOfMembersWithConflict() {
        return this.numberOfMembersWithConflict;
    }
    get NumberOfMembersWithNoData() {
        return this.numberOfMembersWithNoData;
    }
    get FreeBusyStatus() {
        return this.freeBusyStatus;
    }
    //LoadFromJson(jsonProperty: JsonObject, service: ExchangeService): any { throw new Error("Conflict.ts - LoadFromJson : Not implemented."); }
    LoadFromXmlJsObject(jsonProperty, service) {
        for (var key in jsonProperty) {
            switch (key) {
                case XmlElementNames_1.XmlElementNames.NumberOfMembers:
                    this.numberOfMembers = Number(jsonProperty[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.NumberOfMembersAvailable:
                    this.numberOfMembersAvailable = Number(jsonProperty[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.NumberOfMembersWithConflict:
                    this.numberOfMembersWithConflict = Number(jsonProperty[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.NumberOfMembersWithNoData:
                    this.numberOfMembersWithNoData = Number(jsonProperty[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.BusyType:
                    this.freeBusyStatus = LegacyFreeBusyStatus_1.LegacyFreeBusyStatus[jsonProperty[key]];
                    break;
                default:
                    break;
            }
        }
    }
}
exports.Conflict = Conflict;
//# sourceMappingURL=Conflict.js.map