"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CalendarEvent = void 0;
const CalendarEventDetails_1 = require("./CalendarEventDetails");
const LegacyFreeBusyStatus_1 = require("../../Enumerations/LegacyFreeBusyStatus");
const XmlElementNames_1 = require("../../Core/XmlElementNames");
const EwsUtilities_1 = require("../../Core/EwsUtilities");
const ComplexProperty_1 = require("../ComplexProperty");
class CalendarEvent extends ComplexProperty_1.ComplexProperty {
    constructor() {
        super(...arguments);
        this.startTime = null;
        this.endTime = null;
        this.freeBusyStatus = 0;
        this.details = null;
    }
    get StartTime() {
        return this.startTime;
    }
    get EndTime() {
        return this.endTime;
    }
    get FreeBusyStatus() {
        return this.freeBusyStatus;
    }
    get Details() {
        return this.details;
    }
    LoadFromJson(jsonProperty, service) { throw new Error("CalendarEvent.ts - LoadFromJson : Not implemented."); }
    LoadFromXmlJsObject(jsonProperty, service) {
        for (var key in jsonProperty) {
            switch (key) {
                case XmlElementNames_1.XmlElementNames.StartTime:
                    this.startTime = EwsUtilities_1.EwsUtilities.ParseAsUnbiasedDatetimescopedToServicetimeZone(jsonProperty[key], service);
                    break;
                case XmlElementNames_1.XmlElementNames.EndTime:
                    this.endTime = EwsUtilities_1.EwsUtilities.ParseAsUnbiasedDatetimescopedToServicetimeZone(jsonProperty[key], service);
                    break;
                case XmlElementNames_1.XmlElementNames.BusyType:
                    this.freeBusyStatus = LegacyFreeBusyStatus_1.LegacyFreeBusyStatus[jsonProperty[key]];
                    break;
                case XmlElementNames_1.XmlElementNames.CalendarEventDetails:
                    this.details = new CalendarEventDetails_1.CalendarEventDetails();
                    this.details.LoadFromXmlJsObject(jsonProperty[key], service);
                    break;
                default:
                    break;
            }
        }
    }
}
exports.CalendarEvent = CalendarEvent;
//# sourceMappingURL=CalendarEvent.js.map