"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddressEntityCollection = void 0;
const XmlElementNames_1 = require("../Core/XmlElementNames");
const AddressEntity_1 = require("./AddressEntity");
const ComplexPropertyCollection_1 = require("./ComplexPropertyCollection");
/**
 * Represents a collection of AddressEntity objects.
 */
class AddressEntityCollection extends ComplexPropertyCollection_1.ComplexPropertyCollection {
    constructor(collection = null) {
        super();
        if (collection != null) {
            collection.forEach((address) => { this.InternalAdd(address); });
        }
    }
    /**
     * @internal Creates the complex property.
     *
     * @param   {string}            xmlElementName   Name of the XML element.
     * @return  {AddressEntity}     AddressEntity.
     */
    CreateComplexProperty(xmlElementName) { return new AddressEntity_1.AddressEntity(); }
    /**
     * @internal Creates the default complex property.
     *
     * @return  {AddressEntity}      AddressEntity.
     */
    CreateDefaultComplexProperty() { return new AddressEntity_1.AddressEntity(); }
    /**
     * @internal Gets the name of the collection item XML element.
     *
     * @param   {AddressEntity}     complexProperty   The complex property.
     * @return  {string}            XML element name.
     */
    GetCollectionItemXmlElementName(complexProperty) { return XmlElementNames_1.XmlElementNames.NlgAddress; }
}
exports.AddressEntityCollection = AddressEntityCollection;
//# sourceMappingURL=AddressEntityCollection.js.map