"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProtocolConnectionCollection = void 0;
const ProtocolConnection_1 = require("./ProtocolConnection");
const XmlElementNames_1 = require("../Core/XmlElementNames");
/**
 * Represents a user setting that is a collection of protocol connection.
 * @sealed
 */
class ProtocolConnectionCollection {
    /**
     * @internal Initializes a new instance of the **ProtocolConnectionCollection** class.
     */
    constructor() {
        this.connections = [];
    }
    get Connections() {
        return this.connections;
    }
    set Connections(value) {
        this.connections = value;
    }
    /**
     * @internal Read user setting with ProtocolConnectionCollection value.
     *
     * @param   {any} jsObject  Json Object converted from XML.
     * @returns {ProtocolConnectionCollection}
     */
    static LoadFromXmlJsObject(jsObject) {
        const value = new ProtocolConnectionCollection();
        const element = XmlElementNames_1.XmlElementNames.ProtocolConnection;
        let responses = undefined;
        if (Array.isArray(jsObject[element]))
            responses = jsObject[element];
        else
            responses = [jsObject[element]];
        for (let i = 0; i < responses.length; i++) {
            const connection = ProtocolConnection_1.ProtocolConnection.LoadFromXmlJsObject(responses[i]);
            value.Connections.push(connection);
        }
        return value;
    }
}
exports.ProtocolConnectionCollection = ProtocolConnectionCollection;
//# sourceMappingURL=ProtocolConnectionCollection.js.map