"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlternateMailboxCollection = void 0;
const AlternateMailbox_1 = require("./AlternateMailbox");
const XmlElementNames_1 = require("../Core/XmlElementNames");
/**
 * Represents a user setting that is a collection of alternate mailboxes.
 * @sealed
 */
class AlternateMailboxCollection {
    constructor() {
        this.entries = [];
    }
    /**
     * Gets the collection of alternate mailboxes.
     */
    get Entries() {
        return this.entries;
    }
    /** @private set */
    set Entries(value) {
        this.entries = value;
    }
    /**
     * @internal Loads instance of AlternateMailboxCollection.
     *
     * @param   {any} jsObject  Json Object converted from XML.
     * @returns {AlternateMailboxCollection}
     */
    static LoadFromXmlJsObject(obj) {
        const instance = new AlternateMailboxCollection();
        const element = XmlElementNames_1.XmlElementNames.AlternateMailbox;
        let responses = undefined;
        if (Array.isArray(obj[element]))
            responses = obj[element];
        else
            responses = [obj[element]];
        for (let i = 0; i < responses.length; i++) {
            instance.Entries.push(AlternateMailbox_1.AlternateMailbox.LoadFromXmlJsObject(responses[i]));
        }
        return instance;
    }
}
exports.AlternateMailboxCollection = AlternateMailboxCollection;
//# sourceMappingURL=AlternateMailboxCollection.js.map