"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlternateMailbox = void 0;
const XmlElementNames_1 = require("../Core/XmlElementNames");
/**
 * Represents an alternate mailbox.
 * @sealed
 */
class AlternateMailbox {
    /**
     * Initializes a new instance of the **AlternateMailbox** class.
     */
    constructor() {
    }
    /**
     * Gets the alternate mailbox type.
     */
    get Type() {
        return this.type;
    }
    /** @internal set */
    set Type(value) {
        this.type = value;
    }
    /**
     * Gets the alternate mailbox display name.
     */
    get DisplayName() {
        return this.displayName;
    }
    /** @internal set */
    set DisplayName(value) {
        this.displayName = value;
    }
    /**
     * Gets the alternate mailbox legacy DN.
     */
    get LegacyDN() {
        return this.legacyDN;
    }
    /** @internal set */
    set LegacyDN(value) {
        this.legacyDN = value;
    }
    /**
     * Gets the alernate mailbox server.
     */
    get Server() {
        return this.server;
    }
    /** @internal set */
    set Server(value) {
        this.server = value;
    }
    /**
     * Gets the alternate mailbox address.
     * It has value only when Server and LegacyDN is empty.
     */
    get SmtpAddress() {
        return this.smtpAddress;
    }
    /** @internal set */
    set SmtpAddress(value) {
        this.smtpAddress = value;
    }
    /**
     * Gets the alternate mailbox owner SmtpAddress.
     */
    get OwnerSmtpAddress() {
        return this.ownerSmtpAddress;
    }
    /** @internal set */
    set OwnerSmtpAddress(value) {
        this.ownerSmtpAddress = value;
    }
    /**
     * @internal Loads AlternateMailbox instance.
     *
     * @param   {any} jsObject  Json Object converted from XML.
     * @returns {AlternateMailbox}  AlternateMailbox.
     */
    static LoadFromXmlJsObject(jsObject) {
        const altMailbox = new AlternateMailbox();
        altMailbox.Type = jsObject[XmlElementNames_1.XmlElementNames.Type] || null;
        altMailbox.DisplayName = jsObject[XmlElementNames_1.XmlElementNames.DisplayName] || null;
        altMailbox.LegacyDN = jsObject[XmlElementNames_1.XmlElementNames.DisplayName] || null;
        altMailbox.Server = jsObject[XmlElementNames_1.XmlElementNames.DisplayName] || null;
        altMailbox.SmtpAddress = jsObject[XmlElementNames_1.XmlElementNames.DisplayName] || null;
        altMailbox.OwnerSmtpAddress = jsObject[XmlElementNames_1.XmlElementNames.DisplayName] || null;
        return altMailbox;
    }
}
exports.AlternateMailbox = AlternateMailbox;
//# sourceMappingURL=AlternateMailbox.js.map