"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAvailableBrowsers = getAvailableBrowsers;
exports.launchBrowser = launchBrowser;
const child_process_1 = require("child_process");
const which_1 = __importDefault(require("which"));
const browsers_1 = __importDefault(require("./browsers"));
async function getExecutable(name) {
    const execs = browsers_1.default[name];
    if (!execs || !execs[process.platform])
        return;
    for (const exec of execs[process.platform]) {
        const executable = await (0, which_1.default)(exec).catch(() => { });
        if (executable)
            return executable;
    }
}
async function getAvailableBrowsers() {
    const list = [];
    for (const browser of Object.keys(browsers_1.default)) {
        const executable = await getExecutable(browser);
        if (executable)
            list.push({ browser, executable });
    }
    return list;
}
async function launchBrowserMac(browser, address) {
    (0, child_process_1.spawn)('open', ['-a', browser.browser, decodeURI(address)], {
        detached: true,
        env: process.env
    });
}
async function launchEdge(address) {
    (0, child_process_1.spawn)(`start microsoft-edge:"${address}"`, {
        detached: true,
        env: process.env,
        shell: true
    });
}
async function launchBrowser(browser, address) {
    // use open command to open browsers in macOS
    if (process.platform === 'darwin') {
        return launchBrowserMac(browser, address);
    }
    // legacy edge can not be started by spawning the executable
    if (browser.executable.endsWith('MicrosoftEdge.exe')) {
        return launchEdge(address);
    }
    // spawn the executable for all other browsers and platforms
    (0, child_process_1.spawn)(browser.executable, [address], { detached: true, env: process.env });
}
