import {getChildNodes as $gtW1T$getChildNodes} from "@react-stately/collections";
import {Rect as $gtW1T$Rect, LayoutInfo as $gtW1T$LayoutInfo, Size as $gtW1T$Size, Point as $gtW1T$Point, Layout as $gtW1T$Layout} from "@react-stately/virtualizer";

/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ /*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ 

const $61ef60fc9b1041f4$var$DEFAULT_HEIGHT = 48;
class $61ef60fc9b1041f4$export$cacbb3924155d68e extends (0, $gtW1T$Layout) {
    getLayoutInfo(key) {
        let res = this.layoutInfos.get(key);
        // If the layout info wasn't found, it might be outside the bounds of the area that we've
        // computed layout for so far. This can happen when accessing a random key, e.g pressing Home/End.
        // Compute the full layout and try again.
        if (!res && this.validRect.area < this.contentSize.area && this.lastCollection) {
            this.lastValidRect = this.validRect;
            this.validRect = new (0, $gtW1T$Rect)(0, 0, Infinity, Infinity);
            this.rootNodes = this.buildCollection();
            this.validRect = new (0, $gtW1T$Rect)(0, 0, this.contentSize.width, this.contentSize.height);
            res = this.layoutInfos.get(key);
        }
        return res;
    }
    getVisibleLayoutInfos(rect) {
        // If layout hasn't yet been done for the requested rect, union the
        // new rect with the existing valid rect, and recompute.
        if (!this.validRect.containsRect(rect) && this.lastCollection) {
            this.lastValidRect = this.validRect;
            this.validRect = this.validRect.union(rect);
            this.rootNodes = this.buildCollection();
        }
        let res = [];
        let addNodes = (nodes)=>{
            for (let node of nodes)if (this.isVisible(node, rect)) {
                res.push(node.layoutInfo);
                if (node.header) res.push(node.header);
                if (node.children) addNodes(node.children);
            }
        };
        addNodes(this.rootNodes);
        return res;
    }
    isVisible(node, rect) {
        return node.layoutInfo.rect.intersects(rect) || node.layoutInfo.isSticky || this.virtualizer.isPersistedKey(node.layoutInfo.key);
    }
    shouldInvalidateEverything(invalidationContext) {
        // Invalidate cache if the size of the collection changed.
        // In this case, we need to recalculate the entire layout.
        return invalidationContext.sizeChanged;
    }
    validate(invalidationContext) {
        this.collection = this.virtualizer.collection;
        // Reset valid rect if we will have to invalidate everything.
        // Otherwise we can reuse cached layout infos outside the current visible rect.
        this.invalidateEverything = this.shouldInvalidateEverything(invalidationContext);
        if (this.invalidateEverything) {
            this.lastValidRect = this.validRect;
            this.validRect = this.virtualizer.getVisibleRect();
        }
        this.rootNodes = this.buildCollection();
        // Remove deleted layout nodes
        if (this.lastCollection && this.collection !== this.lastCollection) {
            for (let key of this.lastCollection.getKeys())if (!this.collection.getItem(key)) {
                let layoutNode = this.layoutNodes.get(key);
                if (layoutNode) {
                    var _layoutNode_header;
                    this.layoutInfos.delete(layoutNode.layoutInfo.key);
                    this.layoutInfos.delete((_layoutNode_header = layoutNode.header) === null || _layoutNode_header === void 0 ? void 0 : _layoutNode_header.key);
                    this.layoutNodes.delete(key);
                }
            }
        }
        this.lastWidth = this.virtualizer.visibleRect.width;
        this.lastCollection = this.collection;
        this.invalidateEverything = false;
    }
    buildCollection() {
        let y = this.padding;
        let skipped = 0;
        let nodes = [];
        for (let node of this.collection){
            var _this_rowHeight;
            let rowHeight = (_this_rowHeight = this.rowHeight) !== null && _this_rowHeight !== void 0 ? _this_rowHeight : this.estimatedRowHeight;
            // Skip rows before the valid rectangle unless they are already cached.
            if (node.type === "item" && y + rowHeight < this.validRect.y && !this.isValid(node, y)) {
                y += rowHeight;
                skipped++;
                continue;
            }
            let layoutNode = this.buildChild(node, 0, y);
            y = layoutNode.layoutInfo.rect.maxY;
            nodes.push(layoutNode);
            if (node.type === "item" && y > this.validRect.maxY) {
                y += (this.collection.size - (nodes.length + skipped)) * rowHeight;
                break;
            }
        }
        if (this.isLoading) {
            var _this_loaderHeight;
            let rect = new (0, $gtW1T$Rect)(0, y, this.virtualizer.visibleRect.width, (_this_loaderHeight = this.loaderHeight) !== null && _this_loaderHeight !== void 0 ? _this_loaderHeight : this.virtualizer.visibleRect.height);
            let loader = new (0, $gtW1T$LayoutInfo)("loader", "loader", rect);
            this.layoutInfos.set("loader", loader);
            nodes.push({
                layoutInfo: loader
            });
            y = loader.rect.maxY;
        }
        if (nodes.length === 0) {
            var _this_placeholderHeight;
            let rect = new (0, $gtW1T$Rect)(0, y, this.virtualizer.visibleRect.width, (_this_placeholderHeight = this.placeholderHeight) !== null && _this_placeholderHeight !== void 0 ? _this_placeholderHeight : this.virtualizer.visibleRect.height);
            let placeholder = new (0, $gtW1T$LayoutInfo)("placeholder", "placeholder", rect);
            this.layoutInfos.set("placeholder", placeholder);
            nodes.push({
                layoutInfo: placeholder
            });
            y = placeholder.rect.maxY;
        }
        this.contentSize = new (0, $gtW1T$Size)(this.virtualizer.visibleRect.width, y + this.padding);
        return nodes;
    }
    isValid(node, y) {
        let cached = this.layoutNodes.get(node.key);
        return !this.invalidateEverything && cached && cached.node === node && y === (cached.header || cached.layoutInfo).rect.y && cached.layoutInfo.rect.intersects(this.lastValidRect) && cached.validRect.containsRect(cached.layoutInfo.rect.intersection(this.validRect));
    }
    buildChild(node, x, y) {
        if (this.isValid(node, y)) return this.layoutNodes.get(node.key);
        let layoutNode = this.buildNode(node, x, y);
        layoutNode.node = node;
        var _node_parentKey;
        layoutNode.layoutInfo.parentKey = (_node_parentKey = node.parentKey) !== null && _node_parentKey !== void 0 ? _node_parentKey : null;
        this.layoutInfos.set(layoutNode.layoutInfo.key, layoutNode.layoutInfo);
        if (layoutNode.header) this.layoutInfos.set(layoutNode.header.key, layoutNode.header);
        this.layoutNodes.set(node.key, layoutNode);
        return layoutNode;
    }
    buildNode(node, x, y) {
        switch(node.type){
            case "section":
                return this.buildSection(node, x, y);
            case "item":
                return this.buildItem(node, x, y);
        }
    }
    buildSection(node, x, y) {
        let width = this.virtualizer.visibleRect.width;
        let rectHeight = this.headingHeight;
        let isEstimated = false;
        // If no explicit height is available, use an estimated height.
        if (rectHeight == null) {
            // If a previous version of this layout info exists, reuse its height.
            // Mark as estimated if the size of the overall collection view changed,
            // or the content of the item changed.
            let previousLayoutNode = this.layoutNodes.get(node.key);
            if (previousLayoutNode && previousLayoutNode.header) {
                let curNode = this.collection.getItem(node.key);
                let lastNode = this.lastCollection ? this.lastCollection.getItem(node.key) : null;
                rectHeight = previousLayoutNode.header.rect.height;
                isEstimated = width !== this.lastWidth || curNode !== lastNode || previousLayoutNode.header.estimatedSize;
            } else {
                rectHeight = node.rendered ? this.estimatedHeadingHeight : 0;
                isEstimated = true;
            }
        }
        if (rectHeight == null) rectHeight = $61ef60fc9b1041f4$var$DEFAULT_HEIGHT;
        let headerRect = new (0, $gtW1T$Rect)(0, y, width, rectHeight);
        let header = new (0, $gtW1T$LayoutInfo)("header", node.key + ":header", headerRect);
        header.estimatedSize = isEstimated;
        header.parentKey = node.key;
        y += header.rect.height;
        let rect = new (0, $gtW1T$Rect)(0, y, width, 0);
        let layoutInfo = new (0, $gtW1T$LayoutInfo)(node.type, node.key, rect);
        let startY = y;
        let skipped = 0;
        let children = [];
        for (let child of (0, $gtW1T$getChildNodes)(node, this.collection)){
            var _this_rowHeight;
            let rowHeight = (_this_rowHeight = this.rowHeight) !== null && _this_rowHeight !== void 0 ? _this_rowHeight : this.estimatedRowHeight;
            // Skip rows before the valid rectangle unless they are already cached.
            if (y + rowHeight < this.validRect.y && !this.isValid(node, y)) {
                y += rowHeight;
                skipped++;
                continue;
            }
            let layoutNode = this.buildChild(child, x, y);
            y = layoutNode.layoutInfo.rect.maxY;
            children.push(layoutNode);
            if (y > this.validRect.maxY) {
                // Estimate the remaining height for rows that we don't need to layout right now.
                y += ([
                    ...(0, $gtW1T$getChildNodes)(node, this.collection)
                ].length - (children.length + skipped)) * rowHeight;
                break;
            }
        }
        rect.height = y - startY;
        return {
            header: header,
            layoutInfo: layoutInfo,
            children: children,
            validRect: layoutInfo.rect.intersection(this.validRect)
        };
    }
    buildItem(node, x, y) {
        let width = this.virtualizer.visibleRect.width;
        let rectHeight = this.rowHeight;
        let isEstimated = false;
        // If no explicit height is available, use an estimated height.
        if (rectHeight == null) {
            // If a previous version of this layout info exists, reuse its height.
            // Mark as estimated if the size of the overall collection view changed,
            // or the content of the item changed.
            let previousLayoutNode = this.layoutNodes.get(node.key);
            if (previousLayoutNode) {
                rectHeight = previousLayoutNode.layoutInfo.rect.height;
                isEstimated = width !== this.lastWidth || node !== previousLayoutNode.node || previousLayoutNode.layoutInfo.estimatedSize;
            } else {
                rectHeight = this.estimatedRowHeight;
                isEstimated = true;
            }
        }
        if (rectHeight == null) rectHeight = $61ef60fc9b1041f4$var$DEFAULT_HEIGHT;
        if (typeof this.indentationForItem === "function") x += this.indentationForItem(this.collection, node.key) || 0;
        let rect = new (0, $gtW1T$Rect)(x, y, width - x, rectHeight);
        let layoutInfo = new (0, $gtW1T$LayoutInfo)(node.type, node.key, rect);
        // allow overflow so the focus ring/selection ring can extend outside to overlap with the adjacent items borders
        layoutInfo.allowOverflow = true;
        layoutInfo.estimatedSize = isEstimated;
        return {
            layoutInfo: layoutInfo,
            validRect: layoutInfo.rect
        };
    }
    updateItemSize(key, size) {
        let layoutInfo = this.layoutInfos.get(key);
        // If no layoutInfo, item has been deleted/removed.
        if (!layoutInfo) return false;
        layoutInfo.estimatedSize = false;
        if (layoutInfo.rect.height !== size.height) {
            // Copy layout info rather than mutating so that later caches are invalidated.
            let newLayoutInfo = layoutInfo.copy();
            newLayoutInfo.rect.height = size.height;
            this.layoutInfos.set(key, newLayoutInfo);
            // Invalidate layout for this layout node and all parents
            this.updateLayoutNode(key, layoutInfo, newLayoutInfo);
            let node = this.collection.getItem(layoutInfo.parentKey);
            while(node){
                this.updateLayoutNode(node.key, layoutInfo, newLayoutInfo);
                node = this.collection.getItem(node.parentKey);
            }
            return true;
        }
        return false;
    }
    updateLayoutNode(key, oldLayoutInfo, newLayoutInfo) {
        let n = this.layoutNodes.get(key);
        if (n) {
            // Invalidate by reseting validRect.
            n.validRect = new (0, $gtW1T$Rect)();
            // Replace layout info in LayoutNode
            if (n.header === oldLayoutInfo) n.header = newLayoutInfo;
            else if (n.layoutInfo === oldLayoutInfo) n.layoutInfo = newLayoutInfo;
        }
    }
    getContentSize() {
        return this.contentSize;
    }
    getKeyAbove(key) {
        let collection = this.collection;
        key = collection.getKeyBefore(key);
        while(key != null){
            let item = collection.getItem(key);
            if (item.type === "item" && (this.allowDisabledKeyFocus || !this.disabledKeys.has(item.key))) return key;
            key = collection.getKeyBefore(key);
        }
    }
    getKeyBelow(key) {
        let collection = this.collection;
        key = collection.getKeyAfter(key);
        while(key != null){
            let item = collection.getItem(key);
            if (item.type === "item" && (this.allowDisabledKeyFocus || !this.disabledKeys.has(item.key))) return key;
            key = collection.getKeyAfter(key);
        }
    }
    getKeyPageAbove(key) {
        let layoutInfo = this.getLayoutInfo(key);
        if (layoutInfo) {
            let pageY = Math.max(0, layoutInfo.rect.y + layoutInfo.rect.height - this.virtualizer.visibleRect.height);
            while(layoutInfo && layoutInfo.rect.y > pageY){
                let keyAbove = this.getKeyAbove(layoutInfo.key);
                layoutInfo = this.getLayoutInfo(keyAbove);
            }
            if (layoutInfo) return layoutInfo.key;
        }
        return this.getFirstKey();
    }
    getKeyPageBelow(key) {
        let layoutInfo = this.getLayoutInfo(key != null ? key : this.getFirstKey());
        if (layoutInfo) {
            let pageY = Math.min(this.virtualizer.contentSize.height, layoutInfo.rect.y - layoutInfo.rect.height + this.virtualizer.visibleRect.height);
            while(layoutInfo && layoutInfo.rect.y < pageY){
                let keyBelow = this.getKeyBelow(layoutInfo.key);
                layoutInfo = this.getLayoutInfo(keyBelow);
            }
            if (layoutInfo) return layoutInfo.key;
        }
        return this.getLastKey();
    }
    getFirstKey() {
        let collection = this.collection;
        let key = collection.getFirstKey();
        while(key != null){
            let item = collection.getItem(key);
            if (item.type === "item" && (this.allowDisabledKeyFocus || !this.disabledKeys.has(item.key))) return key;
            key = collection.getKeyAfter(key);
        }
    }
    getLastKey() {
        let collection = this.collection;
        let key = collection.getLastKey();
        while(key != null){
            let item = collection.getItem(key);
            if (item.type === "item" && (this.allowDisabledKeyFocus || !this.disabledKeys.has(item.key))) return key;
            key = collection.getKeyBefore(key);
        }
    }
    getKeyForSearch(search, fromKey) {
        if (!this.collator) return null;
        let collection = this.collection;
        let key = fromKey || this.getFirstKey();
        while(key != null){
            let item = collection.getItem(key);
            let substring = item.textValue.slice(0, search.length);
            if (item.textValue && this.collator.compare(substring, search) === 0) return key;
            key = this.getKeyBelow(key);
        }
        return null;
    }
    getInitialLayoutInfo(layoutInfo) {
        layoutInfo.opacity = 0;
        layoutInfo.transform = "scale3d(0.8, 0.8, 0.8)";
        return layoutInfo;
    }
    getFinalLayoutInfo(layoutInfo) {
        layoutInfo.opacity = 0;
        layoutInfo.transform = "scale3d(0.8, 0.8, 0.8)";
        return layoutInfo;
    }
    getDropTargetFromPoint(x, y, isValidDropTarget) {
        x += this.virtualizer.visibleRect.x;
        y += this.virtualizer.visibleRect.y;
        let key = this.virtualizer.keyAtPoint(new (0, $gtW1T$Point)(x, y));
        if (key == null || this.collection.size === 0) return {
            type: "root"
        };
        let layoutInfo = this.getLayoutInfo(key);
        let rect = layoutInfo.rect;
        let target = {
            type: "item",
            key: layoutInfo.key,
            dropPosition: "on"
        };
        // If dropping on the item isn't accepted, try the target before or after depending on the y position.
        // Otherwise, if dropping on the item is accepted, still try the before/after positions if within 10px
        // of the top or bottom of the item.
        if (!isValidDropTarget(target)) {
            if (y <= rect.y + rect.height / 2 && isValidDropTarget({
                ...target,
                dropPosition: "before"
            })) target.dropPosition = "before";
            else if (isValidDropTarget({
                ...target,
                dropPosition: "after"
            })) target.dropPosition = "after";
        } else if (y <= rect.y + 10 && isValidDropTarget({
            ...target,
            dropPosition: "before"
        })) target.dropPosition = "before";
        else if (y >= rect.maxY - 10 && isValidDropTarget({
            ...target,
            dropPosition: "after"
        })) target.dropPosition = "after";
        return target;
    }
    /**
   * Creates a new ListLayout with options. See the list of properties below for a description
   * of the options that can be provided.
   */ constructor(options = {}){
        super();
        this.disabledKeys = new Set();
        this.allowDisabledKeyFocus = false;
        this.rowHeight = options.rowHeight;
        this.estimatedRowHeight = options.estimatedRowHeight;
        this.headingHeight = options.headingHeight;
        this.estimatedHeadingHeight = options.estimatedHeadingHeight;
        this.padding = options.padding || 0;
        this.indentationForItem = options.indentationForItem;
        this.collator = options.collator;
        this.loaderHeight = options.loaderHeight;
        this.placeholderHeight = options.placeholderHeight;
        this.layoutInfos = new Map();
        this.layoutNodes = new Map();
        this.rootNodes = [];
        this.lastWidth = 0;
        this.lastCollection = null;
        this.allowDisabledKeyFocus = options.allowDisabledKeyFocus;
        this.lastValidRect = new (0, $gtW1T$Rect)();
        this.validRect = new (0, $gtW1T$Rect)();
        this.contentSize = new (0, $gtW1T$Size)();
    }
}


/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ 


class $a152112e902709bf$export$62444c3c724b1b20 extends (0, $61ef60fc9b1041f4$export$cacbb3924155d68e) {
    shouldInvalidateEverything(invalidationContext) {
        // If columns changed, clear layout cache.
        return super.shouldInvalidateEverything(invalidationContext) || !this.lastCollection || this.collection.columns.length !== this.lastCollection.columns.length || this.collection.columns.some((c, i)=>c.key !== this.lastCollection.columns[i].key || c.props.width !== this.lastCollection.columns[i].props.width || c.props.minWidth !== this.lastCollection.columns[i].props.minWidth || c.props.maxWidth !== this.lastCollection.columns[i].props.maxWidth);
    }
    getResizerPosition() {
        var _this_getLayoutInfo;
        return (_this_getLayoutInfo = this.getLayoutInfo(this.resizingColumn)) === null || _this_getLayoutInfo === void 0 ? void 0 : _this_getLayoutInfo.rect.maxX;
    }
    getColumnWidth(key) {
        var _this_columnLayout_getColumnWidth;
        return (_this_columnLayout_getColumnWidth = this.columnLayout.getColumnWidth(key)) !== null && _this_columnLayout_getColumnWidth !== void 0 ? _this_columnLayout_getColumnWidth : 0;
    }
    getColumnMinWidth(key) {
        let column = this.collection.columns.find((col)=>col.key === key);
        if (!column) return 0;
        return this.columnLayout.getColumnMinWidth(key);
    }
    getColumnMaxWidth(key) {
        let column = this.collection.columns.find((col)=>col.key === key);
        if (!column) return 0;
        return this.columnLayout.getColumnMaxWidth(key);
    }
    // outside, where this is called, should call props.onColumnResizeStart...
    startResize(key) {
        this.resizingColumn = key;
    }
    // only way to call props.onColumnResize with the new size outside of Layout is to send the result back
    updateResizedColumns(key, width) {
        let newControlled = new Map(Array.from(this.controlledColumns).map(([key, entry])=>[
                key,
                entry.props.width
            ]));
        let newSizes = this.columnLayout.resizeColumnWidth(this.virtualizer.visibleRect.width, this.collection, newControlled, this.uncontrolledWidths, key, width);
        let map = new Map(Array.from(this.uncontrolledColumns).map(([key])=>[
                key,
                newSizes.get(key)
            ]));
        map.set(key, width);
        this.uncontrolledWidths = map;
        // relayoutNow still uses setState, should happen at the same time the parent
        // component's state is processed as a result of props.onColumnResize
        if (this.uncontrolledWidths.size > 0) this.virtualizer.relayoutNow({
            sizeChanged: true
        });
        return newSizes;
    }
    endResize() {
        this.resizingColumn = null;
    }
    buildCollection() {
        // Track whether we were previously loading. This is used to adjust the animations of async loading vs inserts.
        let loadingState = this.collection.body.props.loadingState;
        this.wasLoading = this.isLoading;
        this.isLoading = loadingState === "loading" || loadingState === "loadingMore";
        this.stickyColumnIndices = [];
        for (let column of this.collection.columns)// The selection cell and any other sticky columns always need to be visible.
        // In addition, row headers need to be in the DOM for accessibility labeling.
        if (column.props.isDragButtonCell || column.props.isSelectionCell || this.collection.rowHeaderColumnKeys.has(column.key)) this.stickyColumnIndices.push(column.index);
        let [controlledColumns, uncontrolledColumns] = this.columnLayout.splitColumnsIntoControlledAndUncontrolled(this.collection.columns);
        this.controlledColumns = controlledColumns;
        this.uncontrolledColumns = uncontrolledColumns;
        let colWidths = this.columnLayout.recombineColumns(this.collection.columns, this.uncontrolledWidths, uncontrolledColumns, controlledColumns);
        this.columnWidths = this.columnLayout.buildColumnWidths(this.virtualizer.visibleRect.width, this.collection, colWidths);
        let header = this.buildHeader();
        let body = this.buildBody(0);
        this.lastPersistedKeys = null;
        body.layoutInfo.rect.width = Math.max(header.layoutInfo.rect.width, body.layoutInfo.rect.width);
        this.contentSize = new (0, $gtW1T$Size)(body.layoutInfo.rect.width, body.layoutInfo.rect.maxY);
        return [
            header,
            body
        ];
    }
    buildHeader() {
        let rect = new (0, $gtW1T$Rect)(0, 0, 0, 0);
        let layoutInfo = new (0, $gtW1T$LayoutInfo)("header", "header", rect);
        let y = 0;
        let width = 0;
        let children = [];
        for (let headerRow of this.collection.headerRows){
            let layoutNode = this.buildChild(headerRow, 0, y);
            layoutNode.layoutInfo.parentKey = "header";
            y = layoutNode.layoutInfo.rect.maxY;
            width = Math.max(width, layoutNode.layoutInfo.rect.width);
            children.push(layoutNode);
        }
        rect.width = width;
        rect.height = y;
        this.layoutInfos.set("header", layoutInfo);
        return {
            layoutInfo: layoutInfo,
            children: children,
            validRect: layoutInfo.rect
        };
    }
    buildHeaderRow(headerRow, x, y) {
        let rect = new (0, $gtW1T$Rect)(0, y, 0, 0);
        let row = new (0, $gtW1T$LayoutInfo)("headerrow", headerRow.key, rect);
        let height = 0;
        let columns = [];
        for (let cell of (0, $gtW1T$getChildNodes)(headerRow, this.collection)){
            let layoutNode = this.buildChild(cell, x, y);
            layoutNode.layoutInfo.parentKey = row.key;
            x = layoutNode.layoutInfo.rect.maxX;
            height = Math.max(height, layoutNode.layoutInfo.rect.height);
            columns.push(layoutNode);
        }
        for (let [i, layout] of columns.entries())layout.layoutInfo.zIndex = columns.length - i + 1;
        this.setChildHeights(columns, height);
        rect.height = height;
        rect.width = x;
        return {
            layoutInfo: row,
            children: columns,
            validRect: rect
        };
    }
    setChildHeights(children, height) {
        for (let child of children)if (child.layoutInfo.rect.height !== height) {
            // Need to copy the layout info before we mutate it.
            child.layoutInfo = child.layoutInfo.copy();
            this.layoutInfos.set(child.layoutInfo.key, child.layoutInfo);
            child.layoutInfo.rect.height = height;
        }
    }
    // used to get the column widths when rendering to the DOM
    getRenderedColumnWidth(node) {
        var _node_colspan;
        let colspan = (_node_colspan = node.colspan) !== null && _node_colspan !== void 0 ? _node_colspan : 1;
        var _node_colIndex;
        let colIndex = (_node_colIndex = node.colIndex) !== null && _node_colIndex !== void 0 ? _node_colIndex : node.index;
        let width = 0;
        for(let i = colIndex; i < colIndex + colspan; i++){
            let column = this.collection.columns[i];
            if ((column === null || column === void 0 ? void 0 : column.key) != null) width += this.columnWidths.get(column.key);
        }
        return width;
    }
    getEstimatedHeight(node, width, height, estimatedHeight) {
        let isEstimated = false;
        // If no explicit height is available, use an estimated height.
        if (height == null) {
            // If a previous version of this layout info exists, reuse its height.
            // Mark as estimated if the size of the overall collection view changed,
            // or the content of the item changed.
            let previousLayoutNode = this.layoutNodes.get(node.key);
            if (previousLayoutNode) {
                height = previousLayoutNode.layoutInfo.rect.height;
                isEstimated = node !== previousLayoutNode.node || width !== previousLayoutNode.layoutInfo.rect.width || previousLayoutNode.layoutInfo.estimatedSize;
            } else {
                height = estimatedHeight;
                isEstimated = true;
            }
        }
        return {
            height: height,
            isEstimated: isEstimated
        };
    }
    buildColumn(node, x, y) {
        var _node_props, _node_props1;
        let width = this.getRenderedColumnWidth(node);
        let { height: height , isEstimated: isEstimated  } = this.getEstimatedHeight(node, width, this.headingHeight, this.estimatedHeadingHeight);
        let rect = new (0, $gtW1T$Rect)(x, y, width, height);
        let layoutInfo = new (0, $gtW1T$LayoutInfo)(node.type, node.key, rect);
        layoutInfo.isSticky = !this.disableSticky && (((_node_props = node.props) === null || _node_props === void 0 ? void 0 : _node_props.isDragButtonCell) || ((_node_props1 = node.props) === null || _node_props1 === void 0 ? void 0 : _node_props1.isSelectionCell));
        layoutInfo.zIndex = layoutInfo.isSticky ? 2 : 1;
        layoutInfo.estimatedSize = isEstimated;
        return {
            layoutInfo: layoutInfo,
            validRect: layoutInfo.rect
        };
    }
    buildBody(y) {
        let rect = new (0, $gtW1T$Rect)(0, y, 0, 0);
        let layoutInfo = new (0, $gtW1T$LayoutInfo)("rowgroup", "body", rect);
        let startY = y;
        let skipped = 0;
        let width = 0;
        let children = [];
        for (let node of this.collection){
            var _this_rowHeight;
            let rowHeight = ((_this_rowHeight = this.rowHeight) !== null && _this_rowHeight !== void 0 ? _this_rowHeight : this.estimatedRowHeight) + 1;
            // Skip rows before the valid rectangle unless they are already cached.
            if (y + rowHeight < this.validRect.y && !this.isValid(node, y)) {
                y += rowHeight;
                skipped++;
                continue;
            }
            let layoutNode = this.buildChild(node, 0, y);
            layoutNode.layoutInfo.parentKey = "body";
            y = layoutNode.layoutInfo.rect.maxY;
            width = Math.max(width, layoutNode.layoutInfo.rect.width);
            children.push(layoutNode);
            if (y > this.validRect.maxY) {
                // Estimate the remaining height for rows that we don't need to layout right now.
                y += (this.collection.size - (skipped + children.length)) * rowHeight;
                break;
            }
        }
        if (this.isLoading) {
            // Add some margin around the loader to ensure that scrollbars don't flicker in and out.
            let rect = new (0, $gtW1T$Rect)(40, Math.max(y, 40), (width || this.virtualizer.visibleRect.width) - 80, children.length === 0 ? this.virtualizer.visibleRect.height - 80 : 60);
            let loader = new (0, $gtW1T$LayoutInfo)("loader", "loader", rect);
            loader.parentKey = "body";
            loader.isSticky = !this.disableSticky && children.length === 0;
            this.layoutInfos.set("loader", loader);
            children.push({
                layoutInfo: loader,
                validRect: loader.rect
            });
            y = loader.rect.maxY;
            width = Math.max(width, rect.width);
        } else if (children.length === 0) {
            let rect = new (0, $gtW1T$Rect)(40, Math.max(y, 40), this.virtualizer.visibleRect.width - 80, this.virtualizer.visibleRect.height - 80);
            let empty = new (0, $gtW1T$LayoutInfo)("empty", "empty", rect);
            empty.parentKey = "body";
            empty.isSticky = !this.disableSticky;
            this.layoutInfos.set("empty", empty);
            children.push({
                layoutInfo: empty,
                validRect: empty.rect
            });
            y = empty.rect.maxY;
            width = Math.max(width, rect.width);
        }
        rect.width = width;
        rect.height = y - startY;
        this.layoutInfos.set("body", layoutInfo);
        return {
            layoutInfo: layoutInfo,
            children: children,
            validRect: layoutInfo.rect.intersection(this.validRect)
        };
    }
    buildNode(node, x, y) {
        switch(node.type){
            case "headerrow":
                return this.buildHeaderRow(node, x, y);
            case "item":
                return this.buildRow(node, x, y);
            case "column":
            case "placeholder":
                return this.buildColumn(node, x, y);
            case "cell":
                return this.buildCell(node, x, y);
            default:
                throw new Error("Unknown node type " + node.type);
        }
    }
    buildRow(node, x, y) {
        let rect = new (0, $gtW1T$Rect)(x, y, 0, 0);
        let layoutInfo = new (0, $gtW1T$LayoutInfo)("row", node.key, rect);
        let children = [];
        let height = 0;
        for (let child of (0, $gtW1T$getChildNodes)(node, this.collection))if (x > this.validRect.maxX) {
            // Adjust existing cached layoutInfo to ensure that it is out of view.
            // This can happen due to column resizing.
            let layoutNode = this.layoutNodes.get(child.key);
            if (layoutNode) {
                layoutNode.layoutInfo.rect.x = x;
                x += layoutNode.layoutInfo.rect.width;
            }
        } else {
            let layoutNode = this.buildChild(child, x, y);
            x = layoutNode.layoutInfo.rect.maxX;
            height = Math.max(height, layoutNode.layoutInfo.rect.height);
            children.push(layoutNode);
        }
        this.setChildHeights(children, height);
        rect.width = this.layoutInfos.get("header").rect.width;
        rect.height = height + 1; // +1 for bottom border
        return {
            layoutInfo: layoutInfo,
            children: children,
            validRect: rect.intersection(this.validRect)
        };
    }
    buildCell(node, x, y) {
        var _node_props, _node_props1;
        let width = this.getRenderedColumnWidth(node);
        let { height: height , isEstimated: isEstimated  } = this.getEstimatedHeight(node, width, this.rowHeight, this.estimatedRowHeight);
        let rect = new (0, $gtW1T$Rect)(x, y, width, height);
        let layoutInfo = new (0, $gtW1T$LayoutInfo)(node.type, node.key, rect);
        layoutInfo.isSticky = !this.disableSticky && (((_node_props = node.props) === null || _node_props === void 0 ? void 0 : _node_props.isDragButtonCell) || ((_node_props1 = node.props) === null || _node_props1 === void 0 ? void 0 : _node_props1.isSelectionCell));
        layoutInfo.zIndex = layoutInfo.isSticky ? 2 : 1;
        layoutInfo.estimatedSize = isEstimated;
        return {
            layoutInfo: layoutInfo,
            validRect: rect
        };
    }
    getVisibleLayoutInfos(rect) {
        // If layout hasn't yet been done for the requested rect, union the
        // new rect with the existing valid rect, and recompute.
        if (!this.validRect.containsRect(rect) && this.lastCollection) {
            this.lastValidRect = this.validRect;
            this.validRect = this.validRect.union(rect);
            this.rootNodes = this.buildCollection();
        }
        let res = [];
        this.buildPersistedIndices();
        for (let node of this.rootNodes){
            res.push(node.layoutInfo);
            this.addVisibleLayoutInfos(res, node, rect);
        }
        return res;
    }
    addVisibleLayoutInfos(res, node, rect) {
        if (!node.children || node.children.length === 0) return;
        switch(node.layoutInfo.type){
            case "header":
                for (let child of node.children){
                    res.push(child.layoutInfo);
                    this.addVisibleLayoutInfos(res, child, rect);
                }
                break;
            case "rowgroup":
                {
                    let firstVisibleRow = this.binarySearch(node.children, rect.topLeft, "y");
                    let lastVisibleRow = this.binarySearch(node.children, rect.bottomRight, "y");
                    // Add persisted rows before the visible rows.
                    let persistedRowIndices = this.persistedIndices.get(node.layoutInfo.key);
                    let persistIndex = 0;
                    while(persistedRowIndices && persistIndex < persistedRowIndices.length && persistedRowIndices[persistIndex] < firstVisibleRow){
                        let idx = persistedRowIndices[persistIndex];
                        if (idx < node.children.length) {
                            res.push(node.children[idx].layoutInfo);
                            this.addVisibleLayoutInfos(res, node.children[idx], rect);
                        }
                        persistIndex++;
                    }
                    for(let i = firstVisibleRow; i <= lastVisibleRow; i++){
                        // Skip persisted rows that overlap with visible cells.
                        while(persistedRowIndices && persistIndex < persistedRowIndices.length && persistedRowIndices[persistIndex] < i)persistIndex++;
                        res.push(node.children[i].layoutInfo);
                        this.addVisibleLayoutInfos(res, node.children[i], rect);
                    }
                    // Add persisted rows after the visible rows.
                    while(persistedRowIndices && persistIndex < persistedRowIndices.length){
                        let idx = persistedRowIndices[persistIndex++];
                        if (idx < node.children.length) res.push(node.children[idx].layoutInfo);
                    }
                    break;
                }
            case "headerrow":
            case "row":
                {
                    let firstVisibleCell = this.binarySearch(node.children, rect.topLeft, "x");
                    let lastVisibleCell = this.binarySearch(node.children, rect.topRight, "x");
                    let stickyIndex = 0;
                    // Add persisted/sticky cells before the visible cells.
                    let persistedCellIndices = this.persistedIndices.get(node.layoutInfo.key) || this.stickyColumnIndices;
                    while(stickyIndex < persistedCellIndices.length && persistedCellIndices[stickyIndex] < firstVisibleCell){
                        let idx = persistedCellIndices[stickyIndex];
                        if (idx < node.children.length) res.push(node.children[idx].layoutInfo);
                        stickyIndex++;
                    }
                    for(let i = firstVisibleCell; i <= lastVisibleCell; i++){
                        // Skip sticky cells that overlap with visible cells.
                        while(stickyIndex < persistedCellIndices.length && persistedCellIndices[stickyIndex] < i)stickyIndex++;
                        res.push(node.children[i].layoutInfo);
                    }
                    // Add any remaining sticky cells after the visible cells.
                    while(stickyIndex < persistedCellIndices.length){
                        let idx = persistedCellIndices[stickyIndex++];
                        if (idx < node.children.length) res.push(node.children[idx].layoutInfo);
                    }
                    break;
                }
            default:
                throw new Error("Unknown node type " + node.layoutInfo.type);
        }
    }
    binarySearch(items, point, axis) {
        let low = 0;
        let high = items.length - 1;
        while(low <= high){
            let mid = low + high >> 1;
            let item = items[mid];
            if (axis === "x" && item.layoutInfo.rect.maxX < point.x || axis === "y" && item.layoutInfo.rect.maxY < point.y) low = mid + 1;
            else if (axis === "x" && item.layoutInfo.rect.x > point.x || axis === "y" && item.layoutInfo.rect.y > point.y) high = mid - 1;
            else return mid;
        }
        return Math.max(0, Math.min(items.length - 1, low));
    }
    buildPersistedIndices() {
        if (this.virtualizer.persistedKeys === this.lastPersistedKeys) return;
        this.lastPersistedKeys = this.virtualizer.persistedKeys;
        this.persistedIndices.clear();
        // Build a map of parentKey => indices of children to persist.
        for (let key of this.virtualizer.persistedKeys){
            let layoutInfo = this.layoutInfos.get(key);
            // Walk up ancestors so parents are also persisted if children are.
            while(layoutInfo && layoutInfo.parentKey){
                let collectionNode = this.collection.getItem(layoutInfo.key);
                let indices = this.persistedIndices.get(layoutInfo.parentKey);
                if (!indices) {
                    // stickyColumnIndices are always persisted along with any cells from persistedKeys.
                    indices = collectionNode.type === "cell" || collectionNode.type === "column" ? [
                        ...this.stickyColumnIndices
                    ] : [];
                    this.persistedIndices.set(layoutInfo.parentKey, indices);
                }
                let index = collectionNode.index;
                if (layoutInfo.parentKey === "body") index -= this.collection.headerRows.length;
                if (!indices.includes(index)) indices.push(index);
                layoutInfo = this.layoutInfos.get(layoutInfo.parentKey);
            }
        }
        for (let indices of this.persistedIndices.values())indices.sort((a, b)=>a - b);
    }
    getInitialLayoutInfo(layoutInfo) {
        let res = super.getInitialLayoutInfo(layoutInfo);
        // If this insert was the result of async loading, remove the zoom effect and just keep the fade in.
        if (this.wasLoading) res.transform = null;
        return res;
    }
    // Checks if Chrome version is 105 or greater
    checkChrome105() {
        var _window_navigator_userAgentData;
        if (typeof window === "undefined" || window.navigator == null) return false;
        let isChrome105;
        if (window.navigator["userAgentData"]) isChrome105 = (_window_navigator_userAgentData = window.navigator["userAgentData"]) === null || _window_navigator_userAgentData === void 0 ? void 0 : _window_navigator_userAgentData.brands.some((b)=>b.brand === "Chromium" && Number(b.version) === 105);
        else {
            let regex = /Chrome\/(\d+)/;
            let matches = regex.exec(window.navigator.userAgent);
            isChrome105 = matches && matches.length >= 2 && Number(matches[1]) === 105;
        }
        return isChrome105;
    }
    getDropTargetFromPoint(x, y, isValidDropTarget) {
        var _this_virtualizer_layout_getVisibleLayoutInfos_find;
        x += this.virtualizer.visibleRect.x;
        y += this.virtualizer.visibleRect.y;
        // Offset for height of header row
        y -= (_this_virtualizer_layout_getVisibleLayoutInfos_find = this.virtualizer.layout.getVisibleLayoutInfos(new (0, $gtW1T$Rect)(x, y, 1, 1)).find((info)=>info.type === "headerrow")) === null || _this_virtualizer_layout_getVisibleLayoutInfos_find === void 0 ? void 0 : _this_virtualizer_layout_getVisibleLayoutInfos_find.rect.height;
        // Custom variation of this.virtualizer.keyAtPoint that ignores body
        let key;
        let point = new (0, $gtW1T$Point)(x, y);
        let rectAtPoint = new (0, $gtW1T$Rect)(point.x, point.y, 1, 1);
        let layoutInfos = this.virtualizer.layout.getVisibleLayoutInfos(rectAtPoint).filter((info)=>info.type === "row");
        // Layout may return multiple layout infos in the case of
        // persisted keys, so find the first one that actually intersects.
        for (let layoutInfo of layoutInfos)if (layoutInfo.rect.intersects(rectAtPoint)) key = layoutInfo.key;
        if (key == null || this.collection.size === 0) return {
            type: "root"
        };
        let layoutInfo = this.getLayoutInfo(key);
        let rect = layoutInfo.rect;
        let target = {
            type: "item",
            key: layoutInfo.key,
            dropPosition: "on"
        };
        // If dropping on the item isn't accepted, try the target before or after depending on the y position.
        // Otherwise, if dropping on the item is accepted, still try the before/after positions if within 10px
        // of the top or bottom of the item.
        if (!isValidDropTarget(target)) {
            if (y <= rect.y + rect.height / 2 && isValidDropTarget({
                ...target,
                dropPosition: "before"
            })) target.dropPosition = "before";
            else if (isValidDropTarget({
                ...target,
                dropPosition: "after"
            })) target.dropPosition = "after";
        } else if (y <= rect.y + 10 && isValidDropTarget({
            ...target,
            dropPosition: "before"
        })) target.dropPosition = "before";
        else if (y >= rect.maxY - 10 && isValidDropTarget({
            ...target,
            dropPosition: "after"
        })) target.dropPosition = "after";
        return target;
    }
    constructor(options){
        super(options);
        this.columnWidths = new Map();
        this.wasLoading = false;
        this.isLoading = false;
        this.lastPersistedKeys = null;
        this.persistedIndices = new Map();
        this.collection = options.initialCollection;
        this.stickyColumnIndices = [];
        this.disableSticky = this.checkChrome105();
        this.columnLayout = options.columnLayout;
        let [controlledColumns, uncontrolledColumns] = this.columnLayout.splitColumnsIntoControlledAndUncontrolled(this.collection.columns);
        this.controlledColumns = controlledColumns;
        this.uncontrolledColumns = uncontrolledColumns;
        this.uncontrolledWidths = this.columnLayout.getInitialUncontrolledWidths(uncontrolledColumns);
    }
}




export {$61ef60fc9b1041f4$export$cacbb3924155d68e as ListLayout, $a152112e902709bf$export$62444c3c724b1b20 as TableLayout};
//# sourceMappingURL=module.js.map
