import {clearAnnouncer as $glIEW$clearAnnouncer, announce as $glIEW$announce} from "@react-aria/live-announcer";
import {useRef as $glIEW$useRef, useEffect as $glIEW$useEffect} from "react";
import {useEffectEvent as $glIEW$useEffectEvent, useGlobalListeners as $glIEW$useGlobalListeners} from "@react-aria/utils";
import {useLocalizedStringFormatter as $glIEW$useLocalizedStringFormatter} from "@react-aria/i18n";

function $parcel$interopDefault(a) {
  return a && a.__esModule ? a.default : a;
}
/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ /*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ 
var $a99895ee3dc79e61$exports = {};
var $ed6aae4e5f766f1e$exports = {};
$ed6aae4e5f766f1e$exports = {
    "Empty": `فارغ`
};


var $38854e2b175151fa$exports = {};
$38854e2b175151fa$exports = {
    "Empty": `Изпразни`
};


var $15b25ab20f3945b2$exports = {};
$15b25ab20f3945b2$exports = {
    "Empty": `Prázdné`
};


var $692a4298b6b649a2$exports = {};
$692a4298b6b649a2$exports = {
    "Empty": `Tom`
};


var $1c6e1539193f1243$exports = {};
$1c6e1539193f1243$exports = {
    "Empty": `Leer`
};


var $1e8678632c464b6d$exports = {};
$1e8678632c464b6d$exports = {
    "Empty": `Άδειο`
};


var $4adc85d9bf5b9eed$exports = {};
$4adc85d9bf5b9eed$exports = {
    "Empty": `Empty`
};


var $41c4b2bb61dafbca$exports = {};
$41c4b2bb61dafbca$exports = {
    "Empty": `Vacío`
};


var $405f8b24f5dd2a60$exports = {};
$405f8b24f5dd2a60$exports = {
    "Empty": `Tühjenda`
};


var $7efe3ed02b9b9dd4$exports = {};
$7efe3ed02b9b9dd4$exports = {
    "Empty": `Tyhjä`
};


var $99fc4c101d92daf3$exports = {};
$99fc4c101d92daf3$exports = {
    "Empty": `Vide`
};


var $f9e155e6e8cacaa2$exports = {};
$f9e155e6e8cacaa2$exports = {
    "Empty": `ריק`
};


var $c31b5e8e9a249fd5$exports = {};
$c31b5e8e9a249fd5$exports = {
    "Empty": `Prazno`
};


var $9c5435bc17499bd9$exports = {};
$9c5435bc17499bd9$exports = {
    "Empty": `Üres`
};


var $6d1fc8e84d8165e1$exports = {};
$6d1fc8e84d8165e1$exports = {
    "Empty": `Vuoto`
};


var $46ea6b3641b83e71$exports = {};
$46ea6b3641b83e71$exports = {
    "Empty": `空`
};


var $0e3cc9a288289dc5$exports = {};
$0e3cc9a288289dc5$exports = {
    "Empty": `비어 있음`
};


var $4ff2bb25c0089ffb$exports = {};
$4ff2bb25c0089ffb$exports = {
    "Empty": `Tuščias`
};


var $6cf33cd4c010a2fb$exports = {};
$6cf33cd4c010a2fb$exports = {
    "Empty": `Tukšs`
};


var $5a9f8486f8b8837e$exports = {};
$5a9f8486f8b8837e$exports = {
    "Empty": `Tom`
};


var $583f94d807f6ecea$exports = {};
$583f94d807f6ecea$exports = {
    "Empty": `Leeg`
};


var $cc4dcfeea2b4050d$exports = {};
$cc4dcfeea2b4050d$exports = {
    "Empty": `Pusty`
};


var $68ac2954d56e12b4$exports = {};
$68ac2954d56e12b4$exports = {
    "Empty": `Vazio`
};


var $fdb0616f309780b0$exports = {};
$fdb0616f309780b0$exports = {
    "Empty": `Vazio`
};


var $fe1eccf4ee1d6f52$exports = {};
$fe1eccf4ee1d6f52$exports = {
    "Empty": `Gol`
};


var $a38b6c4e18725976$exports = {};
$a38b6c4e18725976$exports = {
    "Empty": `Не заполнено`
};


var $6c14ae2b766b652c$exports = {};
$6c14ae2b766b652c$exports = {
    "Empty": `Prázdne`
};


var $8f1c9692e16dc5eb$exports = {};
$8f1c9692e16dc5eb$exports = {
    "Empty": `Prazen`
};


var $d2aa7abea627cafa$exports = {};
$d2aa7abea627cafa$exports = {
    "Empty": `Prazno`
};


var $676b82e4b56408e6$exports = {};
$676b82e4b56408e6$exports = {
    "Empty": `Tomt`
};


var $14c9042552d7ce08$exports = {};
$14c9042552d7ce08$exports = {
    "Empty": `Boş`
};


var $393254ebcb66c9f5$exports = {};
$393254ebcb66c9f5$exports = {
    "Empty": `Пусто`
};


var $d49d621f310cf6ce$exports = {};
$d49d621f310cf6ce$exports = {
    "Empty": `空`
};


var $94b60c866ca5dfe6$exports = {};
$94b60c866ca5dfe6$exports = {
    "Empty": `空白`
};


$a99895ee3dc79e61$exports = {
    "ar-AE": $ed6aae4e5f766f1e$exports,
    "bg-BG": $38854e2b175151fa$exports,
    "cs-CZ": $15b25ab20f3945b2$exports,
    "da-DK": $692a4298b6b649a2$exports,
    "de-DE": $1c6e1539193f1243$exports,
    "el-GR": $1e8678632c464b6d$exports,
    "en-US": $4adc85d9bf5b9eed$exports,
    "es-ES": $41c4b2bb61dafbca$exports,
    "et-EE": $405f8b24f5dd2a60$exports,
    "fi-FI": $7efe3ed02b9b9dd4$exports,
    "fr-FR": $99fc4c101d92daf3$exports,
    "he-IL": $f9e155e6e8cacaa2$exports,
    "hr-HR": $c31b5e8e9a249fd5$exports,
    "hu-HU": $9c5435bc17499bd9$exports,
    "it-IT": $6d1fc8e84d8165e1$exports,
    "ja-JP": $46ea6b3641b83e71$exports,
    "ko-KR": $0e3cc9a288289dc5$exports,
    "lt-LT": $4ff2bb25c0089ffb$exports,
    "lv-LV": $6cf33cd4c010a2fb$exports,
    "nb-NO": $5a9f8486f8b8837e$exports,
    "nl-NL": $583f94d807f6ecea$exports,
    "pl-PL": $cc4dcfeea2b4050d$exports,
    "pt-BR": $68ac2954d56e12b4$exports,
    "pt-PT": $fdb0616f309780b0$exports,
    "ro-RO": $fe1eccf4ee1d6f52$exports,
    "ru-RU": $a38b6c4e18725976$exports,
    "sk-SK": $6c14ae2b766b652c$exports,
    "sl-SI": $8f1c9692e16dc5eb$exports,
    "sr-SP": $d2aa7abea627cafa$exports,
    "sv-SE": $676b82e4b56408e6$exports,
    "tr-TR": $14c9042552d7ce08$exports,
    "uk-UA": $393254ebcb66c9f5$exports,
    "zh-CN": $d49d621f310cf6ce$exports,
    "zh-TW": $94b60c866ca5dfe6$exports
};





function $d2e8511e6f209edf$export$e908e06f4b8e3402(props) {
    const _async = (0, $glIEW$useRef)();
    let { value: value , textValue: textValue , minValue: minValue , maxValue: maxValue , isDisabled: isDisabled , isReadOnly: isReadOnly , isRequired: isRequired , onIncrement: onIncrement , onIncrementPage: onIncrementPage , onDecrement: onDecrement , onDecrementPage: onDecrementPage , onDecrementToMin: onDecrementToMin , onIncrementToMax: onIncrementToMax  } = props;
    const stringFormatter = (0, $glIEW$useLocalizedStringFormatter)((0, (/*@__PURE__*/$parcel$interopDefault($a99895ee3dc79e61$exports))));
    const clearAsync = ()=>clearTimeout(_async.current);
    // eslint-disable-next-line arrow-body-style
    (0, $glIEW$useEffect)(()=>{
        return ()=>clearAsync();
    }, []);
    let onKeyDown = (e)=>{
        if (e.ctrlKey || e.metaKey || e.shiftKey || e.altKey || isReadOnly) return;
        switch(e.key){
            case "PageUp":
                if (onIncrementPage) {
                    e.preventDefault();
                    onIncrementPage();
                    break;
                }
            // fallthrough!
            case "ArrowUp":
            case "Up":
                if (onIncrement) {
                    e.preventDefault();
                    onIncrement();
                }
                break;
            case "PageDown":
                if (onDecrementPage) {
                    e.preventDefault();
                    onDecrementPage();
                    break;
                }
            // fallthrough
            case "ArrowDown":
            case "Down":
                if (onDecrement) {
                    e.preventDefault();
                    onDecrement();
                }
                break;
            case "Home":
                if (onDecrementToMin) {
                    e.preventDefault();
                    onDecrementToMin();
                }
                break;
            case "End":
                if (onIncrementToMax) {
                    e.preventDefault();
                    onIncrementToMax();
                }
                break;
        }
    };
    let isFocused = (0, $glIEW$useRef)(false);
    let onFocus = ()=>{
        isFocused.current = true;
    };
    let onBlur = ()=>{
        isFocused.current = false;
    };
    // Replace Unicode hyphen-minus (U+002D) with minus sign (U+2212).
    // This ensures that macOS VoiceOver announces it as "minus" even with other characters between the minus sign
    // and the number (e.g. currency symbol). Otherwise it announces nothing because it assumes the character is a hyphen.
    // In addition, replace the empty string with the word "Empty" so that iOS VoiceOver does not read "50%" for an empty field.
    textValue = textValue === "" ? stringFormatter.format("Empty") : (textValue || `${value}`).replace("-", "−");
    (0, $glIEW$useEffect)(()=>{
        if (isFocused.current) {
            (0, $glIEW$clearAnnouncer)("assertive");
            (0, $glIEW$announce)(textValue, "assertive");
        }
    }, [
        textValue
    ]);
    const onIncrementPressStart = (0, $glIEW$useEffectEvent)((initialStepDelay)=>{
        clearAsync();
        onIncrement();
        // Start spinning after initial delay
        _async.current = window.setTimeout(()=>{
            if (isNaN(maxValue) || isNaN(value) || value < maxValue) onIncrementPressStart(60);
        }, initialStepDelay);
    });
    const onDecrementPressStart = (0, $glIEW$useEffectEvent)((initialStepDelay)=>{
        clearAsync();
        onDecrement();
        // Start spinning after initial delay
        _async.current = window.setTimeout(()=>{
            if (isNaN(minValue) || isNaN(value) || value > minValue) onDecrementPressStart(60);
        }, initialStepDelay);
    });
    let cancelContextMenu = (e)=>{
        e.preventDefault();
    };
    let { addGlobalListener: addGlobalListener , removeAllGlobalListeners: removeAllGlobalListeners  } = (0, $glIEW$useGlobalListeners)();
    return {
        spinButtonProps: {
            role: "spinbutton",
            "aria-valuenow": !isNaN(value) ? value : null,
            "aria-valuetext": textValue,
            "aria-valuemin": minValue,
            "aria-valuemax": maxValue,
            "aria-disabled": isDisabled || null,
            "aria-readonly": isReadOnly || null,
            "aria-required": isRequired || null,
            onKeyDown: onKeyDown,
            onFocus: onFocus,
            onBlur: onBlur
        },
        incrementButtonProps: {
            onPressStart: ()=>{
                onIncrementPressStart(400);
                addGlobalListener(window, "contextmenu", cancelContextMenu);
            },
            onPressEnd: ()=>{
                clearAsync();
                removeAllGlobalListeners();
            },
            onFocus: onFocus,
            onBlur: onBlur
        },
        decrementButtonProps: {
            onPressStart: ()=>{
                onDecrementPressStart(400);
                addGlobalListener(window, "contextmenu", cancelContextMenu);
            },
            onPressEnd: ()=>{
                clearAsync();
                removeAllGlobalListeners();
            },
            onFocus: onFocus,
            onBlur: onBlur
        }
    };
}




export {$d2e8511e6f209edf$export$e908e06f4b8e3402 as useSpinButton};
//# sourceMappingURL=module.js.map
