var $fHYTQ$reactariautils = require("@react-aria/utils");
var $fHYTQ$reactariai18n = require("@react-aria/i18n");
var $fHYTQ$reactariainteractions = require("@react-aria/interactions");
var $fHYTQ$reactariaoverlays = require("@react-aria/overlays");
var $fHYTQ$reactariaselection = require("@react-aria/selection");
var $fHYTQ$reactariafocus = require("@react-aria/focus");
var $fHYTQ$reactstatelycollections = require("@react-stately/collections");
var $fHYTQ$react = require("react");

function $parcel$export(e, n, v, s) {
  Object.defineProperty(e, n, {get: v, set: s, enumerable: true, configurable: true});
}
function $parcel$interopDefault(a) {
  return a && a.__esModule ? a.default : a;
}

$parcel$export(module.exports, "useMenuTrigger", () => $7211ab9328763fb9$export$dc9c12ed27dd1b49);
$parcel$export(module.exports, "useMenu", () => $a3815f0132802737$export$38eaa17faae8f579);
$parcel$export(module.exports, "useMenuItem", () => $38191ed02615ec07$export$9d32628fc2aea7da);
$parcel$export(module.exports, "useMenuSection", () => $63008655e23408c5$export$73f7a44322579622);
/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ /*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ var $d1742ec2644a0949$exports = {};
var $429891642bf97c51$exports = {};
$429891642bf97c51$exports = {
    "longPressMessage": `اضغط مطولاً أو اضغط على Alt + السهم لأسفل لفتح القائمة`
};


var $40d90b799072e111$exports = {};
$40d90b799072e111$exports = {
    "longPressMessage": `Натиснете продължително или натиснете Alt+ стрелка надолу, за да отворите менюто`
};


var $587b89d60e4f3e24$exports = {};
$587b89d60e4f3e24$exports = {
    "longPressMessage": `Dlouhým stiskem nebo stisknutím kláves Alt + šipka dolů otevřete nabídku`
};


var $79eb8045886465e9$exports = {};
$79eb8045886465e9$exports = {
    "longPressMessage": `Langt tryk eller tryk på Alt + pil ned for at åbne menuen`
};


var $9c6faa2088d34bf1$exports = {};
$9c6faa2088d34bf1$exports = {
    "longPressMessage": `Drücken Sie lange oder drücken Sie Alt + Nach-unten, um das Menü zu öffnen`
};


var $ee6e1292c61a8135$exports = {};
$ee6e1292c61a8135$exports = {
    "longPressMessage": `Πιέστε παρατεταμένα ή πατήστε Alt + κάτω βέλος για να ανοίξετε το μενού`
};


var $f479187898d153cc$exports = {};
$f479187898d153cc$exports = {
    "longPressMessage": `Long press or press Alt + ArrowDown to open menu`
};


var $1e6a91f77efbb11f$exports = {};
$1e6a91f77efbb11f$exports = {
    "longPressMessage": `Mantenga pulsado o pulse Alt + flecha abajo para abrir el menú`
};


var $f2fb75e964082636$exports = {};
$f2fb75e964082636$exports = {
    "longPressMessage": `Menüü avamiseks vajutage pikalt või vajutage klahve Alt + allanool`
};


var $75cc65c4b616fac1$exports = {};
$75cc65c4b616fac1$exports = {
    "longPressMessage": `Avaa valikko painamalla pohjassa tai näppäinyhdistelmällä Alt + Alanuoli`
};


var $82a179939aabd1ee$exports = {};
$82a179939aabd1ee$exports = {
    "longPressMessage": `Appuyez de manière prolongée ou appuyez sur Alt + Flèche vers le bas pour ouvrir le menu.`
};


var $40aa37345f1f8748$exports = {};
$40aa37345f1f8748$exports = {
    "longPressMessage": `לחץ לחיצה ארוכה או הקש Alt + ArrowDown כדי לפתוח את התפריט`
};


var $c00088e5c377e2c5$exports = {};
$c00088e5c377e2c5$exports = {
    "longPressMessage": `Dugo pritisnite ili pritisnite Alt + strelicu prema dolje za otvaranje izbornika`
};


var $51f736a409b7d295$exports = {};
$51f736a409b7d295$exports = {
    "longPressMessage": `Nyomja meg hosszan, vagy nyomja meg az Alt + lefele nyíl gombot a menü megnyitásához`
};


var $65bb74747bd8f2fb$exports = {};
$65bb74747bd8f2fb$exports = {
    "longPressMessage": `Premere a lungo o premere Alt + Freccia giù per aprire il menu`
};


var $1bc11da108727c27$exports = {};
$1bc11da108727c27$exports = {
    "longPressMessage": `長押しまたは Alt+下矢印キーでメニューを開く`
};


var $118d77e4be898c17$exports = {};
$118d77e4be898c17$exports = {
    "longPressMessage": `길게 누르거나 Alt + 아래쪽 화살표를 눌러 메뉴 열기`
};


var $4db9ebadbf792309$exports = {};
$4db9ebadbf792309$exports = {
    "longPressMessage": `Norėdami atidaryti meniu, nuspaudę palaikykite arba paspauskite „Alt + ArrowDown“.`
};


var $51288b53bc93ac3d$exports = {};
$51288b53bc93ac3d$exports = {
    "longPressMessage": `Lai atvērtu izvēlni, turiet nospiestu vai nospiediet taustiņu kombināciju Alt + lejupvērstā bultiņa`
};


var $1a4b31206cd66e98$exports = {};
$1a4b31206cd66e98$exports = {
    "longPressMessage": `Langt trykk eller trykk Alt + PilNed for å åpne menyen`
};


var $21e944c6af0b8453$exports = {};
$21e944c6af0b8453$exports = {
    "longPressMessage": `Druk lang op Alt + pijl-omlaag of druk op Alt om het menu te openen`
};


var $20509ccafe6fe6aa$exports = {};
$20509ccafe6fe6aa$exports = {
    "longPressMessage": `Naciśnij i przytrzymaj lub naciśnij klawisze Alt + Strzałka w dół, aby otworzyć menu`
};


var $8006eac1d5d4665b$exports = {};
$8006eac1d5d4665b$exports = {
    "longPressMessage": `Pressione e segure ou pressione Alt + Seta para baixo para abrir o menu`
};


var $4875d1b529941a0a$exports = {};
$4875d1b529941a0a$exports = {
    "longPressMessage": `Prima continuamente ou prima Alt + Seta Para Baixo para abrir o menu`
};


var $37939d04a40a865b$exports = {};
$37939d04a40a865b$exports = {
    "longPressMessage": `Apăsați lung sau apăsați pe Alt + săgeată în jos pentru a deschide meniul`
};


var $fd1c8a4521d30c69$exports = {};
$fd1c8a4521d30c69$exports = {
    "longPressMessage": `Нажмите и удерживайте или нажмите Alt + Стрелка вниз, чтобы открыть меню`
};


var $2940d0a4ba6cbd64$exports = {};
$2940d0a4ba6cbd64$exports = {
    "longPressMessage": `Ponuku otvoríte dlhým stlačením alebo stlačením klávesu Alt + klávesu so šípkou nadol`
};


var $cb481a56d5c8fa56$exports = {};
$cb481a56d5c8fa56$exports = {
    "longPressMessage": `Za odprtje menija pritisnite in držite gumb ali pritisnite Alt+puščica navzdol`
};


var $ecbdeaa2c85d1b32$exports = {};
$ecbdeaa2c85d1b32$exports = {
    "longPressMessage": `Dugo pritisnite ili pritisnite Alt + strelicu prema dole da otvorite meni`
};


var $aeca4735c8d1bab6$exports = {};
$aeca4735c8d1bab6$exports = {
    "longPressMessage": `Håll nedtryckt eller tryck på Alt + pil nedåt för att öppna menyn`
};


var $68243426be5c9f01$exports = {};
$68243426be5c9f01$exports = {
    "longPressMessage": `Menüyü açmak için uzun basın veya Alt + Aşağı Ok tuşuna basın`
};


var $bde63de8df74e87d$exports = {};
$bde63de8df74e87d$exports = {
    "longPressMessage": `Довго або звичайно натисніть комбінацію клавіш Alt і стрілка вниз, щоб відкрити меню`
};


var $2d16ab23cbf254d4$exports = {};
$2d16ab23cbf254d4$exports = {
    "longPressMessage": `长按或按 Alt + 向下方向键以打开菜单`
};


var $bd9ff3a1da9d944a$exports = {};
$bd9ff3a1da9d944a$exports = {
    "longPressMessage": `長按或按 Alt+向下鍵以開啟功能表`
};


$d1742ec2644a0949$exports = {
    "ar-AE": $429891642bf97c51$exports,
    "bg-BG": $40d90b799072e111$exports,
    "cs-CZ": $587b89d60e4f3e24$exports,
    "da-DK": $79eb8045886465e9$exports,
    "de-DE": $9c6faa2088d34bf1$exports,
    "el-GR": $ee6e1292c61a8135$exports,
    "en-US": $f479187898d153cc$exports,
    "es-ES": $1e6a91f77efbb11f$exports,
    "et-EE": $f2fb75e964082636$exports,
    "fi-FI": $75cc65c4b616fac1$exports,
    "fr-FR": $82a179939aabd1ee$exports,
    "he-IL": $40aa37345f1f8748$exports,
    "hr-HR": $c00088e5c377e2c5$exports,
    "hu-HU": $51f736a409b7d295$exports,
    "it-IT": $65bb74747bd8f2fb$exports,
    "ja-JP": $1bc11da108727c27$exports,
    "ko-KR": $118d77e4be898c17$exports,
    "lt-LT": $4db9ebadbf792309$exports,
    "lv-LV": $51288b53bc93ac3d$exports,
    "nb-NO": $1a4b31206cd66e98$exports,
    "nl-NL": $21e944c6af0b8453$exports,
    "pl-PL": $20509ccafe6fe6aa$exports,
    "pt-BR": $8006eac1d5d4665b$exports,
    "pt-PT": $4875d1b529941a0a$exports,
    "ro-RO": $37939d04a40a865b$exports,
    "ru-RU": $fd1c8a4521d30c69$exports,
    "sk-SK": $2940d0a4ba6cbd64$exports,
    "sl-SI": $cb481a56d5c8fa56$exports,
    "sr-SP": $ecbdeaa2c85d1b32$exports,
    "sv-SE": $aeca4735c8d1bab6$exports,
    "tr-TR": $68243426be5c9f01$exports,
    "uk-UA": $bde63de8df74e87d$exports,
    "zh-CN": $2d16ab23cbf254d4$exports,
    "zh-TW": $bd9ff3a1da9d944a$exports
};






function $7211ab9328763fb9$export$dc9c12ed27dd1b49(props, state, ref) {
    let { type: type = "menu" , isDisabled: isDisabled , trigger: trigger = "press"  } = props;
    let menuTriggerId = (0, $fHYTQ$reactariautils.useId)();
    let { triggerProps: triggerProps , overlayProps: overlayProps  } = (0, $fHYTQ$reactariaoverlays.useOverlayTrigger)({
        type: type
    }, state, ref);
    let onKeyDown = (e)=>{
        if (isDisabled) return;
        if (trigger === "longPress" && !e.altKey) return;
        if (ref && ref.current) switch(e.key){
            case "Enter":
            case " ":
                if (trigger === "longPress") return;
            // fallthrough
            case "ArrowDown":
                // Stop propagation, unless it would already be handled by useKeyboard.
                if (!("continuePropagation" in e)) e.stopPropagation();
                e.preventDefault();
                state.toggle("first");
                break;
            case "ArrowUp":
                if (!("continuePropagation" in e)) e.stopPropagation();
                e.preventDefault();
                state.toggle("last");
                break;
        }
    };
    let stringFormatter = (0, $fHYTQ$reactariai18n.useLocalizedStringFormatter)((0, (/*@__PURE__*/$parcel$interopDefault($d1742ec2644a0949$exports))));
    let { longPressProps: longPressProps  } = (0, $fHYTQ$reactariainteractions.useLongPress)({
        isDisabled: isDisabled || trigger !== "longPress",
        accessibilityDescription: stringFormatter.format("longPressMessage"),
        onLongPressStart () {
            state.close();
        },
        onLongPress () {
            state.open("first");
        }
    });
    let pressProps = {
        onPressStart (e) {
            // For consistency with native, open the menu on mouse/key down, but touch up.
            if (e.pointerType !== "touch" && e.pointerType !== "keyboard" && !isDisabled) // If opened with a screen reader, auto focus the first item.
            // Otherwise, the menu itself will be focused.
            state.toggle(e.pointerType === "virtual" ? "first" : null);
        },
        onPress (e) {
            if (e.pointerType === "touch" && !isDisabled) state.toggle();
        }
    };
    // omit onPress from triggerProps since we override it above.
    delete triggerProps.onPress;
    return {
        menuTriggerProps: {
            ...triggerProps,
            ...trigger === "press" ? pressProps : longPressProps,
            id: menuTriggerId,
            onKeyDown: onKeyDown
        },
        menuProps: {
            ...overlayProps,
            "aria-labelledby": menuTriggerId,
            autoFocus: state.focusStrategy || true,
            onClose: state.close
        }
    };
}


/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ 

const $a3815f0132802737$export$6f49b4016bfc8d56 = new WeakMap();
function $a3815f0132802737$export$38eaa17faae8f579(props, state, ref) {
    let { shouldFocusWrap: shouldFocusWrap = true , ...otherProps } = props;
    if (!props["aria-label"] && !props["aria-labelledby"]) console.warn("An aria-label or aria-labelledby prop is required for accessibility.");
    let domProps = (0, $fHYTQ$reactariautils.filterDOMProps)(props, {
        labelable: true
    });
    let { listProps: listProps  } = (0, $fHYTQ$reactariaselection.useSelectableList)({
        ...otherProps,
        ref: ref,
        selectionManager: state.selectionManager,
        collection: state.collection,
        disabledKeys: state.disabledKeys,
        shouldFocusWrap: shouldFocusWrap
    });
    $a3815f0132802737$export$6f49b4016bfc8d56.set(state, {
        onClose: props.onClose,
        onAction: props.onAction
    });
    return {
        menuProps: (0, $fHYTQ$reactariautils.mergeProps)(domProps, {
            role: "menu",
            // this forces AT to move their cursors into any open sub dialogs, the sub dialogs contain hidden close buttons in order to come back to this level of the menu
            "aria-hidden": state.expandedKeys.size > 0 ? true : undefined,
            ...listProps,
            onKeyDown: (e)=>{
                // don't clear the menu selected keys if the user is presses escape since escape closes the menu
                if (e.key !== "Escape") listProps.onKeyDown(e);
            }
        })
    };
}


/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ 







function $38191ed02615ec07$export$9d32628fc2aea7da(props, state, ref) {
    let { key: key , closeOnSelect: closeOnSelect , isVirtualized: isVirtualized , "aria-haspopup": hasPopup  } = props;
    let { direction: direction  } = (0, $fHYTQ$reactariai18n.useLocale)();
    let isTrigger = !!hasPopup;
    let isOpen = state.expandedKeys.has(key);
    var _props_isDisabled;
    let isDisabled = (_props_isDisabled = props.isDisabled) !== null && _props_isDisabled !== void 0 ? _props_isDisabled : state.disabledKeys.has(key);
    var _props_isSelected;
    let isSelected = (_props_isSelected = props.isSelected) !== null && _props_isSelected !== void 0 ? _props_isSelected : state.selectionManager.isSelected(key);
    let openTimeout = (0, $fHYTQ$react.useRef)();
    let cancelOpenTimeout = (0, $fHYTQ$react.useCallback)(()=>{
        if (openTimeout.current) {
            clearTimeout(openTimeout.current);
            openTimeout.current = undefined;
        }
    }, [
        openTimeout
    ]);
    let onSubmenuOpen = (0, $fHYTQ$reactariautils.useEffectEvent)(()=>{
        cancelOpenTimeout();
        state.setExpandedKeys(new Set([
            key
        ]));
    });
    (0, $fHYTQ$reactariautils.useLayoutEffect)(()=>{
        return ()=>cancelOpenTimeout();
    }, [
        cancelOpenTimeout
    ]);
    let data = (0, $a3815f0132802737$export$6f49b4016bfc8d56).get(state);
    let onClose = props.onClose || data.onClose;
    let onActionMenuDialogTrigger = (0, $fHYTQ$react.useCallback)(()=>{
        onSubmenuOpen();
    // will need to disable this lint rule when using useEffectEvent https://react.dev/learn/separating-events-from-effects#logic-inside-effects-is-reactive
    // eslint-disable-next-line react-hooks/exhaustive-deps
    }, []);
    let onAction = isTrigger ? onActionMenuDialogTrigger : props.onAction || data.onAction;
    let role = "menuitem";
    if (state.selectionManager.selectionMode === "single") role = "menuitemradio";
    else if (state.selectionManager.selectionMode === "multiple") role = "menuitemcheckbox";
    let labelId = (0, $fHYTQ$reactariautils.useSlotId)();
    let descriptionId = (0, $fHYTQ$reactariautils.useSlotId)();
    let keyboardId = (0, $fHYTQ$reactariautils.useSlotId)();
    let ariaProps = {
        "aria-disabled": isDisabled || undefined,
        role: role,
        "aria-label": props["aria-label"],
        "aria-labelledby": labelId,
        "aria-describedby": [
            descriptionId,
            keyboardId
        ].filter(Boolean).join(" ") || undefined
    };
    if (state.selectionManager.selectionMode !== "none") ariaProps["aria-checked"] = isSelected;
    if (isVirtualized) {
        ariaProps["aria-posinset"] = state.collection.getItem(key).index;
        ariaProps["aria-setsize"] = (0, $fHYTQ$reactstatelycollections.getItemCount)(state.collection);
    }
    if (hasPopup != null) {
        ariaProps["aria-haspopup"] = hasPopup;
        ariaProps["aria-expanded"] = isOpen ? "true" : "false";
    }
    let onPressStart = (e)=>{
        if (e.pointerType === "keyboard" && onAction) onAction(key);
    };
    let onPressUp = (e)=>{
        if (e.pointerType !== "keyboard") {
            if (onAction) onAction(key);
            // Pressing a menu item should close by default in single selection mode but not multiple
            // selection mode, except if overridden by the closeOnSelect prop.
            if (!isTrigger && onClose && (closeOnSelect !== null && closeOnSelect !== void 0 ? closeOnSelect : state.selectionManager.selectionMode !== "multiple")) onClose();
        }
    };
    let { itemProps: itemProps , isFocused: isFocused  } = (0, $fHYTQ$reactariaselection.useSelectableItem)({
        selectionManager: state.selectionManager,
        key: key,
        ref: ref,
        shouldSelectOnPressUp: true,
        allowsDifferentPressOrigin: true
    });
    let { pressProps: pressProps , isPressed: isPressed  } = (0, $fHYTQ$reactariainteractions.usePress)({
        onPressStart: onPressStart,
        onPressUp: onPressUp,
        isDisabled: isDisabled || isTrigger && state.expandedKeys.has(key)
    });
    let { hoverProps: hoverProps  } = (0, $fHYTQ$reactariainteractions.useHover)({
        isDisabled: isDisabled,
        onHoverStart () {
            if (!(0, $fHYTQ$reactariainteractions.isFocusVisible)() && !(isTrigger && state.expandedKeys.has(key))) {
                state.selectionManager.setFocused(true);
                state.selectionManager.setFocusedKey(key);
                // focus immediately so that a focus scope opened on hover has the correct restore node
                let isFocused = key === state.selectionManager.focusedKey;
                if (isFocused && state.selectionManager.isFocused && document.activeElement !== ref.current) (0, $fHYTQ$reactariafocus.focusSafely)(ref.current);
            }
        },
        onHoverChange: (isHovered)=>{
            if (isHovered && isTrigger && !state.expandedKeys.has(key)) {
                if (!openTimeout.current) openTimeout.current = setTimeout(()=>{
                    onSubmenuOpen();
                }, 200);
            } else if (!isHovered) cancelOpenTimeout();
        }
    });
    let { keyboardProps: keyboardProps  } = (0, $fHYTQ$reactariainteractions.useKeyboard)({
        onKeyDown: (e)=>{
            // Ignore repeating events, which may have started on the menu trigger before moving
            // focus to the menu item. We want to wait for a second complete key press sequence.
            if (e.repeat) {
                e.continuePropagation();
                return;
            }
            switch(e.key){
                case " ":
                    if (!isDisabled && state.selectionManager.selectionMode === "none" && !isTrigger && closeOnSelect !== false && onClose) onClose();
                    break;
                case "Enter":
                    // The Enter key should always close on select, except if overridden.
                    if (!isDisabled && closeOnSelect !== false && !isTrigger && onClose) onClose();
                    break;
                case "ArrowRight":
                    if (isTrigger && direction === "ltr") onSubmenuOpen();
                    else e.continuePropagation();
                    break;
                case "ArrowLeft":
                    if (isTrigger && direction === "rtl") onSubmenuOpen();
                    else e.continuePropagation();
                    break;
                default:
                    e.continuePropagation();
                    break;
            }
        }
    });
    return {
        menuItemProps: {
            ...ariaProps,
            ...(0, $fHYTQ$reactariautils.mergeProps)(itemProps, pressProps, hoverProps, keyboardProps)
        },
        labelProps: {
            id: labelId
        },
        descriptionProps: {
            id: descriptionId
        },
        keyboardShortcutProps: {
            id: keyboardId
        },
        isFocused: isFocused,
        isSelected: isSelected,
        isPressed: isPressed,
        isDisabled: isDisabled
    };
}


/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ 
function $63008655e23408c5$export$73f7a44322579622(props) {
    let { heading: heading , "aria-label": ariaLabel  } = props;
    let headingId = (0, $fHYTQ$reactariautils.useId)();
    return {
        itemProps: {
            role: "presentation"
        },
        headingProps: heading ? {
            // Techincally, menus cannot contain headings according to ARIA.
            // We hide the heading from assistive technology, using role="presentation",
            // and only use it as a label for the nested group.
            id: headingId,
            role: "presentation"
        } : {},
        groupProps: {
            role: "group",
            "aria-label": ariaLabel,
            "aria-labelledby": heading ? headingId : undefined
        }
    };
}




//# sourceMappingURL=main.js.map
