'use strict';

var contextMenu = {
	cut: "Cu&t",
	copy: "&Kopiera",
	paste: "&Klistra in",
	selectAll: "Välj &alla",
	undo: "&Ångra",
	redo: "&Gör om",
	spelling: "Stavning",
	spellingLanguages: "Stavningsspråk",
	moreSpellingSuggestions: "Fler stavningsförslag",
	noSpellingSuggestions: "Inga förslag",
	copyLinkAddress: "Kopiera länkadressen",
	copyLinkText: "Kopiera länktext",
	openLink: "Öppna länken",
	saveImageAs: "Spara bilden som...",
	copyImage: "Kopiera bilden"
};
var dialog = {
	about: {
		title: "Om {{- appName}}",
		version: "Version: <1>{{-version}}</1>",
		checkUpdates: "Sök efter uppdateringar",
		checkUpdatesOnStart: "Sök efter uppdateringar vid start",
		noUpdatesAvailable: "Inga uppdateringar är tillgängliga.",
		copyright: "Upphovsrätt {{copyright}}",
		errorWhenLookingForUpdates: "Ett fel har inträffat vid sökning efter uppdateringar",
		updateChannel: {
			label: "Uppdatera Kanal",
			latest: "Stabil",
			beta: "Beta",
			alpha: "Alpha (experimentell)"
		}
	},
	addServer: {
		title: "Lägg till server",
		message: "Vill du lägga till \"{{- host}}\" till din lista över servrar?",
		add: "Lägg till",
		cancel: "Avbryt"
	},
	addServerError: {
		title: "Ogiltigt servernamn",
		message: "Servern \"{{- host}}\" kunde inte valideras och lades därför inte till."
	},
	certificateError: {
		title: "Certifikatsfel",
		message: "Litar du på certifikat från \"{{- issuerName}}\"? Klicka bara på \"Ja\" om du verkligen litar på det här certifikatet. Om du är osäker bör du kontakta ditt IT- eller säkerhetsteam innan du klickar på \"Ja\".",
		yes: "Ja",
		no: "Nej"
	},
	clearCache: {
		announcement: "Tvinga omladdning",
		title: "Vill du behålla din inloggningssession?",
		message: "Om du tar bort din inloggningssession loggas du ut och ombeds att ange dina inloggningsuppgifter igen.",
		keepLoginData: "Behåll inloggningssessionen",
		deleteLoginData: "Radera inloggningssessionen",
		clearingWait: "Vänligen vänta",
		cancel: "Avbryt"
	},
	downloadRemoval: {
		title: "Är du säker?",
		message: "Vill du ta bort denna nedladdning?",
		yes: "Ja",
		no: "Nej"
	},
	resetAppData: {
		title: "Återställ appdata",
		message: "Detta kommer att logga ut dig från alla dina team och återställa appen till dess ursprungliga inställningar. Detta kan inte ångras.",
		yes: "Ja",
		cancel: "Avbryt"
	},
	clearPermittedScreenCaptureServers: {
		title: "Rensa tillåtna servrar för skärmdumpning",
		message: "Detta kommer att rensa alla behörigheter för skärmdumpsservrar, vilket gör att de ber om tillstånd igen. Detta kan inte ångras.",
		yes: "Ja",
		cancel: "Avbryt"
	},
	screenshare: {
		title: "Dela din skärm",
		announcement: "Välj en skärm att dela"
	},
	update: {
		title: "Uppdatering finns tillgänglig",
		announcement: "En ny uppdatering finns tillgänglig",
		message: "En ny version av Rocket.Chat Desktop App är tillgänglig!",
		currentVersion: "Nuvarande version:",
		newVersion: "Ny version:",
		install: "Installera uppdatering",
		remindLater: "Påminn mig senare",
		skip: "Hoppa över denna version"
	},
	updateDownloading: {
		title: "Nedladdning av uppdatering",
		message: "Du kommer att få ett meddelande när uppdateringen är klar att installeras",
		ok: "OK"
	},
	updateInstallLater: {
		title: "Installera senare",
		message: "Uppdateringen kommer att installeras när du lämnar appen",
		ok: "OK"
	},
	updateReady: {
		title: "Uppdatering klar för installation",
		message: "Uppdateringen har laddats ner",
		installNow: "Installera nu",
		installLater: "Installera senare"
	},
	updateSkip: {
		title: "Hoppa över uppdatering",
		message: "Vi kommer att meddela dig när nästa uppdatering är tillgänglig.\nOm du ändrar dig kan du kontrollera om det finns uppdateringar i menyn Om.",
		ok: "OK"
	},
	selectClientCertificate: {
		announcement: "Välj certifikat",
		select: "Välj",
		validDates: "Gäller från {{-validStart,}} till {{-validExpiry,}}"
	},
	openingExternalProtocol: {
		title: "Länk med anpassat protokoll",
		message: "{{- protocol }} länken kräver en extern applikation.",
		detail: "Den begärda länken är {{- url }}. Vill du fortsätta?",
		dontAskAgain: "Öppna alltid den här typen av länkar i den tillhörande appen",
		yes: "Ja",
		no: "Nej"
	},
	allowVideoCallCaptureScreen: {
		title: "Videosamtalet försöker fånga din skärm",
		message: "Videosamtalet begär tillstånd att fånga din skärm.",
		detail: "Videosamtalet från servern {{- url }} kräver tillstånd för att du ska kunna dela din skärm med andra.",
		dontAskAgain: "Tillåt alltid videosamtal från denna server att fånga din skärm",
		yes: "Tillåt",
		no: "Avbryt"
	},
	mediaPermission: {
		title: "Tillstånd för media krävs",
		message: "{{- permissionType}} är för närvarande avaktiverad i dina systeminställningar.",
		detail: "För att aktivera videosamtalsfunktioner måste du tillåta åtkomst i systemets sekretessinställningar och sedan starta om programmet.",
		openSettings: "Öppna inställningar",
		cancel: "Avbryt",
		microphone: "Mikrofon",
		camera: "Kamera",
		both: "Mikrofon och kamera"
	},
	microphonePermissionDenied: {
		title: "Mikrofonåtkomst krävs",
		message: "Mikrofonåtkomst krävs för att {{- actionType}}. Kontrollera dina systeminställningar.",
		detail: "Du kan aktivera mikrofonåtkomst i datorns integritetsinställningar.",
		openSettings: "Öppna inställningar",
		cancel: "Avbryt",
		actionTypes: {
			initiateCall: "ringa samtal",
			answerCall: "svara på samtal",
			recordMessage: "spela in meddelanden"
		}
	},
	outlookCalendar: {
		title: "Outlook-kalender",
		encryptionUnavailableTitle: "Kryptering är inte tillgänglig",
		encryptionUnavailable: "Ditt operativsystem stöder inte kryptering.\nDina inloggningsuppgifter lagras i klartext.",
		field_required: "Detta fält är obligatoriskt",
		remember_credentials: "Kom ihåg mina inloggningsuppgifter",
		cancel: " Avbryt",
		submit: "Logga in"
	},
	supportedVersion: {
		title: "Versionen av arbetsytan stöds inte"
	}
};
var downloads = {
	title: "Nedladdningar",
	notifications: {
		downloadFinished: "Nedladdning klar",
		downloadInterrupted: "Nedladdning avbruten",
		downloadCancelled: "Nedladdning avbruten",
		downloadFailed: "Nedladdning misslyckades",
		downloadExpired: "Nedladdning har löpt ut",
		downloadExpiredMessage: "Försök ladda ner från källan igen."
	},
	filters: {
		search: "Sök",
		server: "Server",
		mimeType: "Typ",
		status: "Status",
		clear: "Rensa filter",
		all: "Alla",
		mimes: {
			images: "Bilder",
			videos: "Videor",
			audios: "Ljudfiler",
			texts: "Texter",
			files: "Filer"
		},
		statuses: {
			paused: "Pausad",
			cancelled: "Avbruten"
		}
	},
	item: {
		cancel: "Avbryt",
		copyLink: "Kopiera länk",
		errored: "Nedladdning avbruten",
		pause: "Pausa",
		progressSize: "{{receivedBytes, byteSize}} av {{totalBytes, byteSize}} ({{ratio, percentage}})",
		remove: "Ta bort från listan",
		resume: "Återuppta",
		retry: "Försök igen",
		showInFolder: "Visa i mapp"
	},
	showingResults: "Visar resultat {{first}} - {{last}} av {{count}}"
};
var certificatesManager = {
	title: "Certifikatsansvarig",
	trustedCertificates: "Betrodda certifikat",
	notTrustedCertificates: "Inte betrodda certifikat",
	item: {
		domain: "Domän",
		actions: "Åtgärder",
		remove: "Ta bort"
	}
};
var settings = {
	title: "Inställningar",
	general: "Allmänt",
	certificates: "Certifikat",
	options: {
		report: {
			title: "Rapportera fel till utvecklare",
			description: "Rapportera fel anonymt till utvecklarna. Delad information inkluderar appens versionsnummer, typ av operativsystem, server-URL, enhetsspråk och feltyp. Inget innehåll eller användarnamn delas.",
			masDescription: "Detta alternativ är inaktiverat när det installeras från Mac App Store, felen kommer att rapporteras via Mac App Stores felrapporteringsprocess."
		},
		flashFrame: {
			title: "Aktivera Flash Frame",
			titleDarwin: "Toggle Dock Bounce vid varning",
			description: "Blinkar fönstret för att dra till sig användarens uppmärksamhet.",
			onLinux: "Vissa Linux-distributioner har inte stöd för den här funktionen.",
			descriptionDarwin: "Appikonen studsar i dockan för att dra till sig användarens uppmärksamhet."
		},
		hardwareAcceleration: {
			title: "Hårdvaruacceleration",
			description: "Aktiverar användning av hårdvaruacceleration när sådan finns tillgänglig. Programmet laddas om vid ändring."
		},
		videoCallScreenCaptureFallback: {
			title: "Reservläge för videosamtal",
			description: "Stänger av Windows Graphics Capture så att delning fungerar i RDP-sessioner. Appen startas om när du ändrar valet.",
			forcedDescription: "Redan aktiverat eftersom appen upptäckte en RDP-session. Vippbrytaren anger beteendet vid kommande lokala starter."
		},
		internalVideoChatWindow: {
			title: "Öppna videochatt i programfönstret",
			description: "Om den är aktiverad öppnas videochatten i programmets fönster i stället för i standardwebbläsaren. För <strong>Google Meet</strong> och <strong>Jitsi</strong> stöds dock inte skärminspelning i Electron-applikationer, så de kommer alltid att öppnas i webbläsaren oavsett denna inställning.",
			masDescription: "Detta alternativ är inaktiverat när det installeras från Mac App Store. Av säkerhetsskäl öppnas Video Chat alltid i webbläsaren som standard."
		},
		minimizeOnClose: {
			title: "Minimera vid stängning",
			description: "När appen stängs kommer den att minimeras, annars kommer applikationen avslutas. Tray Icon måste inaktiveras för att detta ska gälla."
		},
		menubar: {
			title: "Menyfält",
			description: "Visa menyfältet högst upp i fönstret.",
			disabledHint: "Kan inte inaktivera menyfältet när sidofältet är inaktiverat. Inställningar skulle bli otillgängliga."
		},
		sidebar: {
			title: "Sidofält",
			description: "Visa sidofältet till vänster i fönstret med serverlistan, nedladdningar och inställningar.",
			disabledHint: "Kan inte inaktivera sidofältet när menyfältet är inaktiverat. Inställningar skulle bli otillgängliga."
		},
		trayIcon: {
			title: "Ikon för brickan",
			description: "Visa ikonen i systemfältet. Om ikonen är aktiv kommer appen att döljas i facket när den stängs. Annars avslutas programmet."
		},
		availableBrowsers: {
			title: "Standardwebbläsare",
			description: "Välj vilken webbläsare som ska öppna externa länkar från den här appen. Systemstandard använder inställningarna för ditt operativsystem.",
			systemDefault: "Systemstandard",
			loading: "Laddar webbläsare...",
			current: "Använder för närvarande:"
		},
		clearPermittedScreenCaptureServers: {
			title: "Rensa behörigheter för skärmdumpning",
			description: "Ta bort skärmdumpstillstånden som valts för att inte fråga igen vid videosamtal."
		},
		allowScreenCaptureOnVideoCalls: {
			title: "Tillåt skärmdump under videosamtal",
			description: "Tillåt skärmdump vid videosamtal. Förfrågan om tillstånd kommer vid varje videosamtal."
		},
		ntlmCredentials: {
			title: "NTLM-autentiseringsuppgifter",
			description: "Tillåt att NTLM-autentiseringsuppgifter används vid anslutning till en server.",
			domains: "Domäner som kommer använda autentiseringsuppgifterna. Separerade med kommatecken. Använd * för att matcha alla domäner."
		},
		videoCallWindowPersistence: {
			title: "Kom ihåg fönstrets position för videosamtal",
			description: "Spara och återställ position och storlek för videosamtalsfönster mellan sessioner"
		},
		transparentWindow: {
			title: "Transparent fönstereffekt",
			description: "Aktivera inbyggd vibrans/transparenseffekt för fönstret. Kräver omstart för att tillämpas."
		}
	}
};
var error = {
	authNeeded: "Autentisering krävs, försök <strong>{{- auth}}</strong>",
	connectTimeout: "Timeout vid anslutningsförsök",
	differentCertificate: "Certifikatet skiljer sig från det tidigare.\n\n {{- detail}}",
	noValidServerFound: "Ingen giltig server hittades på URL:en",
	offline: "Kontrollera din Internetanslutning!"
};
var landing = {
	invalidUrl: "Ogiltig webbadress",
	validating: "Validerar...",
	inputUrl: "Ange URL till din server",
	connect: "Anslut"
};
var menus = {
	about: "Om {{- appName}}",
	addNewServer: "Lägg till &ny server",
	back: "&Tillbaka",
	clearTrustedCertificates: "Rensa betrodda certifikat",
	close: "Stäng",
	copy: "&Kopiera",
	cut: "Klipp ut",
	developerMode: "Utvecklarläge",
	disableGpu: "Avaktivera GPU",
	documentation: "Dokumentation",
	downloads: "Nedladdningar",
	settings: "Inställningar",
	editMenu: "&Editera",
	fileMenu: "&Fil",
	forward: "&Framåt",
	helpMenu: "&Hjälp",
	hide: "Göm {{- appName}}",
	hideOthers: "Dölj andra",
	learnMore: "Läs mer om detta",
	minimize: "Minimera",
	openDevTools: "Öppna &utvecklarverktyg",
	openDevToolsOnAllWindows: "Öppna &utvecklarverktyg för alla fönster",
	paste: "&klistra in",
	quit: "Avsluta {{- appName}}",
	redo: "Gör om",
	reload: "Ladda om",
	reloadClearingCache: "Tvinga fram omladdning",
	reportIssue: "Rapportera problem",
	resetAppData: "Återställ appdata",
	resetZoom: "Återställ zoom",
	selectAll: "Välj alla",
	services: "Tjänster",
	showFullScreen: "Fullskärm",
	showMenuBar: "Menyfält",
	showOnUnreadMessage: "Visa vid olästa meddelanden",
	showServerList: "Serverlista",
	showTrayIcon: "Ikon för brickan",
	toggleDevTools: "Toggle &DevTools",
	openConfigFolder: "Öppna mappen &Konfiguration",
	videoCallDevTools: "Öppna videosamtal &DevTools",
	videoCallTools: "Verktyg för videosamtal",
	videoCallDevToolsAutoOpen: "Auto-öppna utvecklarverktyg",
	undo: "Ångra",
	unhide: "Visa alla",
	viewMenu: "&Visa",
	windowMenu: "&Fönster",
	zoomIn: "Zooma in",
	zoomOut: "Zooma ut"
};
var loadingError = {
	title: "Servern kunde inte laddas",
	announcement: "Houston, vi har ett problem",
	reload: "Ladda om"
};
var videoCall = {
	loading: {
		initial: "Laddar videosamtal...",
		reloading: "Laddar om videosamtal...",
		description: "Vänta medan vi ansluter till videosamtalet"
	},
	error: {
		title: "Videosamtalet kunde inte laddas",
		announcement: "Houston, vi har ett problem",
		timeout: "Tidsgräns överskriden - videosamtalet kunde inte laddas inom 15 sekunder",
		crashed: "Webview kraschade",
		maxRetriesReached: "Kunde inte ladda efter flera försök",
		reload: "Ladda om videosamtal"
	}
};
var unsupportedServer = {
	title: "{{instanceDomain}} kör en version av Rocket.Chat som inte stöds",
	announcement: "En administratör måste uppdatera arbetsytan till en version som stöds för att återaktivera åtkomst från mobil- och skrivbordsappar.",
	moreInformation: "Läs mer om detta"
};
var selfxss = {
	title: "Sluta!",
	description: "Detta är en webbläsarfunktion avsedd för utvecklare. Om någon sa till dig att kopiera och klistra in något här för att aktivera en Rocket.Chat-funktion eller \"hacka\" någons konto, är det en bluff och kommer att ge dem tillgång till ditt Rocket.Chat-konto.",
	moreInfo: "Se https://go.rocket.chat/i/xss för mer information."
};
var sidebar = {
	addNewServer: "Lägg till ny server",
	downloads: "Nedladdningar",
	settings: "Inställningar",
	menuTitle: "Anpassa och kontrollera appen",
	item: {
		reload: "Ladda om",
		remove: "Ta bort",
		openDevTools: "Öppna utvecklarverktyg",
		clearCache: "Rensa cacheminnet",
		clearStorageData: "Rensa lagringsdata",
		copyCurrentUrl: "Kopiera aktuell URL",
		reloadClearingCache: "Tvinga fram omladdning",
		serverInfo: "Serverinformation",
		supportedVersionsInfo: "Information om versioner som stöds"
	},
	tooltips: {
		unreadMessage: "{{- count}} olästa meddelanden",
		unreadMessages: "{{- count}} olästa meddelanden",
		userNotLoggedIn: "Inte inloggad",
		addWorkspace: "Lägg till arbetsyta ({{shortcut}}+N)",
		settingsMenu: "Anpassa och kontrollera appen"
	}
};
var touchBar = {
	formatting: "Formatering",
	selectServer: "Välj server"
};
var tray = {
	menu: {
		show: "Visa",
		hide: "Göm",
		quit: "Avsluta"
	},
	tooltip: {
		noUnreadMessage: "{{- appName}}: inget oläst meddelande",
		unreadMention: "{{- appName}}: du har ett oläst meddelande/direktmeddelande",
		unreadMention_plural: "{{- appName}}: du har {{- count}} olästa omnämnanden/direkt meddelanden",
		unreadMessage: "{{- appName}}: du har olästa meddelanden"
	},
	balloon: {
		stillRunning: {
			title: "{{- appName}} är fortfarande igång",
			content: "{{- appName }} är inställd på att fortsätta köras i systemfältet/notifikationsområdet."
		}
	}
};
var taskbar = {
	unreadMessage: "Olästa meddelanden",
	unreadMention: "Olästa omnämnanden",
	noUnreadMessage: "Inga olästa meddelanden"
};
var screenSharing = {
	permissionDenied: "Tillstånd för skärminspelning har nekats",
	permissionRequired: "Tillstånd för skärminspelning krävs för att dela din skärm.",
	permissionInstructions: "Aktivera det i dina systeminställningar och försök igen.",
	title: "Dela din skärm",
	entireScreen: "Hela skärmen",
	applicationWindow: "Applikationsfönster",
	noScreensFound: "Inga skärmar hittades",
	noWindowsFound: "Inga fönster hittades",
	cancel: "Avbryt",
	share: "Dela"
};
var serverInfo = {
	title: "Serverinformation",
	urlLabel: "URL:",
	versionLabel: "Version:",
	unknown: "Okänd",
	exchangeUrlLabel: "Outlook Exchange URL:",
	supportedVersionsTitle: "Versioner som stöds",
	statusLabel: "Status:",
	status: {
		loading: "Laddar...",
		error: "Laddning misslyckades",
		loaded: "Laddad",
		idle: "Viloläge",
		from: "från {{source}}"
	},
	supported: {
		unknown: "Okänd",
		expiring: "Upphör snart",
		yes: "Ja",
		no: "Nej"
	},
	expiration: {
		label: "Utgångsdatum:",
		expiresOn: "Upphör {{date}}"
	}
};
var sv_i18n = {
	contextMenu: contextMenu,
	dialog: dialog,
	downloads: downloads,
	certificatesManager: certificatesManager,
	settings: settings,
	error: error,
	landing: landing,
	menus: menus,
	loadingError: loadingError,
	videoCall: videoCall,
	unsupportedServer: unsupportedServer,
	selfxss: selfxss,
	sidebar: sidebar,
	touchBar: touchBar,
	tray: tray,
	taskbar: taskbar,
	screenSharing: screenSharing,
	serverInfo: serverInfo
};

exports.certificatesManager = certificatesManager;
exports.contextMenu = contextMenu;
exports.default = sv_i18n;
exports.dialog = dialog;
exports.downloads = downloads;
exports.error = error;
exports.landing = landing;
exports.loadingError = loadingError;
exports.menus = menus;
exports.screenSharing = screenSharing;
exports.selfxss = selfxss;
exports.serverInfo = serverInfo;
exports.settings = settings;
exports.sidebar = sidebar;
exports.taskbar = taskbar;
exports.touchBar = touchBar;
exports.tray = tray;
exports.unsupportedServer = unsupportedServer;
exports.videoCall = videoCall;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3YuaTE4bi1oQXVXQUhoVi5qcyIsInNvdXJjZXMiOltdLCJzb3VyY2VzQ29udGVudCI6W10sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OyJ9
