'use strict';

var i18next = require('i18next');
var require$$0 = require('react-dom');
var reactI18next = require('react-i18next');
var fuselage = require('@rocket.chat/fuselage');
var electron = require('electron');
var require$$0$1 = require('react');
var styled = require('@emotion/styled');

function _interopDefault (e) { return e && e.__esModule ? e : { default: e }; }

var i18next__default = /*#__PURE__*/_interopDefault(i18next);
var require$$0__default = /*#__PURE__*/_interopDefault(require$$0);
var require$$0__default$1 = /*#__PURE__*/_interopDefault(require$$0$1);
var styled__default = /*#__PURE__*/_interopDefault(styled);

var createRoot;

var m$1 = require$$0__default.default;
{
  createRoot = m$1.createRoot;
  m$1.hydrateRoot;
}

const useDialog = (visible, onClose = () => undefined) => {
  const dialogRef = require$$0$1.useRef(null);
  const onCloseRef = require$$0$1.useRef();
  require$$0$1.useEffect(() => {
    onCloseRef.current = onClose;
  });
  require$$0$1.useEffect(() => {
    const dialog = dialogRef.current;
    const onClose = onCloseRef.current;
    if (!dialog) {
      return;
    }
    if (!visible) {
      dialog.close();
      return;
    }
    dialog.showModal();
    dialog.onclose = () => {
      dialog.close();
      onClose === null || onClose === void 0 || onClose();
    };
    dialog.onclick = ({
      clientX,
      clientY
    }) => {
      const {
        left,
        top,
        width,
        height
      } = dialog.getBoundingClientRect();
      const isInDialog = top <= clientY && clientY <= top + height && left <= clientX && clientX <= left + width;
      if (!isInDialog) {
        dialog.close();
      }
    };
  }, [visible]);
  return dialogRef;
};

const Wrapper = styled__default.default.dialog`
  z-index: 1000;
  top: 0;
  bottom: 0;
  display: flex;
  flex-direction: column;
  cursor: default;
  user-select: none;
  border: 0;
  background-color: transparent;
  max-height: 90vh;

  &:not([open]) {
    display: none;
  }
`;

var jsxRuntime = {exports: {}};

var reactJsxRuntime_production_min = {};

/**
 * @license React
 * react-jsx-runtime.production.min.js
 *
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

var f = require$$0__default$1.default,
  k = Symbol.for("react.element"),
  l = Symbol.for("react.fragment"),
  m = Object.prototype.hasOwnProperty,
  n = f.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED.ReactCurrentOwner,
  p = {
    key: !0,
    ref: !0,
    __self: !0,
    __source: !0
  };
function q(c, a, g) {
  var b,
    d = {},
    e = null,
    h = null;
  void 0 !== g && (e = "" + g);
  void 0 !== a.key && (e = "" + a.key);
  void 0 !== a.ref && (h = a.ref);
  for (b in a) m.call(a, b) && !p.hasOwnProperty(b) && (d[b] = a[b]);
  if (c && c.defaultProps) for (b in a = c.defaultProps, a) void 0 === d[b] && (d[b] = a[b]);
  return {
    $$typeof: k,
    type: c,
    key: e,
    ref: h,
    props: d,
    _owner: n.current
  };
}
reactJsxRuntime_production_min.Fragment = l;
reactJsxRuntime_production_min.jsx = q;
reactJsxRuntime_production_min.jsxs = q;

{
  jsxRuntime.exports = reactJsxRuntime_production_min;
}

var jsxRuntimeExports = jsxRuntime.exports;

const Dialog = ({
  children,
  isVisible = false,
  onClose
}) => {
  const dialogRef = useDialog(isVisible, onClose);
  return /*#__PURE__*/jsxRuntimeExports.jsx(Wrapper, {
    ref: dialogRef,
    children: /*#__PURE__*/jsxRuntimeExports.jsx(fuselage.Scrollable, {
      children: /*#__PURE__*/jsxRuntimeExports.jsx(fuselage.Tile, {
        elevation: "2",
        padding: "x32",
        display: "flex",
        flexDirection: "column",
        children: children
      })
    })
  });
};

const desktopCapturer = {
  getSources: opts => electron.ipcRenderer.invoke('desktop-capturer-get-sources', [opts])
};
function ScreenSharePicker({
  onMounted
} = {}) {
  const {
    t
  } = reactI18next.useTranslation();
  const [visible, setVisible] = require$$0$1.useState(false);
  const [sources, setSources] = require$$0$1.useState([]);
  const [currentTab, setCurrentTab] = require$$0$1.useState('screen');
  const [selectedSourceId, setSelectedSourceId] = require$$0$1.useState(null);
  const [isScreenRecordingPermissionGranted, setIsScreenRecordingPermissionGranted] = require$$0$1.useState(false);
  const fetchSources = require$$0$1.useCallback(async () => {
    try {
      const sources = await desktopCapturer.getSources({
        types: ['window', 'screen']
      });

      // Filter out sources that are not capturable
      const filteredSources = sources.filter(source => {
        // Only check for basic validity - thumbnail validation is already done by IPC handler
        if (!source.name || source.name.trim() === '') {
          return false;
        }
        return true;
      }).sort((a, b) => a.name.localeCompare(b.name));
      setSources(filteredSources);

      // If the currently selected source is no longer available, clear the selection
      if (selectedSourceId && !filteredSources.find(s => s.id === selectedSourceId)) {
        console.log('Previously selected source no longer available, clearing selection');
        setSelectedSourceId(null);
      }
    } catch (error) {
      console.error('Error fetching screen sharing sources:', error);
      setSources([]);
    }
  }, [selectedSourceId]);
  require$$0$1.useEffect(() => {
    const checkScreenRecordingPermission = async () => {
      const result = await electron.ipcRenderer.invoke('video-call-window/screen-recording-is-permission-granted');
      setIsScreenRecordingPermissionGranted(result);
    };
    checkScreenRecordingPermission().catch(console.error);
  }, [visible]);
  require$$0$1.useEffect(() => {
    fetchSources();
  }, [fetchSources]);
  require$$0$1.useEffect(() => {
    if (onMounted) {
      onMounted(setVisible);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  require$$0$1.useEffect(() => {
    if (!visible) {
      return undefined;
    }
    const timer = setInterval(() => {
      fetchSources();
    }, 3000);
    return () => {
      clearInterval(timer);
    };
  }, [visible, fetchSources]);
  const handleScreenSharingSourceClick = id => () => {
    setSelectedSourceId(id);
  };
  const handleShare = () => {
    if (selectedSourceId) {
      // Validate that the selected source still exists in our current sources list
      const selectedSource = sources.find(s => s.id === selectedSourceId);
      if (!selectedSource) {
        console.error('Selected source no longer available:', selectedSourceId);
        // Refresh sources and clear selection
        fetchSources();
        setSelectedSourceId(null);
        return;
      }

      // Additional validation before sharing
      if (selectedSource.thumbnail.isEmpty()) {
        console.error('Selected source has empty thumbnail, cannot share:', selectedSourceId);
        setSelectedSourceId(null);
        return;
      }
      console.log('Sharing screen source:', {
        id: selectedSource.id,
        name: selectedSource.name
      });
      setVisible(false);
      electron.ipcRenderer.send('video-call-window/screen-sharing-source-responded', selectedSourceId);
    }
  };
  const handleClose = () => {
    setVisible(false);
    electron.ipcRenderer.send('video-call-window/screen-sharing-source-responded', null);
  };

  // Filter sources based on the current tab
  const filteredSources = sources.filter(source => {
    if (currentTab === 'screen') {
      return source.id.includes('screen');
    }
    return source.id.includes('window');
  });
  return /*#__PURE__*/jsxRuntimeExports.jsxs(jsxRuntimeExports.Fragment, {
    children: [/*#__PURE__*/jsxRuntimeExports.jsx(fuselage.PaletteStyleTag, {
      theme: "dark",
      selector: ":root"
    }), /*#__PURE__*/jsxRuntimeExports.jsx(Dialog, {
      isVisible: visible,
      onClose: handleClose,
      children: /*#__PURE__*/jsxRuntimeExports.jsxs(fuselage.Box, {
        width: "680px",
        margin: "auto",
        display: "flex",
        flexDirection: "column",
        height: "560px",
        backgroundColor: "light",
        color: "default",
        children: [/*#__PURE__*/jsxRuntimeExports.jsxs(fuselage.Box, {
          marginBlockEnd: "x12",
          children: [/*#__PURE__*/jsxRuntimeExports.jsx(fuselage.Box, {
            fontScale: "h1",
            marginBlockEnd: "x12",
            children: t('screenSharing.title')
          }), /*#__PURE__*/jsxRuntimeExports.jsxs(fuselage.Tabs, {
            children: [/*#__PURE__*/jsxRuntimeExports.jsx(fuselage.Tabs.Item, {
              selected: currentTab === 'screen',
              onClick: () => setCurrentTab('screen'),
              children: t('screenSharing.entireScreen')
            }), /*#__PURE__*/jsxRuntimeExports.jsx(fuselage.Tabs.Item, {
              selected: currentTab === 'window',
              onClick: () => setCurrentTab('window'),
              children: t('screenSharing.applicationWindow')
            })]
          })]
        }), /*#__PURE__*/jsxRuntimeExports.jsx(fuselage.Box, {
          display: "flex",
          flexDirection: "column",
          overflow: "hidden",
          marginBlockStart: "x10",
          marginBlockEnd: "x10",
          flexGrow: 1,
          children: !isScreenRecordingPermissionGranted ? /*#__PURE__*/jsxRuntimeExports.jsxs(fuselage.Callout, {
            title: t('screenSharing.permissionDenied'),
            type: "danger",
            margin: "x32",
            children: [t('screenSharing.permissionRequired'), /*#__PURE__*/jsxRuntimeExports.jsx("br", {}), t('screenSharing.permissionInstructions')]
          }) : /*#__PURE__*/jsxRuntimeExports.jsx(fuselage.Scrollable, {
            vertical: true,
            children: /*#__PURE__*/jsxRuntimeExports.jsx(fuselage.Box, {
              padding: "x8",
              style: {
                display: 'grid',
                gridTemplateColumns: 'repeat(auto-fit, 208px)',
                gap: '16px',
                justifyContent: 'center'
              },
              children: filteredSources.length === 0 ? /*#__PURE__*/jsxRuntimeExports.jsx(fuselage.Box, {
                display: "flex",
                alignItems: "center",
                justifyContent: "center",
                width: "100%",
                p: "x16",
                style: {
                  gridColumn: '1 / -1'
                },
                children: /*#__PURE__*/jsxRuntimeExports.jsx(fuselage.Label, {
                  children: currentTab === 'screen' ? t('screenSharing.noScreensFound') : t('screenSharing.noWindowsFound')
                })
              }) : filteredSources.map(({
                id,
                name,
                thumbnail
              }) => /*#__PURE__*/jsxRuntimeExports.jsxs(fuselage.Box, {
                width: "x208",
                height: "x170",
                display: "flex",
                flexDirection: "column",
                onClick: handleScreenSharingSourceClick(id),
                bg: selectedSourceId === id ? 'selected' : 'light',
                border: selectedSourceId === id ? '2px solid var(--rcx-color-stroke-highlight)' : '1px solid var(--rcx-color-stroke-light)',
                borderRadius: "x2",
                cursor: "pointer",
                className: "screen-share-thumbnail",
                style: {
                  position: 'relative',
                  overflow: 'visible'
                },
                children: [/*#__PURE__*/jsxRuntimeExports.jsx(fuselage.Box, {
                  flexGrow: 1,
                  display: "flex",
                  alignItems: "flex-start",
                  justifyContent: "flex-start",
                  overflow: "hidden",
                  style: {
                    minHeight: '120px',
                    backgroundColor: 'rgba(0, 0, 0, 0.1)'
                  },
                  children: /*#__PURE__*/jsxRuntimeExports.jsx(fuselage.Box, {
                    is: "img",
                    src: thumbnail.toDataURL(),
                    alt: name,
                    style: {
                      width: '100%',
                      height: 'auto',
                      objectFit: 'contain',
                      objectPosition: 'top',
                      display: 'block'
                    }
                  })
                }), /*#__PURE__*/jsxRuntimeExports.jsx(fuselage.Box, {
                  p: "x4",
                  style: {
                    position: 'absolute',
                    bottom: '0',
                    left: '0',
                    right: '0',
                    background: 'rgba(0, 0, 0, 0.5)',
                    backdropFilter: 'blur(4px)',
                    zIndex: 10,
                    minHeight: 'auto'
                  },
                  children: /*#__PURE__*/jsxRuntimeExports.jsx(fuselage.Label, {
                    title: name,
                    style: {
                      fontSize: '11px',
                      lineHeight: '1.2',
                      color: 'white',
                      textAlign: 'center',
                      width: '100%',
                      margin: 0,
                      wordBreak: 'break-word',
                      display: '-webkit-box',
                      WebkitLineClamp: 2,
                      WebkitBoxOrient: 'vertical',
                      overflow: 'hidden',
                      textOverflow: 'ellipsis'
                    },
                    children: name
                  })
                })]
              }, id))
            })
          })
        }), /*#__PURE__*/jsxRuntimeExports.jsxs(fuselage.Box, {
          display: "flex",
          justifyContent: "space-between",
          marginBlockStart: "auto",
          children: [/*#__PURE__*/jsxRuntimeExports.jsx(fuselage.Button, {
            onClick: handleClose,
            children: t('screenSharing.cancel')
          }), /*#__PURE__*/jsxRuntimeExports.jsx(fuselage.Button, {
            primary: true,
            onClick: handleShare,
            disabled: !selectedSourceId,
            children: t('screenSharing.share')
          })]
        })]
      })
    })]
  });
}

let reactRoot = null;
let setVisibleCallback = null;
let shouldShowOnMount = false;
const mount = () => {
  const container = document.getElementById('screen-picker-root');
  if (!container) {
    console.error('Screen picker root container not found');
    return;
  }
  if (reactRoot) {
    return;
  }
  try {
    reactRoot = createRoot(container);
    reactRoot.render( /*#__PURE__*/jsxRuntimeExports.jsx(reactI18next.I18nextProvider, {
      i18n: i18next__default.default,
      children: /*#__PURE__*/jsxRuntimeExports.jsx(ScreenSharePicker, {
        onMounted: setVisible => {
          setVisibleCallback = setVisible;
          if (shouldShowOnMount) {
            setVisible(true);
            shouldShowOnMount = false;
          }
        }
      })
    }));
    if ("production" === 'development') ;
  } catch (error) {
    console.error('Failed to mount screen share picker:', error);
    reactRoot = null;
    setVisibleCallback = null;
    shouldShowOnMount = false;
  }
};
const show = () => {
  if (!reactRoot) {
    // Set flag BEFORE mounting so onMounted callback can see it during render
    shouldShowOnMount = true;
    mount();
    return;
  }
  if (setVisibleCallback) {
    setVisibleCallback(true);
  } else {
    shouldShowOnMount = true;
    setTimeout(() => {
      if (setVisibleCallback) {
        setVisibleCallback(true);
      }
      shouldShowOnMount = false;
    }, 0);
  }
};

exports.mount = mount;
exports.show = show;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2NyZWVuU2hhcmVQaWNrZXJNb3VudC1zRVFQY0E1Qy5qcyIsInNvdXJjZXMiOlsiLi4vbm9kZV9tb2R1bGVzL3JlYWN0LWRvbS9jbGllbnQuanMiLCIuLi9zcmMvdWkvY29tcG9uZW50cy9EaWFsb2cvaG9va3MudHMiLCIuLi9zcmMvdWkvY29tcG9uZW50cy9EaWFsb2cvc3R5bGVzLnRzeCIsIi4uL25vZGVfbW9kdWxlcy9yZWFjdC9janMvcmVhY3QtanN4LXJ1bnRpbWUucHJvZHVjdGlvbi5taW4uanMiLCIuLi9ub2RlX21vZHVsZXMvcmVhY3QvanN4LXJ1bnRpbWUuanMiLCIuLi9zcmMvdWkvY29tcG9uZW50cy9EaWFsb2cvaW5kZXgudHN4IiwiLi4vc3JjL3ZpZGVvQ2FsbFdpbmRvdy9zY3JlZW5TaGFyZVBpY2tlci50c3giLCIuLi9zcmMvdmlkZW9DYWxsV2luZG93L3NjcmVlblNoYXJlUGlja2VyTW91bnQudHN4Il0sInNvdXJjZXNDb250ZW50IjpbIid1c2Ugc3RyaWN0JztcblxudmFyIG0gPSByZXF1aXJlKCdyZWFjdC1kb20nKTtcbmlmIChwcm9jZXNzLmVudi5OT0RFX0VOViA9PT0gJ3Byb2R1Y3Rpb24nKSB7XG4gIGV4cG9ydHMuY3JlYXRlUm9vdCA9IG0uY3JlYXRlUm9vdDtcbiAgZXhwb3J0cy5oeWRyYXRlUm9vdCA9IG0uaHlkcmF0ZVJvb3Q7XG59IGVsc2Uge1xuICB2YXIgaSA9IG0uX19TRUNSRVRfSU5URVJOQUxTX0RPX05PVF9VU0VfT1JfWU9VX1dJTExfQkVfRklSRUQ7XG4gIGV4cG9ydHMuY3JlYXRlUm9vdCA9IGZ1bmN0aW9uKGMsIG8pIHtcbiAgICBpLnVzaW5nQ2xpZW50RW50cnlQb2ludCA9IHRydWU7XG4gICAgdHJ5IHtcbiAgICAgIHJldHVybiBtLmNyZWF0ZVJvb3QoYywgbyk7XG4gICAgfSBmaW5hbGx5IHtcbiAgICAgIGkudXNpbmdDbGllbnRFbnRyeVBvaW50ID0gZmFsc2U7XG4gICAgfVxuICB9O1xuICBleHBvcnRzLmh5ZHJhdGVSb290ID0gZnVuY3Rpb24oYywgaCwgbykge1xuICAgIGkudXNpbmdDbGllbnRFbnRyeVBvaW50ID0gdHJ1ZTtcbiAgICB0cnkge1xuICAgICAgcmV0dXJuIG0uaHlkcmF0ZVJvb3QoYywgaCwgbyk7XG4gICAgfSBmaW5hbGx5IHtcbiAgICAgIGkudXNpbmdDbGllbnRFbnRyeVBvaW50ID0gZmFsc2U7XG4gICAgfVxuICB9O1xufVxuIiwiaW1wb3J0IHR5cGUgeyBSZWYgfSBmcm9tICdyZWFjdCc7XG5pbXBvcnQgeyB1c2VFZmZlY3QsIHVzZVJlZiB9IGZyb20gJ3JlYWN0JztcblxuZXhwb3J0IGNvbnN0IHVzZURpYWxvZyA9IChcbiAgdmlzaWJsZTogYm9vbGVhbixcbiAgb25DbG9zZSA9ICgpOiB2b2lkID0+IHVuZGVmaW5lZFxuKTogUmVmPEhUTUxEaWFsb2dFbGVtZW50PiA9PiB7XG4gIGNvbnN0IGRpYWxvZ1JlZiA9IHVzZVJlZjxIVE1MRGlhbG9nRWxlbWVudD4obnVsbCk7XG4gIGNvbnN0IG9uQ2xvc2VSZWYgPSB1c2VSZWY8KCkgPT4gdm9pZD4oKTtcblxuICB1c2VFZmZlY3QoKCkgPT4ge1xuICAgIG9uQ2xvc2VSZWYuY3VycmVudCA9IG9uQ2xvc2U7XG4gIH0pO1xuXG4gIHVzZUVmZmVjdCgoKSA9PiB7XG4gICAgY29uc3QgZGlhbG9nID0gZGlhbG9nUmVmLmN1cnJlbnQ7XG4gICAgY29uc3Qgb25DbG9zZSA9IG9uQ2xvc2VSZWYuY3VycmVudDtcblxuICAgIGlmICghZGlhbG9nKSB7XG4gICAgICByZXR1cm47XG4gICAgfVxuXG4gICAgaWYgKCF2aXNpYmxlKSB7XG4gICAgICBkaWFsb2cuY2xvc2UoKTtcbiAgICAgIHJldHVybjtcbiAgICB9XG5cbiAgICBkaWFsb2cuc2hvd01vZGFsKCk7XG5cbiAgICBkaWFsb2cub25jbG9zZSA9ICgpID0+IHtcbiAgICAgIGRpYWxvZy5jbG9zZSgpO1xuICAgICAgb25DbG9zZT8uKCk7XG4gICAgfTtcblxuICAgIGRpYWxvZy5vbmNsaWNrID0gKHsgY2xpZW50WCwgY2xpZW50WSB9KSA9PiB7XG4gICAgICBjb25zdCB7IGxlZnQsIHRvcCwgd2lkdGgsIGhlaWdodCB9ID0gZGlhbG9nLmdldEJvdW5kaW5nQ2xpZW50UmVjdCgpO1xuICAgICAgY29uc3QgaXNJbkRpYWxvZyA9XG4gICAgICAgIHRvcCA8PSBjbGllbnRZICYmXG4gICAgICAgIGNsaWVudFkgPD0gdG9wICsgaGVpZ2h0ICYmXG4gICAgICAgIGxlZnQgPD0gY2xpZW50WCAmJlxuICAgICAgICBjbGllbnRYIDw9IGxlZnQgKyB3aWR0aDtcbiAgICAgIGlmICghaXNJbkRpYWxvZykge1xuICAgICAgICBkaWFsb2cuY2xvc2UoKTtcbiAgICAgIH1cbiAgICB9O1xuICB9LCBbdmlzaWJsZV0pO1xuXG4gIHJldHVybiBkaWFsb2dSZWY7XG59O1xuIiwiaW1wb3J0IHN0eWxlZCBmcm9tICdAZW1vdGlvbi9zdHlsZWQnO1xuXG5leHBvcnQgY29uc3QgV3JhcHBlciA9IHN0eWxlZC5kaWFsb2dgXG4gIHotaW5kZXg6IDEwMDA7XG4gIHRvcDogMDtcbiAgYm90dG9tOiAwO1xuICBkaXNwbGF5OiBmbGV4O1xuICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1xuICBjdXJzb3I6IGRlZmF1bHQ7XG4gIHVzZXItc2VsZWN0OiBub25lO1xuICBib3JkZXI6IDA7XG4gIGJhY2tncm91bmQtY29sb3I6IHRyYW5zcGFyZW50O1xuICBtYXgtaGVpZ2h0OiA5MHZoO1xuXG4gICY6bm90KFtvcGVuXSkge1xuICAgIGRpc3BsYXk6IG5vbmU7XG4gIH1cbmA7XG4iLCIvKipcbiAqIEBsaWNlbnNlIFJlYWN0XG4gKiByZWFjdC1qc3gtcnVudGltZS5wcm9kdWN0aW9uLm1pbi5qc1xuICpcbiAqIENvcHlyaWdodCAoYykgRmFjZWJvb2ssIEluYy4gYW5kIGl0cyBhZmZpbGlhdGVzLlxuICpcbiAqIFRoaXMgc291cmNlIGNvZGUgaXMgbGljZW5zZWQgdW5kZXIgdGhlIE1JVCBsaWNlbnNlIGZvdW5kIGluIHRoZVxuICogTElDRU5TRSBmaWxlIGluIHRoZSByb290IGRpcmVjdG9yeSBvZiB0aGlzIHNvdXJjZSB0cmVlLlxuICovXG4ndXNlIHN0cmljdCc7dmFyIGY9cmVxdWlyZShcInJlYWN0XCIpLGs9U3ltYm9sLmZvcihcInJlYWN0LmVsZW1lbnRcIiksbD1TeW1ib2wuZm9yKFwicmVhY3QuZnJhZ21lbnRcIiksbT1PYmplY3QucHJvdG90eXBlLmhhc093blByb3BlcnR5LG49Zi5fX1NFQ1JFVF9JTlRFUk5BTFNfRE9fTk9UX1VTRV9PUl9ZT1VfV0lMTF9CRV9GSVJFRC5SZWFjdEN1cnJlbnRPd25lcixwPXtrZXk6ITAscmVmOiEwLF9fc2VsZjohMCxfX3NvdXJjZTohMH07XG5mdW5jdGlvbiBxKGMsYSxnKXt2YXIgYixkPXt9LGU9bnVsbCxoPW51bGw7dm9pZCAwIT09ZyYmKGU9XCJcIitnKTt2b2lkIDAhPT1hLmtleSYmKGU9XCJcIithLmtleSk7dm9pZCAwIT09YS5yZWYmJihoPWEucmVmKTtmb3IoYiBpbiBhKW0uY2FsbChhLGIpJiYhcC5oYXNPd25Qcm9wZXJ0eShiKSYmKGRbYl09YVtiXSk7aWYoYyYmYy5kZWZhdWx0UHJvcHMpZm9yKGIgaW4gYT1jLmRlZmF1bHRQcm9wcyxhKXZvaWQgMD09PWRbYl0mJihkW2JdPWFbYl0pO3JldHVybnskJHR5cGVvZjprLHR5cGU6YyxrZXk6ZSxyZWY6aCxwcm9wczpkLF9vd25lcjpuLmN1cnJlbnR9fWV4cG9ydHMuRnJhZ21lbnQ9bDtleHBvcnRzLmpzeD1xO2V4cG9ydHMuanN4cz1xO1xuIiwiJ3VzZSBzdHJpY3QnO1xuXG5pZiAocHJvY2Vzcy5lbnYuTk9ERV9FTlYgPT09ICdwcm9kdWN0aW9uJykge1xuICBtb2R1bGUuZXhwb3J0cyA9IHJlcXVpcmUoJy4vY2pzL3JlYWN0LWpzeC1ydW50aW1lLnByb2R1Y3Rpb24ubWluLmpzJyk7XG59IGVsc2Uge1xuICBtb2R1bGUuZXhwb3J0cyA9IHJlcXVpcmUoJy4vY2pzL3JlYWN0LWpzeC1ydW50aW1lLmRldmVsb3BtZW50LmpzJyk7XG59XG4iLCJpbXBvcnQgeyBTY3JvbGxhYmxlLCBUaWxlIH0gZnJvbSAnQHJvY2tldC5jaGF0L2Z1c2VsYWdlJztcbmltcG9ydCB0eXBlIHsgUmVhY3ROb2RlIH0gZnJvbSAncmVhY3QnO1xuXG5pbXBvcnQgeyB1c2VEaWFsb2cgfSBmcm9tICcuL2hvb2tzJztcbmltcG9ydCB7IFdyYXBwZXIgfSBmcm9tICcuL3N0eWxlcyc7XG5cbnR5cGUgRGlhbG9nUHJvcHMgPSB7XG4gIGNoaWxkcmVuPzogUmVhY3ROb2RlO1xuICBpc1Zpc2libGU/OiBib29sZWFuO1xuICBvbkNsb3NlPzogKCkgPT4gdm9pZDtcbn07XG5cbmV4cG9ydCBjb25zdCBEaWFsb2cgPSAoe1xuICBjaGlsZHJlbixcbiAgaXNWaXNpYmxlID0gZmFsc2UsXG4gIG9uQ2xvc2UsXG59OiBEaWFsb2dQcm9wcykgPT4ge1xuICBjb25zdCBkaWFsb2dSZWYgPSB1c2VEaWFsb2coaXNWaXNpYmxlLCBvbkNsb3NlKTtcblxuICByZXR1cm4gKFxuICAgIDxXcmFwcGVyIHJlZj17ZGlhbG9nUmVmfT5cbiAgICAgIDxTY3JvbGxhYmxlPlxuICAgICAgICA8VGlsZSBlbGV2YXRpb249JzInIHBhZGRpbmc9J3gzMicgZGlzcGxheT0nZmxleCcgZmxleERpcmVjdGlvbj0nY29sdW1uJz5cbiAgICAgICAgICB7Y2hpbGRyZW59XG4gICAgICAgIDwvVGlsZT5cbiAgICAgIDwvU2Nyb2xsYWJsZT5cbiAgICA8L1dyYXBwZXI+XG4gICk7XG59O1xuIiwiaW1wb3J0IHtcbiAgQm94LFxuICBCdXR0b24sXG4gIENhbGxvdXQsXG4gIExhYmVsLFxuICBUYWJzLFxuICBTY3JvbGxhYmxlLFxuICBQYWxldHRlU3R5bGVUYWcsXG59IGZyb20gJ0Byb2NrZXQuY2hhdC9mdXNlbGFnZSc7XG5pbXBvcnQgdHlwZSB7XG4gIERlc2t0b3BDYXB0dXJlcixcbiAgRGVza3RvcENhcHR1cmVyU291cmNlLFxuICBTb3VyY2VzT3B0aW9ucyxcbn0gZnJvbSAnZWxlY3Ryb24nO1xuaW1wb3J0IHsgaXBjUmVuZGVyZXIgfSBmcm9tICdlbGVjdHJvbic7XG5pbXBvcnQgeyB1c2VDYWxsYmFjaywgdXNlRWZmZWN0LCB1c2VTdGF0ZSB9IGZyb20gJ3JlYWN0JztcbmltcG9ydCB7IHVzZVRyYW5zbGF0aW9uIH0gZnJvbSAncmVhY3QtaTE4bmV4dCc7XG5cbmltcG9ydCB7IERpYWxvZyB9IGZyb20gJy4uL3VpL2NvbXBvbmVudHMvRGlhbG9nJztcblxuY29uc3QgZGVza3RvcENhcHR1cmVyOiBEZXNrdG9wQ2FwdHVyZXIgPSB7XG4gIGdldFNvdXJjZXM6IChvcHRzOiBTb3VyY2VzT3B0aW9ucykgPT5cbiAgICBpcGNSZW5kZXJlci5pbnZva2UoJ2Rlc2t0b3AtY2FwdHVyZXItZ2V0LXNvdXJjZXMnLCBbb3B0c10pLFxufTtcblxuaW50ZXJmYWNlIElTY3JlZW5TaGFyZVBpY2tlclByb3BzIHtcbiAgb25Nb3VudGVkPzogKHNldFZpc2libGU6ICh2aXNpYmxlOiBib29sZWFuKSA9PiB2b2lkKSA9PiB2b2lkO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gU2NyZWVuU2hhcmVQaWNrZXIoeyBvbk1vdW50ZWQgfTogSVNjcmVlblNoYXJlUGlja2VyUHJvcHMgPSB7fSkge1xuICBjb25zdCB7IHQgfSA9IHVzZVRyYW5zbGF0aW9uKCk7XG4gIGNvbnN0IFt2aXNpYmxlLCBzZXRWaXNpYmxlXSA9IHVzZVN0YXRlKGZhbHNlKTtcbiAgY29uc3QgW3NvdXJjZXMsIHNldFNvdXJjZXNdID0gdXNlU3RhdGU8RGVza3RvcENhcHR1cmVyU291cmNlW10+KFtdKTtcbiAgY29uc3QgW2N1cnJlbnRUYWIsIHNldEN1cnJlbnRUYWJdID0gdXNlU3RhdGU8J3NjcmVlbicgfCAnd2luZG93Jz4oJ3NjcmVlbicpO1xuICBjb25zdCBbc2VsZWN0ZWRTb3VyY2VJZCwgc2V0U2VsZWN0ZWRTb3VyY2VJZF0gPSB1c2VTdGF0ZTxzdHJpbmcgfCBudWxsPihudWxsKTtcbiAgY29uc3QgW1xuICAgIGlzU2NyZWVuUmVjb3JkaW5nUGVybWlzc2lvbkdyYW50ZWQsXG4gICAgc2V0SXNTY3JlZW5SZWNvcmRpbmdQZXJtaXNzaW9uR3JhbnRlZCxcbiAgXSA9IHVzZVN0YXRlKGZhbHNlKTtcblxuICBjb25zdCBmZXRjaFNvdXJjZXMgPSB1c2VDYWxsYmFjayhhc3luYyAoKTogUHJvbWlzZTx2b2lkPiA9PiB7XG4gICAgdHJ5IHtcbiAgICAgIGNvbnN0IHNvdXJjZXMgPSBhd2FpdCBkZXNrdG9wQ2FwdHVyZXIuZ2V0U291cmNlcyh7XG4gICAgICAgIHR5cGVzOiBbJ3dpbmRvdycsICdzY3JlZW4nXSxcbiAgICAgIH0pO1xuXG4gICAgICAvLyBGaWx0ZXIgb3V0IHNvdXJjZXMgdGhhdCBhcmUgbm90IGNhcHR1cmFibGVcbiAgICAgIGNvbnN0IGZpbHRlcmVkU291cmNlcyA9IHNvdXJjZXNcbiAgICAgICAgLmZpbHRlcigoc291cmNlKSA9PiB7XG4gICAgICAgICAgLy8gT25seSBjaGVjayBmb3IgYmFzaWMgdmFsaWRpdHkgLSB0aHVtYm5haWwgdmFsaWRhdGlvbiBpcyBhbHJlYWR5IGRvbmUgYnkgSVBDIGhhbmRsZXJcbiAgICAgICAgICBpZiAoIXNvdXJjZS5uYW1lIHx8IHNvdXJjZS5uYW1lLnRyaW0oKSA9PT0gJycpIHtcbiAgICAgICAgICAgIHJldHVybiBmYWxzZTtcbiAgICAgICAgICB9XG5cbiAgICAgICAgICByZXR1cm4gdHJ1ZTtcbiAgICAgICAgfSlcbiAgICAgICAgLnNvcnQoKGEsIGIpID0+IGEubmFtZS5sb2NhbGVDb21wYXJlKGIubmFtZSkpO1xuXG4gICAgICBzZXRTb3VyY2VzKGZpbHRlcmVkU291cmNlcyk7XG5cbiAgICAgIC8vIElmIHRoZSBjdXJyZW50bHkgc2VsZWN0ZWQgc291cmNlIGlzIG5vIGxvbmdlciBhdmFpbGFibGUsIGNsZWFyIHRoZSBzZWxlY3Rpb25cbiAgICAgIGlmIChcbiAgICAgICAgc2VsZWN0ZWRTb3VyY2VJZCAmJlxuICAgICAgICAhZmlsdGVyZWRTb3VyY2VzLmZpbmQoKHMpID0+IHMuaWQgPT09IHNlbGVjdGVkU291cmNlSWQpXG4gICAgICApIHtcbiAgICAgICAgY29uc29sZS5sb2coXG4gICAgICAgICAgJ1ByZXZpb3VzbHkgc2VsZWN0ZWQgc291cmNlIG5vIGxvbmdlciBhdmFpbGFibGUsIGNsZWFyaW5nIHNlbGVjdGlvbidcbiAgICAgICAgKTtcbiAgICAgICAgc2V0U2VsZWN0ZWRTb3VyY2VJZChudWxsKTtcbiAgICAgIH1cbiAgICB9IGNhdGNoIChlcnJvcikge1xuICAgICAgY29uc29sZS5lcnJvcignRXJyb3IgZmV0Y2hpbmcgc2NyZWVuIHNoYXJpbmcgc291cmNlczonLCBlcnJvcik7XG4gICAgICBzZXRTb3VyY2VzKFtdKTtcbiAgICB9XG4gIH0sIFtzZWxlY3RlZFNvdXJjZUlkXSk7XG5cbiAgdXNlRWZmZWN0KCgpID0+IHtcbiAgICBjb25zdCBjaGVja1NjcmVlblJlY29yZGluZ1Blcm1pc3Npb24gPSBhc3luYyAoKSA9PiB7XG4gICAgICBjb25zdCByZXN1bHQgPSBhd2FpdCBpcGNSZW5kZXJlci5pbnZva2UoXG4gICAgICAgICd2aWRlby1jYWxsLXdpbmRvdy9zY3JlZW4tcmVjb3JkaW5nLWlzLXBlcm1pc3Npb24tZ3JhbnRlZCdcbiAgICAgICk7XG4gICAgICBzZXRJc1NjcmVlblJlY29yZGluZ1Blcm1pc3Npb25HcmFudGVkKHJlc3VsdCk7XG4gICAgfTtcblxuICAgIGNoZWNrU2NyZWVuUmVjb3JkaW5nUGVybWlzc2lvbigpLmNhdGNoKGNvbnNvbGUuZXJyb3IpO1xuICB9LCBbdmlzaWJsZV0pO1xuXG4gIHVzZUVmZmVjdCgoKSA9PiB7XG4gICAgZmV0Y2hTb3VyY2VzKCk7XG4gIH0sIFtmZXRjaFNvdXJjZXNdKTtcblxuICB1c2VFZmZlY3QoKCkgPT4ge1xuICAgIGlmIChvbk1vdW50ZWQpIHtcbiAgICAgIG9uTW91bnRlZChzZXRWaXNpYmxlKTtcbiAgICB9XG4gICAgLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIHJlYWN0LWhvb2tzL2V4aGF1c3RpdmUtZGVwc1xuICB9LCBbXSk7XG5cbiAgdXNlRWZmZWN0KCgpID0+IHtcbiAgICBpZiAoIXZpc2libGUpIHtcbiAgICAgIHJldHVybiB1bmRlZmluZWQ7XG4gICAgfVxuXG4gICAgY29uc3QgdGltZXIgPSBzZXRJbnRlcnZhbCgoKSA9PiB7XG4gICAgICBmZXRjaFNvdXJjZXMoKTtcbiAgICB9LCAzMDAwKTtcblxuICAgIHJldHVybiAoKSA9PiB7XG4gICAgICBjbGVhckludGVydmFsKHRpbWVyKTtcbiAgICB9O1xuICB9LCBbdmlzaWJsZSwgZmV0Y2hTb3VyY2VzXSk7XG5cbiAgY29uc3QgaGFuZGxlU2NyZWVuU2hhcmluZ1NvdXJjZUNsaWNrID0gKGlkOiBzdHJpbmcpID0+ICgpID0+IHtcbiAgICBzZXRTZWxlY3RlZFNvdXJjZUlkKGlkKTtcbiAgfTtcblxuICBjb25zdCBoYW5kbGVTaGFyZSA9ICgpOiB2b2lkID0+IHtcbiAgICBpZiAoc2VsZWN0ZWRTb3VyY2VJZCkge1xuICAgICAgLy8gVmFsaWRhdGUgdGhhdCB0aGUgc2VsZWN0ZWQgc291cmNlIHN0aWxsIGV4aXN0cyBpbiBvdXIgY3VycmVudCBzb3VyY2VzIGxpc3RcbiAgICAgIGNvbnN0IHNlbGVjdGVkU291cmNlID0gc291cmNlcy5maW5kKChzKSA9PiBzLmlkID09PSBzZWxlY3RlZFNvdXJjZUlkKTtcblxuICAgICAgaWYgKCFzZWxlY3RlZFNvdXJjZSkge1xuICAgICAgICBjb25zb2xlLmVycm9yKCdTZWxlY3RlZCBzb3VyY2Ugbm8gbG9uZ2VyIGF2YWlsYWJsZTonLCBzZWxlY3RlZFNvdXJjZUlkKTtcbiAgICAgICAgLy8gUmVmcmVzaCBzb3VyY2VzIGFuZCBjbGVhciBzZWxlY3Rpb25cbiAgICAgICAgZmV0Y2hTb3VyY2VzKCk7XG4gICAgICAgIHNldFNlbGVjdGVkU291cmNlSWQobnVsbCk7XG4gICAgICAgIHJldHVybjtcbiAgICAgIH1cblxuICAgICAgLy8gQWRkaXRpb25hbCB2YWxpZGF0aW9uIGJlZm9yZSBzaGFyaW5nXG4gICAgICBpZiAoc2VsZWN0ZWRTb3VyY2UudGh1bWJuYWlsLmlzRW1wdHkoKSkge1xuICAgICAgICBjb25zb2xlLmVycm9yKFxuICAgICAgICAgICdTZWxlY3RlZCBzb3VyY2UgaGFzIGVtcHR5IHRodW1ibmFpbCwgY2Fubm90IHNoYXJlOicsXG4gICAgICAgICAgc2VsZWN0ZWRTb3VyY2VJZFxuICAgICAgICApO1xuICAgICAgICBzZXRTZWxlY3RlZFNvdXJjZUlkKG51bGwpO1xuICAgICAgICByZXR1cm47XG4gICAgICB9XG5cbiAgICAgIGNvbnNvbGUubG9nKCdTaGFyaW5nIHNjcmVlbiBzb3VyY2U6Jywge1xuICAgICAgICBpZDogc2VsZWN0ZWRTb3VyY2UuaWQsXG4gICAgICAgIG5hbWU6IHNlbGVjdGVkU291cmNlLm5hbWUsXG4gICAgICB9KTtcblxuICAgICAgc2V0VmlzaWJsZShmYWxzZSk7XG4gICAgICBpcGNSZW5kZXJlci5zZW5kKFxuICAgICAgICAndmlkZW8tY2FsbC13aW5kb3cvc2NyZWVuLXNoYXJpbmctc291cmNlLXJlc3BvbmRlZCcsXG4gICAgICAgIHNlbGVjdGVkU291cmNlSWRcbiAgICAgICk7XG4gICAgfVxuICB9O1xuXG4gIGNvbnN0IGhhbmRsZUNsb3NlID0gKCk6IHZvaWQgPT4ge1xuICAgIHNldFZpc2libGUoZmFsc2UpO1xuICAgIGlwY1JlbmRlcmVyLnNlbmQoJ3ZpZGVvLWNhbGwtd2luZG93L3NjcmVlbi1zaGFyaW5nLXNvdXJjZS1yZXNwb25kZWQnLCBudWxsKTtcbiAgfTtcblxuICAvLyBGaWx0ZXIgc291cmNlcyBiYXNlZCBvbiB0aGUgY3VycmVudCB0YWJcbiAgY29uc3QgZmlsdGVyZWRTb3VyY2VzID0gc291cmNlcy5maWx0ZXIoKHNvdXJjZSkgPT4ge1xuICAgIGlmIChjdXJyZW50VGFiID09PSAnc2NyZWVuJykge1xuICAgICAgcmV0dXJuIHNvdXJjZS5pZC5pbmNsdWRlcygnc2NyZWVuJyk7XG4gICAgfVxuICAgIHJldHVybiBzb3VyY2UuaWQuaW5jbHVkZXMoJ3dpbmRvdycpO1xuICB9KTtcblxuICByZXR1cm4gKFxuICAgIDw+XG4gICAgICA8UGFsZXR0ZVN0eWxlVGFnIHRoZW1lPSdkYXJrJyBzZWxlY3Rvcj0nOnJvb3QnIC8+XG4gICAgICA8RGlhbG9nIGlzVmlzaWJsZT17dmlzaWJsZX0gb25DbG9zZT17aGFuZGxlQ2xvc2V9PlxuICAgICAgICA8Qm94XG4gICAgICAgICAgd2lkdGg9JzY4MHB4J1xuICAgICAgICAgIG1hcmdpbj0nYXV0bydcbiAgICAgICAgICBkaXNwbGF5PSdmbGV4J1xuICAgICAgICAgIGZsZXhEaXJlY3Rpb249J2NvbHVtbidcbiAgICAgICAgICBoZWlnaHQ9JzU2MHB4J1xuICAgICAgICAgIGJhY2tncm91bmRDb2xvcj0nbGlnaHQnXG4gICAgICAgICAgY29sb3I9J2RlZmF1bHQnXG4gICAgICAgID5cbiAgICAgICAgICA8Qm94IG1hcmdpbkJsb2NrRW5kPSd4MTInPlxuICAgICAgICAgICAgPEJveCBmb250U2NhbGU9J2gxJyBtYXJnaW5CbG9ja0VuZD0neDEyJz5cbiAgICAgICAgICAgICAge3QoJ3NjcmVlblNoYXJpbmcudGl0bGUnKX1cbiAgICAgICAgICAgIDwvQm94PlxuXG4gICAgICAgICAgICA8VGFicz5cbiAgICAgICAgICAgICAgPFRhYnMuSXRlbVxuICAgICAgICAgICAgICAgIHNlbGVjdGVkPXtjdXJyZW50VGFiID09PSAnc2NyZWVuJ31cbiAgICAgICAgICAgICAgICBvbkNsaWNrPXsoKSA9PiBzZXRDdXJyZW50VGFiKCdzY3JlZW4nKX1cbiAgICAgICAgICAgICAgPlxuICAgICAgICAgICAgICAgIHt0KCdzY3JlZW5TaGFyaW5nLmVudGlyZVNjcmVlbicpfVxuICAgICAgICAgICAgICA8L1RhYnMuSXRlbT5cbiAgICAgICAgICAgICAgPFRhYnMuSXRlbVxuICAgICAgICAgICAgICAgIHNlbGVjdGVkPXtjdXJyZW50VGFiID09PSAnd2luZG93J31cbiAgICAgICAgICAgICAgICBvbkNsaWNrPXsoKSA9PiBzZXRDdXJyZW50VGFiKCd3aW5kb3cnKX1cbiAgICAgICAgICAgICAgPlxuICAgICAgICAgICAgICAgIHt0KCdzY3JlZW5TaGFyaW5nLmFwcGxpY2F0aW9uV2luZG93Jyl9XG4gICAgICAgICAgICAgIDwvVGFicy5JdGVtPlxuICAgICAgICAgICAgPC9UYWJzPlxuICAgICAgICAgIDwvQm94PlxuICAgICAgICAgIDxCb3hcbiAgICAgICAgICAgIGRpc3BsYXk9J2ZsZXgnXG4gICAgICAgICAgICBmbGV4RGlyZWN0aW9uPSdjb2x1bW4nXG4gICAgICAgICAgICBvdmVyZmxvdz0naGlkZGVuJ1xuICAgICAgICAgICAgbWFyZ2luQmxvY2tTdGFydD0neDEwJ1xuICAgICAgICAgICAgbWFyZ2luQmxvY2tFbmQ9J3gxMCdcbiAgICAgICAgICAgIGZsZXhHcm93PXsxfVxuICAgICAgICAgID5cbiAgICAgICAgICAgIHshaXNTY3JlZW5SZWNvcmRpbmdQZXJtaXNzaW9uR3JhbnRlZCA/IChcbiAgICAgICAgICAgICAgPENhbGxvdXRcbiAgICAgICAgICAgICAgICB0aXRsZT17dCgnc2NyZWVuU2hhcmluZy5wZXJtaXNzaW9uRGVuaWVkJyl9XG4gICAgICAgICAgICAgICAgdHlwZT0nZGFuZ2VyJ1xuICAgICAgICAgICAgICAgIG1hcmdpbj0neDMyJ1xuICAgICAgICAgICAgICA+XG4gICAgICAgICAgICAgICAge3QoJ3NjcmVlblNoYXJpbmcucGVybWlzc2lvblJlcXVpcmVkJyl9XG4gICAgICAgICAgICAgICAgPGJyIC8+XG4gICAgICAgICAgICAgICAge3QoJ3NjcmVlblNoYXJpbmcucGVybWlzc2lvbkluc3RydWN0aW9ucycpfVxuICAgICAgICAgICAgICA8L0NhbGxvdXQ+XG4gICAgICAgICAgICApIDogKFxuICAgICAgICAgICAgICA8U2Nyb2xsYWJsZSB2ZXJ0aWNhbD5cbiAgICAgICAgICAgICAgICA8Qm94XG4gICAgICAgICAgICAgICAgICBwYWRkaW5nPSd4OCdcbiAgICAgICAgICAgICAgICAgIHN0eWxlPXt7XG4gICAgICAgICAgICAgICAgICAgIGRpc3BsYXk6ICdncmlkJyxcbiAgICAgICAgICAgICAgICAgICAgZ3JpZFRlbXBsYXRlQ29sdW1uczogJ3JlcGVhdChhdXRvLWZpdCwgMjA4cHgpJyxcbiAgICAgICAgICAgICAgICAgICAgZ2FwOiAnMTZweCcsXG4gICAgICAgICAgICAgICAgICAgIGp1c3RpZnlDb250ZW50OiAnY2VudGVyJyxcbiAgICAgICAgICAgICAgICAgIH19XG4gICAgICAgICAgICAgICAgPlxuICAgICAgICAgICAgICAgICAge2ZpbHRlcmVkU291cmNlcy5sZW5ndGggPT09IDAgPyAoXG4gICAgICAgICAgICAgICAgICAgIDxCb3hcbiAgICAgICAgICAgICAgICAgICAgICBkaXNwbGF5PSdmbGV4J1xuICAgICAgICAgICAgICAgICAgICAgIGFsaWduSXRlbXM9J2NlbnRlcidcbiAgICAgICAgICAgICAgICAgICAgICBqdXN0aWZ5Q29udGVudD0nY2VudGVyJ1xuICAgICAgICAgICAgICAgICAgICAgIHdpZHRoPScxMDAlJ1xuICAgICAgICAgICAgICAgICAgICAgIHA9J3gxNidcbiAgICAgICAgICAgICAgICAgICAgICBzdHlsZT17eyBncmlkQ29sdW1uOiAnMSAvIC0xJyB9fVxuICAgICAgICAgICAgICAgICAgICA+XG4gICAgICAgICAgICAgICAgICAgICAgPExhYmVsPlxuICAgICAgICAgICAgICAgICAgICAgICAge2N1cnJlbnRUYWIgPT09ICdzY3JlZW4nXG4gICAgICAgICAgICAgICAgICAgICAgICAgID8gdCgnc2NyZWVuU2hhcmluZy5ub1NjcmVlbnNGb3VuZCcpXG4gICAgICAgICAgICAgICAgICAgICAgICAgIDogdCgnc2NyZWVuU2hhcmluZy5ub1dpbmRvd3NGb3VuZCcpfVxuICAgICAgICAgICAgICAgICAgICAgIDwvTGFiZWw+XG4gICAgICAgICAgICAgICAgICAgIDwvQm94PlxuICAgICAgICAgICAgICAgICAgKSA6IChcbiAgICAgICAgICAgICAgICAgICAgZmlsdGVyZWRTb3VyY2VzLm1hcCgoeyBpZCwgbmFtZSwgdGh1bWJuYWlsIH0pID0+IChcbiAgICAgICAgICAgICAgICAgICAgICA8Qm94XG4gICAgICAgICAgICAgICAgICAgICAgICBrZXk9e2lkfVxuICAgICAgICAgICAgICAgICAgICAgICAgd2lkdGg9J3gyMDgnXG4gICAgICAgICAgICAgICAgICAgICAgICBoZWlnaHQ9J3gxNzAnXG4gICAgICAgICAgICAgICAgICAgICAgICBkaXNwbGF5PSdmbGV4J1xuICAgICAgICAgICAgICAgICAgICAgICAgZmxleERpcmVjdGlvbj0nY29sdW1uJ1xuICAgICAgICAgICAgICAgICAgICAgICAgb25DbGljaz17aGFuZGxlU2NyZWVuU2hhcmluZ1NvdXJjZUNsaWNrKGlkKX1cbiAgICAgICAgICAgICAgICAgICAgICAgIGJnPXtzZWxlY3RlZFNvdXJjZUlkID09PSBpZCA/ICdzZWxlY3RlZCcgOiAnbGlnaHQnfVxuICAgICAgICAgICAgICAgICAgICAgICAgYm9yZGVyPXtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgc2VsZWN0ZWRTb3VyY2VJZCA9PT0gaWRcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICA/ICcycHggc29saWQgdmFyKC0tcmN4LWNvbG9yLXN0cm9rZS1oaWdobGlnaHQpJ1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIDogJzFweCBzb2xpZCB2YXIoLS1yY3gtY29sb3Itc3Ryb2tlLWxpZ2h0KSdcbiAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgIGJvcmRlclJhZGl1cz0neDInXG4gICAgICAgICAgICAgICAgICAgICAgICBjdXJzb3I9J3BvaW50ZXInXG4gICAgICAgICAgICAgICAgICAgICAgICBjbGFzc05hbWU9J3NjcmVlbi1zaGFyZS10aHVtYm5haWwnXG4gICAgICAgICAgICAgICAgICAgICAgICBzdHlsZT17e1xuICAgICAgICAgICAgICAgICAgICAgICAgICBwb3NpdGlvbjogJ3JlbGF0aXZlJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgb3ZlcmZsb3c6ICd2aXNpYmxlJyxcbiAgICAgICAgICAgICAgICAgICAgICAgIH19XG4gICAgICAgICAgICAgICAgICAgICAgPlxuICAgICAgICAgICAgICAgICAgICAgICAgPEJveFxuICAgICAgICAgICAgICAgICAgICAgICAgICBmbGV4R3Jvdz17MX1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgZGlzcGxheT0nZmxleCdcbiAgICAgICAgICAgICAgICAgICAgICAgICAgYWxpZ25JdGVtcz0nZmxleC1zdGFydCdcbiAgICAgICAgICAgICAgICAgICAgICAgICAganVzdGlmeUNvbnRlbnQ9J2ZsZXgtc3RhcnQnXG4gICAgICAgICAgICAgICAgICAgICAgICAgIG92ZXJmbG93PSdoaWRkZW4nXG4gICAgICAgICAgICAgICAgICAgICAgICAgIHN0eWxlPXt7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgbWluSGVpZ2h0OiAnMTIwcHgnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGJhY2tncm91bmRDb2xvcjogJ3JnYmEoMCwgMCwgMCwgMC4xKScsXG4gICAgICAgICAgICAgICAgICAgICAgICAgIH19XG4gICAgICAgICAgICAgICAgICAgICAgICA+XG4gICAgICAgICAgICAgICAgICAgICAgICAgIDxCb3hcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBpcz0naW1nJ1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHNyYz17dGh1bWJuYWlsLnRvRGF0YVVSTCgpfVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGFsdD17bmFtZX1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBzdHlsZT17e1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgd2lkdGg6ICcxMDAlJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGhlaWdodDogJ2F1dG8nLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgb2JqZWN0Rml0OiAnY29udGFpbicsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICBvYmplY3RQb3NpdGlvbjogJ3RvcCcsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICBkaXNwbGF5OiAnYmxvY2snLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIH19XG4gICAgICAgICAgICAgICAgICAgICAgICAgIC8+XG4gICAgICAgICAgICAgICAgICAgICAgICA8L0JveD5cbiAgICAgICAgICAgICAgICAgICAgICAgIDxCb3hcbiAgICAgICAgICAgICAgICAgICAgICAgICAgcD0neDQnXG4gICAgICAgICAgICAgICAgICAgICAgICAgIHN0eWxlPXt7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgcG9zaXRpb246ICdhYnNvbHV0ZScsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgYm90dG9tOiAnMCcsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgbGVmdDogJzAnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHJpZ2h0OiAnMCcsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgYmFja2dyb3VuZDogJ3JnYmEoMCwgMCwgMCwgMC41KScsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgYmFja2Ryb3BGaWx0ZXI6ICdibHVyKDRweCknLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHpJbmRleDogMTAsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgbWluSGVpZ2h0OiAnYXV0bycsXG4gICAgICAgICAgICAgICAgICAgICAgICAgIH19XG4gICAgICAgICAgICAgICAgICAgICAgICA+XG4gICAgICAgICAgICAgICAgICAgICAgICAgIDxMYWJlbFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHRpdGxlPXtuYW1lfVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHN0eWxlPXt7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICBmb250U2l6ZTogJzExcHgnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgbGluZUhlaWdodDogJzEuMicsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICBjb2xvcjogJ3doaXRlJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHRleHRBbGlnbjogJ2NlbnRlcicsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICB3aWR0aDogJzEwMCUnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgbWFyZ2luOiAwLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgd29yZEJyZWFrOiAnYnJlYWstd29yZCcsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICBkaXNwbGF5OiAnLXdlYmtpdC1ib3gnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgV2Via2l0TGluZUNsYW1wOiAyLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgV2Via2l0Qm94T3JpZW50OiAndmVydGljYWwnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgb3ZlcmZsb3c6ICdoaWRkZW4nLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgdGV4dE92ZXJmbG93OiAnZWxsaXBzaXMnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIH19XG4gICAgICAgICAgICAgICAgICAgICAgICAgID5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICB7bmFtZX1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgPC9MYWJlbD5cbiAgICAgICAgICAgICAgICAgICAgICAgIDwvQm94PlxuICAgICAgICAgICAgICAgICAgICAgIDwvQm94PlxuICAgICAgICAgICAgICAgICAgICApKVxuICAgICAgICAgICAgICAgICAgKX1cbiAgICAgICAgICAgICAgICA8L0JveD5cbiAgICAgICAgICAgICAgPC9TY3JvbGxhYmxlPlxuICAgICAgICAgICAgKX1cbiAgICAgICAgICA8L0JveD5cbiAgICAgICAgICA8Qm94XG4gICAgICAgICAgICBkaXNwbGF5PSdmbGV4J1xuICAgICAgICAgICAganVzdGlmeUNvbnRlbnQ9J3NwYWNlLWJldHdlZW4nXG4gICAgICAgICAgICBtYXJnaW5CbG9ja1N0YXJ0PSdhdXRvJ1xuICAgICAgICAgID5cbiAgICAgICAgICAgIDxCdXR0b24gb25DbGljaz17aGFuZGxlQ2xvc2V9Pnt0KCdzY3JlZW5TaGFyaW5nLmNhbmNlbCcpfTwvQnV0dG9uPlxuICAgICAgICAgICAgPEJ1dHRvbiBwcmltYXJ5IG9uQ2xpY2s9e2hhbmRsZVNoYXJlfSBkaXNhYmxlZD17IXNlbGVjdGVkU291cmNlSWR9PlxuICAgICAgICAgICAgICB7dCgnc2NyZWVuU2hhcmluZy5zaGFyZScpfVxuICAgICAgICAgICAgPC9CdXR0b24+XG4gICAgICAgICAgPC9Cb3g+XG4gICAgICAgIDwvQm94PlxuICAgICAgPC9EaWFsb2c+XG4gICAgPC8+XG4gICk7XG59XG4iLCJpbXBvcnQgaTE4bmV4dCBmcm9tICdpMThuZXh0JztcbmltcG9ydCB7IGNyZWF0ZVJvb3QsIHR5cGUgUm9vdCB9IGZyb20gJ3JlYWN0LWRvbS9jbGllbnQnO1xuaW1wb3J0IHsgSTE4bmV4dFByb3ZpZGVyIH0gZnJvbSAncmVhY3QtaTE4bmV4dCc7XG5cbmltcG9ydCB7IFNjcmVlblNoYXJlUGlja2VyIH0gZnJvbSAnLi9zY3JlZW5TaGFyZVBpY2tlcic7XG5cbmV4cG9ydCB0eXBlIFNjcmVlblNoYXJlUGlja2VyTW9kdWxlVHlwZSA9IHtcbiAgbW91bnQ6ICgpID0+IHZvaWQ7XG4gIHNob3c6ICgpID0+IHZvaWQ7XG59O1xuXG5sZXQgcmVhY3RSb290OiBSb290IHwgbnVsbCA9IG51bGw7XG5sZXQgc2V0VmlzaWJsZUNhbGxiYWNrOiAoKHZpc2libGU6IGJvb2xlYW4pID0+IHZvaWQpIHwgbnVsbCA9IG51bGw7XG5sZXQgc2hvdWxkU2hvd09uTW91bnQgPSBmYWxzZTtcblxuZXhwb3J0IGNvbnN0IG1vdW50ID0gKCk6IHZvaWQgPT4ge1xuICBjb25zdCBjb250YWluZXIgPSBkb2N1bWVudC5nZXRFbGVtZW50QnlJZCgnc2NyZWVuLXBpY2tlci1yb290Jyk7XG4gIGlmICghY29udGFpbmVyKSB7XG4gICAgY29uc29sZS5lcnJvcignU2NyZWVuIHBpY2tlciByb290IGNvbnRhaW5lciBub3QgZm91bmQnKTtcbiAgICByZXR1cm47XG4gIH1cblxuICBpZiAocmVhY3RSb290KSB7XG4gICAgcmV0dXJuO1xuICB9XG5cbiAgdHJ5IHtcbiAgICByZWFjdFJvb3QgPSBjcmVhdGVSb290KGNvbnRhaW5lcik7XG4gICAgcmVhY3RSb290LnJlbmRlcihcbiAgICAgIDxJMThuZXh0UHJvdmlkZXIgaTE4bj17aTE4bmV4dH0+XG4gICAgICAgIDxTY3JlZW5TaGFyZVBpY2tlclxuICAgICAgICAgIG9uTW91bnRlZD17KHNldFZpc2libGUpID0+IHtcbiAgICAgICAgICAgIHNldFZpc2libGVDYWxsYmFjayA9IHNldFZpc2libGU7XG4gICAgICAgICAgICBpZiAoc2hvdWxkU2hvd09uTW91bnQpIHtcbiAgICAgICAgICAgICAgc2V0VmlzaWJsZSh0cnVlKTtcbiAgICAgICAgICAgICAgc2hvdWxkU2hvd09uTW91bnQgPSBmYWxzZTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICB9fVxuICAgICAgICAvPlxuICAgICAgPC9JMThuZXh0UHJvdmlkZXI+XG4gICAgKTtcblxuICAgIGlmIChwcm9jZXNzLmVudi5OT0RFX0VOViA9PT0gJ2RldmVsb3BtZW50Jykge1xuICAgICAgY29uc29sZS5sb2coJ1NjcmVlbiBzaGFyZSBwaWNrZXIgbW91bnRlZCcpO1xuICAgIH1cbiAgfSBjYXRjaCAoZXJyb3IpIHtcbiAgICBjb25zb2xlLmVycm9yKCdGYWlsZWQgdG8gbW91bnQgc2NyZWVuIHNoYXJlIHBpY2tlcjonLCBlcnJvcik7XG4gICAgcmVhY3RSb290ID0gbnVsbDtcbiAgICBzZXRWaXNpYmxlQ2FsbGJhY2sgPSBudWxsO1xuICAgIHNob3VsZFNob3dPbk1vdW50ID0gZmFsc2U7XG4gIH1cbn07XG5cbmV4cG9ydCBjb25zdCBzaG93ID0gKCk6IHZvaWQgPT4ge1xuICBpZiAoIXJlYWN0Um9vdCkge1xuICAgIC8vIFNldCBmbGFnIEJFRk9SRSBtb3VudGluZyBzbyBvbk1vdW50ZWQgY2FsbGJhY2sgY2FuIHNlZSBpdCBkdXJpbmcgcmVuZGVyXG4gICAgc2hvdWxkU2hvd09uTW91bnQgPSB0cnVlO1xuICAgIG1vdW50KCk7XG4gICAgcmV0dXJuO1xuICB9XG5cbiAgaWYgKHNldFZpc2libGVDYWxsYmFjaykge1xuICAgIHNldFZpc2libGVDYWxsYmFjayh0cnVlKTtcbiAgfSBlbHNlIHtcbiAgICBzaG91bGRTaG93T25Nb3VudCA9IHRydWU7XG4gICAgc2V0VGltZW91dCgoKSA9PiB7XG4gICAgICBpZiAoc2V0VmlzaWJsZUNhbGxiYWNrKSB7XG4gICAgICAgIHNldFZpc2libGVDYWxsYmFjayh0cnVlKTtcbiAgICAgIH1cbiAgICAgIHNob3VsZFNob3dPbk1vdW50ID0gZmFsc2U7XG4gICAgfSwgMCk7XG4gIH1cbn07XG4iXSwibmFtZXMiOlsibSIsInJlcXVpcmUiLCJleHBvcnRzIiwiY3JlYXRlUm9vdCIsImh5ZHJhdGVSb290IiwidXNlRGlhbG9nIiwidmlzaWJsZSIsIm9uQ2xvc2UiLCJ1bmRlZmluZWQiLCJkaWFsb2dSZWYiLCJ1c2VSZWYiLCJvbkNsb3NlUmVmIiwidXNlRWZmZWN0IiwiY3VycmVudCIsImRpYWxvZyIsImNsb3NlIiwic2hvd01vZGFsIiwib25jbG9zZSIsIm9uY2xpY2siLCJjbGllbnRYIiwiY2xpZW50WSIsImxlZnQiLCJ0b3AiLCJ3aWR0aCIsImhlaWdodCIsImdldEJvdW5kaW5nQ2xpZW50UmVjdCIsImlzSW5EaWFsb2ciLCJXcmFwcGVyIiwic3R5bGVkIiwiZiIsImsiLCJTeW1ib2wiLCJmb3IiLCJsIiwiT2JqZWN0IiwicHJvdG90eXBlIiwiaGFzT3duUHJvcGVydHkiLCJuIiwiX19TRUNSRVRfSU5URVJOQUxTX0RPX05PVF9VU0VfT1JfWU9VX1dJTExfQkVfRklSRUQiLCJSZWFjdEN1cnJlbnRPd25lciIsInAiLCJrZXkiLCJyZWYiLCJfX3NlbGYiLCJfX3NvdXJjZSIsInEiLCJjIiwiYSIsImciLCJiIiwiZCIsImUiLCJoIiwiY2FsbCIsImRlZmF1bHRQcm9wcyIsIiQkdHlwZW9mIiwidHlwZSIsInByb3BzIiwiX293bmVyIiwibW9kdWxlIiwiRGlhbG9nIiwiY2hpbGRyZW4iLCJpc1Zpc2libGUiLCJfanN4IiwiU2Nyb2xsYWJsZSIsIlRpbGUiLCJlbGV2YXRpb24iLCJwYWRkaW5nIiwiZGlzcGxheSIsImZsZXhEaXJlY3Rpb24iLCJkZXNrdG9wQ2FwdHVyZXIiLCJnZXRTb3VyY2VzIiwib3B0cyIsImlwY1JlbmRlcmVyIiwiaW52b2tlIiwiU2NyZWVuU2hhcmVQaWNrZXIiLCJvbk1vdW50ZWQiLCJ0IiwidXNlVHJhbnNsYXRpb24iLCJzZXRWaXNpYmxlIiwidXNlU3RhdGUiLCJzb3VyY2VzIiwic2V0U291cmNlcyIsImN1cnJlbnRUYWIiLCJzZXRDdXJyZW50VGFiIiwic2VsZWN0ZWRTb3VyY2VJZCIsInNldFNlbGVjdGVkU291cmNlSWQiLCJpc1NjcmVlblJlY29yZGluZ1Blcm1pc3Npb25HcmFudGVkIiwic2V0SXNTY3JlZW5SZWNvcmRpbmdQZXJtaXNzaW9uR3JhbnRlZCIsImZldGNoU291cmNlcyIsInVzZUNhbGxiYWNrIiwidHlwZXMiLCJmaWx0ZXJlZFNvdXJjZXMiLCJmaWx0ZXIiLCJzb3VyY2UiLCJuYW1lIiwidHJpbSIsInNvcnQiLCJsb2NhbGVDb21wYXJlIiwiZmluZCIsInMiLCJpZCIsImNvbnNvbGUiLCJsb2ciLCJlcnJvciIsImNoZWNrU2NyZWVuUmVjb3JkaW5nUGVybWlzc2lvbiIsInJlc3VsdCIsImNhdGNoIiwidGltZXIiLCJzZXRJbnRlcnZhbCIsImNsZWFySW50ZXJ2YWwiLCJoYW5kbGVTY3JlZW5TaGFyaW5nU291cmNlQ2xpY2siLCJoYW5kbGVTaGFyZSIsInNlbGVjdGVkU291cmNlIiwidGh1bWJuYWlsIiwiaXNFbXB0eSIsInNlbmQiLCJoYW5kbGVDbG9zZSIsImluY2x1ZGVzIiwiX2pzeHMiLCJfRnJhZ21lbnQiLCJQYWxldHRlU3R5bGVUYWciLCJ0aGVtZSIsInNlbGVjdG9yIiwiQm94IiwibWFyZ2luIiwiYmFja2dyb3VuZENvbG9yIiwiY29sb3IiLCJtYXJnaW5CbG9ja0VuZCIsImZvbnRTY2FsZSIsIlRhYnMiLCJJdGVtIiwic2VsZWN0ZWQiLCJvbkNsaWNrIiwib3ZlcmZsb3ciLCJtYXJnaW5CbG9ja1N0YXJ0IiwiZmxleEdyb3ciLCJDYWxsb3V0IiwidGl0bGUiLCJ2ZXJ0aWNhbCIsInN0eWxlIiwiZ3JpZFRlbXBsYXRlQ29sdW1ucyIsImdhcCIsImp1c3RpZnlDb250ZW50IiwibGVuZ3RoIiwiYWxpZ25JdGVtcyIsImdyaWRDb2x1bW4iLCJMYWJlbCIsIm1hcCIsImJnIiwiYm9yZGVyIiwiYm9yZGVyUmFkaXVzIiwiY3Vyc29yIiwiY2xhc3NOYW1lIiwicG9zaXRpb24iLCJtaW5IZWlnaHQiLCJpcyIsInNyYyIsInRvRGF0YVVSTCIsImFsdCIsIm9iamVjdEZpdCIsIm9iamVjdFBvc2l0aW9uIiwiYm90dG9tIiwicmlnaHQiLCJiYWNrZ3JvdW5kIiwiYmFja2Ryb3BGaWx0ZXIiLCJ6SW5kZXgiLCJmb250U2l6ZSIsImxpbmVIZWlnaHQiLCJ0ZXh0QWxpZ24iLCJ3b3JkQnJlYWsiLCJXZWJraXRMaW5lQ2xhbXAiLCJXZWJraXRCb3hPcmllbnQiLCJ0ZXh0T3ZlcmZsb3ciLCJCdXR0b24iLCJwcmltYXJ5IiwiZGlzYWJsZWQiLCJyZWFjdFJvb3QiLCJzZXRWaXNpYmxlQ2FsbGJhY2siLCJzaG91bGRTaG93T25Nb3VudCIsIm1vdW50IiwiY29udGFpbmVyIiwiZG9jdW1lbnQiLCJnZXRFbGVtZW50QnlJZCIsInJlbmRlciIsIkkxOG5leHRQcm92aWRlciIsImkxOG4iLCJpMThuZXh0Iiwic2hvdyIsInNldFRpbWVvdXQiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUFFQSxJQUFJQSxHQUFDLEdBQUdDLDJCQUFvQixDQUFBO0FBQ2U7QUFDekNDLEVBQUFBLFVBQWtCLEdBQUdGLEdBQUMsQ0FBQ0csVUFBVSxDQUFBO0FBQ2pDRCxFQUFzQkYsR0FBQyxDQUFDSSxXQUFXLENBQUE7QUFDckM7O0FDSE8sTUFBTUMsU0FBUyxHQUFHQSxDQUN2QkMsT0FBZ0IsRUFDaEJDLE9BQU8sR0FBR0EsTUFBWUMsU0FBUyxLQUNKO0FBQzNCLEVBQUEsTUFBTUMsU0FBUyxHQUFHQyxtQkFBTSxDQUFvQixJQUFJLENBQUMsQ0FBQTtBQUNqRCxFQUFBLE1BQU1DLFVBQVUsR0FBR0QsbUJBQU0sRUFBYyxDQUFBO0FBRXZDRSxFQUFBQSxzQkFBUyxDQUFDLE1BQU07SUFDZEQsVUFBVSxDQUFDRSxPQUFPLEdBQUdOLE9BQU8sQ0FBQTtBQUM5QixHQUFDLENBQUMsQ0FBQTtBQUVGSyxFQUFBQSxzQkFBUyxDQUFDLE1BQU07QUFDZCxJQUFBLE1BQU1FLE1BQU0sR0FBR0wsU0FBUyxDQUFDSSxPQUFPLENBQUE7QUFDaEMsSUFBQSxNQUFNTixPQUFPLEdBQUdJLFVBQVUsQ0FBQ0UsT0FBTyxDQUFBO0lBRWxDLElBQUksQ0FBQ0MsTUFBTSxFQUFFO0FBQ1gsTUFBQSxPQUFBO0FBQ0YsS0FBQTtJQUVBLElBQUksQ0FBQ1IsT0FBTyxFQUFFO01BQ1pRLE1BQU0sQ0FBQ0MsS0FBSyxFQUFFLENBQUE7QUFDZCxNQUFBLE9BQUE7QUFDRixLQUFBO0lBRUFELE1BQU0sQ0FBQ0UsU0FBUyxFQUFFLENBQUE7SUFFbEJGLE1BQU0sQ0FBQ0csT0FBTyxHQUFHLE1BQU07TUFDckJILE1BQU0sQ0FBQ0MsS0FBSyxFQUFFLENBQUE7QUFDZFIsTUFBQUEsT0FBTyxLQUFQQSxJQUFBQSxJQUFBQSxPQUFPLEtBQVBBLEtBQUFBLENBQUFBLElBQUFBLE9BQU8sRUFBSSxDQUFBO0tBQ1osQ0FBQTtJQUVETyxNQUFNLENBQUNJLE9BQU8sR0FBRyxDQUFDO01BQUVDLE9BQU87QUFBRUMsTUFBQUEsT0FBQUE7QUFBUSxLQUFDLEtBQUs7TUFDekMsTUFBTTtRQUFFQyxJQUFJO1FBQUVDLEdBQUc7UUFBRUMsS0FBSztBQUFFQyxRQUFBQSxNQUFBQTtBQUFPLE9BQUMsR0FBR1YsTUFBTSxDQUFDVyxxQkFBcUIsRUFBRSxDQUFBO01BQ25FLE1BQU1DLFVBQVUsR0FDZEosR0FBRyxJQUFJRixPQUFPLElBQ2RBLE9BQU8sSUFBSUUsR0FBRyxHQUFHRSxNQUFNLElBQ3ZCSCxJQUFJLElBQUlGLE9BQU8sSUFDZkEsT0FBTyxJQUFJRSxJQUFJLEdBQUdFLEtBQUssQ0FBQTtNQUN6QixJQUFJLENBQUNHLFVBQVUsRUFBRTtRQUNmWixNQUFNLENBQUNDLEtBQUssRUFBRSxDQUFBO0FBQ2hCLE9BQUE7S0FDRCxDQUFBO0FBQ0gsR0FBQyxFQUFFLENBQUNULE9BQU8sQ0FBQyxDQUFDLENBQUE7QUFFYixFQUFBLE9BQU9HLFNBQVMsQ0FBQTtBQUNsQixDQUFDOztBQzlDTSxNQUFNa0IsT0FBTyxHQUFHQyx1QkFBTSxDQUFDZCxNQUFNLENBQUE7QUFDcEM7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLENBQUM7Ozs7Ozs7Ozs7Ozs7Ozs7QUNSWSxJQUFJZSxDQUFDLEdBQUM1Qiw2QkFBZ0I7QUFBQzZCLEVBQUFBLENBQUMsR0FBQ0MsTUFBTSxDQUFDQyxHQUFHLENBQUMsZUFBZSxDQUFDO0FBQUNDLEVBQUFBLENBQUMsR0FBQ0YsTUFBTSxDQUFDQyxHQUFHLENBQUMsZ0JBQWdCLENBQUM7QUFBQ2hDLEVBQUFBLENBQUMsR0FBQ2tDLE1BQU0sQ0FBQ0MsU0FBUyxDQUFDQyxjQUFjO0FBQUNDLEVBQUFBLENBQUMsR0FBQ1IsQ0FBQyxDQUFDUyxrREFBa0QsQ0FBQ0MsaUJBQWlCO0FBQUNDLEVBQUFBLENBQUMsR0FBQztJQUFDQyxHQUFHLEVBQUMsQ0FBQyxDQUFDO0lBQUNDLEdBQUcsRUFBQyxDQUFDLENBQUM7SUFBQ0MsTUFBTSxFQUFDLENBQUMsQ0FBQztBQUFDQyxJQUFBQSxRQUFRLEVBQUMsQ0FBQyxDQUFBO0dBQUUsQ0FBQTtBQUNuUCxTQUFTQyxDQUFDQSxDQUFDQyxDQUFDLEVBQUNDLENBQUMsRUFBQ0MsQ0FBQyxFQUFDO0FBQUMsRUFBQSxJQUFJQyxDQUFDO0lBQUNDLENBQUMsR0FBQyxFQUFFO0FBQUNDLElBQUFBLENBQUMsR0FBQyxJQUFJO0FBQUNDLElBQUFBLENBQUMsR0FBQyxJQUFJLENBQUE7RUFBQyxLQUFLLENBQUMsS0FBR0osQ0FBQyxLQUFHRyxDQUFDLEdBQUMsRUFBRSxHQUFDSCxDQUFDLENBQUMsQ0FBQTtBQUFDLEVBQUEsS0FBSyxDQUFDLEtBQUdELENBQUMsQ0FBQ04sR0FBRyxLQUFHVSxDQUFDLEdBQUMsRUFBRSxHQUFDSixDQUFDLENBQUNOLEdBQUcsQ0FBQyxDQUFBO0VBQUMsS0FBSyxDQUFDLEtBQUdNLENBQUMsQ0FBQ0wsR0FBRyxLQUFHVSxDQUFDLEdBQUNMLENBQUMsQ0FBQ0wsR0FBRyxDQUFDLENBQUE7QUFBQyxFQUFBLEtBQUlPLENBQUMsSUFBSUYsQ0FBQyxFQUFDL0MsQ0FBQyxDQUFDcUQsSUFBSSxDQUFDTixDQUFDLEVBQUNFLENBQUMsQ0FBQyxJQUFFLENBQUNULENBQUMsQ0FBQ0osY0FBYyxDQUFDYSxDQUFDLENBQUMsS0FBR0MsQ0FBQyxDQUFDRCxDQUFDLENBQUMsR0FBQ0YsQ0FBQyxDQUFDRSxDQUFDLENBQUMsQ0FBQyxDQUFBO0FBQUMsRUFBQSxJQUFHSCxDQUFDLElBQUVBLENBQUMsQ0FBQ1EsWUFBWSxFQUFDLEtBQUlMLENBQUMsSUFBSUYsQ0FBQyxHQUFDRCxDQUFDLENBQUNRLFlBQVksRUFBQ1AsQ0FBQyxFQUFDLEtBQUssQ0FBQyxLQUFHRyxDQUFDLENBQUNELENBQUMsQ0FBQyxLQUFHQyxDQUFDLENBQUNELENBQUMsQ0FBQyxHQUFDRixDQUFDLENBQUNFLENBQUMsQ0FBQyxDQUFDLENBQUE7RUFBQyxPQUFNO0FBQUNNLElBQUFBLFFBQVEsRUFBQ3pCLENBQUM7QUFBQzBCLElBQUFBLElBQUksRUFBQ1YsQ0FBQztBQUFDTCxJQUFBQSxHQUFHLEVBQUNVLENBQUM7QUFBQ1QsSUFBQUEsR0FBRyxFQUFDVSxDQUFDO0FBQUNLLElBQUFBLEtBQUssRUFBQ1AsQ0FBQztJQUFDUSxNQUFNLEVBQUNyQixDQUFDLENBQUN4QixPQUFBQTtHQUFRLENBQUE7QUFBQSxDQUFBO0FBQWlCLDhCQUFBLENBQUEsUUFBQSxHQUFDb0IsRUFBQztBQUFZLDhCQUFBLENBQUEsR0FBQSxHQUFDWSxFQUFDO0FBQUMzQyw4QkFBQUEsQ0FBQUEsSUFBWSxHQUFDMkM7O0FDUi9UO0FBQ3pDYyxFQUFBQSxVQUFBQSxDQUFBQSxPQUFjLEdBQUcxRCw4QkFBb0QsQ0FBQTtBQUN2RSxDQUVBOzs7O0FDTU8sTUFBTTJELE1BQU0sR0FBR0EsQ0FBQztFQUNyQkMsUUFBUTtBQUNSQyxFQUFBQSxTQUFTLEdBQUcsS0FBSztBQUNqQnZELEVBQUFBLE9BQUFBO0FBQ1csQ0FBQyxLQUFLO0FBQ2pCLEVBQUEsTUFBTUUsU0FBUyxHQUFHSixTQUFTLENBQUN5RCxTQUFTLEVBQUV2RCxPQUFPLENBQUMsQ0FBQTtFQUUvQyxvQkFDRXdELHFCQUFBLENBQUNwQyxPQUFPLEVBQUE7QUFBQ2UsSUFBQUEsR0FBRyxFQUFFakMsU0FBVTtJQUFBb0QsUUFBQSxlQUN0QkUscUJBQUEsQ0FBQ0MsbUJBQVUsRUFBQTtNQUFBSCxRQUFBLGVBQ1RFLHFCQUFBLENBQUNFLGFBQUksRUFBQTtBQUFDQyxRQUFBQSxTQUFTLEVBQUMsR0FBRztBQUFDQyxRQUFBQSxPQUFPLEVBQUMsS0FBSztBQUFDQyxRQUFBQSxPQUFPLEVBQUMsTUFBTTtBQUFDQyxRQUFBQSxhQUFhLEVBQUMsUUFBUTtBQUFBUixRQUFBQSxRQUFBLEVBQ3BFQSxRQUFBQTtPQUNHLENBQUE7S0FDSSxDQUFBO0FBQUMsR0FDTixDQUFDLENBQUE7QUFFZCxDQUFDOztBQ1JELE1BQU1TLGVBQWdDLEdBQUc7RUFDdkNDLFVBQVUsRUFBR0MsSUFBb0IsSUFDL0JDLG9CQUFXLENBQUNDLE1BQU0sQ0FBQyw4QkFBOEIsRUFBRSxDQUFDRixJQUFJLENBQUMsQ0FBQTtBQUM3RCxDQUFDLENBQUE7QUFNTSxTQUFTRyxpQkFBaUJBLENBQUM7QUFBRUMsRUFBQUEsU0FBQUE7QUFBbUMsQ0FBQyxHQUFHLEVBQUUsRUFBRTtFQUM3RSxNQUFNO0FBQUVDLElBQUFBLENBQUFBO0dBQUcsR0FBR0MsMkJBQWMsRUFBRSxDQUFBO0VBQzlCLE1BQU0sQ0FBQ3hFLE9BQU8sRUFBRXlFLFVBQVUsQ0FBQyxHQUFHQyxxQkFBUSxDQUFDLEtBQUssQ0FBQyxDQUFBO0VBQzdDLE1BQU0sQ0FBQ0MsT0FBTyxFQUFFQyxVQUFVLENBQUMsR0FBR0YscUJBQVEsQ0FBMEIsRUFBRSxDQUFDLENBQUE7RUFDbkUsTUFBTSxDQUFDRyxVQUFVLEVBQUVDLGFBQWEsQ0FBQyxHQUFHSixxQkFBUSxDQUFzQixRQUFRLENBQUMsQ0FBQTtFQUMzRSxNQUFNLENBQUNLLGdCQUFnQixFQUFFQyxtQkFBbUIsQ0FBQyxHQUFHTixxQkFBUSxDQUFnQixJQUFJLENBQUMsQ0FBQTtFQUM3RSxNQUFNLENBQ0pPLGtDQUFrQyxFQUNsQ0MscUNBQXFDLENBQ3RDLEdBQUdSLHFCQUFRLENBQUMsS0FBSyxDQUFDLENBQUE7QUFFbkIsRUFBQSxNQUFNUyxZQUFZLEdBQUdDLHdCQUFXLENBQUMsWUFBMkI7SUFDMUQsSUFBSTtBQUNGLE1BQUEsTUFBTVQsT0FBTyxHQUFHLE1BQU1YLGVBQWUsQ0FBQ0MsVUFBVSxDQUFDO0FBQy9Db0IsUUFBQUEsS0FBSyxFQUFFLENBQUMsUUFBUSxFQUFFLFFBQVEsQ0FBQTtBQUM1QixPQUFDLENBQUMsQ0FBQTs7QUFFRjtBQUNBLE1BQUEsTUFBTUMsZUFBZSxHQUFHWCxPQUFPLENBQzVCWSxNQUFNLENBQUVDLE1BQU0sSUFBSztBQUNsQjtBQUNBLFFBQUEsSUFBSSxDQUFDQSxNQUFNLENBQUNDLElBQUksSUFBSUQsTUFBTSxDQUFDQyxJQUFJLENBQUNDLElBQUksRUFBRSxLQUFLLEVBQUUsRUFBRTtBQUM3QyxVQUFBLE9BQU8sS0FBSyxDQUFBO0FBQ2QsU0FBQTtBQUVBLFFBQUEsT0FBTyxJQUFJLENBQUE7QUFDYixPQUFDLENBQUMsQ0FDREMsSUFBSSxDQUFDLENBQUNsRCxDQUFDLEVBQUVFLENBQUMsS0FBS0YsQ0FBQyxDQUFDZ0QsSUFBSSxDQUFDRyxhQUFhLENBQUNqRCxDQUFDLENBQUM4QyxJQUFJLENBQUMsQ0FBQyxDQUFBO01BRS9DYixVQUFVLENBQUNVLGVBQWUsQ0FBQyxDQUFBOztBQUUzQjtBQUNBLE1BQUEsSUFDRVAsZ0JBQWdCLElBQ2hCLENBQUNPLGVBQWUsQ0FBQ08sSUFBSSxDQUFFQyxDQUFDLElBQUtBLENBQUMsQ0FBQ0MsRUFBRSxLQUFLaEIsZ0JBQWdCLENBQUMsRUFDdkQ7QUFDQWlCLFFBQUFBLE9BQU8sQ0FBQ0MsR0FBRyxDQUNULG9FQUNGLENBQUMsQ0FBQTtRQUNEakIsbUJBQW1CLENBQUMsSUFBSSxDQUFDLENBQUE7QUFDM0IsT0FBQTtLQUNELENBQUMsT0FBT2tCLEtBQUssRUFBRTtBQUNkRixNQUFBQSxPQUFPLENBQUNFLEtBQUssQ0FBQyx3Q0FBd0MsRUFBRUEsS0FBSyxDQUFDLENBQUE7TUFDOUR0QixVQUFVLENBQUMsRUFBRSxDQUFDLENBQUE7QUFDaEIsS0FBQTtBQUNGLEdBQUMsRUFBRSxDQUFDRyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUE7QUFFdEJ6RSxFQUFBQSxzQkFBUyxDQUFDLE1BQU07QUFDZCxJQUFBLE1BQU02Riw4QkFBOEIsR0FBRyxZQUFZO01BQ2pELE1BQU1DLE1BQU0sR0FBRyxNQUFNakMsb0JBQVcsQ0FBQ0MsTUFBTSxDQUNyQywwREFDRixDQUFDLENBQUE7TUFDRGMscUNBQXFDLENBQUNrQixNQUFNLENBQUMsQ0FBQTtLQUM5QyxDQUFBO0lBRURELDhCQUE4QixFQUFFLENBQUNFLEtBQUssQ0FBQ0wsT0FBTyxDQUFDRSxLQUFLLENBQUMsQ0FBQTtBQUN2RCxHQUFDLEVBQUUsQ0FBQ2xHLE9BQU8sQ0FBQyxDQUFDLENBQUE7QUFFYk0sRUFBQUEsc0JBQVMsQ0FBQyxNQUFNO0FBQ2Q2RSxJQUFBQSxZQUFZLEVBQUUsQ0FBQTtBQUNoQixHQUFDLEVBQUUsQ0FBQ0EsWUFBWSxDQUFDLENBQUMsQ0FBQTtBQUVsQjdFLEVBQUFBLHNCQUFTLENBQUMsTUFBTTtBQUNkLElBQUEsSUFBSWdFLFNBQVMsRUFBRTtNQUNiQSxTQUFTLENBQUNHLFVBQVUsQ0FBQyxDQUFBO0FBQ3ZCLEtBQUE7QUFDQTtHQUNELEVBQUUsRUFBRSxDQUFDLENBQUE7QUFFTm5FLEVBQUFBLHNCQUFTLENBQUMsTUFBTTtJQUNkLElBQUksQ0FBQ04sT0FBTyxFQUFFO0FBQ1osTUFBQSxPQUFPRSxTQUFTLENBQUE7QUFDbEIsS0FBQTtBQUVBLElBQUEsTUFBTW9HLEtBQUssR0FBR0MsV0FBVyxDQUFDLE1BQU07QUFDOUJwQixNQUFBQSxZQUFZLEVBQUUsQ0FBQTtLQUNmLEVBQUUsSUFBSSxDQUFDLENBQUE7QUFFUixJQUFBLE9BQU8sTUFBTTtNQUNYcUIsYUFBYSxDQUFDRixLQUFLLENBQUMsQ0FBQTtLQUNyQixDQUFBO0FBQ0gsR0FBQyxFQUFFLENBQUN0RyxPQUFPLEVBQUVtRixZQUFZLENBQUMsQ0FBQyxDQUFBO0FBRTNCLEVBQUEsTUFBTXNCLDhCQUE4QixHQUFJVixFQUFVLElBQUssTUFBTTtJQUMzRGYsbUJBQW1CLENBQUNlLEVBQUUsQ0FBQyxDQUFBO0dBQ3hCLENBQUE7RUFFRCxNQUFNVyxXQUFXLEdBQUdBLE1BQVk7QUFDOUIsSUFBQSxJQUFJM0IsZ0JBQWdCLEVBQUU7QUFDcEI7QUFDQSxNQUFBLE1BQU00QixjQUFjLEdBQUdoQyxPQUFPLENBQUNrQixJQUFJLENBQUVDLENBQUMsSUFBS0EsQ0FBQyxDQUFDQyxFQUFFLEtBQUtoQixnQkFBZ0IsQ0FBQyxDQUFBO01BRXJFLElBQUksQ0FBQzRCLGNBQWMsRUFBRTtBQUNuQlgsUUFBQUEsT0FBTyxDQUFDRSxLQUFLLENBQUMsc0NBQXNDLEVBQUVuQixnQkFBZ0IsQ0FBQyxDQUFBO0FBQ3ZFO0FBQ0FJLFFBQUFBLFlBQVksRUFBRSxDQUFBO1FBQ2RILG1CQUFtQixDQUFDLElBQUksQ0FBQyxDQUFBO0FBQ3pCLFFBQUEsT0FBQTtBQUNGLE9BQUE7O0FBRUE7QUFDQSxNQUFBLElBQUkyQixjQUFjLENBQUNDLFNBQVMsQ0FBQ0MsT0FBTyxFQUFFLEVBQUU7QUFDdENiLFFBQUFBLE9BQU8sQ0FBQ0UsS0FBSyxDQUNYLG9EQUFvRCxFQUNwRG5CLGdCQUNGLENBQUMsQ0FBQTtRQUNEQyxtQkFBbUIsQ0FBQyxJQUFJLENBQUMsQ0FBQTtBQUN6QixRQUFBLE9BQUE7QUFDRixPQUFBO0FBRUFnQixNQUFBQSxPQUFPLENBQUNDLEdBQUcsQ0FBQyx3QkFBd0IsRUFBRTtRQUNwQ0YsRUFBRSxFQUFFWSxjQUFjLENBQUNaLEVBQUU7UUFDckJOLElBQUksRUFBRWtCLGNBQWMsQ0FBQ2xCLElBQUFBO0FBQ3ZCLE9BQUMsQ0FBQyxDQUFBO01BRUZoQixVQUFVLENBQUMsS0FBSyxDQUFDLENBQUE7QUFDakJOLE1BQUFBLG9CQUFXLENBQUMyQyxJQUFJLENBQ2QsbURBQW1ELEVBQ25EL0IsZ0JBQ0YsQ0FBQyxDQUFBO0FBQ0gsS0FBQTtHQUNELENBQUE7RUFFRCxNQUFNZ0MsV0FBVyxHQUFHQSxNQUFZO0lBQzlCdEMsVUFBVSxDQUFDLEtBQUssQ0FBQyxDQUFBO0FBQ2pCTixJQUFBQSxvQkFBVyxDQUFDMkMsSUFBSSxDQUFDLG1EQUFtRCxFQUFFLElBQUksQ0FBQyxDQUFBO0dBQzVFLENBQUE7O0FBRUQ7QUFDQSxFQUFBLE1BQU14QixlQUFlLEdBQUdYLE9BQU8sQ0FBQ1ksTUFBTSxDQUFFQyxNQUFNLElBQUs7SUFDakQsSUFBSVgsVUFBVSxLQUFLLFFBQVEsRUFBRTtBQUMzQixNQUFBLE9BQU9XLE1BQU0sQ0FBQ08sRUFBRSxDQUFDaUIsUUFBUSxDQUFDLFFBQVEsQ0FBQyxDQUFBO0FBQ3JDLEtBQUE7QUFDQSxJQUFBLE9BQU94QixNQUFNLENBQUNPLEVBQUUsQ0FBQ2lCLFFBQVEsQ0FBQyxRQUFRLENBQUMsQ0FBQTtBQUNyQyxHQUFDLENBQUMsQ0FBQTtFQUVGLG9CQUNFQyxzQkFBQSxDQUFBQywwQkFBQSxFQUFBO0lBQUEzRCxRQUFBLEVBQUEsY0FDRUUscUJBQUEsQ0FBQzBELHdCQUFlLEVBQUE7QUFBQ0MsTUFBQUEsS0FBSyxFQUFDLE1BQU07QUFBQ0MsTUFBQUEsUUFBUSxFQUFDLE9BQUE7QUFBTyxLQUFFLENBQUMsZUFDakQ1RCxxQkFBQSxDQUFDSCxNQUFNLEVBQUE7QUFBQ0UsTUFBQUEsU0FBUyxFQUFFeEQsT0FBUTtBQUFDQyxNQUFBQSxPQUFPLEVBQUU4RyxXQUFZO01BQUF4RCxRQUFBLGVBQy9DMEQsc0JBQUEsQ0FBQ0ssWUFBRyxFQUFBO0FBQ0ZyRyxRQUFBQSxLQUFLLEVBQUMsT0FBTztBQUNic0csUUFBQUEsTUFBTSxFQUFDLE1BQU07QUFDYnpELFFBQUFBLE9BQU8sRUFBQyxNQUFNO0FBQ2RDLFFBQUFBLGFBQWEsRUFBQyxRQUFRO0FBQ3RCN0MsUUFBQUEsTUFBTSxFQUFDLE9BQU87QUFDZHNHLFFBQUFBLGVBQWUsRUFBQyxPQUFPO0FBQ3ZCQyxRQUFBQSxLQUFLLEVBQUMsU0FBUztRQUFBbEUsUUFBQSxFQUFBLGNBRWYwRCxzQkFBQSxDQUFDSyxZQUFHLEVBQUE7QUFBQ0ksVUFBQUEsY0FBYyxFQUFDLEtBQUs7VUFBQW5FLFFBQUEsRUFBQSxjQUN2QkUscUJBQUEsQ0FBQzZELFlBQUcsRUFBQTtBQUFDSyxZQUFBQSxTQUFTLEVBQUMsSUFBSTtBQUFDRCxZQUFBQSxjQUFjLEVBQUMsS0FBSztZQUFBbkUsUUFBQSxFQUNyQ2dCLENBQUMsQ0FBQyxxQkFBcUIsQ0FBQTtBQUFDLFdBQ3RCLENBQUMsZUFFTjBDLHNCQUFBLENBQUNXLGFBQUksRUFBQTtBQUFBckUsWUFBQUEsUUFBQSxFQUNIRSxjQUFBQSxxQkFBQSxDQUFDbUUsYUFBSSxDQUFDQyxJQUFJLEVBQUE7Y0FDUkMsUUFBUSxFQUFFakQsVUFBVSxLQUFLLFFBQVM7QUFDbENrRCxjQUFBQSxPQUFPLEVBQUVBLE1BQU1qRCxhQUFhLENBQUMsUUFBUSxDQUFFO2NBQUF2QixRQUFBLEVBRXRDZ0IsQ0FBQyxDQUFDLDRCQUE0QixDQUFBO0FBQUMsYUFDdkIsQ0FBQyxlQUNaZCxxQkFBQSxDQUFDbUUsYUFBSSxDQUFDQyxJQUFJLEVBQUE7Y0FDUkMsUUFBUSxFQUFFakQsVUFBVSxLQUFLLFFBQVM7QUFDbENrRCxjQUFBQSxPQUFPLEVBQUVBLE1BQU1qRCxhQUFhLENBQUMsUUFBUSxDQUFFO2NBQUF2QixRQUFBLEVBRXRDZ0IsQ0FBQyxDQUFDLGlDQUFpQyxDQUFBO0FBQUMsYUFDNUIsQ0FBQyxDQUFBO0FBQUEsV0FDUixDQUFDLENBQUE7QUFBQSxTQUNKLENBQUMsZUFDTmQscUJBQUEsQ0FBQzZELFlBQUcsRUFBQTtBQUNGeEQsVUFBQUEsT0FBTyxFQUFDLE1BQU07QUFDZEMsVUFBQUEsYUFBYSxFQUFDLFFBQVE7QUFDdEJpRSxVQUFBQSxRQUFRLEVBQUMsUUFBUTtBQUNqQkMsVUFBQUEsZ0JBQWdCLEVBQUMsS0FBSztBQUN0QlAsVUFBQUEsY0FBYyxFQUFDLEtBQUs7QUFDcEJRLFVBQUFBLFFBQVEsRUFBRSxDQUFFO0FBQUEzRSxVQUFBQSxRQUFBLEVBRVgsQ0FBQzBCLGtDQUFrQyxnQkFDbENnQyxzQkFBQSxDQUFDa0IsZ0JBQU8sRUFBQTtBQUNOQyxZQUFBQSxLQUFLLEVBQUU3RCxDQUFDLENBQUMsZ0NBQWdDLENBQUU7QUFDM0NyQixZQUFBQSxJQUFJLEVBQUMsUUFBUTtBQUNicUUsWUFBQUEsTUFBTSxFQUFDLEtBQUs7QUFBQWhFLFlBQUFBLFFBQUEsRUFFWGdCLENBQUFBLENBQUMsQ0FBQyxrQ0FBa0MsQ0FBQyxlQUN0Q2QscUJBQUEsQ0FBQSxJQUFBLEVBQUEsRUFBSyxDQUFDLEVBQ0xjLENBQUMsQ0FBQyxzQ0FBc0MsQ0FBQyxDQUFBO0FBQUEsV0FDbkMsQ0FBQyxnQkFFVmQscUJBQUEsQ0FBQ0MsbUJBQVUsRUFBQTtZQUFDMkUsUUFBUSxFQUFBLElBQUE7WUFBQTlFLFFBQUEsZUFDbEJFLHFCQUFBLENBQUM2RCxZQUFHLEVBQUE7QUFDRnpELGNBQUFBLE9BQU8sRUFBQyxJQUFJO0FBQ1p5RSxjQUFBQSxLQUFLLEVBQUU7QUFDTHhFLGdCQUFBQSxPQUFPLEVBQUUsTUFBTTtBQUNmeUUsZ0JBQUFBLG1CQUFtQixFQUFFLHlCQUF5QjtBQUM5Q0MsZ0JBQUFBLEdBQUcsRUFBRSxNQUFNO0FBQ1hDLGdCQUFBQSxjQUFjLEVBQUUsUUFBQTtlQUNoQjtjQUFBbEYsUUFBQSxFQUVEK0IsZUFBZSxDQUFDb0QsTUFBTSxLQUFLLENBQUMsZ0JBQzNCakYscUJBQUEsQ0FBQzZELFlBQUcsRUFBQTtBQUNGeEQsZ0JBQUFBLE9BQU8sRUFBQyxNQUFNO0FBQ2Q2RSxnQkFBQUEsVUFBVSxFQUFDLFFBQVE7QUFDbkJGLGdCQUFBQSxjQUFjLEVBQUMsUUFBUTtBQUN2QnhILGdCQUFBQSxLQUFLLEVBQUMsTUFBTTtBQUNaaUIsZ0JBQUFBLENBQUMsRUFBQyxLQUFLO0FBQ1BvRyxnQkFBQUEsS0FBSyxFQUFFO0FBQUVNLGtCQUFBQSxVQUFVLEVBQUUsUUFBQTtpQkFBVztnQkFBQXJGLFFBQUEsZUFFaENFLHFCQUFBLENBQUNvRixjQUFLLEVBQUE7QUFBQXRGLGtCQUFBQSxRQUFBLEVBQ0hzQixVQUFVLEtBQUssUUFBUSxHQUNwQk4sQ0FBQyxDQUFDLDhCQUE4QixDQUFDLEdBQ2pDQSxDQUFDLENBQUMsOEJBQThCLENBQUE7aUJBQy9CLENBQUE7QUFBQyxlQUNMLENBQUMsR0FFTmUsZUFBZSxDQUFDd0QsR0FBRyxDQUFDLENBQUM7Z0JBQUUvQyxFQUFFO2dCQUFFTixJQUFJO0FBQUVtQixnQkFBQUEsU0FBQUE7ZUFBVyxrQkFDMUNLLHNCQUFBLENBQUNLLFlBQUcsRUFBQTtBQUVGckcsZ0JBQUFBLEtBQUssRUFBQyxNQUFNO0FBQ1pDLGdCQUFBQSxNQUFNLEVBQUMsTUFBTTtBQUNiNEMsZ0JBQUFBLE9BQU8sRUFBQyxNQUFNO0FBQ2RDLGdCQUFBQSxhQUFhLEVBQUMsUUFBUTtBQUN0QmdFLGdCQUFBQSxPQUFPLEVBQUV0Qiw4QkFBOEIsQ0FBQ1YsRUFBRSxDQUFFO0FBQzVDZ0QsZ0JBQUFBLEVBQUUsRUFBRWhFLGdCQUFnQixLQUFLZ0IsRUFBRSxHQUFHLFVBQVUsR0FBRyxPQUFRO0FBQ25EaUQsZ0JBQUFBLE1BQU0sRUFDSmpFLGdCQUFnQixLQUFLZ0IsRUFBRSxHQUNuQiw2Q0FBNkMsR0FDN0MseUNBQ0w7QUFDRGtELGdCQUFBQSxZQUFZLEVBQUMsSUFBSTtBQUNqQkMsZ0JBQUFBLE1BQU0sRUFBQyxTQUFTO0FBQ2hCQyxnQkFBQUEsU0FBUyxFQUFDLHdCQUF3QjtBQUNsQ2IsZ0JBQUFBLEtBQUssRUFBRTtBQUNMYyxrQkFBQUEsUUFBUSxFQUFFLFVBQVU7QUFDcEJwQixrQkFBQUEsUUFBUSxFQUFFLFNBQUE7aUJBQ1Y7Z0JBQUF6RSxRQUFBLEVBQUEsY0FFRkUscUJBQUEsQ0FBQzZELFlBQUcsRUFBQTtBQUNGWSxrQkFBQUEsUUFBUSxFQUFFLENBQUU7QUFDWnBFLGtCQUFBQSxPQUFPLEVBQUMsTUFBTTtBQUNkNkUsa0JBQUFBLFVBQVUsRUFBQyxZQUFZO0FBQ3ZCRixrQkFBQUEsY0FBYyxFQUFDLFlBQVk7QUFDM0JULGtCQUFBQSxRQUFRLEVBQUMsUUFBUTtBQUNqQk0sa0JBQUFBLEtBQUssRUFBRTtBQUNMZSxvQkFBQUEsU0FBUyxFQUFFLE9BQU87QUFDbEI3QixvQkFBQUEsZUFBZSxFQUFFLG9CQUFBO21CQUNqQjtrQkFBQWpFLFFBQUEsZUFFRkUscUJBQUEsQ0FBQzZELFlBQUcsRUFBQTtBQUNGZ0Msb0JBQUFBLEVBQUUsRUFBQyxLQUFLO0FBQ1JDLG9CQUFBQSxHQUFHLEVBQUUzQyxTQUFTLENBQUM0QyxTQUFTLEVBQUc7QUFDM0JDLG9CQUFBQSxHQUFHLEVBQUVoRSxJQUFLO0FBQ1Y2QyxvQkFBQUEsS0FBSyxFQUFFO0FBQ0xySCxzQkFBQUEsS0FBSyxFQUFFLE1BQU07QUFDYkMsc0JBQUFBLE1BQU0sRUFBRSxNQUFNO0FBQ2R3SSxzQkFBQUEsU0FBUyxFQUFFLFNBQVM7QUFDcEJDLHNCQUFBQSxjQUFjLEVBQUUsS0FBSztBQUNyQjdGLHNCQUFBQSxPQUFPLEVBQUUsT0FBQTtBQUNYLHFCQUFBO21CQUNELENBQUE7QUFBQyxpQkFDQyxDQUFDLGVBQ05MLHFCQUFBLENBQUM2RCxZQUFHLEVBQUE7QUFDRnBGLGtCQUFBQSxDQUFDLEVBQUMsSUFBSTtBQUNOb0csa0JBQUFBLEtBQUssRUFBRTtBQUNMYyxvQkFBQUEsUUFBUSxFQUFFLFVBQVU7QUFDcEJRLG9CQUFBQSxNQUFNLEVBQUUsR0FBRztBQUNYN0ksb0JBQUFBLElBQUksRUFBRSxHQUFHO0FBQ1Q4SSxvQkFBQUEsS0FBSyxFQUFFLEdBQUc7QUFDVkMsb0JBQUFBLFVBQVUsRUFBRSxvQkFBb0I7QUFDaENDLG9CQUFBQSxjQUFjLEVBQUUsV0FBVztBQUMzQkMsb0JBQUFBLE1BQU0sRUFBRSxFQUFFO0FBQ1ZYLG9CQUFBQSxTQUFTLEVBQUUsTUFBQTttQkFDWDtrQkFBQTlGLFFBQUEsZUFFRkUscUJBQUEsQ0FBQ29GLGNBQUssRUFBQTtBQUNKVCxvQkFBQUEsS0FBSyxFQUFFM0MsSUFBSztBQUNaNkMsb0JBQUFBLEtBQUssRUFBRTtBQUNMMkIsc0JBQUFBLFFBQVEsRUFBRSxNQUFNO0FBQ2hCQyxzQkFBQUEsVUFBVSxFQUFFLEtBQUs7QUFDakJ6QyxzQkFBQUEsS0FBSyxFQUFFLE9BQU87QUFDZDBDLHNCQUFBQSxTQUFTLEVBQUUsUUFBUTtBQUNuQmxKLHNCQUFBQSxLQUFLLEVBQUUsTUFBTTtBQUNic0csc0JBQUFBLE1BQU0sRUFBRSxDQUFDO0FBQ1Q2QyxzQkFBQUEsU0FBUyxFQUFFLFlBQVk7QUFDdkJ0RyxzQkFBQUEsT0FBTyxFQUFFLGFBQWE7QUFDdEJ1RyxzQkFBQUEsZUFBZSxFQUFFLENBQUM7QUFDbEJDLHNCQUFBQSxlQUFlLEVBQUUsVUFBVTtBQUMzQnRDLHNCQUFBQSxRQUFRLEVBQUUsUUFBUTtBQUNsQnVDLHNCQUFBQSxZQUFZLEVBQUUsVUFBQTtxQkFDZDtBQUFBaEgsb0JBQUFBLFFBQUEsRUFFRGtDLElBQUFBO21CQUNJLENBQUE7QUFBQyxpQkFDTCxDQUFDLENBQUE7QUFBQSxlQUFBLEVBNUVETSxFQTZFRixDQUNOLENBQUE7YUFFQSxDQUFBO1dBQ0ssQ0FBQTtBQUNiLFNBQ0UsQ0FBQyxlQUNOa0Isc0JBQUEsQ0FBQ0ssWUFBRyxFQUFBO0FBQ0Z4RCxVQUFBQSxPQUFPLEVBQUMsTUFBTTtBQUNkMkUsVUFBQUEsY0FBYyxFQUFDLGVBQWU7QUFDOUJSLFVBQUFBLGdCQUFnQixFQUFDLE1BQU07VUFBQTFFLFFBQUEsRUFBQSxjQUV2QkUscUJBQUEsQ0FBQytHLGVBQU0sRUFBQTtBQUFDekMsWUFBQUEsT0FBTyxFQUFFaEIsV0FBWTtZQUFBeEQsUUFBQSxFQUFFZ0IsQ0FBQyxDQUFDLHNCQUFzQixDQUFBO0FBQUMsV0FBUyxDQUFDLGVBQ2xFZCxxQkFBQSxDQUFDK0csZUFBTSxFQUFBO1lBQUNDLE9BQU8sRUFBQSxJQUFBO0FBQUMxQyxZQUFBQSxPQUFPLEVBQUVyQixXQUFZO1lBQUNnRSxRQUFRLEVBQUUsQ0FBQzNGLGdCQUFpQjtZQUFBeEIsUUFBQSxFQUMvRGdCLENBQUMsQ0FBQyxxQkFBcUIsQ0FBQTtBQUFDLFdBQ25CLENBQUMsQ0FBQTtBQUFBLFNBQ04sQ0FBQyxDQUFBO09BQ0gsQ0FBQTtBQUFDLEtBQ0EsQ0FBQyxDQUFBO0FBQUEsR0FDVCxDQUFDLENBQUE7QUFFUDs7QUM1VUEsSUFBSW9HLFNBQXNCLEdBQUcsSUFBSSxDQUFBO0FBQ2pDLElBQUlDLGtCQUF1RCxHQUFHLElBQUksQ0FBQTtBQUNsRSxJQUFJQyxpQkFBaUIsR0FBRyxLQUFLLENBQUE7QUFFaEJDLE1BQUFBLEtBQUssR0FBR0EsTUFBWTtBQUMvQixFQUFBLE1BQU1DLFNBQVMsR0FBR0MsUUFBUSxDQUFDQyxjQUFjLENBQUMsb0JBQW9CLENBQUMsQ0FBQTtFQUMvRCxJQUFJLENBQUNGLFNBQVMsRUFBRTtBQUNkL0UsSUFBQUEsT0FBTyxDQUFDRSxLQUFLLENBQUMsd0NBQXdDLENBQUMsQ0FBQTtBQUN2RCxJQUFBLE9BQUE7QUFDRixHQUFBO0FBRUEsRUFBQSxJQUFJeUUsU0FBUyxFQUFFO0FBQ2IsSUFBQSxPQUFBO0FBQ0YsR0FBQTtFQUVBLElBQUk7QUFDRkEsSUFBQUEsU0FBUyxHQUFHOUssVUFBVSxDQUFDa0wsU0FBUyxDQUFDLENBQUE7QUFDakNKLElBQUFBLFNBQVMsQ0FBQ08sTUFBTSxlQUNkekgscUJBQUEsQ0FBQzBILDRCQUFlLEVBQUE7QUFBQ0MsTUFBQUEsSUFBSSxFQUFFQyx3QkFBUTtNQUFBOUgsUUFBQSxlQUM3QkUscUJBQUEsQ0FBQ1ksaUJBQWlCLEVBQUE7UUFDaEJDLFNBQVMsRUFBR0csVUFBVSxJQUFLO0FBQ3pCbUcsVUFBQUEsa0JBQWtCLEdBQUduRyxVQUFVLENBQUE7QUFDL0IsVUFBQSxJQUFJb0csaUJBQWlCLEVBQUU7WUFDckJwRyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUE7QUFDaEJvRyxZQUFBQSxpQkFBaUIsR0FBRyxLQUFLLENBQUE7QUFDM0IsV0FBQTtBQUNGLFNBQUE7T0FDRCxDQUFBO0FBQUMsS0FDYSxDQUNuQixDQUFDLENBQUE7SUFFRCxJQUFJLFlBQW9CLEtBQUssYUFBYSxFQUFFLENBRTVDO0dBQ0QsQ0FBQyxPQUFPM0UsS0FBSyxFQUFFO0FBQ2RGLElBQUFBLE9BQU8sQ0FBQ0UsS0FBSyxDQUFDLHNDQUFzQyxFQUFFQSxLQUFLLENBQUMsQ0FBQTtBQUM1RHlFLElBQUFBLFNBQVMsR0FBRyxJQUFJLENBQUE7QUFDaEJDLElBQUFBLGtCQUFrQixHQUFHLElBQUksQ0FBQTtBQUN6QkMsSUFBQUEsaUJBQWlCLEdBQUcsS0FBSyxDQUFBO0FBQzNCLEdBQUE7QUFDRixFQUFDO0FBRVlTLE1BQUFBLElBQUksR0FBR0EsTUFBWTtFQUM5QixJQUFJLENBQUNYLFNBQVMsRUFBRTtBQUNkO0FBQ0FFLElBQUFBLGlCQUFpQixHQUFHLElBQUksQ0FBQTtBQUN4QkMsSUFBQUEsS0FBSyxFQUFFLENBQUE7QUFDUCxJQUFBLE9BQUE7QUFDRixHQUFBO0FBRUEsRUFBQSxJQUFJRixrQkFBa0IsRUFBRTtJQUN0QkEsa0JBQWtCLENBQUMsSUFBSSxDQUFDLENBQUE7QUFDMUIsR0FBQyxNQUFNO0FBQ0xDLElBQUFBLGlCQUFpQixHQUFHLElBQUksQ0FBQTtBQUN4QlUsSUFBQUEsVUFBVSxDQUFDLE1BQU07QUFDZixNQUFBLElBQUlYLGtCQUFrQixFQUFFO1FBQ3RCQSxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsQ0FBQTtBQUMxQixPQUFBO0FBQ0FDLE1BQUFBLGlCQUFpQixHQUFHLEtBQUssQ0FBQTtLQUMxQixFQUFFLENBQUMsQ0FBQyxDQUFBO0FBQ1AsR0FBQTtBQUNGOzs7OzsiLCJ4X2dvb2dsZV9pZ25vcmVMaXN0IjpbMCwzLDRdfQ==
