'use strict';

var contextMenu = {
	cut: "Recor&tar",
	copy: "&Copiar",
	paste: "Co&lar",
	selectAll: "&Selecionar tudo",
	undo: "&Desfazer",
	redo: "&Refazer",
	spelling: "Verificação ortográfica",
	spellingLanguages: "Idiomas",
	moreSpellingSuggestions: "Mais sugestões de grafia",
	noSpellingSuggestions: "Sem sugestões",
	copyLinkAddress: "Copiar endereço do link",
	copyLinkText: "Copiar texto do link",
	openLink: "Abrir link",
	saveImageAs: "Salvar imagem como...",
	copyImage: "Copiar imagem"
};
var dialog = {
	about: {
		title: "Sobre {{- appName}}",
		version: "Versão: <1>{{-version}}</1>",
		checkUpdates: "Verificar Atualizações",
		checkUpdatesOnStart: "Verificar Atualizações ao Abrir",
		noUpdatesAvailable: "Não há atualizações disponíveis.",
		copyright: "{{copyright}} Todos os direitos reservados.",
		errorWhenLookingForUpdates: "Ocorreu um erro ao procurar por atualizações",
		updateChannel: {
			label: "Canal de atualização",
			latest: "Estável",
			beta: "Beta",
			alpha: "Alpha (Experimental)"
		}
	},
	addServer: {
		title: "Adicionar Servidor",
		message: "Você quer adicionar \"{{- host}}\" a sua lista de servidores?",
		add: "Adicionar",
		cancel: "Cancelar"
	},
	addServerError: {
		title: "Host inválido",
		message: "O host \"{{- host}}\" não pôde ser validado, portanto não foi adicionado."
	},
	certificateError: {
		title: "Erro de Certificado",
		message: "Você confia no certificado de \"{{- issuerName}}\"? Clique em 'Sim' apenas se você realmente confiar neste certificado. Se estiver em dúvida, entre em contato com sua equipe de TI ou segurança antes de clicar em 'Sim'.",
		yes: "Sim",
		no: "Não"
	},
	clearCache: {
		announcement: "Forçar recarregamento",
		title: "Deseja manter a sessão de login?",
		message: "Ao excluir sua sessão de login, você será desconectado e precisará informar suas credenciais novamente.",
		keepLoginData: "Manter sessão de login",
		deleteLoginData: "Excluir sessão de login",
		clearingWait: "Aguarde, por favor",
		cancel: "Cancelar"
	},
	downloadRemoval: {
		title: "Você tem certeza?",
		message: "Remover este download?",
		yes: "Sim",
		no: "Não"
	},
	resetAppData: {
		title: "Limpar dados do aplicativo",
		message: "Isto vai deslogá-lo de todos os times e resetar o aplicativo para suas configurações originais. Isto não pode ser desfeito.",
		yes: "Sim",
		cancel: "Cancelar"
	},
	clearPermittedScreenCaptureServers: {
		title: "Limpar permissões de servidores com captura de tela",
		message: "Isto vai limpar todas as permissões de servidores com captura de tela. Isto não pode ser desfeito.",
		yes: "Sim",
		cancel: "Cancelar"
	},
	screenshare: {
		title: "Compartilhe sua tela",
		announcement: "Selecione uma tela para compartilhar"
	},
	update: {
		title: "Atualização Disponível",
		announcement: "Nova versão está disponível",
		message: "Uma nova versão do aplicativo desktop Rocket.Chat está disponível!",
		currentVersion: "Versão Atual:",
		newVersion: "Nova Versão:",
		install: "Instalar Atualização",
		remindLater: "Lembrar Depois",
		skip: "Pular Versão"
	},
	updateDownloading: {
		title: "Baixando atualização",
		message: "Você será notificado quando a atualização estiver pronta para instalação",
		ok: "OK"
	},
	updateInstallLater: {
		title: "Instalando Depois",
		message: "Atualização será instalada quando você sair do aplicativo",
		ok: "OK"
	},
	updateReady: {
		title: "Atualização Pronta para Instalar",
		message: "Atualização foi baixada",
		installNow: "Instalar Agora",
		installLater: "Instalar Depois"
	},
	updateSkip: {
		title: "Pular Atualização",
		message: "Nós iremos lembrá-lo quando a próxima atualização estiver disponível.\nSe você mudar de ideia, pode verificar as atualizações no menu Sobre.",
		ok: "OK"
	},
	selectClientCertificate: {
		announcement: "Selecione o Certificado",
		select: "Selecionar",
		validDates: "Válido de {{-validStart,}} a {{-validExpiry,}}"
	},
	openingExternalProtocol: {
		title: "Link com protocolo externo",
		message: "O link {{- protocol }} requer uma aplicação externa.",
		detail: "O link solicitado é {{- url }} . Você quer continuar?",
		dontAskAgain: "Abrir sempre estes tipos de links no aplicativo associado",
		yes: "Sim",
		no: "Não"
	},
	allowVideoCallCaptureScreen: {
		title: "Permitir Captura de Tela pela Video Chamada",
		message: "A Video chamada está solicitando permissão para capturar sua tela.",
		detail: "A video chamada do servidor {{- url }} requer permissão para compartilhar sua tela com outros.",
		dontAskAgain: "Sempre permitir a captura de tela por video chamadas neste servidor",
		yes: "Permitir",
		no: "Cancelar"
	},
	mediaPermission: {
		title: "Permissão de Mídia Necessária",
		message: "O acesso ao {{- permissionType}} está atualmente desabilitado nas configurações do seu sistema.",
		detail: "Para ativar os recursos de videochamada, permita o acesso nas configurações de privacidade do seu sistema e reinicie a aplicação.",
		openSettings: "Abrir Configurações",
		cancel: "Cancelar",
		microphone: "Microfone",
		camera: "Câmera",
		both: "Microfone e Câmera"
	},
	microphonePermissionDenied: {
		title: "Acesso ao microfone necessário",
		message: "O acesso ao microfone é necessário para {{- actionType }}. Verifique as configurações do sistema.",
		detail: "Você pode ativar o acesso ao microfone nas configurações de privacidade do sistema.",
		openSettings: "Abrir configurações",
		cancel: "Cancelar",
		actionTypes: {
			initiateCall: "fazer chamadas",
			answerCall: "atender chamadas",
			recordMessage: "gravar mensagens"
		}
	},
	supportedVersion: {
		title: "Versão de workspace não suportada"
	}
};
var downloads = {
	title: "Downloads",
	notifications: {
		downloadFinished: "Download finalizado"
	},
	filters: {
		search: "Buscar",
		server: "Servidor",
		mimeType: "Tipo",
		status: "Status",
		clear: "Limpar filtros",
		all: "Todos",
		mimes: {
			images: "Imagens",
			videos: "Vídeos",
			audios: "Áudio",
			texts: "Textos",
			files: "Arquivos"
		},
		statuses: {
			paused: "Pausado",
			cancelled: "Cancelado"
		}
	},
	item: {
		cancel: "Cancelar",
		copyLink: "Copiar link",
		errored: "Download cancelado",
		pause: "Pause",
		progressSize: "{{receivedBytes, byteSize}} de {{totalBytes, byteSize}} ({{ratio, percentage}})",
		remove: "Remover da lista",
		resume: "Continuar",
		retry: "Tentar novamente",
		showInFolder: "Mostrar na Pasta"
	},
	showingResults: "Mostrando resultados {{first}} - {{last}} de {{count}}"
};
var certificatesManager = {
	title: "Gerenciador de certificados",
	trustedCertificates: "Certificados confiáveis",
	notTrustedCertificates: "Certificados não confiáveis",
	item: {
		domain: "Domínio",
		actions: "Ações",
		remove: "Remover"
	}
};
var settings = {
	title: "Configurações",
	general: "Geral",
	certificates: "Certificados",
	options: {
		report: {
			title: "Relatar erros aos desenvolvedores",
			description: "Reporte os erros anonimamente aos desenvolvedores. As informações compartilhadas incluem número de versão do aplicativo, tipo de sistema operacional, URL do servidor, idioma do dispositivo e tipo de erro. Nenhum conteúdo ou nome de usuário é compartilhado.",
			masDescription: "Esta opção esta desativada quando for instalado através da Mac App Store, os erros serão reportados através do processo de relatórios de erros da Mac Apple Store."
		},
		flashFrame: {
			title: "Piscar janela",
			titleDarwin: "Ícone deve saltar na dock",
			description: "Pisca a janela para atrair a atenção do usuário.",
			onLinux: "Algumas distribuições Linux não possuem suporte a esta funcionalidade.",
			descriptionDarwin: "Faz o ícone da aplicação saltar na dock quando recebe notificação."
		},
		hardwareAcceleration: {
			title: "Aceleração de hardware",
			description: "Ativa aceleração de hardware quando disponível. O aplicativo será reiniciado ao ser alterado."
		},
		videoCallScreenCaptureFallback: {
			title: "Fallback de captura para videochamadas",
			description: "Desativa o Windows Graphics Capture para que o compartilhamento funcione em sessões RDP. O aplicativo reinicia ao mudar esta opção.",
			forcedDescription: "Atualmente aplicado porque o aplicativo detectou uma sessão RDP. O alternador define o comportamento das próximas execuções locais."
		},
		internalVideoChatWindow: {
			title: "Abrir chat em video em uma janela da aplicação",
			description: "Se ativado, o Chat de Vídeo será aberto na janela do aplicativo em vez do navegador padrão. No entanto, para <strong>Google Meet</strong> e <strong>Jitsi</strong>, a gravação de tela não é suportada em aplicativos Electron, então eles sempre serão abertos no navegador independentemente desta configuração.",
			masDescription: "Esta opção esta desativada quando for instalado através da Mac App Store, por motivos de segurança o chat em video sera aberto usando o navegador por padrão."
		},
		minimizeOnClose: {
			title: "Minimizar ao fechar",
			description: "Quando fechado o aplicativo será minimizado para a barra de tarefas, senão será fechado. Ícone da bandeja precisa estar desativado para que isto funcione."
		},
		menubar: {
			title: "Barra de menus",
			description: "Mostra a barra de menus no topo da aplicação",
			disabledHint: "Não é possível desativar a barra de menus quando a barra lateral está desativada. As configurações se tornariam inacessíveis."
		},
		sidebar: {
			title: "Barra lateral",
			description: "Mostra a barra na lateral da janela com a lista de servidores, downloads e configurações.",
			disabledHint: "Não é possível desativar a barra lateral quando a barra de menus está desativada. As configurações se tornariam inacessíveis."
		},
		trayIcon: {
			title: "Ícone da bandeja",
			description: "Mostra um ícone na bandeja do sistema para acessar rapidamente a aplicação. Se o ícone da bandeja estiver ativado, a aplicação será minimizada para a barra de tarefas ao ser fechada. Por outro lado se o ícone da bandeja estiver desativado, a aplicação será finalizada ao ser fechada."
		},
		availableBrowsers: {
			title: "Navegador Padrão",
			description: "Escolha qual navegador abrirá os links externos deste aplicativo. Sistema Padrão usa as configurações do seu sistema operacional.",
			systemDefault: "Sistema Padrão",
			loading: "Carregando navegadores...",
			current: "Usando atualmente:"
		},
		clearPermittedScreenCaptureServers: {
			title: "Limpar Permissões de Captura de Tela",
			description: "Limpar as permissões de captura de tela que foram selecionadas para não perguntar novamente em chamadas de vídeo."
		},
		allowScreenCaptureOnVideoCalls: {
			title: "Permitir Captura de Tela em Chamadas de Vídeo",
			description: "Permitir captura de tela em chamadas de vídeo. Isso solicitará permissão em cada chamada de vídeo."
		},
		ntlmCredentials: {
			title: "Credenciais NTLM",
			description: "Permitir que as credenciais NTLM sejam usadas ao conectar-se a um servidor.",
			domains: "Domínios que usarão as credenciais. Separados por vírgula. Use * para corresponder a todos os domínios."
		},
		videoCallWindowPersistence: {
			title: "Lembrar posição da janela de videochamada",
			description: "Salvar e restaurar a posição e o tamanho das janelas de videochamada entre as sessões"
		},
		transparentWindow: {
			title: "Efeito de janela transparente",
			description: "Ativar efeito nativo de vibração/transparência para a janela. Requer reinicialização para aplicar."
		}
	}
};
var error = {
	authNeeded: "Autenticação necessária, tente <strong>{{- auth}}</strong>",
	connectTimeout: "Tempo esgotado ao conectar",
	differentCertificate: "Certificado é diferente do antigo.\n\n {{- detail}}",
	noValidServerFound: "Nenhum servidor válido encontrado neste endereço",
	offline: "Verifique sua conexão com a Internet!"
};
var landing = {
	invalidUrl: "Endereço inválido",
	validating: "Validando...",
	inputUrl: "Insira o endereço do seu servidor",
	connect: "Conectar"
};
var menus = {
	about: "Sobre {{- appName}}",
	addNewServer: "Adicionar &novo servidor",
	back: "&Voltar",
	clearTrustedCertificates: "Limpar certificados confiáveis",
	close: "Fechar",
	copy: "&Copiar",
	cut: "Recor&tar",
	developerMode: "Modo desenvolvedor",
	disableGpu: "Desabilitar GPU",
	documentation: "Documentação",
	downloads: "Downloads",
	settings: "Configurações",
	editMenu: "&Editar",
	fileMenu: "&Arquivo",
	forward: "&Avançar",
	helpMenu: "Aj&uda",
	hide: "Ocultar {{- appName}}",
	hideOthers: "Ocultar Outros",
	learnMore: "Saiba mais",
	minimize: "Minimizar",
	openDevTools: "Abrir &DevTools",
	openDevToolsOnAllWindows: "Abrir &DevTools em todas as janelas",
	paste: "Co&lar",
	quit: "&Sair do {{- appName}}",
	redo: "&Refazer",
	reload: "&Recarregar",
	reloadClearingCache: "Forçar recarregamento",
	reportIssue: "Reportar problema",
	resetAppData: "Limpar dados do aplicativo",
	resetZoom: "Redefinir zoom",
	selectAll: "&Selecionar tudo",
	services: "Serviços",
	showFullScreen: "Tela cheia",
	showMenuBar: "Barra de menus",
	showOnUnreadMessage: "Exibir quando há mensagens não lidas",
	showServerList: "Lista de servidores",
	showTrayIcon: "Ícone da bandeja",
	toggleDevTools: "Alternar &DevTools",
	undo: "&Desfazer",
	unhide: "Mostrar todos",
	viewMenu: "&Exibir",
	windowMenu: "&Janela",
	zoomIn: "Aumentar zoom",
	zoomOut: "Diminuir zoom"
};
var loadingError = {
	title: "Servidor Falhou em Carregar",
	announcement: "Houston, nós temos um problema",
	reload: "Recarregar"
};
var videoCall = {
	loading: {
		initial: "Carregando chamada de vídeo...",
		reloading: "Recarregando chamada de vídeo...",
		description: "Por favor aguarde enquanto nos conectamos à chamada de vídeo"
	},
	error: {
		title: "Falha ao carregar chamada de vídeo",
		announcement: "Houston, temos um problema",
		timeout: "Tempo limite excedido - a chamada de vídeo não pôde carregar em 15 segundos",
		crashed: "Webview travou",
		maxRetriesReached: "Falha ao carregar após múltiplas tentativas",
		reload: "Recarregar chamada de vídeo"
	}
};
var unsupportedServer = {
	title: "{{instanceDomain}} está executando uma versão não suportada do Rocket.Chat",
	announcement: "Um administrador precisa atualizar o workspace para uma versão suportada para reativar o acesso aos aplicativos móveis e desktop.",
	moreInformation: "Saiba mais"
};
var selfxss = {
	title: "Pare!",
	description: "Esta é uma funcionalidade do navegador destinada aos desenvolvedores. Se alguém lhe disse para copiar-colar algo aqui para activar uma funcionalidade Rocket.Chat ou \"hackear\" a conta de alguém, é um golpe e dará acesso à sua conta Rocket.Chat.",
	moreInfo: "Veja https://go.rocket.chat/i/xss para mais informações."
};
var sidebar = {
	addNewServer: "Adicionar novo servidor",
	downloads: "Downloads",
	settings: "Configurações",
	menuTitle: "Personalizar e controlar app",
	item: {
		reload: "Recarregar",
		remove: "Remover",
		openDevTools: "Abrir DevTools",
		clearCache: "Limpar cache",
		clearStorageData: "Limpar dados de armazenamento",
		copyCurrentUrl: "Copiar URL",
		reloadClearingCache: "Forçar recarregamento"
	},
	tooltips: {
		unreadMessage: "{{- count}} mensagem não lida",
		unreadMessages: "{{- count}} mensagens não lidas",
		userNotLoggedIn: "Não conectado",
		addWorkspace: "Adicionar workspace ({{shortcut}}+N)",
		settingsMenu: "Personalizar e controlar app"
	}
};
var touchBar = {
	formatting: "Formatação",
	selectServer: "Selecionar servidor"
};
var tray = {
	menu: {
		show: "Mostrar",
		hide: "Esconder",
		quit: "Sair"
	},
	tooltip: {
		noUnreadMessage: "{{- appName}}: não há mensagens não lidas",
		unreadMention: "{{- appName}}: você tem uma menção/mensagem direta não lida",
		unreadMention_plural: "{{- appName}}: você tem {{- count}} menções/mensagens diretas não lidas",
		unreadMessage: "{{- appName}}: você tem mensagens não lidas"
	},
	balloon: {
		stillRunning: {
			title: "{{- appName}} ainda está rodando",
			content: "{{- appName }} está configurado para permanecer em funcionamento na bandeja do sistema/área de notificação."
		}
	}
};
var taskbar = {
	unreadMessage: "Mensagens não lidas",
	unreadMention: "Menções não lidas",
	noUnreadMessage: "Nenhuma mensagem"
};
var screenSharing = {
	permissionDenied: "Permissão de Gravação de Tela Negada",
	permissionRequired: "A permissão de gravação de tela é necessária para compartilhar sua tela.",
	permissionInstructions: "Por favor, ative-a nas preferências do sistema e tente novamente.",
	title: "Compartilhar sua tela",
	entireScreen: "Toda sua tela",
	applicationWindow: "Janela de aplicativo",
	noScreensFound: "Nenhuma tela encontrada",
	noWindowsFound: "Nenhuma janela encontrada",
	cancel: "Cancelar",
	share: "Compartilhar"
};
var serverInfo = {
	title: "Informações do Servidor",
	urlLabel: "URL:",
	versionLabel: "Versão:",
	unknown: "Desconhecido",
	exchangeUrlLabel: "URL do Outlook Exchange:",
	supportedVersionsTitle: "Versões Suportadas",
	statusLabel: "Status:",
	status: {
		loading: "Carregando...",
		error: "Falha ao carregar",
		loaded: "Carregado",
		idle: "Inativo",
		from: "de {{source}}"
	},
	supported: {
		unknown: "Desconhecido",
		expiring: "Expirando",
		yes: "Sim",
		no: "Não"
	},
	expiration: {
		label: "Expiração:",
		expiresOn: "Expira em {{date}}"
	}
};
var ptBR_i18n = {
	contextMenu: contextMenu,
	dialog: dialog,
	downloads: downloads,
	certificatesManager: certificatesManager,
	settings: settings,
	error: error,
	landing: landing,
	menus: menus,
	loadingError: loadingError,
	videoCall: videoCall,
	unsupportedServer: unsupportedServer,
	selfxss: selfxss,
	sidebar: sidebar,
	touchBar: touchBar,
	tray: tray,
	taskbar: taskbar,
	screenSharing: screenSharing,
	serverInfo: serverInfo
};

exports.certificatesManager = certificatesManager;
exports.contextMenu = contextMenu;
exports.default = ptBR_i18n;
exports.dialog = dialog;
exports.downloads = downloads;
exports.error = error;
exports.landing = landing;
exports.loadingError = loadingError;
exports.menus = menus;
exports.screenSharing = screenSharing;
exports.selfxss = selfxss;
exports.serverInfo = serverInfo;
exports.settings = settings;
exports.sidebar = sidebar;
exports.taskbar = taskbar;
exports.touchBar = touchBar;
exports.tray = tray;
exports.unsupportedServer = unsupportedServer;
exports.videoCall = videoCall;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicHQtQlIuaTE4bi1nRExHUEt5Ni5qcyIsInNvdXJjZXMiOltdLCJzb3VyY2VzQ29udGVudCI6W10sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OzsifQ==
