'use strict';

var electron = require('electron');
var child_process = require('child_process');
var fs = require('fs');
var rimraf = require('rimraf');
var redux = require('redux');
var path = require('path');
var i18next = require('i18next');
var reselect = require('reselect');
var ElectronStore = require('electron-store');
var detectBrowsers = require('detect-browsers');
var semver$1 = require('semver');
var os = require('os');
var electronDl = require('electron-dl');
var Bugsnag = require('@bugsnag/js');
var axios = require('axios');
var xhr = require('@ewsjs/xhr');
var ewsJavascriptApi = require('ews-javascript-api');
var promises = require('node:fs/promises');
var node_path = require('node:path');
var jwt = require('jsonwebtoken');
require('moment');
var process$1 = require('process');
var electronUpdater = require('electron-updater');

function _interopDefault (e) { return e && e.__esModule ? e : { default: e }; }

function _interopNamespace(e) {
  if (e && e.__esModule) return e;
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n.default = e;
  return Object.freeze(n);
}

var fs__namespace = /*#__PURE__*/_interopNamespace(fs);
var path__default = /*#__PURE__*/_interopDefault(path);
var i18next__default = /*#__PURE__*/_interopDefault(i18next);
var ElectronStore__default = /*#__PURE__*/_interopDefault(ElectronStore);
var os__default = /*#__PURE__*/_interopDefault(os);
var electronDl__default = /*#__PURE__*/_interopDefault(electronDl);
var Bugsnag__default = /*#__PURE__*/_interopDefault(Bugsnag);
var axios__default = /*#__PURE__*/_interopDefault(axios);
var jwt__default = /*#__PURE__*/_interopDefault(jwt);
var process__default = /*#__PURE__*/_interopDefault(process$1);

var files = [
	"app/**/*",
	"package.json"
];
var extraResources = [
	"build/icon.ico",
	"servers.json"
];
var appId = "chat.rocket";
var protocols = {
	name: "Rocket.Chat",
	schemes: [
		"rocketchat"
	]
};
var afterPack = "./build/afterPack.js";
var mac = {
	category: "public.app-category.productivity",
	target: [
		"dmg",
		"pkg",
		"zip",
		"mas"
	],
	icon: "build/icon.icns",
	bundleVersion: "26010",
	helperBundleId: "chat.rocket.electron.helper",
	type: "distribution",
	artifactName: "rocketchat-${version}-${os}.${ext}",
	mergeASARs: false,
	extendInfo: {
		NSMicrophoneUsageDescription: "I need access to your microphone to record the audio you want to send.",
		NSCameraUsageDescription: "I need access to your camera to record the video you want to send.",
		NSScreenCaptureDescription: "I need access to your screen to share it through video calls when you want to."
	},
	hardenedRuntime: true,
	gatekeeperAssess: false,
	provisioningProfile: "Desktop.provisionprofile",
	entitlements: "build/entitlements.mac.plist",
	entitlementsInherit: "build/entitlements.mac.plist"
};
var dmg = {
	background: "build/background.png",
	contents: [
		{
			type: "dir",
			x: 100,
			y: 211
		},
		{
			type: "link",
			path: "/Applications",
			x: 500,
			y: 211
		}
	]
};
var pkg = {
	isRelocatable: false,
	overwriteAction: "upgrade"
};
var mas = {
	entitlements: "build/entitlements.mas.plist",
	entitlementsInherit: "build/entitlements.mas.inherit.plist",
	entitlementsLoginHelper: "build/entitlements.mas.inherit.plist",
	hardenedRuntime: false,
	asarUnpack: [
		"node_modules"
	],
	artifactName: "rocketchat-${version}-mas.${ext}"
};
var win = {
	target: [
		{
			target: "nsis",
			arch: [
				"x64",
				"ia32"
			]
		},
		{
			target: "msi",
			arch: [
				"x64",
				"ia32"
			]
		},
		{
			target: "zip",
			arch: [
				"x64",
				"ia32"
			]
		}
	],
	icon: "build/icon.ico",
	legalTrademarks: "",
	verifyUpdateCodeSignature: true,
	requestedExecutionLevel: "asInvoker",
	signAndEditExecutable: true,
	artifactName: "rocketchat-${version}-${os}-${arch}.${ext}",
	signtoolOptions: {
		sign: "./build/winSignKms.js",
		signingHashAlgorithms: [
			"sha256"
		],
		timeStampServer: "http://timestamp.digicert.com"
	}
};
var nsis = {
	oneClick: false,
	perMachine: false,
	allowElevation: true,
	allowToChangeInstallationDirectory: true,
	installerIcon: "build/installerIcon.ico",
	uninstallerIcon: "build/uninstallerIcon.ico",
	installerSidebar: "build/installerSidebar.bmp",
	uninstallerSidebar: "build/uninstallerSidebar.bmp",
	uninstallDisplayName: "${productName} ${version}",
	include: "build/installer.nsh",
	license: "LICENSE",
	deleteAppDataOnUninstall: false,
	displayLanguageSelector: false,
	unicode: true,
	warningsAsErrors: true,
	runAfterFinish: true,
	createDesktopShortcut: "always",
	createStartMenuShortcut: true,
	menuCategory: false
};
var msi = {
	warningsAsErrors: false,
	additionalWixArgs: [
		"-sval"
	]
};
var appx = {
	backgroundColor: "#2f343d",
	languages: [
		"en-US",
		"en-GB",
		"pt-BR"
	],
	identityName: "0B67C87C.RocketChat",
	publisher: "CN=BBFF7141-7CAF-4FCD-8930-083FCDE6E854",
	publisherDisplayName: "Rocket.Chat Technologies Corp.",
	applicationId: "RocketChat",
	displayName: "Rocket.Chat"
};
var linux = {
	target: [
		"AppImage",
		"tar.gz",
		"deb",
		"rpm",
		"snap",
		"flatpak"
	],
	executableName: "rocketchat-desktop",
	category: "GNOME;GTK;Network;InstantMessaging",
	desktop: {
		entry: {
			Name: "Rocket.Chat",
			Comment: "Official Rocket.Chat Desktop Client",
			GenericName: "Rocket.Chat",
			Categories: "GNOME;GTK;Network;InstantMessaging"
		}
	},
	artifactName: "rocketchat-${version}-${os}-${arch}.${ext}"
};
var deb = {
	fpm: [
		"--after-install=build/linux/postinst.sh"
	],
	recommends: [
		"xdg-desktop-portal",
		"xdg-desktop-portal-gtk"
	]
};
var rpm = {
	fpm: [
		"--rpm-rpmbuild-define=_build_id_links none",
		"--rpm-tag=Recommends: xdg-desktop-portal",
		"--rpm-tag=Recommends: xdg-desktop-portal-gtk"
	]
};
var snap = {
	base: "core22",
	allowNativeWayland: false,
	plugs: [
		"desktop",
		"desktop-legacy",
		"home",
		"x11",
		"wayland",
		"unity7",
		"browser-support",
		"network",
		"gsettings",
		"pulseaudio",
		"opengl",
		"camera",
		"audio-playback",
		"audio-record",
		"screen-inhibit-control",
		"upower-observe",
		"pipewire"
	]
};
var afterSign = "./build/notarize.js";
var generateUpdatesFilesForAllChannels = true;
var publish = [
	{
		provider: "github",
		owner: "RocketChat",
		repo: "Rocket.Chat.Electron",
		vPrefixedTagName: false
	}
];
var electronBuilderJson = {
	files: files,
	extraResources: extraResources,
	appId: appId,
	protocols: protocols,
	afterPack: afterPack,
	mac: mac,
	dmg: dmg,
	pkg: pkg,
	mas: mas,
	win: win,
	nsis: nsis,
	msi: msi,
	appx: appx,
	linux: linux,
	deb: deb,
	rpm: rpm,
	snap: snap,
	afterSign: afterSign,
	generateUpdatesFilesForAllChannels: generateUpdatesFilesForAllChannels,
	publish: publish
};

var workspaces = [
	"workspaces/*"
];
var productName = "Rocket.Chat";
var name = "rocketchat";
var description = "Official OSX, Windows, and Linux Desktop Clients for Rocket.Chat";
var version = "4.11.1";
var author = "Rocket.Chat Support <support@rocket.chat>";
var copyright = "© 2016-2026, Rocket.Chat";
var homepage = "https://rocket.chat";
var license = "MIT";
var goUrlShortener = "go.rocket.chat";
var keywords = [
	"rocketchat",
	"desktop",
	"electron"
];
var repository = {
	type: "git",
	url: "git+https://github.com/RocketChat/Rocket.Chat.Electron.git"
};
var bugs = {
	url: "https://github.com/RocketChat/Rocket.Chat.Electron/issues"
};
var main$1 = "app/main.js";
var scripts = {
	postinstall: "run-s install-app-deps clean patch-package",
	"patch-package": "patch-package",
	start: "run-s build:watch",
	clean: "rimraf app dist",
	build: "rollup -c",
	"build:watch": "rollup -c -w",
	"build-mac": "yarn build && yarn electron-builder --publish never --mac --universal",
	"build-mas": "yarn build && yarn electron-builder --publish never --mac mas --universal",
	"build-win": "yarn build && yarn electron-builder --publish never --win",
	"build-linux": "yarn build && yarn electron-builder --publish never --linux",
	"build-assets": "ts-node -O '{\"module\":\"commonjs\"}' src/buildAssets.ts",
	"build-assets-win": "ts-node -O \"{\\\"module\\\":\\\"commonjs\\\"}\" src/buildAssets.ts",
	release: "yarn electron-builder --publish onTagOrDraft --x64",
	"install-app-deps": "electron-builder install-app-deps",
	test: "xvfb-maybe jest --forceExit --detectOpenHandles --maxWorkers=1",
	changelog: "conventional-changelog -p angular -i CHANGELOG.md -s",
	lint: "run-s .:lint:eslint .:lint:tsc",
	".:lint:eslint": "eslint .",
	".:lint:tsc": "tsc --noEmit",
	"lint-fix": "run-s .:lint-fix:eslint .:lint:tsc",
	".:lint-fix:eslint": "eslint --fix .",
	"workspaces:build": "yarn workspaces foreach -At run build"
};
var dependencies = {
	"@bugsnag/js": "~7.22.3",
	"@emotion/css": "~11.11.2",
	"@emotion/react": "~11.11.3",
	"@emotion/styled": "~11.11.0",
	"@ewsjs/xhr": "~2.0.2",
	"@rocket.chat/css-in-js": "~0.31.25",
	"@rocket.chat/desktop-api": "~1.1.0",
	"@rocket.chat/fuselage": "0.58.0",
	"@rocket.chat/fuselage-hooks": "~0.33.1",
	"@rocket.chat/fuselage-polyfills": "~0.31.25",
	"@rocket.chat/icons": "0.37.0",
	axios: "~1.6.4",
	"detect-browsers": "~6.1.0",
	"electron-dl": "4.0.0",
	"electron-store": "~8.1.0",
	"electron-updater": "^5.3.0",
	"ews-javascript-api": "~0.13.2",
	i18next: "~23.7.16",
	jsonwebtoken: "~9.0.2",
	moment: "~2.30.1",
	react: "~18.3.1",
	"react-dom": "~18.3.1",
	"react-hook-form": "~7.49.2",
	"react-i18next": "~14.0.0",
	"react-keyed-flatten-children": "~3.0.0",
	"react-redux": "~9.0.4",
	"react-virtuoso": "~4.6.2",
	redux: "~5.0.1",
	reselect: "~5.0.1",
	rimraf: "~5.0.7",
	semver: "~7.5.4"
};
var devDependencies = {
	"@babel/core": "~7.23.9",
	"@babel/eslint-parser": "~7.23.3",
	"@babel/plugin-proposal-class-properties": "~7.18.6",
	"@babel/plugin-proposal-function-bind": "~7.23.3",
	"@babel/preset-env": "~7.23.7",
	"@babel/preset-react": "~7.23.3",
	"@babel/preset-typescript": "~7.23.3",
	"@electron/fuses": "~1.8.0",
	"@fiahfy/icns-convert": "~0.0.12",
	"@fiahfy/ico-convert": "~0.0.12",
	"@kayahr/jest-electron-runner": "29.14.0",
	"@rocket.chat/eslint-config": "~0.7.0",
	"@rocket.chat/prettier-config": "~0.31.25",
	"@rollup/plugin-babel": "~6.0.4",
	"@rollup/plugin-commonjs": "~25.0.7",
	"@rollup/plugin-json": "~6.1.0",
	"@rollup/plugin-node-resolve": "~15.2.3",
	"@rollup/plugin-replace": "~5.0.5",
	"@types/electron-devtools-installer": "~2.2.5",
	"@types/jest": "~29.5.11",
	"@types/jsonwebtoken": "~9.0.5",
	"@types/node": "~16.18.69",
	"@types/react": "~18.3.18",
	"@types/react-dom": "~18.3.5",
	"@typescript-eslint/eslint-plugin": "~6.17.0",
	"@typescript-eslint/parser": "~6.17.0",
	"builtin-modules": "~3.3.0",
	chokidar: "~3.5.3",
	"conventional-changelog-cli": "~4.1.0",
	"convert-svg-to-png": "~0.6.4",
	electron: "39.2.5",
	"electron-builder": "26.0.3",
	"electron-devtools-installer": "^3.2.0",
	"electron-notarize": "^1.2.2",
	eslint: "~8.56.0",
	"eslint-config-prettier": "~9.1.0",
	"eslint-import-resolver-typescript": "~3.6.1",
	"eslint-plugin-import": "~2.26.0",
	"eslint-plugin-prettier": "~5.1.2",
	"eslint-plugin-react": "~7.33.2",
	"eslint-plugin-react-hooks": "~4.6.0",
	jest: "~29.7.0",
	"jest-environment-jsdom": "~29.7.0",
	jimp: "~0.22.10",
	"npm-run-all": "~4.1.5",
	"patch-package": "~8.0.0",
	prettier: "~3.2.5",
	puppeteer: "23.1.1",
	rollup: "~4.9.6",
	"rollup-plugin-copy": "~3.5.0",
	"ts-jest": "~29.1.4",
	"ts-node": "~10.9.2",
	typescript: "~5.7.3",
	"xvfb-maybe": "~0.2.1"
};
var optionalDependencies = {
	fsevents: "2.3.3"
};
var engines = {
	node: ">=22.17.1"
};
var devEngines = {
	node: ">=22.17.1",
	yarn: ">=4.0.2"
};
var resolutions = {
	"@fiahfy/icns-convert/sharp": "0.29.3",
	"@fiahfy/ico-convert/sharp": "0.29.3"
};
var volta = {
	node: "22.17.1",
	yarn: "4.0.2"
};
var packageManager = "yarn@4.6.0";
var packageJson = {
	"private": true,
	workspaces: workspaces,
	productName: productName,
	name: name,
	description: description,
	version: version,
	author: author,
	copyright: copyright,
	homepage: homepage,
	license: license,
	goUrlShortener: goUrlShortener,
	keywords: keywords,
	repository: repository,
	bugs: bugs,
	main: main$1,
	scripts: scripts,
	dependencies: dependencies,
	devDependencies: devDependencies,
	optionalDependencies: optionalDependencies,
	engines: engines,
	devEngines: devEngines,
	resolutions: resolutions,
	volta: volta,
	packageManager: packageManager
};

const JITSI_SERVER_CAPTURE_SCREEN_PERMISSION_UPDATED = 'jitsi-server-capture-screen-permission-updated';
const JITSI_SERVER_CAPTURE_SCREEN_PERMISSIONS_CLEARED = 'jitsi-server-capture-screen-permissions-cleared';

function _defineProperty(e, r, t) {
  return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, {
    value: t,
    enumerable: !0,
    configurable: !0,
    writable: !0
  }) : e[r] = t, e;
}
function _toPrimitive(t, r) {
  if ("object" != typeof t || !t) return t;
  var e = t[Symbol.toPrimitive];
  if (void 0 !== e) {
    var i = e.call(t, r || "default");
    if ("object" != typeof i) return i;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return ("string" === r ? String : Number)(t);
}
function _toPropertyKey(t) {
  var i = _toPrimitive(t, "string");
  return "symbol" == typeof i ? i : i + "";
}

const isFSA = action => typeof action === 'object' && action !== null && !Array.isArray(action) && 'type' in action && typeof action.type === 'string';
const hasMeta = action => 'meta' in action && typeof action.meta === 'object' && action.meta !== null;
const isResponse = action => hasMeta(action) && action.meta.response === true;
const isLocallyScoped = action => hasMeta(action) && action.meta.scope === 'local';
const isSingleScoped = action => {
  var _ipcMeta, _ipcMeta2;
  return ((_ipcMeta = action.ipcMeta) === null || _ipcMeta === void 0 ? void 0 : _ipcMeta.webContentsId) && ((_ipcMeta2 = action.ipcMeta) === null || _ipcMeta2 === void 0 ? void 0 : _ipcMeta2.scope) === 'single';
};
const isErrored = action => 'meta' in action && action.error === true && action.payload instanceof Error;
const hasPayload = action => 'payload' in action;
const isResponseTo = (id, ...types) => action => isResponse(action) && types.includes(action.type) && action.meta.id === id;

const invoke = (webContents, channel, ...args) => new Promise((resolve, reject) => {
  const id = Math.random().toString(16).slice(2);
  electron.ipcMain.once(`${channel}@${id}`, (_, {
    resolved,
    rejected
  }) => {
    if (rejected) {
      const error = new Error(rejected.message);
      error.name = rejected.name;
      error.stack = rejected.stack;
      reject(error);
      return;
    }
    resolve(resolved);
  });
  webContents.send(channel, id, ...args);
});
const handle = (channel, handler) => {
  electron.ipcMain.handle(channel, (event, ...args) => handler(event.sender, ...args));
  return () => {
    electron.ipcMain.removeHandler(channel);
  };
};

var ActionScope = /*#__PURE__*/function (ActionScope) {
  ActionScope["LOCAL"] = "local";
  ActionScope["SINGLE"] = "single";
  return ActionScope;
}(ActionScope || {});
const forwardToRenderers = api => {
  const renderers = new Set();
  handle('redux/get-initial-state', async webContents => {
    renderers.add(webContents);
    webContents.addListener('destroyed', () => {
      renderers.delete(webContents);
    });
    return api.getState();
  });
  handle('redux/action-dispatched', async (webContents, action) => {
    var _webContents$hostWebC, _webContents$hostWebC2;
    api.dispatch({
      ...action,
      ipcMeta: {
        webContentsId: webContents.id,
        ...(((_webContents$hostWebC = webContents.hostWebContents) === null || _webContents$hostWebC === void 0 ? void 0 : _webContents$hostWebC.id) && {
          viewInstanceId: (_webContents$hostWebC2 = webContents.hostWebContents) === null || _webContents$hostWebC2 === void 0 ? void 0 : _webContents$hostWebC2.id
        }),
        ...action.ipcMeta
      }
    });
  });
  return next => action => {
    if (!isFSA(action) || isLocallyScoped(action)) {
      return next(action);
    }
    const rendererAction = {
      ...action,
      meta: {
        ...(hasMeta(action) && action.meta),
        scope: ActionScope.LOCAL
      }
    };
    if (isSingleScoped(action)) {
      const {
        webContentsId,
        viewInstanceId
      } = action.ipcMeta;
      [...renderers].filter(w => w.id === webContentsId || viewInstanceId && w.id === viewInstanceId).forEach(w => invoke(w, 'redux/action-dispatched', rendererAction));
      return next(action);
    }
    renderers.forEach(webContents => {
      invoke(webContents, 'redux/action-dispatched', rendererAction);
    });
    return next(action);
  };
};

const APP_PATH_SET = 'app/path-set';
const APP_VERSION_SET = 'app/version-set';
const APP_SETTINGS_LOADED = 'app/settings-loaded';
const APP_ALLOWED_NTLM_CREDENTIALS_DOMAINS_SET = 'app/allowed-ntlm-credentials-domains-set';
const APP_MAIN_WINDOW_TITLE_SET = 'app/main-window-title-set';
const APP_MACHINE_THEME_SET = 'app/machine-theme-set';
const APP_SCREEN_CAPTURE_FALLBACK_FORCED_SET = 'app/screen-capture-fallback-forced-set';

const allowedNTLMCredentialsDomains = (state = null, action) => {
  switch (action.type) {
    case APP_SETTINGS_LOADED:
      {
        const {
          allowedNTLMCredentialsDomains = state
        } = action.payload;
        return allowedNTLMCredentialsDomains;
      }
    case APP_ALLOWED_NTLM_CREDENTIALS_DOMAINS_SET:
      {
        if (action.payload === null) return null;
        return action.payload;
      }
    default:
      return state;
  }
};

const appPath = (state = null, action) => {
  switch (action.type) {
    case APP_PATH_SET:
      return action.payload;
    default:
      return state;
  }
};

const appVersion = (state = null, action) => {
  switch (action.type) {
    case APP_VERSION_SET:
      return action.payload;
    default:
      return state;
  }
};

const machineTheme = (state = 'light', action) => {
  switch (action.type) {
    case APP_MACHINE_THEME_SET:
      {
        return action.payload;
      }
    default:
      return state;
  }
};

const mainWindowTitle = (state = null, action) => {
  switch (action.type) {
    case APP_MAIN_WINDOW_TITLE_SET:
      return action.payload;
    default:
      return state;
  }
};

const screenCaptureFallbackForced = (state = false, action) => {
  switch (action.type) {
    case APP_SCREEN_CAPTURE_FALLBACK_FORCED_SET:
      return action.payload;
    default:
      return state;
  }
};

const DOWNLOAD_CREATED = 'downloads/created';
const DOWNLOAD_REMOVED = 'downloads/removed';
const DOWNLOADS_CLEARED = 'downloads/cleared';
const DOWNLOAD_UPDATED = 'downloads/updated';

const DownloadStatus = {
  ALL: 'All',
  PAUSED: 'Paused',
  CANCELLED: 'Cancelled'
};

const downloads = (state = {}, action) => {
  switch (action.type) {
    case APP_SETTINGS_LOADED:
      {
        var _action$payload$downl;
        const initDownloads = (_action$payload$downl = action.payload.downloads) !== null && _action$payload$downl !== void 0 ? _action$payload$downl : {};
        Object.values(initDownloads).forEach(value => {
          if (value.state === 'progressing' || value.state === 'paused') {
            value.state = 'cancelled';
            value.status = DownloadStatus.CANCELLED;
          }
        });
        return initDownloads !== null && initDownloads !== void 0 ? initDownloads : {};
      }
    case DOWNLOAD_CREATED:
      {
        const download = action.payload;
        return {
          ...state,
          [download.itemId]: download
        };
      }
    case DOWNLOAD_UPDATED:
      {
        const existingDownload = state[action.payload.itemId];
        if (!existingDownload) {
          return state; // Don't update if download doesn't exist
        }
        const newState = {
          ...state
        };
        newState[action.payload.itemId] = {
          ...existingDownload,
          ...action.payload
        };
        return newState;
      }
    case DOWNLOAD_REMOVED:
      {
        const newState = {
          ...state
        };
        delete newState[action.payload];
        return newState;
      }
    case DOWNLOADS_CLEARED:
      return {};
    default:
      return state;
  }
};

const allowedJitsiServers = (state = {}, action) => {
  switch (action.type) {
    case APP_SETTINGS_LOADED:
      {
        const {
          allowedJitsiServers = {}
        } = action.payload;
        state = allowedJitsiServers;
        return state;
      }
    case JITSI_SERVER_CAPTURE_SCREEN_PERMISSION_UPDATED:
      {
        state = {
          ...state,
          [action.payload.jitsiServer]: action.payload.allowed
        };
        return state;
      }
    case JITSI_SERVER_CAPTURE_SCREEN_PERMISSIONS_CLEARED:
      {
        state = {};
        return state;
      }
    default:
      return state;
  }
};

const CERTIFICATES_CLEARED = 'certificates/cleared';
const CERTIFICATES_LOADED = 'certificates/loaded';
const CERTIFICATES_CLIENT_CERTIFICATE_REQUESTED = 'certificates/client-certificate-requested';
const TRUSTED_CERTIFICATES_UPDATED = 'trusted-certificates/updated';
const NOT_TRUSTED_CERTIFICATES_UPDATED = 'not-trusted-certificates/updated';
const SELECT_CLIENT_CERTIFICATE_DIALOG_CERTIFICATE_SELECTED = 'select-client-certificate-dialog/certificate-selected';
const SELECT_CLIENT_CERTIFICATE_DIALOG_DISMISSED = 'select-client-certificate-dialog/dismissed';
const EXTERNAL_PROTOCOL_PERMISSION_UPDATED = 'navigation/external-protocol-permission-updated';

const clientCertificates = (state = [], action) => {
  switch (action.type) {
    case CERTIFICATES_CLIENT_CERTIFICATE_REQUESTED:
      return action.payload;
    case SELECT_CLIENT_CERTIFICATE_DIALOG_CERTIFICATE_SELECTED:
    case SELECT_CLIENT_CERTIFICATE_DIALOG_DISMISSED:
      return [];
    default:
      return state;
  }
};
const trustedCertificates = (state = {}, action) => {
  switch (action.type) {
    case CERTIFICATES_LOADED:
    case TRUSTED_CERTIFICATES_UPDATED:
      return action.payload;
    case CERTIFICATES_CLEARED:
      return {};
    case APP_SETTINGS_LOADED:
      {
        const {
          trustedCertificates = state
        } = action.payload;
        return trustedCertificates;
      }
    default:
      return state;
  }
};
const notTrustedCertificates = (state = {}, action) => {
  switch (action.type) {
    case NOT_TRUSTED_CERTIFICATES_UPDATED:
      return action.payload;
    case CERTIFICATES_CLEARED:
      return {};
    case APP_SETTINGS_LOADED:
      {
        const {
          notTrustedCertificates = state
        } = action.payload;
        return notTrustedCertificates;
      }
    default:
      return state;
  }
};
const externalProtocols = (state = {}, action) => {
  switch (action.type) {
    case APP_SETTINGS_LOADED:
      {
        const {
          externalProtocols = {}
        } = action.payload;
        state = externalProtocols;
        return state;
      }
    case EXTERNAL_PROTOCOL_PERMISSION_UPDATED:
      {
        state = {
          ...state,
          [action.payload.protocol]: action.payload.allowed
        };
        return state;
      }
    default:
      return state;
  }
};

const DEEP_LINKS_SERVER_ADDED = 'deep-links/server-added';
const DEEP_LINKS_SERVER_FOCUSED = 'deep-links/server-focused';

const OUTLOOK_CALENDAR_SET_CREDENTIALS = 'outlook-calendar/set-credentials';
const OUTLOOK_CALENDAR_ASK_CREDENTIALS = 'outlook-calendar/ask-credentials';
const OUTLOOK_CALENDAR_DIALOG_DISMISSED = 'outlook-calendar/dialog-dismissed';
const OUTLOOK_CALENDAR_SAVE_CREDENTIALS = 'outlook-calendar/save-credentials';

const ABOUT_DIALOG_DISMISSED = 'about-dialog/dismissed';
const ABOUT_DIALOG_TOGGLE_UPDATE_ON_START = 'about-dialog/toggle-update-on-start';
const ABOUT_DIALOG_UPDATE_CHANNEL_CHANGED = 'about-dialog/update-channel-changed';
const ADD_SERVER_VIEW_SERVER_ADDED = 'add-server/view-server-added';
const CLEAR_CACHE_TRIGGERED = 'clear-cache/triggered';
const CLEAR_CACHE_DIALOG_DELETE_LOGIN_DATA_CLICKED = 'clear-cache-dialog/delete-login-data-clicked';
const CLEAR_CACHE_DIALOG_KEEP_LOGIN_DATA_CLICKED = 'clear-cache-dialog/keep-login-data-clicked';
const LOADING_ERROR_VIEW_RELOAD_SERVER_CLICKED = 'loading-error-view/reload-server-clicked';
const MENU_BAR_ABOUT_CLICKED = 'menu-bar/about-clicked';
const MENU_BAR_ADD_NEW_SERVER_CLICKED = 'menu-bar/add-new-server-clicked';
const MENU_BAR_SELECT_SERVER_CLICKED = 'menu-bar/select-server-clicked';
const MENU_BAR_TOGGLE_IS_MENU_BAR_ENABLED_CLICKED = 'menu-bar/toggle-is-menu-bar-enabled-clicked';
const MENU_BAR_TOGGLE_IS_SHOW_WINDOW_ON_UNREAD_CHANGED_ENABLED_CLICKED = 'menu-bar/toggle-is-show-window-on-unread-changed-enabled-clicked';
const MENU_BAR_TOGGLE_IS_SIDE_BAR_ENABLED_CLICKED = 'menu-bar/toggle-is-side-bar-enabled-clicked';
const MENU_BAR_TOGGLE_IS_TRAY_ICON_ENABLED_CLICKED = 'menu-bar/toggle-is-tray-icon-enabled-clicked';
const MENU_BAR_TOGGLE_IS_DEVELOPER_MODE_ENABLED_CLICKED = 'menu-bar/toggle-is-developer-mode-enabled-clicked';
const MENU_BAR_TOGGLE_IS_VIDEO_CALL_DEVTOOLS_AUTO_OPEN_ENABLED_CLICKED = 'menu-bar/toggle-is-video-call-devtools-auto-open-enabled-clicked';
const ROOT_WINDOW_ICON_CHANGED = 'root-window/icon-changed';
const ROOT_WINDOW_STATE_CHANGED = 'root-window/state-changed';
const VIDEO_CALL_WINDOW_STATE_CHANGED = 'video-call-window/state-changed';
const SIDE_BAR_ADD_NEW_SERVER_CLICKED = 'side-bar/add-new-server-clicked';
const SIDE_BAR_CONTEXT_MENU_TRIGGERED = 'side-bar/context-menu-triggered';
const SIDE_BAR_DOWNLOADS_BUTTON_CLICKED = 'side-bar/downloads-button-clicked';
const SIDE_BAR_SETTINGS_BUTTON_CLICKED = 'side-bar/settings-button-clicked';
const SIDE_BAR_REMOVE_SERVER_CLICKED = 'side-bar/remove-server-clicked';
const SIDE_BAR_SERVER_SELECTED = 'side-bar/server-selected';
const SIDE_BAR_SERVERS_SORTED = 'side-bar/servers-sorted';
const TOUCH_BAR_FORMAT_BUTTON_TOUCHED = 'touch-bar/format-button-touched';
const TOUCH_BAR_SELECT_SERVER_TOUCHED = 'touch-bar/select-server-touched';
const UPDATE_DIALOG_DISMISSED = 'update-dialog/dismissed';
const UPDATE_DIALOG_INSTALL_BUTTON_CLICKED = 'update-dialog/install-button-clicked';
const UPDATE_DIALOG_REMIND_UPDATE_LATER_CLICKED = 'update-dialog/remind-update-later-clicked';
const UPDATE_DIALOG_SKIP_UPDATE_CLICKED = 'update-dialog/skip-update-clicked';
const WEBVIEW_READY = 'webview/ready';
const WEBVIEW_ATTACHED = 'webview/attached';
const WEBVIEW_DID_FAIL_LOAD = 'webview/did-fail-load';
const WEBVIEW_DID_NAVIGATE = 'webview/did-navigate';
const WEBVIEW_DID_START_LOADING = 'webview/did-start-loading';
const WEBVIEW_FAVICON_CHANGED = 'webview/favicon-changed';
const WEBVIEW_FOCUS_REQUESTED = 'webview/focus-requested';
const WEBVIEW_MESSAGE_BOX_BLURRED = 'webview/message-box-blurred';
const WEBVIEW_MESSAGE_BOX_FOCUSED = 'webview/message-box-focused';
const WEBVIEW_SCREEN_SHARING_SOURCE_REQUESTED = 'webview/screen-sharing-source-requested';
const WEBVIEW_SCREEN_SHARING_SOURCE_RESPONDED = 'webview/screen-sharing-source-responded';
const WEBVIEW_SIDEBAR_STYLE_CHANGED = 'webview/sidebar-style-changed';
const WEBVIEW_SIDEBAR_CUSTOM_THEME_CHANGED = 'webview/sidebar-custom-theme-changed';
const WEBVIEW_GIT_COMMIT_HASH_CHANGED = 'webview/git-commit-hash-changed';
const WEBVIEW_GIT_COMMIT_HASH_CHECK = 'webview/git-commit-hash-check';
const WEBVIEW_TITLE_CHANGED = 'webview/title-changed';
const WEBVIEW_PAGE_TITLE_CHANGED = 'webview/page-title-changed';
const WEBVIEW_UNREAD_CHANGED = 'webview/unread-changed';
const WEBVIEW_USER_LOGGED_IN = 'webview/user-loggedin';
const WEBVIEW_USER_THEME_APPEARANCE_CHANGED = 'webview/user-theme-appearance-changed';
const WEBVIEW_ALLOWED_REDIRECTS_CHANGED = 'webview/allowed-redirects-changed';
const SETTINGS_SET_REPORT_OPT_IN_CHANGED = 'settings/set-bugsnag-opt-in-changed';
const SETTINGS_SET_FLASHFRAME_OPT_IN_CHANGED = 'settings/set-flashframe-opt-in-changed';
const SETTINGS_SET_HARDWARE_ACCELERATION_OPT_IN_CHANGED = 'settings/set-hardware-acceleration-opt-in-changed';
const SETTINGS_SET_INTERNALVIDEOCHATWINDOW_OPT_IN_CHANGED = 'settings/set-internalvideochatwindow-opt-in-changed';
const SETTINGS_SET_MINIMIZE_ON_CLOSE_OPT_IN_CHANGED = 'settings/set-minimize-on-close-opt-in-changed';
const SETTINGS_SET_IS_TRAY_ICON_ENABLED_CHANGED = 'settings/set-is-tray-icon-enabled-changed';
const SETTINGS_SET_IS_SIDE_BAR_ENABLED_CHANGED = 'settings/set-is-side-bar-enabled-changed';
const SETTINGS_SET_IS_MENU_BAR_ENABLED_CHANGED = 'settings/set-is-menu-bar-enabled-changed';
const SETTINGS_SET_IS_VIDEO_CALL_WINDOW_PERSISTENCE_ENABLED_CHANGED = 'settings/set-is-video-call-window-persistence-enabled-changed';
const SETTINGS_SET_IS_TRANSPARENT_WINDOW_ENABLED_CHANGED = 'settings/set-is-transparent-window-enabled-changed';
const SETTINGS_SET_IS_DEVELOPER_MODE_ENABLED_CHANGED = 'settings/set-is-developer-mode-enabled-changed';
const SETTINGS_SET_IS_VIDEO_CALL_DEVTOOLS_AUTO_OPEN_ENABLED_CHANGED = 'settings/set-is-video-call-devtools-auto-open-enabled-changed';
const SETTINGS_SET_IS_VIDEO_CALL_SCREEN_CAPTURE_FALLBACK_ENABLED_CHANGED = 'settings/set-is-video-call-screen-capture-fallback-enabled-changed';
const SETTINGS_CLEAR_PERMITTED_SCREEN_CAPTURE_PERMISSIONS = 'settings/clear-permitted-screen-capture-permissions';
const SETTINGS_NTLM_CREDENTIALS_CHANGED = 'settings/ntlm-credentials-changed';
const SETTINGS_AVAILABLE_BROWSERS_UPDATED = 'settings/available-browsers-updated';
const SETTINGS_SELECTED_BROWSER_CHANGED = 'settings/selected-browser-changed';
const SET_HAS_TRAY_MINIMIZE_NOTIFICATION_SHOWN = 'notifications/set-has-tray-minimize-notification-shown';
const DOWNLOADS_BACK_BUTTON_CLICKED = 'downloads/back-button-clicked';
const WEBVIEW_SERVER_SUPPORTED_VERSIONS_UPDATED = 'webview/server-supported-versions-updated';
const WEBVIEW_SERVER_UNIQUE_ID_UPDATED = 'webview/server-workspace-uid-updated';
const WEBVIEW_SERVER_IS_SUPPORTED_VERSION = 'webview/server-is-supported-version';
const WEBVIEW_SERVER_SUPPORTED_VERSIONS_LOADING = 'webview/server-supported-versions-loading';
const WEBVIEW_SERVER_SUPPORTED_VERSIONS_ERROR = 'webview/server-supported-versions-error';
const WEBVIEW_SERVER_VERSION_UPDATED = 'webview/version-updated';
const SUPPORTED_VERSION_DIALOG_DISMISS = 'supported-versions-dialog/dismiss';
const WEBVIEW_SERVER_RELOADED = 'webview/server-reloaded';
const WEBVIEW_PDF_VIEWER_ATTACHED = 'webview/pdf-viewer/attached';
const SIDE_BAR_SERVER_RELOAD = 'side-bar/server-reload';
const SIDE_BAR_SERVER_COPY_URL = 'side-bar/server-copy-url';
const SIDE_BAR_SERVER_OPEN_DEV_TOOLS = 'side-bar/server-open-dev-tools';
const SIDE_BAR_SERVER_FORCE_RELOAD = 'side-bar/server-force-reload';
const SIDE_BAR_SERVER_REMOVE = 'side-bar/server-remove';
const WEBVIEW_FORCE_RELOAD_WITH_CACHE_CLEAR = 'webview/force-reload-with-cache-clear';
const OPEN_SERVER_INFO_MODAL = 'server-info-modal/open';
const CLOSE_SERVER_INFO_MODAL = 'server-info-modal/close';

const SERVERS_LOADED = 'servers/loaded';
const SERVER_URL_RESOLUTION_REQUESTED = 'server/url-resolution-requested';
const SERVER_URL_RESOLVED = 'server/url-resolved';
const SERVER_DOCUMENT_VIEWER_OPEN_URL = 'server/document-viewer/open-url';

/* eslint-disable complexity */

const ensureUrlFormat = serverUrl => {
  if (serverUrl) {
    return new URL(serverUrl).href;
  }
  throw new Error('cannot handle null server URLs');
};
const upsert = (state, server) => {
  const index = state.findIndex(({
    url
  }) => url === server.url);
  if (index === -1) {
    return [...state, server];
  }
  return state.map((_server, i) => i === index ? {
    ..._server,
    ...server
  } : _server);
};
const update = (state, server) => {
  const index = state.findIndex(({
    url
  }) => url === server.url);
  if (index === -1) {
    return state;
  }
  return state.map((_server, i) => i === index ? {
    ..._server,
    ...server
  } : _server);
};
const servers = (state = [], action) => {
  switch (action.type) {
    case ADD_SERVER_VIEW_SERVER_ADDED:
    case DEEP_LINKS_SERVER_ADDED:
      {
        const url = action.payload;
        return upsert(state, {
          url,
          title: url
        });
      }
    case SIDE_BAR_REMOVE_SERVER_CLICKED:
      {
        const _url = action.payload;
        return state.filter(({
          url
        }) => url !== _url);
      }
    case SIDE_BAR_SERVERS_SORTED:
      {
        const urls = action.payload;
        return state.sort(({
          url: a
        }, {
          url: b
        }) => urls.indexOf(a) - urls.indexOf(b));
      }
    case WEBVIEW_TITLE_CHANGED:
      {
        const {
          url,
          title = url
        } = action.payload;
        return upsert(state, {
          url,
          title
        });
      }
    case WEBVIEW_PAGE_TITLE_CHANGED:
      {
        const {
          url,
          pageTitle
        } = action.payload;
        return upsert(state, {
          url,
          pageTitle
        });
      }
    case WEBVIEW_SERVER_SUPPORTED_VERSIONS_UPDATED:
      {
        const {
          url,
          supportedVersions,
          source
        } = action.payload;
        return upsert(state, {
          url,
          supportedVersions,
          supportedVersionsSource: source,
          supportedVersionsFetchState: 'success'
        });
      }
    case WEBVIEW_SERVER_SUPPORTED_VERSIONS_LOADING:
      {
        const {
          url
        } = action.payload;
        return upsert(state, {
          url,
          supportedVersionsFetchState: 'loading'
        });
      }
    case WEBVIEW_SERVER_SUPPORTED_VERSIONS_ERROR:
      {
        const {
          url
        } = action.payload;
        return upsert(state, {
          url,
          supportedVersionsFetchState: 'error'
        });
      }
    case SUPPORTED_VERSION_DIALOG_DISMISS:
      {
        const {
          url
        } = action.payload;
        return upsert(state, {
          url,
          expirationMessageLastTimeShown: new Date()
        });
      }
    case WEBVIEW_SERVER_UNIQUE_ID_UPDATED:
      {
        const {
          url,
          uniqueID
        } = action.payload;
        return upsert(state, {
          url,
          uniqueID
        });
      }
    case WEBVIEW_USER_THEME_APPEARANCE_CHANGED:
      {
        const {
          url,
          themeAppearance
        } = action.payload;
        return upsert(state, {
          url,
          themeAppearance
        });
      }
    case WEBVIEW_SERVER_IS_SUPPORTED_VERSION:
      {
        const {
          url,
          isSupportedVersion
        } = action.payload;
        return upsert(state, {
          url,
          isSupportedVersion,
          supportedVersionsValidatedAt: new Date()
        });
      }
    case WEBVIEW_SERVER_VERSION_UPDATED:
      {
        const {
          url,
          version
        } = action.payload;
        return upsert(state, {
          url,
          version
        });
      }
    case WEBVIEW_UNREAD_CHANGED:
      {
        const {
          url,
          badge
        } = action.payload;
        return upsert(state, {
          url,
          badge
        });
      }
    case WEBVIEW_USER_LOGGED_IN:
      {
        const {
          url,
          userLoggedIn
        } = action.payload;
        return upsert(state, {
          url,
          userLoggedIn
        });
      }
    case WEBVIEW_ALLOWED_REDIRECTS_CHANGED:
      {
        const {
          url,
          allowedRedirects
        } = action.payload;
        return upsert(state, {
          url,
          allowedRedirects
        });
      }
    case WEBVIEW_SIDEBAR_STYLE_CHANGED:
      {
        const {
          url,
          style
        } = action.payload;
        return upsert(state, {
          url,
          style
        });
      }
    case WEBVIEW_SIDEBAR_CUSTOM_THEME_CHANGED:
      {
        const {
          url,
          customTheme
        } = action.payload;
        return upsert(state, {
          url,
          customTheme
        });
      }
    case WEBVIEW_GIT_COMMIT_HASH_CHANGED:
      {
        const {
          url,
          gitCommitHash
        } = action.payload;
        return upsert(state, {
          url,
          gitCommitHash
        });
      }
    case WEBVIEW_FAVICON_CHANGED:
      {
        const {
          url,
          favicon
        } = action.payload;
        return upsert(state, {
          url,
          favicon
        });
      }
    case WEBVIEW_DID_NAVIGATE:
      {
        const {
          url,
          pageUrl
        } = action.payload;
        if (pageUrl !== null && pageUrl !== void 0 && pageUrl.includes(url)) {
          return upsert(state, {
            url,
            lastPath: pageUrl
          });
        }
        return state;
      }
    case WEBVIEW_DID_START_LOADING:
      {
        const {
          url
        } = action.payload;
        return upsert(state, {
          url,
          failed: false
        });
      }
    case WEBVIEW_DID_FAIL_LOAD:
      {
        const {
          url,
          isMainFrame
        } = action.payload;
        if (isMainFrame) {
          return upsert(state, {
            url,
            failed: true
          });
        }
        return state;
      }
    case SERVERS_LOADED:
      {
        const {
          servers = state
        } = action.payload;
        return servers.map(server => ({
          ...server,
          url: ensureUrlFormat(server.url)
        }));
      }
    case APP_SETTINGS_LOADED:
      {
        const {
          servers = state
        } = action.payload;
        return servers.map(server => ({
          ...server,
          url: ensureUrlFormat(server.url),
          documentViewerOpenUrl: ''
        }));
      }
    case WEBVIEW_READY:
      {
        const {
          url,
          webContentsId
        } = action.payload;
        return update(state, {
          url,
          webContentsId
        });
      }
    case WEBVIEW_ATTACHED:
      {
        const {
          url,
          webContentsId
        } = action.payload;
        return update(state, {
          url,
          webContentsId
        });
      }
    case OUTLOOK_CALENDAR_SAVE_CREDENTIALS:
      {
        const {
          url,
          outlookCredentials
        } = action.payload;
        return upsert(state, {
          url,
          outlookCredentials
        });
      }
    case SERVER_DOCUMENT_VIEWER_OPEN_URL:
      {
        const {
          server,
          documentUrl
        } = action.payload;
        return upsert(state, {
          url: server,
          documentViewerOpenUrl: documentUrl
        });
      }
    default:
      return state;
  }
};

const availableBrowsers = (state = [], action) => {
  switch (action.type) {
    case SETTINGS_AVAILABLE_BROWSERS_UPDATED:
      return action.payload;
    case APP_SETTINGS_LOADED:
      {
        return state;
      }
    default:
      return state;
  }
};

const currentView = (state = 'add-new-server', action) => {
  switch (action.type) {
    case ADD_SERVER_VIEW_SERVER_ADDED:
    case DEEP_LINKS_SERVER_ADDED:
    case DEEP_LINKS_SERVER_FOCUSED:
    case MENU_BAR_SELECT_SERVER_CLICKED:
    case TOUCH_BAR_SELECT_SERVER_TOUCHED:
    case SIDE_BAR_SERVER_SELECTED:
      {
        const url = action.payload;
        return {
          url
        };
      }
    case WEBVIEW_FOCUS_REQUESTED:
      {
        const {
          url,
          view
        } = action.payload;
        if (view === 'downloads') return 'downloads';
        return {
          url
        };
      }
    case SERVERS_LOADED:
      {
        const {
          selected
        } = action.payload;
        return selected ? {
          url: selected
        } : 'add-new-server';
      }
    case APP_SETTINGS_LOADED:
      {
        const {
          currentView = state
        } = action.payload;
        return currentView;
      }
    case MENU_BAR_ADD_NEW_SERVER_CLICKED:
    case SIDE_BAR_ADD_NEW_SERVER_CLICKED:
      return 'add-new-server';
    case SIDE_BAR_REMOVE_SERVER_CLICKED:
      {
        if (typeof state === 'object' && state.url === action.payload) {
          return 'add-new-server';
        }
        return state;
      }
    case SIDE_BAR_DOWNLOADS_BUTTON_CLICKED:
      return 'downloads';
    case SIDE_BAR_SETTINGS_BUTTON_CLICKED:
      return 'settings';
    case DOWNLOADS_BACK_BUTTON_CLICKED:
      return {
        url: action.payload
      };
    default:
      return state;
  }
};

const initialServerInfoModalState = {
  isOpen: false,
  serverData: null
};
const serverInfoModal = (state = initialServerInfoModalState, action) => {
  switch (action.type) {
    case OPEN_SERVER_INFO_MODAL:
      return {
        isOpen: true,
        serverData: action.payload
      };
    case CLOSE_SERVER_INFO_MODAL:
      return initialServerInfoModalState;
    default:
      return state;
  }
};
const dialogs = (state = {
  serverInfoModal: initialServerInfoModalState
}, action) => {
  switch (action.type) {
    case OPEN_SERVER_INFO_MODAL:
    case CLOSE_SERVER_INFO_MODAL:
      return {
        ...state,
        serverInfoModal: serverInfoModal(state.serverInfoModal, action)
      };
    default:
      return state;
  }
};

const hasHideOnTrayNotificationShown = (state = false, action) => {
  switch (action.type) {
    case APP_SETTINGS_LOADED:
      return Boolean(action.payload.hasHideOnTrayNotificationShown);
    case SET_HAS_TRAY_MINIMIZE_NOTIFICATION_SHOWN:
      return action.payload;
    default:
      return state;
  }
};

const isAddNewServersEnabled = (state = true, action) => {
  switch (action.type) {
    case APP_SETTINGS_LOADED:
      return Boolean(action.payload.isAddNewServersEnabled);
    default:
      return state;
  }
};

const isDeveloperModeEnabled = (state = false, action) => {
  switch (action.type) {
    case SETTINGS_SET_IS_DEVELOPER_MODE_ENABLED_CHANGED:
    case MENU_BAR_TOGGLE_IS_DEVELOPER_MODE_ENABLED_CLICKED:
      return action.payload;
    case APP_SETTINGS_LOADED:
      {
        const {
          isDeveloperModeEnabled = state
        } = action.payload;
        return isDeveloperModeEnabled;
      }
    default:
      return state;
  }
};

const UPDATE_SKIPPED = 'update/skipped';
const UPDATES_CHECK_FOR_UPDATES_REQUESTED = 'updates/check-for-updates-requested';
const UPDATES_CHECKING_FOR_UPDATE = 'updates/checking-for-update';
const UPDATES_ERROR_THROWN = 'updates/error-thrown';
const UPDATES_NEW_VERSION_AVAILABLE = 'updates/new-version-available';
const UPDATES_NEW_VERSION_NOT_AVAILABLE = 'updates/new-version-not-available';
const UPDATES_READY = 'updates/ready';
const UPDATES_CHANNEL_CHANGED = 'updates/channel-changed';

const isFlashFrameEnabled = (state = false, action) => {
  switch (action.type) {
    case APP_SETTINGS_LOADED:
      return Boolean(action.payload.isFlashFrameEnabled);
    case UPDATES_READY:
      return action.payload.isFlashFrameEnabled;
    case SETTINGS_SET_FLASHFRAME_OPT_IN_CHANGED:
      {
        return action.payload;
      }
    default:
      return state;
  }
};

const isHardwareAccelerationEnabled = (state = false, action) => {
  switch (action.type) {
    case APP_SETTINGS_LOADED:
      return Boolean(action.payload.isHardwareAccelerationEnabled);
    case UPDATES_READY:
      return action.payload.isHardwareAccelerationEnabled;
    case SETTINGS_SET_HARDWARE_ACCELERATION_OPT_IN_CHANGED:
      {
        return action.payload;
      }
    default:
      return state;
  }
};

const isInternalVideoChatWindowEnabled = (state = false, action) => {
  switch (action.type) {
    case APP_SETTINGS_LOADED:
      return Boolean(action.payload.isInternalVideoChatWindowEnabled);
    case UPDATES_READY:
      return action.payload.isInternalVideoChatWindowEnabled;
    case SETTINGS_SET_INTERNALVIDEOCHATWINDOW_OPT_IN_CHANGED:
      {
        return action.payload;
      }
    default:
      return state;
  }
};

const isMenuBarEnabled = (state = true, action) => {
  switch (action.type) {
    case SETTINGS_SET_IS_MENU_BAR_ENABLED_CHANGED:
    case MENU_BAR_TOGGLE_IS_MENU_BAR_ENABLED_CLICKED:
      return action.payload;
    case APP_SETTINGS_LOADED:
      {
        const {
          isMenuBarEnabled = state
        } = action.payload;
        return isMenuBarEnabled;
      }
    default:
      return state;
  }
};

const isMessageBoxFocused = (state = false, action) => {
  switch (action.type) {
    case WEBVIEW_MESSAGE_BOX_FOCUSED:
      return true;
    case WEBVIEW_DID_START_LOADING:
    case WEBVIEW_MESSAGE_BOX_BLURRED:
    case WEBVIEW_DID_FAIL_LOAD:
      return false;
    default:
      return state;
  }
};

const isMinimizeOnCloseEnabled = (state = process.platform === 'win32', action) => {
  switch (action.type) {
    case SETTINGS_SET_MINIMIZE_ON_CLOSE_OPT_IN_CHANGED:
      {
        return action.payload;
      }
    case APP_SETTINGS_LOADED:
      {
        const {
          isMinimizeOnCloseEnabled = state
        } = action.payload;
        return isMinimizeOnCloseEnabled;
      }
    default:
      return state;
  }
};

const isNTLMCredentialsEnabled = (state = false, action) => {
  switch (action.type) {
    case APP_SETTINGS_LOADED:
      {
        const {
          isNTLMCredentialsEnabled = state
        } = action.payload;
        return isNTLMCredentialsEnabled;
      }
    case SETTINGS_NTLM_CREDENTIALS_CHANGED:
      {
        return action.payload;
      }
    default:
      return state;
  }
};

const isReportEnabled = (state = false, action) => {
  switch (action.type) {
    case APP_SETTINGS_LOADED:
      return Boolean(action.payload.isReportEnabled);
    case UPDATES_READY:
      return action.payload.isReportEnabled;
    case SETTINGS_SET_REPORT_OPT_IN_CHANGED:
      {
        return action.payload;
      }
    default:
      return state;
  }
};

const isShowWindowOnUnreadChangedEnabled = (state = false, action) => {
  switch (action.type) {
    case MENU_BAR_TOGGLE_IS_SHOW_WINDOW_ON_UNREAD_CHANGED_ENABLED_CLICKED:
      return action.payload;
    case APP_SETTINGS_LOADED:
      {
        const {
          isShowWindowOnUnreadChangedEnabled = state
        } = action.payload;
        return isShowWindowOnUnreadChangedEnabled;
      }
    default:
      return state;
  }
};

const isSideBarEnabled = (state = true, action) => {
  switch (action.type) {
    case SETTINGS_SET_IS_SIDE_BAR_ENABLED_CHANGED:
    case MENU_BAR_TOGGLE_IS_SIDE_BAR_ENABLED_CLICKED:
      return action.payload;
    case APP_SETTINGS_LOADED:
      {
        const {
          isSideBarEnabled = state
        } = action.payload;
        return isSideBarEnabled;
      }
    default:
      return state;
  }
};

const isTransparentWindowEnabled = (state = false, action) => {
  switch (action.type) {
    case SETTINGS_SET_IS_TRANSPARENT_WINDOW_ENABLED_CHANGED:
      {
        const {
          payload
        } = action;
        if (typeof payload === 'boolean') {
          return payload;
        }
        console.warn(`Invalid payload type for ${SETTINGS_SET_IS_TRANSPARENT_WINDOW_ENABLED_CHANGED}: expected boolean, got ${typeof payload}`);
        return state;
      }
    case APP_SETTINGS_LOADED:
      {
        const {
          isTransparentWindowEnabled = state
        } = action.payload;
        return isTransparentWindowEnabled;
      }
    default:
      return state;
  }
};

const isTrayIconEnabled = (state = process.platform !== 'linux', action) => {
  switch (action.type) {
    case SETTINGS_SET_IS_TRAY_ICON_ENABLED_CHANGED:
    case MENU_BAR_TOGGLE_IS_TRAY_ICON_ENABLED_CLICKED:
      return action.payload;
    case APP_SETTINGS_LOADED:
      {
        const {
          isTrayIconEnabled = state
        } = action.payload;
        return isTrayIconEnabled;
      }
    default:
      return state;
  }
};

const isVideoCallDevtoolsAutoOpenEnabled = (state = false, action) => {
  switch (action.type) {
    case SETTINGS_SET_IS_VIDEO_CALL_DEVTOOLS_AUTO_OPEN_ENABLED_CHANGED:
    case MENU_BAR_TOGGLE_IS_VIDEO_CALL_DEVTOOLS_AUTO_OPEN_ENABLED_CLICKED:
      return action.payload;
    case APP_SETTINGS_LOADED:
      {
        const {
          isVideoCallDevtoolsAutoOpenEnabled = state
        } = action.payload;
        return isVideoCallDevtoolsAutoOpenEnabled;
      }
    default:
      return state;
  }
};

const isVideoCallScreenCaptureFallbackEnabled = (state = false, action) => {
  switch (action.type) {
    case APP_SETTINGS_LOADED:
      return Boolean(action.payload.isVideoCallScreenCaptureFallbackEnabled);
    case UPDATES_READY:
      {
        const {
          isVideoCallScreenCaptureFallbackEnabled = state
        } = action.payload;
        return isVideoCallScreenCaptureFallbackEnabled;
      }
    case SETTINGS_SET_IS_VIDEO_CALL_SCREEN_CAPTURE_FALLBACK_ENABLED_CHANGED:
      return action.payload;
    default:
      return state;
  }
};

const isVideoCallWindowPersistenceEnabled = (state = true,
// Enabled by default
action) => {
  switch (action.type) {
    case SETTINGS_SET_IS_VIDEO_CALL_WINDOW_PERSISTENCE_ENABLED_CHANGED:
      return action.payload;
    case APP_SETTINGS_LOADED:
      {
        const {
          isVideoCallWindowPersistenceEnabled = state
        } = action.payload;
        return isVideoCallWindowPersistenceEnabled;
      }
    default:
      return state;
  }
};

const lastSelectedServerUrl = (state = '', action) => {
  switch (action.type) {
    case APP_SETTINGS_LOADED:
      {
        const {
          lastSelectedServerUrl = state,
          servers
        } = action.payload;
        if (state === '' && servers && servers.length > 0) {
          return servers[0].url;
        }
        return lastSelectedServerUrl;
      }
    case SIDE_BAR_SERVER_SELECTED:
      return action.payload;
    default:
      return state;
  }
};

const SCREEN_SHARING_DIALOG_DISMISSED = 'screen-sharing-dialog/dismissed';

const openDialog = (state = null, action) => {
  switch (action.type) {
    case MENU_BAR_ABOUT_CLICKED:
      return 'about';
    case WEBVIEW_SCREEN_SHARING_SOURCE_REQUESTED:
      return 'screen-sharing';
    case UPDATES_NEW_VERSION_AVAILABLE:
      return 'update';
    case CERTIFICATES_CLIENT_CERTIFICATE_REQUESTED:
      return 'select-client-certificate';
    case ABOUT_DIALOG_DISMISSED:
      if (state === 'about') {
        return null;
      }
      return state;
    case OUTLOOK_CALENDAR_ASK_CREDENTIALS:
      return 'outlook-credentials';
    case SCREEN_SHARING_DIALOG_DISMISSED:
    case WEBVIEW_SCREEN_SHARING_SOURCE_RESPONDED:
    case SELECT_CLIENT_CERTIFICATE_DIALOG_CERTIFICATE_SELECTED:
    case SELECT_CLIENT_CERTIFICATE_DIALOG_DISMISSED:
    case UPDATE_DIALOG_DISMISSED:
    case UPDATE_DIALOG_SKIP_UPDATE_CLICKED:
    case UPDATE_DIALOG_REMIND_UPDATE_LATER_CLICKED:
    case UPDATE_DIALOG_INSTALL_BUTTON_CLICKED:
    case OUTLOOK_CALENDAR_DIALOG_DISMISSED:
    case OUTLOOK_CALENDAR_SET_CREDENTIALS:
      return null;
    default:
      return state;
  }
};

const rootWindowIcon = (state = null, action) => {
  switch (action.type) {
    case ROOT_WINDOW_ICON_CHANGED:
      {
        return action.payload;
      }
    default:
      return state;
  }
};

const rootWindowState = (state = {
  focused: true,
  visible: true,
  maximized: false,
  minimized: false,
  fullscreen: false,
  normal: true,
  bounds: {
    x: undefined,
    y: undefined,
    width: 1000,
    height: 600
  }
}, action) => {
  switch (action.type) {
    case ROOT_WINDOW_STATE_CHANGED:
      return action.payload;
    case APP_SETTINGS_LOADED:
      {
        const {
          rootWindowState = state
        } = action.payload;
        return rootWindowState;
      }
    default:
      return state;
  }
};

const selectedBrowser = (state = null, action) => {
  switch (action.type) {
    case SETTINGS_SELECTED_BROWSER_CHANGED:
      return action.payload;
    case APP_SETTINGS_LOADED:
      {
        const {
          selectedBrowser = state
        } = action.payload;
        return selectedBrowser;
      }
    default:
      return state;
  }
};

const videoCallWindowState = (state = {
  focused: true,
  visible: true,
  maximized: false,
  minimized: false,
  fullscreen: false,
  normal: true,
  bounds: {
    x: undefined,
    y: undefined,
    width: 0,
    height: 0
  }
}, action) => {
  switch (action.type) {
    case VIDEO_CALL_WINDOW_STATE_CHANGED:
      return action.payload;
    case APP_SETTINGS_LOADED:
      {
        const {
          videoCallWindowState = state
        } = action.payload;
        return videoCallWindowState;
      }
    default:
      return state;
  }
};

const doCheckForUpdatesOnStartup = (state = true, action) => {
  switch (action.type) {
    case UPDATES_READY:
      {
        const {
          doCheckForUpdatesOnStartup
        } = action.payload;
        return doCheckForUpdatesOnStartup;
      }
    case ABOUT_DIALOG_TOGGLE_UPDATE_ON_START:
      {
        const doCheckForUpdatesOnStartup = action.payload;
        return doCheckForUpdatesOnStartup;
      }
    case APP_SETTINGS_LOADED:
      {
        const {
          doCheckForUpdatesOnStartup = state
        } = action.payload;
        return doCheckForUpdatesOnStartup;
      }
    default:
      return state;
  }
};
const isCheckingForUpdates = (state = false, action) => {
  switch (action.type) {
    case UPDATES_CHECKING_FOR_UPDATE:
      return true;
    case UPDATES_ERROR_THROWN:
      return false;
    case UPDATES_NEW_VERSION_NOT_AVAILABLE:
      return false;
    case UPDATES_NEW_VERSION_AVAILABLE:
      return false;
    default:
      return state;
  }
};
const isEachUpdatesSettingConfigurable = (state = true, action) => {
  switch (action.type) {
    case UPDATES_READY:
      {
        const {
          isEachUpdatesSettingConfigurable
        } = action.payload;
        return isEachUpdatesSettingConfigurable;
      }
    case APP_SETTINGS_LOADED:
      {
        const {
          isEachUpdatesSettingConfigurable = state
        } = action.payload;
        return isEachUpdatesSettingConfigurable;
      }
    default:
      return state;
  }
};
const isUpdatingAllowed = (state = true, action) => {
  switch (action.type) {
    case UPDATES_READY:
      {
        const {
          isUpdatingAllowed
        } = action.payload;
        return isUpdatingAllowed;
      }
    default:
      return state;
  }
};
const isUpdatingEnabled = (state = true, action) => {
  switch (action.type) {
    case UPDATES_READY:
      {
        const {
          isUpdatingEnabled
        } = action.payload;
        return isUpdatingEnabled;
      }
    case APP_SETTINGS_LOADED:
      {
        const {
          isUpdatingEnabled = state
        } = action.payload;
        return isUpdatingEnabled;
      }
    default:
      return state;
  }
};
const newUpdateVersion = (state = null, action) => {
  switch (action.type) {
    case UPDATES_NEW_VERSION_AVAILABLE:
      {
        const newUpdateVersion = action.payload;
        return newUpdateVersion;
      }
    case UPDATES_NEW_VERSION_NOT_AVAILABLE:
    case UPDATE_SKIPPED:
      {
        return null;
      }
    default:
      return state;
  }
};
const skippedUpdateVersion = (state = null, action) => {
  switch (action.type) {
    case UPDATES_READY:
      {
        const {
          skippedUpdateVersion
        } = action.payload;
        return skippedUpdateVersion;
      }
    case UPDATE_SKIPPED:
      {
        const skippedUpdateVersion = action.payload;
        return skippedUpdateVersion;
      }
    case APP_SETTINGS_LOADED:
      {
        const {
          skippedUpdateVersion = state
        } = action.payload;
        return skippedUpdateVersion;
      }
    default:
      return state;
  }
};
const updateError = (state = null, action) => {
  switch (action.type) {
    case UPDATES_CHECKING_FOR_UPDATE:
      return null;
    case UPDATES_ERROR_THROWN:
      return action.payload;
    case UPDATES_NEW_VERSION_NOT_AVAILABLE:
      return null;
    case UPDATES_NEW_VERSION_AVAILABLE:
      return null;
    default:
      return state;
  }
};
const updateChannel = (state = 'latest', action) => {
  switch (action.type) {
    case ABOUT_DIALOG_UPDATE_CHANNEL_CHANGED:
    case UPDATES_CHANNEL_CHANGED:
      {
        return action.payload;
      }
    case UPDATES_READY:
      {
        const {
          updateChannel
        } = action.payload;
        return updateChannel;
      }
    case APP_SETTINGS_LOADED:
      {
        const {
          updateChannel = state
        } = action.payload;
        return updateChannel;
      }
    default:
      return state;
  }
};

const rootReducer = redux.combineReducers({
  allowedJitsiServers,
  appPath,
  appVersion,
  availableBrowsers,
  clientCertificates,
  currentView,
  dialogs,
  doCheckForUpdatesOnStartup,
  downloads,
  externalProtocols,
  isCheckingForUpdates,
  isEachUpdatesSettingConfigurable,
  isMenuBarEnabled,
  isMessageBoxFocused,
  isShowWindowOnUnreadChangedEnabled,
  isSideBarEnabled,
  isTrayIconEnabled,
  isMinimizeOnCloseEnabled,
  isUpdatingAllowed,
  isUpdatingEnabled,
  mainWindowTitle,
  machineTheme,
  newUpdateVersion,
  openDialog,
  rootWindowIcon,
  rootWindowState,
  selectedBrowser,
  servers,
  skippedUpdateVersion,
  trustedCertificates,
  notTrustedCertificates,
  updateError,
  isReportEnabled,
  isFlashFrameEnabled,
  isHardwareAccelerationEnabled,
  isInternalVideoChatWindowEnabled,
  isAddNewServersEnabled,
  hasHideOnTrayNotificationShown,
  lastSelectedServerUrl,
  allowedNTLMCredentialsDomains,
  isNTLMCredentialsEnabled,
  videoCallWindowState,
  isVideoCallWindowPersistenceEnabled,
  isDeveloperModeEnabled,
  updateChannel,
  screenCaptureFallbackForced,
  isVideoCallDevtoolsAutoOpenEnabled,
  isTransparentWindowEnabled,
  isVideoCallScreenCaptureFallbackEnabled
});

let reduxStore;
let lastAction;
const catchLastAction = () => next => action => {
  lastAction = action;
  return next(action);
};
const createMainReduxStore = () => {
  const middlewares = redux.applyMiddleware(catchLastAction, forwardToRenderers);
  reduxStore = redux.createStore(rootReducer, {}, middlewares);
};
const dispatch = action => {
  reduxStore.dispatch(action);
};
const dispatchSingle = action => {
  reduxStore.dispatch({
    ...action,
    ipcMeta: {
      ...action.ipcMeta,
      scope: 'single'
    }
  });
};
const dispatchLocal = action => {
  reduxStore.dispatch({
    ...action,
    ipcMeta: {
      ...action.ipcMeta,
      scope: 'local'
    },
    meta: {
      scope: 'local'
    }
  });
};
const select = selector => selector(reduxStore.getState());
const watch = (selector, watcher) => {
  const initial = select(selector);
  watcher(initial, undefined);
  let prev = initial;
  return reduxStore.subscribe(() => {
    const curr = select(selector);
    if (Object.is(prev, curr)) {
      return;
    }
    watcher(curr, prev);
    prev = curr;
  });
};
const listen = (typeOrPredicate, listener) => {
  const effectivePredicate = typeof typeOrPredicate === 'function' ? typeOrPredicate : action => action.type === typeOrPredicate;
  return reduxStore.subscribe(() => {
    if (!effectivePredicate(lastAction)) {
      return;
    }
    listener(lastAction);
  });
};
class Service {
  constructor() {
    _defineProperty(this, "unsubscribers", new Set());
  }
  // eslint-disable-next-line @typescript-eslint/no-empty-function
  initialize() {}

  // eslint-disable-next-line @typescript-eslint/no-empty-function
  destroy() {}
  watch(selector, watcher) {
    this.unsubscribers.add(watch(selector, watcher));
  }

  // eslint-disable-next-line no-dupe-class-members

  // eslint-disable-next-line no-dupe-class-members
  listen(typeOrPredicate, listener) {
    if (typeof typeOrPredicate === 'string') {
      this.unsubscribers.add(listen(typeOrPredicate, listener));
      return;
    }
    this.unsubscribers.add(listen(typeOrPredicate, listener));
  }
  setUp() {
    this.initialize();
  }
  tearDown() {
    this.unsubscribers.forEach(unsubscribe => unsubscribe());
    this.destroy();
  }
}

// const isResponseTo = <Response extends RootAction>(id: unknown, type: Response['type']) =>
//   (action: RootAction): action is Response =>
//     isResponse(action) && action.type === type && action.meta.id === id;

const request = (requestAction, ...types) => new Promise((resolve, reject) => {
  const id = Math.random().toString(36).slice(2);
  const unsubscribe = listen(isResponseTo(id, ...types), action => {
    unsubscribe();
    if (isErrored(action)) {
      reject(action.payload);
      return;
    }
    if (hasPayload(action)) {
      resolve(action.payload);
    }
  });
  dispatch({
    ...requestAction,
    meta: {
      request: true,
      id
    }
  });
});

const readSetting = key => {
  try {
    const filePath = path__default.default.join(electron.app.getPath('userData'), 'config.json');
    const content = fs__namespace.default.readFileSync(filePath, 'utf8');
    const json = JSON.parse(content);
    return json[key];
  } catch (e) {
    return null;
  }
};

var readSetting$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  readSetting: readSetting
});

const migrations = {
  '>=3.1.0': before => {
    var _rest$currentView;
    const {
      currentServerUrl,
      ...rest
    } = before;
    return {
      ...rest,
      currentView: currentServerUrl ? {
        url: currentServerUrl
      } : (_rest$currentView = rest.currentView) !== null && _rest$currentView !== void 0 ? _rest$currentView : 'add-new-server',
      downloads: {}
    };
  },
  '>=3.5.0': before => ({
    ...before,
    isReportEnabled: true,
    isInternalVideoChatWindowEnabled: true,
    isFlashFrameEnabled: process.platform === 'win32' || process.platform === 'darwin'
  }),
  '>=3.7.9': before => ({
    ...before,
    isMinimizeOnCloseEnabled: process.platform === 'win32'
  }),
  '>=3.8.0': before => ({
    ...before,
    isReportEnabled: !process.mas
  }),
  '>=3.8.4': before => ({
    ...before,
    isInternalVideoChatWindowEnabled: !process.mas,
    isAddNewServersEnabled: true
  }),
  '>=3.8.7': before => ({
    ...before,
    isHardwareAccelerationEnabled: true
  }),
  '>=3.8.9': before => ({
    ...before,
    isAddNewServersEnabled: true
  }),
  '>=3.8.12': before => ({
    ...before,
    hasHideOnTrayNotificationShown: false
  }),
  '>=3.9.6': before => ({
    ...before,
    isNTLMCredentialsEnabled: false,
    allowedNTLMCredentialsDomains: null,
    lastSelectedServerUrl: ''
  }),
  '>=4.1.0': before => ({
    ...before,
    mainWindowTitle: 'Rocket.Chat',
    machineTheme: 'light'
  }),
  '>=4.2.0': before => ({
    ...before,
    selectedBrowser: null
  }),
  '>=4.4.0': before => ({
    ...before,
    isDeveloperModeEnabled: false
  }),
  '>=4.5.0': before => ({
    ...before,
    updateChannel: 'latest'
  }),
  '>=4.7.2': before => ({
    ...before,
    isVideoCallDevtoolsAutoOpenEnabled: false
  }),
  '>=4.9.0': before => ({
    ...before,
    isTransparentWindowEnabled: false,
    isVideoCallScreenCaptureFallbackEnabled: false
  })
};

let electronStore;
const getElectronStore = () => {
  if (!electronStore) {
    electronStore = new ElectronStore__default.default({
      migrations: Object.fromEntries(Object.entries(migrations).map(([semver, transform]) => [semver, store => {
        store.store = transform(store.store);
      }])),
      projectVersion: electron.app.getVersion(),
      configFileMode: 0o666
    });
  }
  return electronStore;
};
const getPersistedValues = () => getElectronStore().store;
let lastSavedTime = 0;
const persistValues = values => {
  if (Date.now() - lastSavedTime > 1000) {
    try {
      getElectronStore().set(values);
    } catch (error) {
      error instanceof Error && console.error(error);
    }
    lastSavedTime = Date.now();
  }
};

const selectGlobalBadge = ({
  servers
}) => {
  const badges = servers.map(({
    badge
  }) => badge);
  const mentionCount = badges.filter(badge => Number.isInteger(badge)).reduce((sum, count) => sum + count, 0);
  return mentionCount || badges.some(badge => !!badge) && '•' || undefined;
};
const selectGlobalBadgeText = reselect.createSelector(selectGlobalBadge, badge => {
  if (badge === '•') {
    return '•';
  }
  if (Number.isInteger(badge)) {
    return String(badge);
  }
  return '';
});
const isBadgeCount = badge => Number.isInteger(badge);
const selectGlobalBadgeCount = reselect.createSelector(selectGlobalBadge, badge => isBadgeCount(badge) ? badge : 0);

function debounce(cb, wait = 20) {
  let h;
  const callable = (...args) => {
    h && clearTimeout(h);
    h = setTimeout(() => cb(...args), wait);
  };
  return callable;
}

const getAppIconPath = ({
  platform
}) => {
  if (platform !== 'win32') {
    throw Error('only win32 platform is supported');
  }
  return `${electron.app.getAppPath()}/app/images/icon.ico`;
};
const getMacOSTrayIconPath = badge => path__default.default.join(electron.app.getAppPath(), `app/images/tray/darwin/${badge ? 'notification' : 'default'}Template.png`);
const getWindowsTrayIconPath = badge => {
  const name = !badge && 'default' || badge === '•' && 'notification-dot' || typeof badge === 'number' && badge > 9 && 'notification-plus-9' || `notification-${badge}`;
  return path__default.default.join(electron.app.getAppPath(), `app/images/tray/win32/${name}.ico`);
};
const getLinuxTrayIconPath = badge => {
  const name = !badge && 'default' || badge === '•' && 'notification-dot' || typeof badge === 'number' && badge > 9 && 'notification-plus-9' || `notification-${badge}`;
  return path__default.default.join(electron.app.getAppPath(), `app/images/tray/linux/${name}.png`);
};
const getTrayIconPath = ({
  badge,
  platform
}) => {
  switch (platform !== null && platform !== void 0 ? platform : process.platform) {
    case 'darwin':
      return getMacOSTrayIconPath(badge);
    case 'win32':
      return getWindowsTrayIconPath(badge);
    case 'linux':
      return getLinuxTrayIconPath(badge);
    default:
      throw Error(`unsupported platform (${platform})`);
  }
};

const webPreferences = {
  nodeIntegration: true,
  nodeIntegrationInSubFrames: true,
  contextIsolation: false,
  webviewTag: true
};
const selectRootWindowState = ({
  rootWindowState
}) => rootWindowState !== null && rootWindowState !== void 0 ? rootWindowState : {
  bounds: {
    x: 0,
    y: 0,
    width: 0,
    height: 0
  },
  focused: false,
  fullscreen: false,
  maximized: false,
  minimized: false,
  normal: false,
  visible: false
};
let _rootWindow;
let tempWindow;
const getRootWindow = () => new Promise((resolve, reject) => {
  setTimeout(() => {
    if (!_rootWindow) {
      reject(new Error('Root window not initialized'));
      return;
    }
    if (_rootWindow.isDestroyed()) {
      reject(new Error('Root window has been destroyed'));
      return;
    }
    resolve(_rootWindow);
  }, 300);
});
const platformTitleBarStyle = process.platform === 'darwin' ? 'hidden' : 'default';
const isMac = process.platform === 'darwin';
const getEnableVibrancy = () => {
  if (!isMac) {
    return false;
  }
  try {
    const persistedValues = getPersistedValues();
    return (persistedValues === null || persistedValues === void 0 ? void 0 : persistedValues.isTransparentWindowEnabled) === true;
  } catch (error) {
    return false;
  }
};
const createRootWindow = () => {
  const enableVibrancy = getEnableVibrancy();
  _rootWindow = new electron.BrowserWindow({
    width: 1000,
    height: 600,
    minWidth: 400,
    minHeight: 400,
    titleBarStyle: platformTitleBarStyle,
    backgroundColor: enableVibrancy ? '#00000000' : '#2f343d',
    show: false,
    webPreferences,
    ...(enableVibrancy ? {
      transparent: true,
      vibrancy: 'sidebar',
      visualEffectState: 'active'
    } : {})
  });

  // Block navigation to smb:// protocol
  _rootWindow.webContents.on('will-navigate', (event, url) => {
    if (typeof url === 'string' && url.toLowerCase().startsWith('smb://')) {
      event.preventDefault();
    }
  });
  _rootWindow.webContents.setWindowOpenHandler(({
    url
  }) => {
    if (url.toLowerCase().startsWith('smb://')) {
      return {
        action: 'deny'
      };
    }
    return {
      action: 'allow'
    };
  });
  _rootWindow.addListener('close', event => {
    event.preventDefault();
  });
  tempWindow.destroy();
};
const normalizeNumber = value => value && isFinite(1 / value) ? value : 0;
const isInsideSomeScreen = ({
  x,
  y,
  width,
  height
}) => electron.screen.getAllDisplays().some(({
  bounds
}) => x >= bounds.x && y >= bounds.y && x + width <= bounds.x + bounds.width && y + height <= bounds.y + bounds.height);
const applyRootWindowState = browserWindow => {
  const rootWindowState = select(selectRootWindowState);
  const isTrayIconEnabled = select(({
    isTrayIconEnabled
  }) => isTrayIconEnabled);
  let {
    x = null,
    y = null
  } = rootWindowState.bounds;
  let {
    width,
    height
  } = rootWindowState.bounds;
  if (x === null || y === null || !isInsideSomeScreen({
    x,
    y,
    width,
    height
  })) {
    const primaryDisplay = electron.screen.getPrimaryDisplay();
    const {
      bounds: {
        width: primaryDisplayWidth,
        height: primaryDisplayHeight
      }
    } = primaryDisplay;
    x = Math.round((primaryDisplayWidth - width) / 2);
    y = Math.round((primaryDisplayHeight - height) / 2);
    width = normalizeNumber(primaryDisplay.workAreaSize.width * 0.9);
    height = normalizeNumber(primaryDisplay.workAreaSize.height * 0.9);
  }
  if (browserWindow.isVisible()) {
    return;
  }
  x = normalizeNumber(x);
  y = normalizeNumber(y);
  width = normalizeNumber(width);
  height = normalizeNumber(height);
  if (browserWindow && Number.isInteger(width) && Number.isInteger(height) && Number.isInteger(x) && Number.isInteger(y)) {
    browserWindow.setBounds({
      width,
      height,
      x,
      y
    });
  }
  if (rootWindowState.maximized) {
    browserWindow.maximize();
  }
  if (rootWindowState.minimized) {
    browserWindow.minimize();
  }
  if (rootWindowState.fullscreen) {
    browserWindow.setFullScreen(true);
  }
  if (rootWindowState.visible || !isTrayIconEnabled) {
    browserWindow.show();
  }
  if (rootWindowState.focused) {
    browserWindow.focus();
  }
};
const fetchRootWindowState = async () => {
  const browserWindow = await getRootWindow();
  return {
    focused: browserWindow === null || browserWindow === void 0 ? void 0 : browserWindow.isFocused(),
    visible: browserWindow === null || browserWindow === void 0 ? void 0 : browserWindow.isVisible(),
    maximized: browserWindow === null || browserWindow === void 0 ? void 0 : browserWindow.isMaximized(),
    minimized: browserWindow === null || browserWindow === void 0 ? void 0 : browserWindow.isMinimized(),
    fullscreen: browserWindow === null || browserWindow === void 0 ? void 0 : browserWindow.isFullScreen(),
    normal: browserWindow === null || browserWindow === void 0 ? void 0 : browserWindow.isNormal(),
    bounds: browserWindow === null || browserWindow === void 0 ? void 0 : browserWindow.getNormalBounds()
  };
};
const setupRootWindow = () => {
  const safeWindowOperation = async (operation, operationName) => {
    try {
      const window = await getRootWindow();
      if (window.isDestroyed()) {
        return;
      }
      return await operation(window);
    } catch (error) {
    }
  };
  const unsubscribers = [watch(selectGlobalBadgeCount, async globalBadgeCount => {
    await safeWindowOperation(async browserWindow => {
      if (browserWindow.isFocused() || globalBadgeCount === 0) {
        return;
      }
      const {
        isShowWindowOnUnreadChangedEnabled,
        isFlashFrameEnabled
      } = select(({
        isShowWindowOnUnreadChangedEnabled,
        isFlashFrameEnabled
      }) => ({
        isShowWindowOnUnreadChangedEnabled,
        isFlashFrameEnabled
      }));
      if (isShowWindowOnUnreadChangedEnabled && !browserWindow.isVisible()) {
        const isMinimized = browserWindow.isMinimized();
        const isMaximized = browserWindow.isMaximized();
        browserWindow.showInactive();
        if (isMinimized) {
          browserWindow.minimize();
        }
        if (isMaximized) {
          browserWindow.maximize();
        }
        return;
      }
      if (isFlashFrameEnabled && process.platform !== 'darwin') {
        browserWindow.flashFrame(true);
      }
    });
  }), watch(({
    currentView,
    servers
  }) => {
    const currentServer = typeof currentView === 'object' ? servers.find(({
      url
    }) => url === currentView.url) : null;
    return (currentServer === null || currentServer === void 0 ? void 0 : currentServer.pageTitle) || (currentServer === null || currentServer === void 0 ? void 0 : currentServer.title) || electron.app.name;
  }, async windowTitle => {
    await safeWindowOperation(browserWindow => {
      browserWindow.setTitle(windowTitle);
      dispatch({
        type: APP_MAIN_WINDOW_TITLE_SET,
        payload: windowTitle
      });
    });
  }), listen(WEBVIEW_FOCUS_REQUESTED, async () => {
    await safeWindowOperation(rootWindow => {
      rootWindow.focus();
      rootWindow.show();
    });
  })];
  const fetchAndDispatchWindowState = debounce(async () => {
    try {
      const state = await fetchRootWindowState();
      dispatchLocal({
        type: ROOT_WINDOW_STATE_CHANGED,
        payload: state
      });
    } catch (error) {
    }
  }, 1000);
  getRootWindow().then(rootWindow => {
    rootWindow.addListener('show', fetchAndDispatchWindowState);
    rootWindow.addListener('hide', fetchAndDispatchWindowState);
    rootWindow.addListener('focus', fetchAndDispatchWindowState);
    rootWindow.addListener('blur', fetchAndDispatchWindowState);
    rootWindow.addListener('maximize', fetchAndDispatchWindowState);
    rootWindow.addListener('unmaximize', fetchAndDispatchWindowState);
    rootWindow.addListener('minimize', fetchAndDispatchWindowState);
    rootWindow.addListener('restore', fetchAndDispatchWindowState);
    rootWindow.addListener('resize', fetchAndDispatchWindowState);
    rootWindow.addListener('move', fetchAndDispatchWindowState);
    fetchAndDispatchWindowState();
    rootWindow.addListener('focus', async () => {
      rootWindow.flashFrame(false);
    });
    rootWindow.addListener('close', async event => {
      try {
        if (rootWindow.isDestroyed()) {
          return;
        }
        if (rootWindow.isFullScreen()) {
          await new Promise(resolve => rootWindow.once('leave-full-screen', () => resolve()));
          rootWindow.setFullScreen(false);
        }
        if (process.platform !== 'linux' && !rootWindow.isDestroyed()) {
          rootWindow.blur();
        }
        let isTrayIconEnabled;
        let isMinimizeOnCloseEnabled;
        try {
          isTrayIconEnabled = select(({
            isTrayIconEnabled
          }) => isTrayIconEnabled !== null && isTrayIconEnabled !== void 0 ? isTrayIconEnabled : true);
          isMinimizeOnCloseEnabled = select(({
            isMinimizeOnCloseEnabled
          }) => isMinimizeOnCloseEnabled !== null && isMinimizeOnCloseEnabled !== void 0 ? isMinimizeOnCloseEnabled : true);
        } catch (error) {
          console.warn('Failed to access application state during close:', error);
          isTrayIconEnabled = true;
          isMinimizeOnCloseEnabled = true;
        }
        if (process.platform === 'darwin' || isTrayIconEnabled) {
          if (!rootWindow.isDestroyed()) {
            rootWindow.hide();
          }
          return;
        }
        if (process.platform === 'win32' && isMinimizeOnCloseEnabled) {
          if (!rootWindow.isDestroyed()) {
            rootWindow.minimize();
          }
          return;
        }

        // Prevent race condition: window destruction during app.quit()
        event.preventDefault();
        electron.app.quit();
      } catch (error) {
        console.error('Error in close event handler:', error);
        event.preventDefault();
        electron.app.quit();
      }
    });
    unsubscribers.push(() => {
      try {
        if (rootWindow && !rootWindow.isDestroyed()) {
          rootWindow.removeAllListeners();
          setImmediate(() => {
            if (rootWindow && !rootWindow.isDestroyed()) {
              rootWindow.close();
            }
          });
        }
      } catch (error) {
        console.error('Error during root window cleanup:', error);
      }
    });
  });
  if (process.platform === 'linux' || process.platform === 'win32') {
    const selectRootWindowIcon = reselect.createStructuredSelector({
      globalBadge: selectGlobalBadge,
      rootWindowIcon: ({
        rootWindowIcon
      }) => rootWindowIcon
    });
    unsubscribers.push(watch(selectRootWindowIcon, async ({
      globalBadge,
      rootWindowIcon
    }) => {
      await safeWindowOperation(async browserWindow => {
        if (!rootWindowIcon) {
          browserWindow.setIcon(electron.nativeImage.createFromPath(getTrayIconPath({
            platform: process.platform,
            badge: globalBadge
          })));
          return;
        }
        const icon = electron.nativeImage.createEmpty();
        const {
          scaleFactor
        } = electron.screen.getPrimaryDisplay();
        if (process.platform === 'linux') {
          rootWindowIcon.icon.forEach(representation => {
            icon.addRepresentation({
              ...representation,
              scaleFactor
            });
          });
        }
        if (process.platform === 'win32') {
          for (const representation of rootWindowIcon.icon) {
            var _representation$width;
            icon.addRepresentation({
              ...representation,
              scaleFactor: Math.max(((_representation$width = representation.width) !== null && _representation$width !== void 0 ? _representation$width : 0) / 32, 1)
            });
          }
        }
        browserWindow.setIcon(icon);
        if (process.platform === 'win32') {
          let overlayIcon = null;
          const overlayDescription = typeof globalBadge === 'number' && i18next__default.default.t('unreadMention', {
            appName: electron.app.name,
            count: globalBadge
          }) || globalBadge === '•' && i18next__default.default.t('unreadMessage', {
            appName: electron.app.name
          }) || i18next__default.default.t('noUnreadMessage', {
            appName: electron.app.name
          });
          if (rootWindowIcon.overlay) {
            overlayIcon = electron.nativeImage.createEmpty();
            for (const representation of rootWindowIcon.overlay) {
              overlayIcon.addRepresentation({
                ...representation,
                scaleFactor: 1
              });
            }
          }
          const isTrayIconEnabled = select(({
            isTrayIconEnabled
          }) => isTrayIconEnabled !== null && isTrayIconEnabled !== void 0 ? isTrayIconEnabled : true);
          if (!isTrayIconEnabled) {
            const t = i18next__default.default.t.bind(i18next__default.default);
            const translate = `taskbar.${overlayDescription}`;
            const taskbarTitle = globalBadge !== undefined ? `(${globalBadge}) ${t(translate)}` : t(translate);
            browserWindow.setTitle(taskbarTitle);
          }
          browserWindow.setOverlayIcon(overlayIcon, overlayDescription);
        }
      });
    }), watch(({
      isMenuBarEnabled
    }) => isMenuBarEnabled, async isMenuBarEnabled => {
      await safeWindowOperation(browserWindow => {
        browserWindow.autoHideMenuBar = !isMenuBarEnabled;
        browserWindow.setMenuBarVisibility(isMenuBarEnabled);
      });
    }));
  }
  electron.app.addListener('before-quit', () => {
    unsubscribers.forEach(unsubscriber => {
      try {
        unsubscriber();
      } catch (error) {
        console.warn('Unsubscriber error during quit:', error);
      }
    });
  });
};
const showRootWindow = async () => {
  const browserWindow = await getRootWindow();
  browserWindow.loadFile(path__default.default.join(electron.app.getAppPath(), 'app/index.html'));
  return new Promise(resolve => {
    browserWindow.once('ready-to-show', () => {
      applyRootWindowState(browserWindow);
      const isTrayIconEnabled = select(({
        isTrayIconEnabled
      }) => isTrayIconEnabled);
      if (electron.app.commandLine.hasSwitch('start-hidden') && isTrayIconEnabled) {
        console.debug('Start application in background');
        browserWindow.hide();
      }
      setupRootWindow();
      resolve();
    });
  });
};
const watchMachineTheme = () => {
  dispatchMachineTheme();
  electron.nativeTheme.on('updated', () => {
    dispatchMachineTheme();
  });
};
const dispatchMachineTheme = () => {
  const isDarkMode = electron.nativeTheme.shouldUseDarkColors;
  dispatch({
    type: APP_MACHINE_THEME_SET,
    payload: isDarkMode ? 'dark' : 'light'
  });
};
const exportLocalStorage = async () => {
  try {
    tempWindow = new electron.BrowserWindow({
      show: false,
      webPreferences
    });
    tempWindow.loadFile(path__default.default.join(electron.app.getAppPath(), 'app/index.html'));
    await new Promise(resolve => {
      tempWindow.once('ready-to-show', () => {
        resolve();
      });
    });
    return tempWindow.webContents.executeJavaScript(`(() => {
      const data = ({...localStorage})
      localStorage.clear();
      return data;
    })()`);
  } catch (error) {
    console.error(error);
    return {};
  }
};

const t$7 = i18next__default.default.t.bind(i18next__default.default);
const askForAppDataReset = async parentWindow => {
  parentWindow === null || parentWindow === void 0 || parentWindow.show();
  const {
    response
  } = await electron.dialog.showMessageBox(parentWindow !== null && parentWindow !== void 0 ? parentWindow : await getRootWindow(), {
    type: 'question',
    buttons: [t$7('dialog.resetAppData.yes'), t$7('dialog.resetAppData.cancel')],
    defaultId: 1,
    title: t$7('dialog.resetAppData.title'),
    message: t$7('dialog.resetAppData.message')
  });
  return response === 0;
};
const askForServerAddition = async (serverUrl, parentWindow) => {
  parentWindow === null || parentWindow === void 0 || parentWindow.show();
  const {
    response
  } = await electron.dialog.showMessageBox(parentWindow !== null && parentWindow !== void 0 ? parentWindow : await getRootWindow(), {
    type: 'question',
    buttons: [t$7('dialog.addServer.add'), t$7('dialog.addServer.cancel')],
    defaultId: 0,
    title: t$7('dialog.addServer.title'),
    message: t$7('dialog.addServer.message', {
      host: serverUrl
    })
  });
  return response === 0;
};
const warnAboutInvalidServerUrl = (_serverUrl, _reason, _parentWindow) => {
  // TODO
  throw Error('not implemented');
};
let AskUpdateInstallResponse = /*#__PURE__*/function (AskUpdateInstallResponse) {
  AskUpdateInstallResponse[AskUpdateInstallResponse["INSTALL_LATER"] = 0] = "INSTALL_LATER";
  AskUpdateInstallResponse[AskUpdateInstallResponse["INSTALL_NOW"] = 1] = "INSTALL_NOW";
  return AskUpdateInstallResponse;
}({});
const askUpdateInstall = async parentWindow => {
  const {
    response
  } = await electron.dialog.showMessageBox(parentWindow !== null && parentWindow !== void 0 ? parentWindow : await getRootWindow(), {
    type: 'question',
    title: t$7('dialog.updateReady.title'),
    message: t$7('dialog.updateReady.message'),
    buttons: [t$7('dialog.updateReady.installLater'), t$7('dialog.updateReady.installNow')],
    defaultId: 1
  });
  if (response === 1) {
    return AskUpdateInstallResponse.INSTALL_NOW;
  }
  return AskUpdateInstallResponse.INSTALL_LATER;
};
const warnAboutInstallUpdateLater = async parentWindow => {
  await electron.dialog.showMessageBox(parentWindow !== null && parentWindow !== void 0 ? parentWindow : await getRootWindow(), {
    type: 'info',
    title: t$7('dialog.updateInstallLater.title'),
    message: t$7('dialog.updateInstallLater.message'),
    buttons: [t$7('dialog.updateInstallLater.ok')],
    defaultId: 0
  });
};
let AskForCertificateTrustResponse = /*#__PURE__*/function (AskForCertificateTrustResponse) {
  AskForCertificateTrustResponse[AskForCertificateTrustResponse["YES"] = 0] = "YES";
  AskForCertificateTrustResponse[AskForCertificateTrustResponse["NO"] = 1] = "NO";
  return AskForCertificateTrustResponse;
}({});
const askForCertificateTrust = async (issuerName, detail, parentWindow) => {
  const {
    response
  } = await electron.dialog.showMessageBox(parentWindow !== null && parentWindow !== void 0 ? parentWindow : await getRootWindow(), {
    title: t$7('dialog.certificateError.title'),
    message: t$7('dialog.certificateError.message', {
      issuerName
    }),
    detail,
    type: 'warning',
    buttons: [t$7('dialog.certificateError.yes'), t$7('dialog.certificateError.no')],
    cancelId: 1,
    defaultId: 1
  });
  if (response === 0) {
    return AskForCertificateTrustResponse.YES;
  }
  return AskForCertificateTrustResponse.NO;
};
const warnAboutUpdateDownload = async parentWindow => {
  await electron.dialog.showMessageBox(parentWindow !== null && parentWindow !== void 0 ? parentWindow : await getRootWindow(), {
    type: 'info',
    title: t$7('dialog.updateDownloading.title'),
    message: t$7('dialog.updateDownloading.message'),
    buttons: [t$7('dialog.updateDownloading.ok')],
    defaultId: 0
  });
};
const warnAboutUpdateSkipped = async parentWindow => {
  await electron.dialog.showMessageBox(parentWindow !== null && parentWindow !== void 0 ? parentWindow : await getRootWindow(), {
    type: 'warning',
    title: t$7('dialog.updateSkip.title'),
    message: t$7('dialog.updateSkip.message'),
    buttons: [t$7('dialog.updateSkip.ok')],
    defaultId: 0
  });
};
const askForOpeningExternalProtocol = async (url, parentWindow) => {
  const {
    response,
    checkboxChecked
  } = await electron.dialog.showMessageBox(parentWindow !== null && parentWindow !== void 0 ? parentWindow : await getRootWindow(), {
    type: 'warning',
    buttons: [t$7('dialog.openingExternalProtocol.yes'), t$7('dialog.openingExternalProtocol.no')],
    defaultId: 1,
    title: t$7('dialog.openingExternalProtocol.title'),
    message: t$7('dialog.openingExternalProtocol.message', {
      protocol: url.protocol
    }),
    detail: t$7('dialog.openingExternalProtocol.detail', {
      url: url.toString()
    }),
    checkboxLabel: t$7('dialog.openingExternalProtocol.dontAskAgain'),
    checkboxChecked: false
  });
  return {
    allowed: response === 0,
    dontAskAgain: checkboxChecked
  };
};
const askForJitsiCaptureScreenPermission = async (url, parentWindow) => {
  const {
    response,
    checkboxChecked
  } = await electron.dialog.showMessageBox(parentWindow !== null && parentWindow !== void 0 ? parentWindow : await getRootWindow(), {
    type: 'warning',
    buttons: [t$7('dialog.allowVideoCallCaptureScreen.yes'), t$7('dialog.allowVideoCallCaptureScreen.no')],
    defaultId: 1,
    title: t$7('dialog.allowVideoCallCaptureScreen.title'),
    message: t$7('dialog.allowVideoCallCaptureScreen.message'),
    detail: t$7('dialog.allowVideoCallCaptureScreen.detail', {
      url: url.toString()
    }),
    checkboxLabel: t$7('dialog.allowVideoCallCaptureScreen.dontAskAgain'),
    checkboxChecked: false
  });
  return {
    allowed: response === 0,
    dontAskAgain: checkboxChecked
  };
};
const askForClearScreenCapturePermission = async parentWindow => {
  parentWindow === null || parentWindow === void 0 || parentWindow.show();
  const {
    response
  } = await electron.dialog.showMessageBox(parentWindow !== null && parentWindow !== void 0 ? parentWindow : await getRootWindow(), {
    type: 'question',
    buttons: [t$7('dialog.clearPermittedScreenCaptureServers.yes'), t$7('dialog.clearPermittedScreenCaptureServers.cancel')],
    defaultId: 1,
    title: t$7('dialog.clearPermittedScreenCaptureServers.title'),
    message: t$7('dialog.clearPermittedScreenCaptureServers.message')
  });
  return response === 0;
};
const askForMediaPermissionSettings = async (permissionType, parentWindow) => {
  parentWindow === null || parentWindow === void 0 || parentWindow.show();
  const {
    response
  } = await electron.dialog.showMessageBox(parentWindow !== null && parentWindow !== void 0 ? parentWindow : await getRootWindow(), {
    type: 'warning',
    buttons: [t$7('dialog.mediaPermission.openSettings'), t$7('dialog.mediaPermission.cancel')],
    defaultId: 0,
    title: t$7('dialog.mediaPermission.title'),
    message: t$7('dialog.mediaPermission.message', {
      permissionType: t$7(`dialog.mediaPermission.${permissionType}`)
    }),
    detail: t$7('dialog.mediaPermission.detail')
  });
  return response === 0;
};

// Cache browsers to avoid repeatedly fetching them
let cachedBrowsers = null;
let browserLoadPromise = null;

/**
 * Lazy load browsers asynchronously
 * This ensures we don't slow down app startup
 */
const loadBrowsersLazy = () => {
  if (cachedBrowsers) {
    return Promise.resolve(cachedBrowsers);
  }
  if (!browserLoadPromise) {
    // Start loading browsers asynchronously after a delay to not block the app startup
    browserLoadPromise = new Promise(resolve => {
      // Delay browser detection for 2 seconds after this function is first called
      // to avoid slowing down app startup and initial interactions
      setTimeout(async () => {
        try {
          const browsers = await detectBrowsers.getAvailableBrowsers();
          cachedBrowsers = browsers;
          const browserIds = browsers.map(browser => browser.browser);
          if (browserIds.length > 0) {
            dispatch({
              type: SETTINGS_AVAILABLE_BROWSERS_UPDATED,
              payload: browserIds
            });
          }
          resolve(browsers);
        } catch (error) {
          console.error('Error detecting browsers:', error);
          resolve([]);
        }
      }, 2000);
    });
  }
  return browserLoadPromise;
};

/**
 * Launches a URL in the selected browser from settings or falls back to system default
 *
 * @param url The URL to open
 * @returns Promise that resolves when the browser is launched
 */
const openExternal = async url => {
  // Get the selected browser from settings
  const selectedBrowser = readSetting('selectedBrowser');

  // If no specific browser is selected, use the system default
  if (!selectedBrowser) {
    return electron.shell.openExternal(url);
  }
  try {
    // Lazy load browsers when needed
    const browsers = await loadBrowsersLazy();

    // Find the selected browser in the available browsers
    const browser = browsers.find(browser => browser.browser === selectedBrowser);
    if (browser) {
      // Launch the selected browser with the URL
      return detectBrowsers.launchBrowser(browser, url);
    }
    // If the selected browser isn't available, fall back to system default
    console.warn(`Selected browser "${selectedBrowser}" not found, using system default.`);
    return electron.shell.openExternal(url);
  } catch (error) {
    console.error('Error launching browser:', error);
    // Fall back to shell.openExternal on error
    return electron.shell.openExternal(url);
  }
};

/**
 * Trigger preloading of browsers in the background
 * Call this function when the app is fully loaded
 */
const preloadBrowsersList = () => {
  // Begin loading browsers in the background after app is ready
  setTimeout(() => {
    loadBrowsersLazy().catch(error => {
      console.error('Failed to preload browsers list:', error);
    });
  }, 5000); // Delay for 5 seconds after this function is called
};

const packageJsonInformation = {
  productName: packageJson.productName,
  goUrlShortener: packageJson.goUrlShortener
};
const electronBuilderJsonInformation = {
  appId: electronBuilderJson.appId,
  protocol: electronBuilderJson.protocols.schemes[0]
};
let isScreenCaptureFallbackForced = false;
const getPlatformName = () => {
  switch (process.platform) {
    case 'win32':
      return 'Windows';
    case 'linux':
      return 'Linux';
    case 'darwin':
      return 'macOS';
    default:
      return 'Unknown';
  }
};
const relaunchApp = (...args) => {
  // For AppImage, use spawn to relaunch because app.relaunch() doesn't work reliably
  if (process.env.APPIMAGE) {
    console.log('Relaunching AppImage:', {
      appImage: process.env.APPIMAGE,
      args
    });

    // Spawn the AppImage as a detached process
    child_process.spawn(process.env.APPIMAGE, args, {
      detached: true,
      stdio: 'ignore'
    }).unref();
    electron.app.exit();
    return;
  }

  // For non-AppImage, use the standard relaunch method
  const command = process.argv.slice(1, electron.app.isPackaged ? 1 : 2);
  electron.app.relaunch({
    args: [...command, ...args]
  });
  electron.app.exit();
};
const performElectronStartup = () => {
  electron.app.setAsDefaultProtocolClient(electronBuilderJsonInformation.protocol);
  electron.app.setAppUserModelId(electronBuilderJsonInformation.appId);
  electron.app.commandLine.appendSwitch('autoplay-policy', 'no-user-gesture-required');
  const disabledChromiumFeatures = ['HardwareMediaKeyHandling', 'MediaSessionService'];
  if (getPlatformName() === 'macOS' && process.mas) {
    electron.app.commandLine.appendSwitch('disable-accelerated-video-decode');
  }
  const args = process.argv.slice(electron.app.isPackaged ? 1 : 2);
  if (args.includes('--reset-app-data')) {
    rimraf.rimraf.sync(electron.app.getPath('userData'));
    relaunchApp();
    return;
  }
  const canStart = process.mas || electron.app.requestSingleInstanceLock();
  if (!canStart) {
    electron.app.exit();
    return;
  }
  const isHardwareAccelerationEnabled = readSetting('isHardwareAccelerationEnabled');
  const isScreenCaptureFallbackEnabled = readSetting('isVideoCallScreenCaptureFallbackEnabled');
  isScreenCaptureFallbackForced = false;
  if (args.includes('--disable-gpu') || isHardwareAccelerationEnabled === false) {
    console.log('Disabling Hardware acceleration');
    electron.app.disableHardwareAcceleration();
    electron.app.commandLine.appendSwitch('disable-2d-canvas-image-chromium');
    electron.app.commandLine.appendSwitch('disable-accelerated-2d-canvas');
    electron.app.commandLine.appendSwitch('disable-gpu');
  }
  if (process.platform === 'win32') {
    const sessionName = process.env.SESSIONNAME;
    const isRdpSession = typeof sessionName === 'string' && sessionName !== 'Console';
    isScreenCaptureFallbackForced = isRdpSession;
    if (isScreenCaptureFallbackEnabled || isRdpSession) {
      console.log('Disabling Windows Graphics Capture for video calls', JSON.stringify({
        reason: isScreenCaptureFallbackEnabled ? 'user-setting' : 'rdp-session',
        sessionName
      }));
      disabledChromiumFeatures.push('WebRtcAllowWgcDesktopCapturer');
      disabledChromiumFeatures.push('WebRtcAllowWgcScreenCapturer');
    }
  }

  // Apply all disabled features in a single call
  electron.app.commandLine.appendSwitch('disable-features', disabledChromiumFeatures.join(','));

  // Enable PipeWire screen capture for Linux (Wayland support)
  if (process.platform === 'linux') {
    var _process$env$ELECTRON;
    electron.app.commandLine.appendSwitch('enable-features', 'WebRTCPipeWireCapturer');

    // Detect display server and force X11 if not in Wayland session
    // This must happen BEFORE Electron tries to auto-select platform
    // to prevent segfaults when Wayland is attempted but unavailable
    const hasOzonePlatformOverride = args.some(arg => arg.startsWith('--ozone-platform=')) || (((_process$env$ELECTRON = process.env.ELECTRON_OZONE_PLATFORM_HINT) === null || _process$env$ELECTRON === void 0 ? void 0 : _process$env$ELECTRON.trim()) || '') !== '';
    if (!hasOzonePlatformOverride) {
      const sessionType = process.env.XDG_SESSION_TYPE;
      const waylandDisplay = process.env.WAYLAND_DISPLAY;

      // Normalize values: trim whitespace and handle empty strings
      const normalizedSessionType = (sessionType === null || sessionType === void 0 ? void 0 : sessionType.trim()) || '';
      const normalizedWaylandDisplay = (waylandDisplay === null || waylandDisplay === void 0 ? void 0 : waylandDisplay.trim()) || '';

      // Only use Wayland if we're actually in a Wayland session AND have a valid socket
      // This covers all edge cases:
      // - X11 sessions (sessionType === 'x11' or unset) → force X11
      // - Invalid session types (tty, mir, etc.) → force X11
      // - Wayland session but no display → force X11
      // - Wayland session but socket doesn't exist → force X11
      const checkWaylandSocket = () => {
        if (normalizedSessionType !== 'wayland' || normalizedWaylandDisplay === '') {
          return false;
        }
        try {
          var _process$getuid, _process$getuid2, _process;
          const runtimeDir = process.env.XDG_RUNTIME_DIR || `/run/user/${(_process$getuid = (_process$getuid2 = (_process = process).getuid) === null || _process$getuid2 === void 0 ? void 0 : _process$getuid2.call(_process)) !== null && _process$getuid !== void 0 ? _process$getuid : 1000}`;
          const socketPath = `${runtimeDir}/${normalizedWaylandDisplay}`;
          const stats = fs__namespace.statSync(socketPath);
          return stats.isSocket();
        } catch {
          return false;
        }
      };
      const isWaylandSession = checkWaylandSocket();
      if (isWaylandSession) {
        console.log('Using Wayland platform', JSON.stringify({
          sessionType: normalizedSessionType,
          waylandDisplay: normalizedWaylandDisplay
        }));
        // Let Electron use Wayland (default auto behavior)
        // Don't set ozone-platform, let Electron auto-detect
      } else {
        let reason;
        if (normalizedSessionType === 'wayland' && normalizedWaylandDisplay !== '') {
          reason = 'socket-not-found';
        } else if (normalizedSessionType === 'wayland') {
          reason = 'no-wayland-display';
        } else if (normalizedSessionType === 'x11') {
          reason = 'x11-session';
        } else if (normalizedSessionType === '') {
          reason = 'no-session-type';
        } else {
          reason = 'invalid-session-type';
        }
        console.log('Forcing X11 platform', JSON.stringify({
          sessionType: normalizedSessionType || 'unset',
          waylandDisplay: normalizedWaylandDisplay || 'unset',
          reason
        }));
        electron.app.commandLine.appendSwitch('ozone-platform', 'x11');
      }
    }
  }
};
const initializeScreenCaptureFallbackState = () => {
  dispatch({
    type: APP_SCREEN_CAPTURE_FALLBACK_FORCED_SET,
    payload: isScreenCaptureFallbackForced
  });
};
const setupGpuCrashHandler = () => {
  if (process.platform !== 'linux') {
    return;
  }
  const args = process.argv.slice(electron.app.isPackaged ? 1 : 2);
  if (args.includes('--disable-gpu')) {
    return;
  }

  // Handle GPU process crashes (runtime failures)
  electron.app.on('child-process-gone', (_event, details) => {
    if (details.type !== 'GPU') {
      return;
    }
    console.log('GPU process crashed, disabling GPU and relaunching with X11');
    const userArgs = process.argv.slice(electron.app.isPackaged ? 1 : 2);
    relaunchApp('--disable-gpu', '--ozone-platform=x11', ...userArgs);
  });

  // Proactive GPU detection: check GPU status once info is available
  electron.app.once('gpu-info-update', () => {
    const gpuFeatures = electron.app.getGPUFeatureStatus();
    const {
      gpu_compositing: gpuCompositing,
      webgl
    } = gpuFeatures;

    // Check if key GPU features are disabled/unavailable (includes _software variants)
    const isGpuBroken = status => !status || status.startsWith('disabled') || status.startsWith('unavailable');
    if (isGpuBroken(gpuCompositing) || isGpuBroken(webgl)) {
      console.log('GPU features unavailable, disabling GPU and relaunching with X11', JSON.stringify(gpuFeatures));
      const userArgs = process.argv.slice(electron.app.isPackaged ? 1 : 2);
      relaunchApp('--disable-gpu', '--ozone-platform=x11', ...userArgs);
      return;
    }
    console.log('GPU features status:', JSON.stringify(gpuFeatures));
  });
};
const setupApp = () => {
  electron.app.addListener('activate', async () => {
    try {
      const browserWindow = await getRootWindow();
      if (!browserWindow.isVisible()) {
        const wasMinimized = browserWindow.isMinimized();
        const wasMaximized = browserWindow.isMaximized();
        browserWindow.showInactive();
        if (wasMinimized) browserWindow.minimize();
        if (wasMaximized) browserWindow.maximize();
      }
      browserWindow.focus();
    } catch (error) {
      console.warn('Could not activate window:', error);
    }
  });
  electron.app.addListener('window-all-closed', () => {
    // Don't quit immediately if this might be caused by video call window closure
    // especially during first launch when main window might not be fully ready
    setTimeout(() => {
      const allWindows = electron.BrowserWindow.getAllWindows();

      // Only quit if there are truly no windows left after a brief delay
      // This prevents crashes when video call window closes before main window is established
      if (allWindows.length === 0) {
        console.log('No windows remaining after delay, quitting application');
        electron.app.quit();
      } else {
        console.log(`${allWindows.length} window(s) still exist, not quitting`);
      }
    }, 100); // Brief delay to let window state stabilize
  });
  electron.app.whenReady().then(() => preloadBrowsersList());
  listen(SETTINGS_SET_HARDWARE_ACCELERATION_OPT_IN_CHANGED, () => {
    relaunchApp();
  });
  listen(SETTINGS_SET_IS_TRANSPARENT_WINDOW_ENABLED_CHANGED, () => {
    relaunchApp();
  });
  listen(SETTINGS_SET_IS_VIDEO_CALL_SCREEN_CAPTURE_FALLBACK_ENABLED_CHANGED, action => {
    const newSettingValue = action.payload;
    const currentPersistedSetting = readSetting('isVideoCallScreenCaptureFallbackEnabled');
    const sessionName = process.env.SESSIONNAME;
    const isRdpSession = typeof sessionName === 'string' && sessionName !== 'Console';
    if (newSettingValue !== currentPersistedSetting && !isRdpSession) {
      relaunchApp();
    } else if (isRdpSession) {
      console.log('Screen Capture Fallback setting changed in RDP session. Change will apply when running locally. No restart needed now since WGC is already disabled by RDP detection.');
    }
  });
  listen(APP_ALLOWED_NTLM_CREDENTIALS_DOMAINS_SET, action => {
    if (action.payload.length > 0) {
      electron.session.defaultSession.allowNTLMCredentialsForDomains(action.payload);
    }
  });
  listen(SETTINGS_NTLM_CREDENTIALS_CHANGED, action => {
    if (action.payload === true) {
      const allowedNTLMCredentialsDomains = readSetting('allowedNTLMCredentialsDomains');
      if (allowedNTLMCredentialsDomains) {
        console.log('Setting NTLM credentials', allowedNTLMCredentialsDomains);
        electron.session.defaultSession.allowNTLMCredentialsForDomains(allowedNTLMCredentialsDomains);
      }
    } else {
      console.log('Clearing NTLM credentials');
      electron.session.defaultSession.allowNTLMCredentialsForDomains('');
    }
  });
  listen(SETTINGS_CLEAR_PERMITTED_SCREEN_CAPTURE_PERMISSIONS, async () => {
    const permitted = await askForClearScreenCapturePermission();
    if (permitted) {
      dispatch({
        type: JITSI_SERVER_CAPTURE_SCREEN_PERMISSIONS_CLEARED,
        payload: {}
      });
    }
  });
  const allowedNTLMCredentialsDomains = readSetting('allowedNTLMCredentialsDomains');
  const isNTLMCredentialsEnabled = readSetting('isNTLMCredentialsEnabled');
  if (isNTLMCredentialsEnabled && allowedNTLMCredentialsDomains.length > 0) {
    console.log('Setting NTLM credentials', allowedNTLMCredentialsDomains);
    electron.session.defaultSession.allowNTLMCredentialsForDomains(allowedNTLMCredentialsDomains);
  }
  dispatch({
    type: APP_PATH_SET,
    payload: electron.app.getAppPath()
  });
  dispatch({
    type: APP_VERSION_SET,
    payload: electron.app.getVersion()
  });
  dispatch({
    type: APP_MAIN_WINDOW_TITLE_SET,
    payload: 'Rocket.Chat'
  });
};

const selectPersistableValues = reselect.createStructuredSelector({
  currentView: ({
    currentView
  }) => currentView,
  doCheckForUpdatesOnStartup: ({
    doCheckForUpdatesOnStartup
  }) => doCheckForUpdatesOnStartup,
  downloads: ({
    downloads
  }) => downloads,
  machineTheme: ({
    machineTheme
  }) => machineTheme,
  isMenuBarEnabled: ({
    isMenuBarEnabled
  }) => isMenuBarEnabled,
  isShowWindowOnUnreadChangedEnabled: ({
    isShowWindowOnUnreadChangedEnabled
  }) => isShowWindowOnUnreadChangedEnabled,
  isSideBarEnabled: ({
    isSideBarEnabled
  }) => isSideBarEnabled,
  isTrayIconEnabled: ({
    isTrayIconEnabled
  }) => isTrayIconEnabled,
  rootWindowState: ({
    rootWindowState
  }) => rootWindowState,
  servers: ({
    servers
  }) => servers,
  skippedUpdateVersion: ({
    skippedUpdateVersion
  }) => skippedUpdateVersion,
  trustedCertificates: ({
    trustedCertificates
  }) => trustedCertificates,
  notTrustedCertificates: ({
    notTrustedCertificates
  }) => notTrustedCertificates,
  isEachUpdatesSettingConfigurable: ({
    isEachUpdatesSettingConfigurable
  }) => isEachUpdatesSettingConfigurable,
  isUpdatingEnabled: ({
    isUpdatingEnabled
  }) => isUpdatingEnabled,
  isHardwareAccelerationEnabled: ({
    isHardwareAccelerationEnabled
  }) => isHardwareAccelerationEnabled,
  externalProtocols: ({
    externalProtocols
  }) => externalProtocols,
  allowedJitsiServers: ({
    allowedJitsiServers
  }) => allowedJitsiServers,
  isReportEnabled: ({
    isReportEnabled
  }) => isReportEnabled,
  isFlashFrameEnabled: ({
    isFlashFrameEnabled
  }) => isFlashFrameEnabled,
  isInternalVideoChatWindowEnabled: ({
    isInternalVideoChatWindowEnabled
  }) => isInternalVideoChatWindowEnabled,
  isMinimizeOnCloseEnabled: ({
    isMinimizeOnCloseEnabled
  }) => isMinimizeOnCloseEnabled,
  isAddNewServersEnabled: ({
    isAddNewServersEnabled
  }) => isAddNewServersEnabled,
  isDeveloperModeEnabled: ({
    isDeveloperModeEnabled
  }) => isDeveloperModeEnabled,
  hasHideOnTrayNotificationShown: ({
    hasHideOnTrayNotificationShown
  }) => hasHideOnTrayNotificationShown,
  lastSelectedServerUrl: ({
    lastSelectedServerUrl
  }) => lastSelectedServerUrl,
  allowedNTLMCredentialsDomains: ({
    allowedNTLMCredentialsDomains
  }) => allowedNTLMCredentialsDomains,
  isNTLMCredentialsEnabled: ({
    isNTLMCredentialsEnabled
  }) => isNTLMCredentialsEnabled,
  mainWindowTitle: ({
    mainWindowTitle
  }) => mainWindowTitle || 'Rocket.Chat',
  selectedBrowser: ({
    selectedBrowser
  }) => selectedBrowser,
  videoCallWindowState: ({
    videoCallWindowState
  }) => videoCallWindowState,
  isVideoCallWindowPersistenceEnabled: ({
    isVideoCallWindowPersistenceEnabled
  }) => isVideoCallWindowPersistenceEnabled,
  isVideoCallDevtoolsAutoOpenEnabled: ({
    isVideoCallDevtoolsAutoOpenEnabled
  }) => isVideoCallDevtoolsAutoOpenEnabled,
  isTransparentWindowEnabled: ({
    isTransparentWindowEnabled
  }) => isTransparentWindowEnabled,
  isVideoCallScreenCaptureFallbackEnabled: ({
    isVideoCallScreenCaptureFallbackEnabled
  }) => isVideoCallScreenCaptureFallbackEnabled,
  updateChannel: ({
    updateChannel
  }) => updateChannel
});

const loadUserDataOverriddenSettings = async () => {
  try {
    const filePath = path__default.default.join(electron.app.getPath('userData'), 'overridden-settings.json');
    const content = await fs__namespace.default.promises.readFile(filePath, 'utf8');
    const json = JSON.parse(content);
    return json && typeof json === 'object' ? json : {};
  } catch (error) {
    return {};
  }
};
const loadAppAsarOverriddenSettings = async () => {
  try {
    const filePath = path__default.default.join(electron.app.getAppPath(), electron.app.getAppPath().endsWith('app.asar') ? '..' : '.', 'overridden-settings.json');
    const content = await fs__namespace.default.promises.readFile(filePath, 'utf8');
    const json = JSON.parse(content);
    return json && typeof json === 'object' ? json : {};
  } catch (error) {
    return {};
  }
};
const mergePersistableValues = async localStorage => {
  var _userRootWindowState$, _values, _userRootWindowState$2, _values2, _userRootWindowState$3, _values3, _userRootWindowState$4, _values4, _userRootWindowState$5, _values5, _userRootWindowState$6, _values6, _userRootWindowState$7, _values7;
  const initialValues = select(selectPersistableValues);
  const electronStoreValues = getPersistedValues();
  const userDataOverriddenSettings = await loadUserDataOverriddenSettings();
  const appAsarOverriddenSettings = await loadAppAsarOverriddenSettings();
  const localStorageValues = Object.fromEntries(Object.entries(localStorage).map(([key, value]) => {
    try {
      return [key, JSON.parse(value)];
    } catch (error) {
      return [];
    }
  }));
  let values = selectPersistableValues({
    ...initialValues,
    ...electronStoreValues,
    ...localStorageValues,
    ...userDataOverriddenSettings,
    ...appAsarOverriddenSettings
  });
  if (localStorage.autohideMenu) {
    values = {
      ...values,
      isMenuBarEnabled: localStorage.autohideMenu !== 'true'
    };
  }
  if (localStorage.showWindowOnUnreadChanged) {
    values = {
      ...values,
      isShowWindowOnUnreadChangedEnabled: localStorage.showWindowOnUnreadChanged === 'true'
    };
  }
  if (localStorage['sidebar-closed']) {
    values = {
      ...values,
      isSideBarEnabled: localStorage['sidebar-closed'] !== 'true'
    };
  }
  if (localStorage.hideTray) {
    values = {
      ...values,
      isTrayIconEnabled: localStorage.hideTray !== 'true'
    };
  }
  const userRootWindowState = await (async () => {
    try {
      const filePath = path__default.default.join(electron.app.getPath('userData'), 'main-window-state.json');
      const content = await fs__namespace.default.promises.readFile(filePath, 'utf8');
      const json = JSON.parse(content);
      await fs__namespace.default.promises.unlink(filePath);
      return json && typeof json === 'object' ? json : {};
    } catch (error) {
      return {};
    }
  })();
  values = {
    ...values,
    rootWindowState: {
      focused: true,
      visible: !((_userRootWindowState$ = userRootWindowState === null || userRootWindowState === void 0 ? void 0 : userRootWindowState.isHidden) !== null && _userRootWindowState$ !== void 0 ? _userRootWindowState$ : !((_values = values) !== null && _values !== void 0 && (_values = _values.rootWindowState) !== null && _values !== void 0 && _values.visible)),
      maximized: (_userRootWindowState$2 = userRootWindowState === null || userRootWindowState === void 0 ? void 0 : userRootWindowState.isMaximized) !== null && _userRootWindowState$2 !== void 0 ? _userRootWindowState$2 : (_values2 = values) === null || _values2 === void 0 || (_values2 = _values2.rootWindowState) === null || _values2 === void 0 ? void 0 : _values2.maximized,
      minimized: (_userRootWindowState$3 = userRootWindowState === null || userRootWindowState === void 0 ? void 0 : userRootWindowState.isMinimized) !== null && _userRootWindowState$3 !== void 0 ? _userRootWindowState$3 : (_values3 = values) === null || _values3 === void 0 || (_values3 = _values3.rootWindowState) === null || _values3 === void 0 ? void 0 : _values3.minimized,
      fullscreen: false,
      normal: !(userRootWindowState !== null && userRootWindowState !== void 0 && userRootWindowState.isMinimized || userRootWindowState !== null && userRootWindowState !== void 0 && userRootWindowState.isMaximized),
      bounds: {
        x: (_userRootWindowState$4 = userRootWindowState === null || userRootWindowState === void 0 ? void 0 : userRootWindowState.x) !== null && _userRootWindowState$4 !== void 0 ? _userRootWindowState$4 : normalizeNumber((_values4 = values) === null || _values4 === void 0 || (_values4 = _values4.rootWindowState) === null || _values4 === void 0 || (_values4 = _values4.bounds) === null || _values4 === void 0 ? void 0 : _values4.x),
        y: (_userRootWindowState$5 = userRootWindowState === null || userRootWindowState === void 0 ? void 0 : userRootWindowState.y) !== null && _userRootWindowState$5 !== void 0 ? _userRootWindowState$5 : normalizeNumber((_values5 = values) === null || _values5 === void 0 || (_values5 = _values5.rootWindowState) === null || _values5 === void 0 || (_values5 = _values5.bounds) === null || _values5 === void 0 ? void 0 : _values5.y),
        width: (_userRootWindowState$6 = userRootWindowState === null || userRootWindowState === void 0 ? void 0 : userRootWindowState.width) !== null && _userRootWindowState$6 !== void 0 ? _userRootWindowState$6 : (_values6 = values) === null || _values6 === void 0 || (_values6 = _values6.rootWindowState) === null || _values6 === void 0 || (_values6 = _values6.bounds) === null || _values6 === void 0 ? void 0 : _values6.width,
        height: (_userRootWindowState$7 = userRootWindowState === null || userRootWindowState === void 0 ? void 0 : userRootWindowState.height) !== null && _userRootWindowState$7 !== void 0 ? _userRootWindowState$7 : (_values7 = values) === null || _values7 === void 0 || (_values7 = _values7.rootWindowState) === null || _values7 === void 0 || (_values7 = _values7.bounds) === null || _values7 === void 0 ? void 0 : _values7.height
      }
    }
  };
  if (!values.isMenuBarEnabled && !values.isSideBarEnabled) {
    values = {
      ...values,
      isSideBarEnabled: true
    };
  }
  dispatch({
    type: APP_SETTINGS_LOADED,
    payload: values
  });
};
const watchAndPersistChanges = () => {
  watch(selectPersistableValues, values => {
    persistValues(values);
  });
};

let ServerUrlResolutionStatus = /*#__PURE__*/function (ServerUrlResolutionStatus) {
  ServerUrlResolutionStatus["OK"] = "ok";
  ServerUrlResolutionStatus["INVALID_URL"] = "invalid-url";
  ServerUrlResolutionStatus["TIMEOUT"] = "timeout";
  ServerUrlResolutionStatus["INVALID"] = "invalid";
  return ServerUrlResolutionStatus;
}({});
const isServerUrlResolutionResult = obj => {
  if (!Array.isArray(obj)) {
    return false;
  }
  return obj.length === 3 && typeof obj[0] === 'string' && [ServerUrlResolutionStatus.INVALID, ServerUrlResolutionStatus.INVALID_URL, ServerUrlResolutionStatus.TIMEOUT].includes(obj[1]) && typeof obj[2] === 'object' || obj.length === 2 && typeof obj[0] === 'string' && obj[1] === ServerUrlResolutionStatus.OK;
};

const t$6 = i18next__default.default.t.bind(i18next__default.default);
const loadUserTrustedCertificates = async () => {
  try {
    const filePath = path__default.default.join(electron.app.getPath('userData'), 'certificate.json');
    const content = await fs__namespace.default.promises.readFile(filePath, 'utf8');
    const json = JSON.parse(content);
    await fs__namespace.default.promises.unlink(filePath);
    return json && typeof json === 'object' ? json : {};
  } catch (error) {
    return {};
  }
};
const serializeCertificate = certificate => `${certificate.issuerName}\n${certificate.data.toString()}`;
const queuedTrustRequests = new Map();
const setupNavigation = async () => {
  electron.app.addListener('certificate-error', async (event, _webContents, requestedUrl, error, certificate, callback) => {
    var _queuedTrustRequests$2, _queuedTrustRequests$3;
    event.preventDefault();
    const serialized = serializeCertificate(certificate);
    const {
      host
    } = new URL(requestedUrl);
    let trustedCertificates = select(({
      trustedCertificates
    }) => trustedCertificates);
    const isTrusted = !!trustedCertificates[host] && trustedCertificates[host] === serialized;
    if (isTrusted) {
      callback(true);
      return;
    }
    let notTrustedCertificates = select(({
      notTrustedCertificates
    }) => notTrustedCertificates);
    const isNotTrusted = !!notTrustedCertificates[host] && notTrustedCertificates[host] === serialized;
    if (isNotTrusted) {
      callback(false);
      return;
    }
    if (queuedTrustRequests.has(certificate.fingerprint)) {
      var _queuedTrustRequests$;
      (_queuedTrustRequests$ = queuedTrustRequests.get(certificate.fingerprint)) === null || _queuedTrustRequests$ === void 0 || _queuedTrustRequests$.push(callback);
      return;
    }
    queuedTrustRequests.set(certificate.fingerprint, [callback]);
    let detail = `URL: ${requestedUrl}\nError: ${error}`;
    if (trustedCertificates[host]) {
      detail = t$6('error.differentCertificate', {
        detail
      });
    }
    const response = await askForCertificateTrust(certificate.issuerName, detail);
    const isTrustedByUser = response;
    (_queuedTrustRequests$2 = queuedTrustRequests.get(certificate.fingerprint)) === null || _queuedTrustRequests$2 === void 0 || _queuedTrustRequests$2.forEach(cb => cb(isTrustedByUser === AskForCertificateTrustResponse.YES));
    queuedTrustRequests.delete(certificate.fingerprint);
    trustedCertificates = select(({
      trustedCertificates
    }) => trustedCertificates);
    if (isTrustedByUser === AskForCertificateTrustResponse.YES) {
      dispatch({
        type: TRUSTED_CERTIFICATES_UPDATED,
        payload: {
          ...trustedCertificates,
          [host]: serialized
        }
      });
    }
    (_queuedTrustRequests$3 = queuedTrustRequests.get(certificate.fingerprint)) === null || _queuedTrustRequests$3 === void 0 || _queuedTrustRequests$3.forEach(cb => cb(isTrustedByUser === AskForCertificateTrustResponse.NO));
    queuedTrustRequests.delete(certificate.fingerprint);
    notTrustedCertificates = select(({
      notTrustedCertificates
    }) => notTrustedCertificates);
    if (isTrustedByUser === AskForCertificateTrustResponse.NO) {
      dispatch({
        type: NOT_TRUSTED_CERTIFICATES_UPDATED,
        payload: {
          ...notTrustedCertificates,
          [host]: serialized
        }
      });
    }
  });
  electron.app.addListener('select-client-certificate', async (event, _webContents, _url, certificateList, callback) => {
    event.preventDefault();
    if (certificateList.length === 1) {
      callback(certificateList[0]);
      return;
    }
    const fingerprint = await request({
      type: CERTIFICATES_CLIENT_CERTIFICATE_REQUESTED,
      payload: JSON.parse(JSON.stringify(certificateList))
    }, SELECT_CLIENT_CERTIFICATE_DIALOG_CERTIFICATE_SELECTED, SELECT_CLIENT_CERTIFICATE_DIALOG_DISMISSED);
    const certificate = certificateList.find(certificate => certificate.fingerprint === fingerprint);
    if (!certificate) {
      callback(undefined);
      return;
    }
    callback(certificate);
  });
  electron.app.addListener('login', (event, _webContents, authenticationResponseDetails, _authInfo, callback) => {
    event.preventDefault();
    const servers = select(({
      servers
    }) => servers);
    for (const server of servers) {
      const {
        host: serverHost,
        username,
        password
      } = new URL(server.url);
      const requestHost = new URL(authenticationResponseDetails.url).host;
      if (serverHost !== requestHost || !username) {
        callback();
        return;
      }
      callback(username, password);
    }
  });
  const trustedCertificates = select(({
    trustedCertificates
  }) => trustedCertificates);
  const userTrustedCertificates = await loadUserTrustedCertificates();
  dispatch({
    type: CERTIFICATES_LOADED,
    payload: {
      ...trustedCertificates,
      ...userTrustedCertificates
    }
  });
};
const isProtocolAllowed = async rawUrl => {
  const url = new URL(rawUrl);
  const instrinsicProtocols = ['http:', 'https:', 'mailto:'];
  const persistedProtocols = Object.entries(select(({
    externalProtocols
  }) => externalProtocols)).filter(([, allowed]) => allowed).map(([protocol]) => protocol);
  const allowedProtocols = [...instrinsicProtocols, ...persistedProtocols];
  if (allowedProtocols.includes(url.protocol)) {
    return true;
  }
  const {
    allowed,
    dontAskAgain
  } = await askForOpeningExternalProtocol(url);
  if (dontAskAgain) {
    dispatch({
      type: EXTERNAL_PROTOCOL_PERMISSION_UPDATED,
      payload: {
        protocol: url.protocol,
        allowed
      }
    });
  }
  return allowed;
};

const computeMediaNeeds = mediaTypes => {
  return {
    needsAudio: mediaTypes.includes('audio'),
    needsVideo: mediaTypes.includes('video')
  };
};
const readMediaStatusesAndInitializeAllowed = async (needsAudio, needsVideo, handleNotDetermined) => {
  let micStatus;
  let camStatus;
  if (needsAudio) {
    micStatus = electron.systemPreferences.getMediaAccessStatus('microphone');
  }
  if (needsVideo) {
    camStatus = electron.systemPreferences.getMediaAccessStatus('camera');
  }
  let microphoneAllowed = !needsAudio || micStatus === 'granted';
  let cameraAllowed = !needsVideo || camStatus === 'granted';
  if (handleNotDetermined) {
    if (micStatus === 'not-determined') {
      microphoneAllowed = await electron.systemPreferences.askForMediaAccess('microphone');
    }
    if (camStatus === 'not-determined') {
      cameraAllowed = await electron.systemPreferences.askForMediaAccess('camera');
    }
  }
  return {
    micStatus,
    camStatus,
    microphoneAllowed,
    cameraAllowed
  };
};
const handleDeniedPermissions = async (parentWindow, micStatus, camStatus, _microphoneAllowed, _cameraAllowed, openers, isDeniedStatus) => {
  const micDenied = isDeniedStatus(micStatus);
  const camDenied = isDeniedStatus(camStatus);
  if (micDenied || camDenied) {
    if (parentWindow && !parentWindow.isDestroyed()) {
      let permissionType;
      if (micDenied && camDenied) {
        permissionType = 'both';
      } else if (micDenied) {
        permissionType = 'microphone';
      } else {
        permissionType = 'camera';
      }
      try {
        const openSettings = await askForMediaPermissionSettings(permissionType, parentWindow);
        if (openSettings) {
          electron.shell.openExternal(openers[permissionType]);
        }
      } catch (error) {
        console.warn('Failed to open media permission settings dialog:', error);
      }
    }
  }
};
const handleMediaPermissionRequest = async (mediaTypes, parentWindow, _actionType, callback) => {
  if (process.platform === 'darwin') {
    const {
      needsAudio,
      needsVideo
    } = computeMediaNeeds(mediaTypes);
    const {
      micStatus,
      camStatus,
      microphoneAllowed,
      cameraAllowed
    } = await readMediaStatusesAndInitializeAllowed(needsAudio, needsVideo, true);
    const openers = {
      microphone: 'x-apple.systempreferences:com.apple.preference.security?Privacy_Microphone',
      camera: 'x-apple.systempreferences:com.apple.preference.security?Privacy_Camera',
      both: 'x-apple.systempreferences:com.apple.preference.security?Privacy_Microphone'
    };
    const isDeniedStatus = status => status === 'denied' || status === 'restricted';
    await handleDeniedPermissions(parentWindow, micStatus, camStatus, microphoneAllowed, cameraAllowed, openers, isDeniedStatus);
    callback(microphoneAllowed && cameraAllowed);
    return;
  }
  if (process.platform === 'win32') {
    const {
      needsAudio,
      needsVideo
    } = computeMediaNeeds(mediaTypes);
    const {
      micStatus,
      camStatus,
      microphoneAllowed,
      cameraAllowed
    } = await readMediaStatusesAndInitializeAllowed(needsAudio, needsVideo, false);
    const openers = {
      microphone: 'ms-settings:privacy-microphone',
      camera: 'ms-settings:privacy-webcam',
      both: 'ms-settings:privacy-microphone'
    };
    const isDeniedStatus = status => status === 'denied';
    await handleDeniedPermissions(parentWindow, micStatus, camStatus, microphoneAllowed, cameraAllowed, openers, isDeniedStatus);
    callback(microphoneAllowed && cameraAllowed);
    return;
  }
  if (process.platform === 'linux') {
    // Linux: Electron's systemPreferences APIs are not available on Linux.
    // Permission handling is delegated to:
    // 1. Browser permission prompts (Chromium will show native permission dialogs)
    // 2. System-level audio configuration (PulseAudio, PipeWire, ALSA)
    // We allow the request and let the browser and OS handle the permission flow.
    callback(true);
    return;
  }

  // Other platforms (unsupported): Allow access and let browser handle permissions
  callback(true);
};

const SPELL_CHECKING_TOGGLED = 'spell-checking/toggled';
const SPELL_CHECKING_LANGUAGE_TOGGLED = 'spell-checking/language-toggled';

const t$5 = i18next__default.default.t.bind(i18next__default.default);
const createSpellCheckingMenuTemplate = (serverViewWebContents, {
  isEditable,
  dictionarySuggestions
}) => {
  if (!isEditable) {
    return [];
  }
  const {
    availableSpellCheckerLanguages
  } = serverViewWebContents.session;
  const spellCheckerLanguages = serverViewWebContents.session.getSpellCheckerLanguages();
  return [...(spellCheckerLanguages.length > 0 && dictionarySuggestions ? [...(dictionarySuggestions.length === 0 ? [{
    label: t$5('contextMenu.noSpellingSuggestions'),
    enabled: false
  }] : dictionarySuggestions.slice(0, 6).map(dictionarySuggestion => ({
    label: dictionarySuggestion,
    click: () => {
      serverViewWebContents.replaceMisspelling(dictionarySuggestion);
    }
  }))), ...(dictionarySuggestions.length > 6 ? [{
    label: t$5('contextMenu.moreSpellingSuggestions'),
    submenu: dictionarySuggestions.slice(6).map(dictionarySuggestion => ({
      label: dictionarySuggestion,
      click: () => {
        serverViewWebContents.replaceMisspelling(dictionarySuggestion);
      }
    }))
  }] : []), {
    type: 'separator'
  }] : []), ...(process.platform === 'darwin' ? [{
    label: t$5('contextMenu.spelling'),
    type: 'checkbox',
    checked: spellCheckerLanguages.length > 0,
    click: ({
      checked
    }) => {
      dispatch({
        type: SPELL_CHECKING_TOGGLED,
        payload: checked
      });
    }
  }] : [{
    label: t$5('contextMenu.spellingLanguages'),
    enabled: availableSpellCheckerLanguages.length > 0,
    submenu: [...availableSpellCheckerLanguages.map(availableSpellCheckerLanguage => ({
      label: availableSpellCheckerLanguage,
      type: 'checkbox',
      checked: spellCheckerLanguages.includes(availableSpellCheckerLanguage),
      click: ({
        checked
      }) => {
        dispatch({
          type: SPELL_CHECKING_LANGUAGE_TOGGLED,
          payload: {
            name: availableSpellCheckerLanguage,
            enabled: checked
          }
        });
      }
    }))]
  }]), {
    type: 'separator'
  }];
};
const createImageMenuTemplate = (serverViewWebContents, {
  mediaType,
  srcURL,
  x,
  y
}) => mediaType === 'image' ? [{
  label: t$5('contextMenu.saveImageAs'),
  click: () => serverViewWebContents.downloadURL(srcURL)
}, {
  label: t$5('contextMenu.copyImage'),
  click: () => serverViewWebContents.copyImageAt(x, y)
}, {
  type: 'separator'
}] : [];
const createLinkMenuTemplate = (_serverViewWebContents, {
  linkURL,
  linkText
}) => linkURL ? [{
  label: t$5('contextMenu.openLink'),
  click: () => {
    isProtocolAllowed(linkURL).then(allowed => {
      if (!allowed) {
        return;
      }
      openExternal(linkURL);
    });
  }
}, {
  label: t$5('contextMenu.copyLinkText'),
  click: () => electron.clipboard.write({
    text: linkText,
    bookmark: linkText
  }),
  enabled: !!linkText
}, {
  label: t$5('contextMenu.copyLinkAddress'),
  click: () => electron.clipboard.write({
    text: linkURL,
    bookmark: linkText
  })
}, {
  type: 'separator'
}] : [];
const createDefaultMenuTemplate = (_serverViewWebContents, {
  editFlags: {
    canUndo = false,
    canRedo = false,
    canCut = false,
    canCopy = false,
    canPaste = false,
    canSelectAll = false
  }
}) => [{
  label: t$5('contextMenu.undo'),
  role: 'undo',
  accelerator: 'CommandOrControl+Z',
  enabled: canUndo
}, {
  label: t$5('contextMenu.redo'),
  role: 'redo',
  accelerator: process.platform === 'win32' ? 'Control+Y' : 'CommandOrControl+Shift+Z',
  enabled: canRedo
}, {
  type: 'separator'
}, {
  label: t$5('contextMenu.cut'),
  role: 'cut',
  accelerator: 'CommandOrControl+X',
  enabled: canCut
}, {
  label: t$5('contextMenu.copy'),
  role: 'copy',
  accelerator: 'CommandOrControl+C',
  enabled: canCopy
}, {
  label: t$5('contextMenu.paste'),
  role: 'paste',
  accelerator: 'CommandOrControl+V',
  enabled: canPaste
}, {
  label: t$5('contextMenu.selectAll'),
  role: 'selectAll',
  accelerator: 'CommandOrControl+A',
  enabled: canSelectAll
}];
const createPopupMenuForServerView = (serverViewWebContents, params) => electron.Menu.buildFromTemplate([...createSpellCheckingMenuTemplate(serverViewWebContents, params), ...createImageMenuTemplate(serverViewWebContents, params), ...createLinkMenuTemplate(serverViewWebContents, params), ...createDefaultMenuTemplate(serverViewWebContents, params)]);

const t$4 = i18next__default.default.t.bind(i18next__default.default);
const webContentsByServerUrl = new Map();
const VIDEO_CALL_PRELOAD_PATH = 'app/preload/preload.js';

/**
 * Determines if a webview is a video call webview based on partition and frame name.
 */
const isVideoCallWebview = (partition, frameName) => {
  if (partition === 'persist:video-call-session') {
    return true;
  }
  if (frameName === 'Video Call') {
    return true;
  }
  return false;
};

/**
 * Resolves and validates preload file paths, falling back to safe defaults.
 * Returns the preload path or null if no valid preload is available.
 */
const resolvePreloadPath = isVideoCall => {
  const appPath = electron.app.getAppPath();
  const defaultPreload = path__default.default.join(appPath, 'app/preload.js');
  const videoCallPreload = path__default.default.join(appPath, VIDEO_CALL_PRELOAD_PATH);
  const targetPreload = isVideoCall ? videoCallPreload : defaultPreload;
  const fallbackPreload = isVideoCall ? defaultPreload : null;
  if (fs__namespace.default.existsSync(targetPreload)) {
    return targetPreload;
  }
  if (fallbackPreload && fs__namespace.default.existsSync(fallbackPreload)) {
    console.warn(`Preload file not found: ${targetPreload}, falling back to: ${fallbackPreload}`);
    return fallbackPreload;
  }
  console.warn(`Preload file not found: ${targetPreload}${fallbackPreload ? ` or fallback: ${fallbackPreload}` : ''}. Preload will be disabled.`);
  return null;
};
const getWebContentsByServerUrl = url => webContentsByServerUrl.get(url);
const getServerUrlByWebContentsId = webContentsId => {
  var _Array$from$find;
  const targetWebContents = electron.webContents.fromId(webContentsId);
  if (!targetWebContents) {
    return undefined;
  }
  return (_Array$from$find = Array.from(webContentsByServerUrl.entries()).find(([, wc]) => wc === targetWebContents)) === null || _Array$from$find === void 0 ? void 0 : _Array$from$find[0];
};
const initializeServerWebContentsAfterReady = (_serverUrl, guestWebContents, rootWindow) => {
  const handleContextMenu = async (event, params) => {
    event.preventDefault();
    const menu = createPopupMenuForServerView(guestWebContents, params);
    menu.popup({
      window: rootWindow
    });
  };
  guestWebContents.addListener('context-menu', handleContextMenu);
  guestWebContents.on('page-title-updated', (_event, pageTitle) => {
    dispatch({
      type: WEBVIEW_PAGE_TITLE_CHANGED,
      payload: {
        url: _serverUrl,
        pageTitle
      }
    });
  });
};
const serverReloadView = async serverUrl => {
  const url = new URL(serverUrl).href;
  const guestWebContents = getWebContentsByServerUrl(url);
  if (!guestWebContents) {
    return;
  }
  try {
    await guestWebContents.loadURL(url);
  } catch (error) {
    console.error('Failed to load URL for guestWebContents:', error);
  }
  dispatch({
    type: WEBVIEW_SERVER_RELOADED,
    payload: {
      url
    }
  });
};
const initializeServerWebContentsAfterAttach = (serverUrl, guestWebContents, rootWindow) => {
  webContentsByServerUrl.set(serverUrl, guestWebContents);
  const webviewSession = guestWebContents.session;
  guestWebContents.addListener('destroyed', () => {
    guestWebContents.removeAllListeners();
    webviewSession.removeAllListeners();
    webContentsByServerUrl.delete(serverUrl);
    const canPurge = select(({
      servers
    }) => !servers.some(server => server.url === serverUrl));
    if (canPurge) {
      webviewSession.clearStorageData();
      return;
    }
    webviewSession.flushStorageData();
  });
  const handleDidStartLoading = () => {
    dispatch({
      type: WEBVIEW_DID_START_LOADING,
      payload: {
        url: serverUrl
      }
    });
    rootWindow.webContents.send(WEBVIEW_DID_START_LOADING, serverUrl);
  };
  const handleDidFailLoad = (_event, errorCode, _errorDescription, _validatedURL, isMainFrame, _frameProcessId, _frameRoutingId) => {
    if (errorCode === -3) {
      console.warn('Ignoring likely spurious did-fail-load with errorCode -3, cf https://github.com/electron/electron/issues/14004');
      return;
    }
    dispatch({
      type: WEBVIEW_DID_FAIL_LOAD,
      payload: {
        url: serverUrl,
        isMainFrame
      }
    });
  };
  const handleDidNavigateInPage = (_event, pageUrl, _isMainFrame, _frameProcessId, _frameRoutingId) => {
    dispatch({
      type: WEBVIEW_DID_NAVIGATE,
      payload: {
        url: serverUrl,
        pageUrl
      }
    });
  };
  const handleBeforeInputEvent = (_event, {
    type,
    key
  }) => {
    if (type !== 'keyUp' && type !== 'keyDown') {
      return;
    }
    const shortcutKey = process.platform === 'darwin' ? 'Meta' : 'Control';
    if (key !== shortcutKey && key !== 'Escape') {
      return;
    }
    rootWindow.webContents.sendInputEvent({
      type,
      keyCode: key,
      modifiers: []
    });
  };
  guestWebContents.addListener('did-start-loading', handleDidStartLoading);
  guestWebContents.addListener('did-fail-load', handleDidFailLoad);
  guestWebContents.addListener('did-navigate-in-page', handleDidNavigateInPage);
  guestWebContents.addListener('before-input-event', handleBeforeInputEvent);
};
const attachGuestWebContentsEvents = async () => {
  const rootWindow = await getRootWindow();
  const handleWillAttachWebview = (_event, webPreferences, _params) => {
    delete webPreferences.enableBlinkFeatures;
    const isVideoCall = isVideoCallWebview(_params.partition, _params.frameName);
    const preloadPath = resolvePreloadPath(isVideoCall);
    if (preloadPath) {
      webPreferences.preload = preloadPath;
    } else {
      delete webPreferences.preload;
    }
    webPreferences.nodeIntegration = false;
    webPreferences.nodeIntegrationInWorker = false;
    webPreferences.nodeIntegrationInSubFrames = false;
    webPreferences.webSecurity = true;
    webPreferences.contextIsolation = true;
    webPreferences.sandbox = false;
  };
  const handleDidAttachWebview = (_event, webContents) => {
    webContents.setWindowOpenHandler(({
      url,
      frameName,
      disposition
    }) => {
      if (disposition === 'foreground-tab' || disposition === 'background-tab') {
        isProtocolAllowed(url).then(allowed => {
          if (!allowed) {
            return {
              action: 'deny'
            };
          }
          openExternal(url);
          return {
            action: 'deny'
          };
        });
        return {
          action: 'deny'
        };
      }
      const isVideoCall = isVideoCallWebview(undefined, frameName);
      const preloadPath = resolvePreloadPath(isVideoCall);
      return {
        action: 'allow',
        overrideBrowserWindowOptions: {
          ...(isVideoCall ? {
            webPreferences: {
              ...(preloadPath ? {
                preload: preloadPath
              } : {}),
              sandbox: false
            }
          } : {}),
          show: false
        }
      };
    });
    webContents.addListener('did-create-window', (window, {
      url,
      frameName,
      disposition,
      referrer,
      postBody
    }) => {
      window.once('ready-to-show', () => {
        window.show();
      });
      isProtocolAllowed(url).then(allowed => {
        if (!allowed) {
          window.destroy();
          return;
        }
        const isGoogleSignIn = frameName === 'Login' && disposition === 'new-window' && new URL(url).hostname.match(/(\.)?google\.com$/);
        window.loadURL(url, {
          userAgent: isGoogleSignIn ? electron.app.userAgentFallback.replace(`Electron/${process.versions.electron} `, '').replace(`${electron.app.name}/${electron.app.getVersion()} `, '') : electron.app.userAgentFallback,
          httpReferrer: referrer,
          ...(postBody && {
            extraHeaders: `Content-Type: ${postBody.contentType}; boundary=${postBody.boundary}`,
            postData: postBody.data
          })
        });
      });
    });
  };
  const handlePermissionRequest = async (_webContents, permission, callback, details) => {
    console.log('Permission request', permission, details);
    switch (permission) {
      case 'media':
        {
          const {
            mediaTypes = []
          } = details;
          await handleMediaPermissionRequest(mediaTypes, rootWindow, 'recordMessage', callback);
          return;
        }
      case 'geolocation':
      case 'notifications':
      case 'midiSysex':
      case 'pointerLock':
      case 'fullscreen':
        callback(true);
        return;
      case 'openExternal':
        {
          if (!details.externalURL) {
            callback(false);
            return;
          }
          const allowed = await isProtocolAllowed(details.externalURL);
          callback(allowed);
          return;
        }
      default:
        callback(false);
    }
  };
  listen(WEBVIEW_READY, action => {
    const guestWebContents = electron.webContents.fromId(action.payload.webContentsId);
    initializeServerWebContentsAfterReady(action.payload.url, guestWebContents, rootWindow);
    guestWebContents.session.setPermissionRequestHandler(handlePermissionRequest);
    // Download handling is now managed by electron-dl in main.ts
    // and integrated with our downloads system via setupDownloads()

    // prevents the webview from navigating because of twitter preview links
    guestWebContents.on('will-navigate', (e, redirectUrl) => {
      const preventNavigateHosts = ['t.co', 'twitter.com'];
      if (preventNavigateHosts.includes(new URL(redirectUrl).hostname)) {
        e.preventDefault();
        isProtocolAllowed(redirectUrl).then(allowed => {
          if (!allowed) {
            return;
          }
          openExternal(redirectUrl);
        });
      }
    });
  });
  listen(WEBVIEW_ATTACHED, action => {
    const guestWebContents = electron.webContents.fromId(action.payload.webContentsId);
    initializeServerWebContentsAfterAttach(action.payload.url, guestWebContents, rootWindow);
  });
  listen(LOADING_ERROR_VIEW_RELOAD_SERVER_CLICKED, action => {
    const guestWebContents = getWebContentsByServerUrl(action.payload.url);
    if (!guestWebContents) {
      return;
    }
    guestWebContents.loadURL(action.payload.url).catch(error => {
      console.error('Failed to load URL for guestWebContents:', error);
    });
  });
  listen(SIDE_BAR_SERVER_RELOAD, action => {
    serverReloadView(action.payload);
  });
  listen(SIDE_BAR_SERVER_COPY_URL, async action => {
    const guestWebContents = getWebContentsByServerUrl(action.payload);
    const currentUrl = await (guestWebContents === null || guestWebContents === void 0 ? void 0 : guestWebContents.getURL());
    electron.clipboard.writeText(currentUrl || '');
  });
  listen(SIDE_BAR_SERVER_OPEN_DEV_TOOLS, action => {
    const guestWebContents = getWebContentsByServerUrl(action.payload);
    guestWebContents === null || guestWebContents === void 0 || guestWebContents.openDevTools();
  });
  listen(SIDE_BAR_SERVER_FORCE_RELOAD, action => {
    const guestWebContents = getWebContentsByServerUrl(action.payload);
    if (!guestWebContents) {
      return;
    }
    dispatch({
      type: CLEAR_CACHE_TRIGGERED,
      payload: guestWebContents.id
    });
  });
  listen(SIDE_BAR_SERVER_REMOVE, action => {
    dispatch({
      type: SIDE_BAR_REMOVE_SERVER_CLICKED,
      payload: action.payload
    });
  });
  listen(SIDE_BAR_CONTEXT_MENU_TRIGGERED, action => {
    const {
      payload: serverUrl
    } = action;
    const menuTemplate = [{
      label: t$4('sidebar.item.reload'),
      click: () => {
        const guestWebContents = getWebContentsByServerUrl(serverUrl);
        if (!guestWebContents) {
          return;
        }
        guestWebContents.loadURL(serverUrl).catch(error => {
          console.error('Failed to load URL for guestWebContents:', error);
        });
        if (serverUrl) {
          dispatch({
            type: WEBVIEW_SERVER_RELOADED,
            payload: {
              url: serverUrl
            }
          });
        }
      }
    }, {
      label: t$4('sidebar.item.remove'),
      click: () => {
        dispatch({
          type: SIDE_BAR_REMOVE_SERVER_CLICKED,
          payload: serverUrl
        });
      }
    }, {
      type: 'separator'
    }, {
      label: t$4('sidebar.item.openDevTools'),
      click: () => {
        const guestWebContents = getWebContentsByServerUrl(serverUrl);
        guestWebContents === null || guestWebContents === void 0 || guestWebContents.openDevTools();
      }
    }, {
      label: t$4('sidebar.item.copyCurrentUrl'),
      click: async () => {
        const guestWebContents = getWebContentsByServerUrl(serverUrl);
        const currentUrl = await (guestWebContents === null || guestWebContents === void 0 ? void 0 : guestWebContents.getURL());
        electron.clipboard.writeText(currentUrl || '');
      }
    }, {
      label: t$4('sidebar.item.reloadClearingCache'),
      click: async () => {
        const guestWebContents = getWebContentsByServerUrl(serverUrl);
        if (!guestWebContents) {
          return;
        }
        dispatch({
          type: CLEAR_CACHE_TRIGGERED,
          payload: guestWebContents.id
        });
      }
    }];
    const menu = electron.Menu.buildFromTemplate(menuTemplate);
    menu.popup({
      window: rootWindow
    });
  });
  listen(CERTIFICATES_CLEARED, () => {
    for (const serverViewWebContents of webContentsByServerUrl.values()) {
      serverViewWebContents.reloadIgnoringCache();
    }
  });
  rootWindow.webContents.addListener('will-attach-webview', handleWillAttachWebview);
  rootWindow.webContents.addListener('did-attach-webview', handleDidAttachWebview);
  handle('server-view/get-url', async webContents => {
    var _Array$from$find2;
    return (_Array$from$find2 = Array.from(webContentsByServerUrl.entries()).find(([, v]) => v === webContents)) === null || _Array$from$find2 === void 0 ? void 0 : _Array$from$find2[0];
  });
  let injectableCode;
  handle('server-view/ready', async webContents => {
    if (!injectableCode) {
      injectableCode = await fs__namespace.default.promises.readFile(path__default.default.join(electron.app.getAppPath(), 'app/injected.js'), 'utf8');
    }
    webContents.executeJavaScript(injectableCode, true);
  });
  handle('server-view/open-url-on-browser', async (_webContents, url) => {
    const allowed = await isProtocolAllowed(url);
    if (!allowed) {
      return;
    }
    openExternal(url);
  });
  listen(WEBVIEW_FORCE_RELOAD_WITH_CACHE_CLEAR, async action => {
    const serverUrl = action.payload;
    const guestWebContents = getWebContentsByServerUrl(serverUrl);
    if (!guestWebContents) {
      return;
    }

    // Clear cache keeping login data using the same method as Force Reload
    await guestWebContents.session.clearCache();
    await guestWebContents.session.clearStorageData({
      storages: ['cookies', 'indexdb', 'filesystem', 'shadercache', 'websql', 'serviceworkers', 'cachestorage']
    });

    // Reload ignoring cache
    guestWebContents.reloadIgnoringCache();
    dispatch({
      type: WEBVIEW_SERVER_RELOADED,
      payload: {
        url: serverUrl
      }
    });
  });
};

// This module contains all the urls used in the app

const rocketchat = {
  site: 'https://rocket.chat',
  subdomain: subdomain => `https://${subdomain}.rocket.chat`
};
const supportedVersions = ({
  domain,
  uniqueId
}) => `https://releases.rocket.chat/v2/server/supportedVersions?domain=${domain}&uniqueId=${uniqueId}&source=desktop`;
const server = serverUrl => ({
  uniqueId: `${serverUrl}api/v1/settings.public?_id=uniqueID`,
  setting: id => `${serverUrl}api/v1/settings.public?query=${encodeURIComponent(JSON.stringify({
    _id: id
  }))}`,
  info: `${serverUrl}api/info`,
  calendarEvents: {
    list: `${serverUrl}api/v1/calendar-events.list`,
    import: `${serverUrl}api/v1/calendar-events.import`,
    update: `${serverUrl}api/v1/calendar-events.update`,
    delete: `${serverUrl}api/v1/calendar-events.delete`
  }
});
const docs = {
  index: 'https://docs.rocket.chat/',
  // TODO: should it be a go link?
  supportedVersions: 'https://go.rocket.chat/i/supported-versions',
  newIssue: 'https://github.com/RocketChat/Rocket.Chat/issues/new' // TODO: should it be a go link?
};

const REQUIRED_SERVER_VERSION_RANGE = '>=2.0.0';
const convertToURL = input => {
  let url;
  if (/^https?:\/\//.test(input)) {
    url = new URL(input);
  } else {
    url = new URL(`https://${input}`);
  }
  const {
    protocol,
    username,
    password,
    hostname,
    port,
    pathname
  } = url;
  return Object.assign(new URL('https://0.0.0.0'), {
    protocol,
    username,
    password,
    hostname,
    port: protocol === 'http' && port === '80' && undefined || protocol === 'https' && port === '443' && undefined || port,
    pathname: /\/$/.test(pathname) ? pathname : `${pathname}/`
  });
};
const fetchServerInformation = async url => {
  const {
    webContents
  } = await getRootWindow();
  const [urlHref, version] = await invoke(webContents, 'servers/fetch-info', url.href);
  return [convertToURL(urlHref), version];
};
const resolveServerUrl = async input => {
  let url;
  try {
    url = convertToURL(input);
  } catch (error) {
    return [input, ServerUrlResolutionStatus.INVALID_URL, error];
  }
  let version;
  try {
    [url, version] = await fetchServerInformation(url);
  } catch (error) {
    if (!(error instanceof Error)) {
      throw error;
    }
    if (!/(^https?:\/\/)|(\.)|(^([^:]+:[^@]+@)?localhost(:\d+)?$)/.test(input)) {
      return resolveServerUrl(rocketchat.subdomain(input));
    }
    if ((error === null || error === void 0 ? void 0 : error.name) === 'AbortError') {
      return [url.href, ServerUrlResolutionStatus.TIMEOUT, error];
    }
    return [url.href, ServerUrlResolutionStatus.INVALID, error];
  }
  const semver = semver$1.coerce(version);
  if (!semver || !semver$1.satisfies(semver, REQUIRED_SERVER_VERSION_RANGE)) {
    return [url.href, ServerUrlResolutionStatus.INVALID, new Error(`incompatible server version (${version}, expected ${REQUIRED_SERVER_VERSION_RANGE})`)];
  }
  return [url.href, ServerUrlResolutionStatus.OK];
};
const loadAppServers = async () => {
  try {
    let filePath = path__default.default.join(electron.app.getAppPath(), electron.app.getAppPath().endsWith('app.asar') ? '..' : '.', 'servers.json');
    if (process.platform === 'darwin') {
      const darwinFilePath = `/Library/Preferences/${packageJsonInformation.productName}/servers.json`;
      if (fs__namespace.default.existsSync(darwinFilePath)) filePath = darwinFilePath;
    }
    const content = await fs__namespace.default.promises.readFile(filePath, 'utf8');
    const json = JSON.parse(content);
    return json && typeof json === 'object' ? json : {};
  } catch (error) {
    return {};
  }
};
const loadUserServers = async () => {
  try {
    const filePath = path__default.default.join(electron.app.getPath('userData'), 'servers.json');
    const content = await fs__namespace.default.promises.readFile(filePath, 'utf8');
    const json = JSON.parse(content);
    await fs__namespace.default.promises.unlink(filePath);
    return json && typeof json === 'object' ? json : {};
  } catch (error) {
    return {};
  }
};
const setupServers = async localStorage => {
  var _ref, _serversMap$get$url, _serversMap$get, _servers$, _servers$2;
  listen(SERVER_URL_RESOLUTION_REQUESTED, async action => {
    if (!hasMeta(action)) {
      return;
    }
    try {
      dispatch({
        type: SERVER_URL_RESOLVED,
        payload: await resolveServerUrl(action.payload),
        meta: {
          response: true,
          id: action.meta.id
        }
      });
    } catch (error) {
      isServerUrlResolutionResult(error) && dispatch({
        type: SERVER_URL_RESOLVED,
        payload: error,
        error: true,
        meta: {
          response: true,
          id: action.meta.id
        }
      });
    }
  });
  listen(WEBVIEW_GIT_COMMIT_HASH_CHECK, async action => {
    const {
      url,
      gitCommitHash
    } = action.payload;
    const servers = select(({
      servers
    }) => servers);
    const server = servers.find(server => server.url === url);
    if ((server === null || server === void 0 ? void 0 : server.gitCommitHash) !== gitCommitHash && (server === null || server === void 0 ? void 0 : server.gitCommitHash) !== undefined) {
      dispatch({
        type: WEBVIEW_GIT_COMMIT_HASH_CHANGED,
        payload: {
          url,
          gitCommitHash
        }
      });
      const guestWebContents = getWebContentsByServerUrl(url);
      await (guestWebContents === null || guestWebContents === void 0 ? void 0 : guestWebContents.session.clearStorageData({
        storages: ['indexdb']
      }));
      await (guestWebContents === null || guestWebContents === void 0 ? void 0 : guestWebContents.session.clearCache());
      guestWebContents === null || guestWebContents === void 0 || guestWebContents.reload();
    }
  });
  let servers = select(({
    servers
  }) => servers);
  let currentServerUrl = select(({
    currentView
  }) => typeof currentView === 'object' ? currentView.url : null);
  const serversMap = new Map(servers.filter(Boolean).filter(({
    url,
    title
  }) => typeof url === 'string' && typeof title === 'string').map(server => [server.url, server]));
  if (localStorage['rocket.chat.hosts']) {
    try {
      const storedString = JSON.parse(localStorage['rocket.chat.hosts']);
      if (/^https?:\/\//.test(storedString)) {
        serversMap.set(storedString, {
          url: storedString,
          title: storedString
        });
      } else {
        const storedValue = JSON.parse(storedString);
        if (Array.isArray(storedValue)) {
          storedValue.map(url => url.replace(/\/$/, '')).forEach(url => {
            serversMap.set(url, {
              url,
              title: url
            });
          });
        }
      }
    } catch (error) {
      console.warn(error);
    }
  }
  if (serversMap.size === 0) {
    const appConfiguration = await loadAppServers();
    for (const [title, url] of Object.entries(appConfiguration)) {
      serversMap.set(url, {
        url,
        title
      });
    }
    const userConfiguration = await loadUserServers();
    for (const [title, url] of Object.entries(userConfiguration)) {
      serversMap.set(url, {
        url,
        title
      });
    }
  }
  if (localStorage['rocket.chat.currentHost'] && localStorage['rocket.chat.currentHost'] !== 'null') {
    currentServerUrl = localStorage['rocket.chat.currentHost'];
  }
  servers = Array.from(serversMap.values());
  currentServerUrl = currentServerUrl ? (_ref = (_serversMap$get$url = (_serversMap$get = serversMap.get(currentServerUrl)) === null || _serversMap$get === void 0 ? void 0 : _serversMap$get.url) !== null && _serversMap$get$url !== void 0 ? _serversMap$get$url : (_servers$ = servers[0]) === null || _servers$ === void 0 ? void 0 : _servers$.url) !== null && _ref !== void 0 ? _ref : null : (_servers$2 = servers[0]) === null || _servers$2 === void 0 ? void 0 : _servers$2.url;
  if (localStorage['rocket.chat.sortOrder']) {
    try {
      const sorting = JSON.parse(localStorage['rocket.chat.sortOrder']);
      if (Array.isArray(sorting)) {
        servers = [...serversMap.values()].sort((a, b) => sorting.indexOf(a.url) - sorting.indexOf(b.url));
      }
    } catch (error) {
      console.warn(error);
    }
  }
  dispatch({
    type: SERVERS_LOADED,
    payload: {
      servers,
      selected: currentServerUrl
    }
  });
};

const isDefinedProtocol = parsedUrl => parsedUrl.protocol === `${electronBuilderJsonInformation.protocol}:`;
const isGoUrlShortener = parsedUrl => parsedUrl.protocol === 'https:' && parsedUrl.hostname === packageJsonInformation.goUrlShortener;
const parseDeepLink = input => {
  if (/^--/.test(input)) {
    // input is a CLI flag
    return null;
  }
  let url;
  try {
    url = new URL(input);
  } catch (error) {
    return null;
  }
  if (isDefinedProtocol(url)) {
    const action = url.hostname;
    const args = url.searchParams;
    return {
      action,
      args
    };
  }
  if (isGoUrlShortener(url)) {
    const action = url.pathname;
    const args = url.searchParams;
    return {
      action,
      args
    };
  }
  return null;
};
let processDeepLinksInArgs = async () => undefined;
const performOnServer = async (url, action) => {
  const [serverUrl, status, error] = await resolveServerUrl(url);
  if (status !== ServerUrlResolutionStatus.OK) {
    var _error$message;
    await warnAboutInvalidServerUrl(serverUrl, (_error$message = error === null || error === void 0 ? void 0 : error.message) !== null && _error$message !== void 0 ? _error$message : '');
    return;
  }
  const isServerAdded = select(({
    servers
  }) => servers.some(server => server.url === serverUrl));
  if (isServerAdded) {
    dispatch({
      type: DEEP_LINKS_SERVER_FOCUSED,
      payload: serverUrl
    });
    await action(serverUrl);
    return;
  }
  const permitted = await askForServerAddition(serverUrl);
  if (!permitted) {
    return;
  }
  dispatch({
    type: DEEP_LINKS_SERVER_ADDED,
    payload: serverUrl
  });
  await action(serverUrl);
};
const getWebContents = serverUrl => new Promise(resolve => {
  const poll = () => {
    const webContents = getWebContentsByServerUrl(serverUrl);
    if (webContents) {
      resolve(webContents);
      return;
    }
    setTimeout(poll, 100);
  };
  poll();
});
const performAuthentication = async ({
  host,
  token,
  userId
}) => performOnServer(host, async serverUrl => {
  const url = new URL('home', serverUrl);
  url.searchParams.append('resumeToken', token);
  url.searchParams.append('userId', userId);
  const webContents = await getWebContents(serverUrl);
  webContents.loadURL(url.href);
});

// https://developer.rocket.chat/rocket.chat/deeplink#channel-group-dm
const performOpenRoom = async ({
  host,
  path,
  token,
  userId
}) => performOnServer(host, async serverUrl => {
  if (!path) {
    return;
  }
  if (!/^\/?(direct|group|channel|livechat)\/[0-9a-zA-Z-_.]+/.test(path)) {
    return;
  }
  const url = new URL(path, serverUrl);
  if (token && userId) {
    url.searchParams.append('resumeToken', token);
    url.searchParams.append('userId', userId);
  }
  const webContents = await getWebContents(serverUrl);
  webContents.loadURL(url.href);
});
const performInvite = async ({
  host,
  path
}) => performOnServer(host, async serverUrl => {
  if (!/^invite\//.test(path)) {
    return;
  }
  const webContents = await getWebContents(serverUrl);
  webContents.loadURL(new URL(path, serverUrl).href);
});
const performConference = async ({
  host,
  path
}) => performOnServer(host, async serverUrl => {
  if (!/^conference\//.test(path)) {
    return;
  }
  const webContents = await getWebContents(serverUrl);
  webContents.loadURL(new URL(path, serverUrl).href);
});
const processDeepLink = async deepLink => {
  const parsedDeepLink = parseDeepLink(deepLink);
  if (!parsedDeepLink) {
    return;
  }
  const {
    action,
    args
  } = parsedDeepLink;
  switch (action) {
    case 'auth':
      {
        var _args$get, _args$get2, _args$get3;
        const host = (_args$get = args.get('host')) !== null && _args$get !== void 0 ? _args$get : undefined;
        const token = (_args$get2 = args.get('token')) !== null && _args$get2 !== void 0 ? _args$get2 : undefined;
        const userId = (_args$get3 = args.get('userId')) !== null && _args$get3 !== void 0 ? _args$get3 : undefined;
        if (host && token && userId) {
          await performAuthentication({
            host,
            token,
            userId
          });
        }
        break;
      }
    case 'room':
      {
        var _args$get4, _args$get5, _args$get6, _args$get7;
        const host = (_args$get4 = args.get('host')) !== null && _args$get4 !== void 0 ? _args$get4 : undefined;
        const path = (_args$get5 = args.get('path')) !== null && _args$get5 !== void 0 ? _args$get5 : undefined;
        const token = (_args$get6 = args.get('token')) !== null && _args$get6 !== void 0 ? _args$get6 : undefined;
        const userId = (_args$get7 = args.get('userId')) !== null && _args$get7 !== void 0 ? _args$get7 : undefined;
        if (host && path) {
          await performOpenRoom({
            host,
            path,
            token,
            userId
          });
        }
        break;
      }
    case 'invite':
      {
        var _args$get8, _args$get9;
        const host = (_args$get8 = args.get('host')) !== null && _args$get8 !== void 0 ? _args$get8 : undefined;
        const path = (_args$get9 = args.get('path')) !== null && _args$get9 !== void 0 ? _args$get9 : undefined;
        if (host && path) {
          await performInvite({
            host,
            path
          });
        }
        break;
      }
    case 'conference':
      {
        var _args$get10, _args$get11;
        const host = (_args$get10 = args.get('host')) !== null && _args$get10 !== void 0 ? _args$get10 : undefined;
        const path = (_args$get11 = args.get('path')) !== null && _args$get11 !== void 0 ? _args$get11 : undefined;
        if (host && path) {
          await performConference({
            host,
            path
          });
        }
        break;
      }
  }
};
const setupDeepLinks = () => {
  electron.app.addListener('open-url', async (event, url) => {
    event.preventDefault();
    const browserWindow = await getRootWindow();
    if (!browserWindow.isVisible()) {
      browserWindow.showInactive();
    }
    browserWindow.focus();
    await processDeepLink(url);
  });
  electron.app.addListener('second-instance', async (event, argv) => {
    event.preventDefault();
    const browserWindow = await getRootWindow();
    if (browserWindow && !browserWindow.isVisible()) {
      browserWindow.showInactive();
    }
    if (browserWindow) browserWindow.focus();
    const args = argv.slice(electron.app.isPackaged ? 1 : 2);
    for (const arg of args) {
      // eslint-disable-next-line no-await-in-loop
      await processDeepLink(arg);
    }
  });
  processDeepLinksInArgs = async () => {
    const args = process.argv.slice(electron.app.isPackaged ? 1 : 2);
    for (const arg of args) {
      // eslint-disable-next-line no-await-in-loop
      await processDeepLink(arg);
    }
  };
};

const startDocumentViewerHandler = () => {
  handle('document-viewer/open-window', async (event, url, _format, _options) => {
    const validUrl = new URL(url);
    const allowedProtocols = ['http:', 'https:'];
    if (!allowedProtocols.includes(validUrl.protocol)) {
      return;
    }
    const server = select(({
      servers
    }) => servers.find(s => new URL(s.url).origin === new URL(event.getURL()).origin));
    if (!server) {
      return;
    }
    dispatch({
      type: SERVER_DOCUMENT_VIEWER_OPEN_URL,
      payload: {
        server: server.url,
        documentUrl: url
      }
    });
  });
  listen(WEBVIEW_PDF_VIEWER_ATTACHED, async action => {
    const webContentsId = action.payload.WebContentsId;
    const webContent = electron.webContents.fromId(webContentsId);
    if (!webContent) {
      return;
    }
    webContent.on('will-navigate', (event, url) => {
      // Only prevent navigation for PDF viewer webviews, not video call windows
      // Check if this is actually a PDF viewer by examining the context
      const currentUrl = webContent.getURL();

      // Skip handling if this is a video call window or not a PDF viewer context
      if (currentUrl.includes('video-call-window.html') || currentUrl.includes('app/video-call-window.html')) {
        return;
      }

      // Also check if the navigation URL is an external protocol (like zoommtg://)
      // that should be handled by the system, not intercepted
      try {
        const navUrl = new URL(url);
        const isExternalProtocol = !['http:', 'https:', 'file:', 'data:', 'about:'].includes(navUrl.protocol);

        // If it's an external protocol, let the system handle it normally
        if (isExternalProtocol) {
          return;
        }
      } catch (e) {
        // If URL parsing fails, let the default handling proceed
        return;
      }
      event.preventDefault();
      setTimeout(() => {
        openExternal(url);
      }, 10);
    });
  });
};

let getAbsoluteUrl;

const NOTIFICATIONS_CREATE_REQUESTED = 'notifications/create-requested';
const NOTIFICATIONS_CREATE_RESPONDED = 'notifications/create-responded';
const NOTIFICATIONS_NOTIFICATION_ACTIONED = 'notifications/notification-actioned';
const NOTIFICATIONS_NOTIFICATION_CLICKED = 'notifications/notification-clicked';
const NOTIFICATIONS_NOTIFICATION_CLOSED = 'notifications/notification-closed';
const NOTIFICATIONS_NOTIFICATION_DISMISSED = 'notifications/notification-dismissed';
const NOTIFICATIONS_NOTIFICATION_REPLIED = 'notifications/notification-replied';
const NOTIFICATIONS_NOTIFICATION_SHOWN = 'notifications/notification-shown';

const normalizeIconUrl = iconUrl => {
  if (/^data:/.test(iconUrl)) {
    return iconUrl;
  }
  if (!/^https?:\/\//.test(iconUrl)) {
    return getAbsoluteUrl(iconUrl);
  }
  return iconUrl;
};
const eventHandlers = new Map();
const createNotification$1 = async ({
  title,
  icon,
  onEvent,
  ...options
}) => {
  const id = await request({
    type: NOTIFICATIONS_CREATE_REQUESTED,
    payload: {
      title,
      ...(icon ? {
        icon: normalizeIconUrl(icon)
      } : {}),
      ...options
    }
  }, NOTIFICATIONS_CREATE_RESPONDED);
  eventHandlers.set(id, event => onEvent === null || onEvent === void 0 ? void 0 : onEvent({
    type: event.type,
    detail: event.detail
  }));
  return id;
};

const items = new Map();
const handleWillDownloadEvent = async (_event, item, serverWebContents) => {
  const itemId = Date.now();
  items.set(itemId, item);
  const server = select(({
    servers
  }) => servers.find(server => server.webContentsId === serverWebContents.id));
  const serverUrl = (server === null || server === void 0 ? void 0 : server.url) || 'unknown';
  const serverTitle = (server === null || server === void 0 ? void 0 : server.title) || 'Unknown Server';
  const downloadPayload = {
    itemId,
    state: item.isPaused() ? 'paused' : item.getState(),
    status: item.isPaused() ? DownloadStatus.PAUSED : DownloadStatus.ALL,
    fileName: item.getFilename(),
    receivedBytes: item.getReceivedBytes(),
    totalBytes: item.getTotalBytes(),
    startTime: item.getStartTime() * 1000,
    endTime: undefined,
    url: item.getURL(),
    serverUrl,
    serverTitle,
    mimeType: item.getMimeType(),
    savePath: item.getSavePath()
  };
  dispatch({
    type: DOWNLOAD_CREATED,
    payload: downloadPayload
  });
  item.on('updated', () => {
    dispatch({
      type: DOWNLOAD_UPDATED,
      payload: {
        itemId,
        state: item.isPaused() ? 'paused' : item.getState(),
        status: item.isPaused() ? DownloadStatus.PAUSED : DownloadStatus.ALL,
        fileName: item.getFilename(),
        receivedBytes: item.getReceivedBytes(),
        totalBytes: item.getTotalBytes(),
        startTime: item.getStartTime() * 1000,
        endTime: Date.now(),
        url: item.getURL(),
        mimeType: item.getMimeType(),
        savePath: item.getSavePath()
      }
    });
  });
  item.on('done', (_event, _state) => {
    dispatch({
      type: DOWNLOAD_UPDATED,
      payload: {
        itemId,
        state: item.getState(),
        status: item.getState() === 'cancelled' ? DownloadStatus.CANCELLED : DownloadStatus.ALL,
        fileName: item.getFilename(),
        receivedBytes: item.getReceivedBytes(),
        totalBytes: item.getTotalBytes(),
        startTime: item.getStartTime() * 1000,
        endTime: Date.now(),
        url: item.getURL(),
        mimeType: item.getMimeType(),
        savePath: item.getSavePath()
      }
    });
    items.delete(itemId);
  });
};
const setupDownloads = () => {
  handle('downloads/show-in-folder', async (_webContents, itemId) => {
    const download = select(({
      downloads
    }) => downloads[itemId]);
    if (!download) {
      return;
    }
    electron.shell.showItemInFolder(download.savePath);
  });
  handle('downloads/copy-link', async (_webContent, itemId) => {
    const download = select(({
      downloads
    }) => downloads[itemId]);
    if (!download) {
      return;
    }
    electron.clipboard.writeText(download.url);
  });
  handle('downloads/pause', async (_webContent, itemId) => {
    if (!items.has(itemId)) {
      return;
    }
    const item = items.get(itemId);
    if (item !== null && item !== void 0 && item.isPaused()) {
      return;
    }
    item === null || item === void 0 || item.pause();
  });
  handle('downloads/resume', async (_webContent, itemId) => {
    if (!items.has(itemId)) {
      return;
    }
    const item = items.get(itemId);
    if (!(item !== null && item !== void 0 && item.canResume())) {
      return;
    }
    item === null || item === void 0 || item.resume();
  });
  handle('downloads/cancel', async (_webContent, itemId) => {
    if (!items.has(itemId)) {
      return;
    }
    const item = items.get(itemId);
    item === null || item === void 0 || item.cancel();
  });
  handle('downloads/retry', async (_webContent, itemId) => {
    var _URL$searchParams$get;
    const {
      download,
      webContentsId
    } = select(({
      downloads,
      servers
    }) => {
      var _servers$find;
      const download = downloads[itemId];
      const {
        webContentsId
      } = (_servers$find = servers.find(server => server.url === download.serverUrl)) !== null && _servers$find !== void 0 ? _servers$find : {};
      return {
        download,
        webContentsId
      };
    });
    const downloadStartTimestamp = new URL(download.url).searchParams.get('X-Amz-Date');
    const expiresIn = (_URL$searchParams$get = new URL(download.url).searchParams.get('X-Amz-Expires')) !== null && _URL$searchParams$get !== void 0 ? _URL$searchParams$get : 120;
    const parsedStartTime = {
      year: downloadStartTimestamp === null || downloadStartTimestamp === void 0 ? void 0 : downloadStartTimestamp.substring(0, 4),
      month: downloadStartTimestamp === null || downloadStartTimestamp === void 0 ? void 0 : downloadStartTimestamp.substring(4, 6),
      day: downloadStartTimestamp === null || downloadStartTimestamp === void 0 ? void 0 : downloadStartTimestamp.substring(6, 8),
      hour: downloadStartTimestamp === null || downloadStartTimestamp === void 0 ? void 0 : downloadStartTimestamp.substring(9, 11),
      minute: downloadStartTimestamp === null || downloadStartTimestamp === void 0 ? void 0 : downloadStartTimestamp.substring(11, 13),
      second: downloadStartTimestamp === null || downloadStartTimestamp === void 0 ? void 0 : downloadStartTimestamp.substring(13, 15)
    };
    const s3Expired = new Date().getTime() > new Date(`${parsedStartTime.year}-${parsedStartTime.month}-${parsedStartTime.day}T${parsedStartTime.hour}:${parsedStartTime.minute}:${parsedStartTime.second}Z`).getTime() + +expiresIn * 1000;
    if (s3Expired) {
      createNotification$1({
        title: i18next.t('downloads.notifications.downloadExpired'),
        body: i18next.t('downloads.notifications.downloadExpiredMessage'),
        subtitle: download.fileName,
        category: 'DOWNLOADS'
      });
      dispatch({
        type: DOWNLOAD_UPDATED,
        payload: {
          ...download,
          state: 'expired',
          status: DownloadStatus.CANCELLED
        }
      });
      return;
    }
    dispatch({
      type: DOWNLOAD_REMOVED,
      payload: itemId
    });
    if (webContentsId && electron.webContents !== undefined) {
      if (electron.webContents.fromId !== undefined) {
        const webContentsInstance = electron.webContents.fromId(webContentsId);
        if (webContentsInstance !== undefined) {
          webContentsInstance.downloadURL(download.url);
        }
      }
    }
  });
  handle('downloads/clear-all', async () => {
    dispatch({
      type: DOWNLOADS_CLEARED
    });
  });
  handle('downloads/remove', async (_webContent, itemId) => {
    if (items.has(itemId)) {
      const item = items.get(itemId);
      item === null || item === void 0 || item.cancel();
    }
    dispatch({
      type: DOWNLOAD_REMOVED,
      payload: itemId
    });
  });
};

// Lazy default download path resolution
let cachedDefaultDownloadPath = null;
function getDefaultDownloadPath() {
  if (cachedDefaultDownloadPath === null) {
    try {
      cachedDefaultDownloadPath = electron.app.getPath('downloads');
    } catch {
      cachedDefaultDownloadPath = os__default.default.tmpdir();
    }
  }
  return cachedDefaultDownloadPath;
}
function isValidDirectory(dir) {
  try {
    return !!dir && fs.existsSync(dir) && fs.statSync(dir).isDirectory();
  } catch {
    return false;
  }
}
const downloadStore = new ElectronStore__default.default({
  name: 'download-preferences',
  schema: {
    lastDownloadDirectory: {
      type: 'string'
    }
  }
});
const setupElectronDlWithTracking = () => {
  electronDl__default.default({
    saveAs: true,
    onStarted: item => {
      try {
        // Set the save dialog options with both directory and filename
        const configuredDir = downloadStore.get('lastDownloadDirectory', getDefaultDownloadPath());
        const lastDownloadDir = configuredDir && isValidDirectory(configuredDir) ? configuredDir : getDefaultDownloadPath();
        const fullPath = path__default.default.join(lastDownloadDir, item.getFilename());
        item.setSaveDialogOptions({
          defaultPath: fullPath
        });

        // Find the webContents that initiated this download
        // According to electron-dl docs, onStarted only receives DownloadItem
        // We need to find an active webContents for tracking purposes
        const webContentsArray = electron.webContents.getAllWebContents();

        // Use the first available webContents for tracking
        let sourceWebContents = null;
        for (const wc of webContentsArray) {
          if (wc && typeof wc.isDestroyed === 'function' && !wc.isDestroyed()) {
            sourceWebContents = wc;
            break;
          }
        }
        if (sourceWebContents) {
          const fakeEvent = {
            defaultPrevented: false,
            preventDefault: () => {}
          };
          handleWillDownloadEvent(fakeEvent, item, sourceWebContents).catch(() => {
            // Silently handle tracking errors
          });
        }
      } catch {
        // Silently handle any other errors in onStarted
      }
    },
    onCompleted: file => {
      try {
        // Remember the directory where the file was saved
        if (file.path) {
          const downloadDirectory = path__default.default.dirname(file.path);
          downloadStore.set('lastDownloadDirectory', downloadDirectory);
        }
        createNotification$1({
          title: i18next.t('downloads.title', {
            defaultValue: 'Downloads'
          }),
          body: file.filename || 'Unknown file',
          subtitle: i18next.t('downloads.notifications.downloadFinished'),
          category: 'DOWNLOADS'
        });
      } catch {
        // Silently handle any errors in onCompleted
      }
    }
  });
};

const DEFAULT_CRITICAL_PATTERNS = ['FATAL', 'Cannot access native module', 'Electron internal error'];
const isCriticalError = error => {
  return DEFAULT_CRITICAL_PATTERNS.some(pattern => {
    var _error$message, _error$stack;
    return ((_error$message = error.message) === null || _error$message === void 0 ? void 0 : _error$message.includes(pattern)) || ((_error$stack = error.stack) === null || _error$stack === void 0 ? void 0 : _error$stack.includes(pattern));
  });
};
let _globalHandlersBound = false;
const setupGlobalErrorHandlers = () => {
  if (_globalHandlersBound) return;
  process.on('uncaughtException', error => {
    console.error('Uncaught Exception:', error);
    if (Bugsnag__default.default.isStarted()) {
      Bugsnag__default.default.notify(error);
    }
    if (isCriticalError(error)) {
      console.error('Critical error detected, app cannot continue');
      electron.app.quit();
    }
  });
  process.on('unhandledRejection', reason => {
    const error = reason instanceof Error ? reason : new Error(`Unhandled Promise Rejection: ${String(reason)}`);
    console.error('Unhandled Promise Rejection:', error);
    if (Bugsnag__default.default.isStarted()) {
      Bugsnag__default.default.notify(error);
    }
    if (isCriticalError(error)) {
      console.error('Critical promise rejection, app cannot continue');
      electron.app.quit();
    }
  });
  _globalHandlersBound = true;
};
const listenToBugsnagEnabledToggle = async appType => {
  {
    return;
  }
};
const setupRendererErrorHandling = async appType => {
  await listenToBugsnagEnabledToggle();
};
const setupMainErrorHandling = async () => {
  setupGlobalErrorHandlers();
  await setupRendererErrorHandling();
};

const I18N_LNG_REQUESTED = 'i18n/lng-requested';
const I18N_LNG_RESPONDED = 'i18n/lng-responded';

const fallbackLng = 'en';
const byteUnits = ['byte', 'kilobyte', 'megabyte', 'gigabyte', 'terabyte', 'petabyte'];
const formatBytes = bytes => {
  const order = Math.min(Math.floor(Math.log(bytes) / Math.log(1024)), byteUnits.length - 1);
  const unit = byteUnits[order];
  if (!unit) {
    return '???';
  }
  const formatter = new Intl.NumberFormat(undefined, {
    notation: 'compact',
    style: 'unit',
    unit,
    maximumFractionDigits: 1
  });
  return formatter.format(bytes / Math.pow(1024, order));
};
const formatByteSpeed = bytesPerSecond => {
  const order = Math.min(Math.floor(Math.log(bytesPerSecond) / Math.log(1024)), byteUnits.length - 1);
  const unit = byteUnits[order];
  if (!unit) {
    return '???';
  }
  const formatter = new Intl.NumberFormat(undefined, {
    notation: 'compact',
    style: 'unit',
    unit: `${unit}-per-second`,
    maximumFractionDigits: 1
  });
  return formatter.format(bytesPerSecond / Math.pow(1024, order));
};
const formatPercentage = ratio => {
  const formatter = new Intl.NumberFormat(undefined, {
    style: 'percent',
    maximumFractionDigits: 0
  });
  return formatter.format(ratio);
};
const formatDuration = duration => {
  const formatter = new Intl.RelativeTimeFormat(undefined, {
    style: 'narrow',
    numeric: 'always'
  });
  duration /= 1000;
  if (duration / 60 < 1) {
    return formatter.format(duration, 'second');
  }
  duration /= 60;
  if (duration / 60 < 1) {
    return formatter.format(duration, 'minute');
  }
  duration /= 60;
  if (duration / 24 < 1) {
    return formatter.format(duration, 'hour');
  }
  duration /= 24;
  if (duration / 7 < 1) {
    return formatter.format(duration, 'day');
  }
  duration /= 7;
  if (duration / 30 < 1) {
    return formatter.format(duration, 'week');
  }
  duration /= 30;
  if (duration / 12 < 1) {
    return formatter.format(duration, 'month');
  }
  duration /= 12;
  return formatter.format(duration, 'year');
};
const interpolation = {
  format: (value, format, lng) => {
    if (value instanceof Date && !Number.isNaN(value.getTime())) {
      return new Intl.DateTimeFormat(lng).format(value);
    }
    switch (format) {
      case 'byteSize':
        return formatBytes(value);
      case 'byteSpeed':
        return formatByteSpeed(value);
      case 'percentage':
        return formatPercentage(value);
      case 'duration':
        return formatDuration(value);
    }
    return String(value);
  }
};

var resources = {
  'de-DE': () => Promise.resolve().then(function () { return require('./de-DE.i18n-Dit6C4kK.js'); }),
  'en': () => Promise.resolve().then(function () { return require('./en.i18n-yTu9CcvG.js'); }),
  'es': () => Promise.resolve().then(function () { return require('./es.i18n-ElGg1WHL.js'); }),
  'fi': () => Promise.resolve().then(function () { return require('./fi.i18n-aoBgNzCt.js'); }),
  'sv': () => Promise.resolve().then(function () { return require('./sv.i18n-hAuWAHhV.js'); }),
  'no': () => Promise.resolve().then(function () { return require('./no.i18n-d7-NyvoU.js'); }),
  'fr': () => Promise.resolve().then(function () { return require('./fr.i18n-xlxgrvr0.js'); }),
  'hu': () => Promise.resolve().then(function () { return require('./hu.i18n-68OzyLj8.js'); }),
  'it-IT': () => Promise.resolve().then(function () { return require('./it-IT.i18n-fQannT1r.js'); }),
  'ja': () => Promise.resolve().then(function () { return require('./ja.i18n-x0gh7Xie.js'); }),
  'pl': () => Promise.resolve().then(function () { return require('./pl.i18n-GpTyPFE3.js'); }),
  'pt-BR': () => Promise.resolve().then(function () { return require('./pt-BR.i18n-gDLGPKy6.js'); }),
  'ru': () => Promise.resolve().then(function () { return require('./ru.i18n-6VkRzdj5.js'); }),
  'tr-TR': () => Promise.resolve().then(function () { return require('./tr-TR.i18n-GmrX7VAX.js'); }),
  'uk-UA': () => Promise.resolve().then(function () { return require('./uk-UA.i18n-Ah5dKRFd.js'); }),
  'zh-CN': () => Promise.resolve().then(function () { return require('./zh-CN.i18n-SdfKVrgS.js'); }),
  'zh-TW': () => Promise.resolve().then(function () { return require('./zh-TW.i18n-dDGpEwdN.js'); })
};

const hasLng = lng => lng in resources;
const getLng = async () => {
  await electron.app.whenReady();
  const locale = electron.app.getSystemLocale();
  let [languageCode, countryCode] = locale.split(/[-_]/);
  if (!languageCode || languageCode.length !== 2) {
    return fallbackLng;
  }
  languageCode = languageCode.toLowerCase();
  const isCountryCodeInexistentOrNonStandard = !countryCode || countryCode.length !== 2;
  countryCode = isCountryCodeInexistentOrNonStandard ? '' : countryCode.toUpperCase();
  const lng = countryCode ? `${languageCode}-${countryCode}` : languageCode;
  if (hasLng(lng)) {
    return lng;
  }
  return Object.keys(resources).find(language => language.startsWith(languageCode));
};
let getLanguage = 'en';
class I18nService extends Service {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "initialization", void 0);
    _defineProperty(this, "t", i18next__default.default.t.bind(i18next__default.default));
  }
  async initializeAsync() {
    const lng = await getLng();
    getLanguage = lng || 'en';
    this.t = await i18next__default.default.init({
      lng,
      fallbackLng,
      resources: {
        ...(lng && lng in resources && {
          [lng]: {
            translation: await resources[lng]()
          }
        }),
        [fallbackLng]: {
          translation: await resources[fallbackLng]()
        }
      },
      interpolation,
      initImmediate: true
    });
  }
  initialize() {
    this.initialization = this.initializeAsync();
    this.listen(I18N_LNG_REQUESTED, action => {
      var _action$meta;
      if (!hasMeta(action) || !action.meta.id) {
        return;
      }
      dispatch({
        type: I18N_LNG_RESPONDED,
        payload: hasLng(i18next__default.default.language) ? i18next__default.default.language : fallbackLng,
        meta: {
          response: true,
          id: (_action$meta = action.meta) === null || _action$meta === void 0 ? void 0 : _action$meta.id
        }
      });
    });
  }
  wait() {
    var _this$initialization;
    return (_this$initialization = this.initialization) !== null && _this$initialization !== void 0 ? _this$initialization : Promise.reject(new Error('not initialized'));
  }
}
var i18n = new I18nService();

var main = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: i18n,
  get getLanguage () { return getLanguage; }
});

const isJitsiServerAllowed = async rawUrl => {
  const url = new URL(rawUrl);
  const persistedServers = Object.entries(select(({
    allowedJitsiServers
  }) => allowedJitsiServers)).filter(([key]) => key === url.host);
  if (persistedServers.length) {
    return {
      allowed: persistedServers[0][1],
      dontAskAgain: true
    };
  }
  const {
    allowed,
    dontAskAgain
  } = await askForJitsiCaptureScreenPermission(url);
  if (dontAskAgain) {
    dispatch({
      type: JITSI_SERVER_CAPTURE_SCREEN_PERMISSION_UPDATED,
      payload: {
        jitsiServer: url.hostname,
        allowed
      }
    });
  }
  return {
    allowed,
    dontAskAgain
  };
};

let permitted = false;
let dontAskAgain = false;
let firstAskPermission = true;
const handleJitsiDesktopCapturerGetSources = () => {
  handle('jitsi-desktop-capturer-get-sources', async (_webContents, [opts, jitsiDomain]) => {
    if (permitted) return electron.desktopCapturer.getSources(opts);
    if (dontAskAgain) return [];
    if (firstAskPermission) {
      firstAskPermission = false;
      const askResult = await isJitsiServerAllowed(jitsiDomain);
      permitted = askResult.allowed;
      dontAskAgain = askResult.dontAskAgain;
    }
    return [];
  });
};

class AttentionDrawingService extends Service {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "activeVoiceNotifications", new Set());
    _defineProperty(this, "bounceId", null);
  }
  async drawAttention(notificationId) {
    if (this.activeVoiceNotifications.has(notificationId)) {
      return;
    }
    const {
      isFlashFrameEnabled
    } = select(({
      isFlashFrameEnabled
    }) => ({
      isFlashFrameEnabled
    }));
    if (!isFlashFrameEnabled) {
      return;
    }
    try {
      const browserWindow = await getRootWindow();
      if (browserWindow.isDestroyed()) {
        return;
      }
      this.activeVoiceNotifications.add(notificationId);
      if (process.platform === 'darwin') {
        if (this.bounceId === null) {
          var _app$dock$bounce, _app$dock;
          this.bounceId = (_app$dock$bounce = (_app$dock = electron.app.dock) === null || _app$dock === void 0 ? void 0 : _app$dock.bounce('critical')) !== null && _app$dock$bounce !== void 0 ? _app$dock$bounce : null;
        }
      } else {
        browserWindow.flashFrame(true);
      }
    } catch (error) {
    }
  }
  async stopAttention(notificationId) {
    if (!this.activeVoiceNotifications.has(notificationId)) {
      return;
    }
    this.activeVoiceNotifications.delete(notificationId);
    if (this.activeVoiceNotifications.size > 0) {
      return;
    }
    if (process.platform === 'darwin' && this.bounceId !== null) {
      var _app$dock2;
      (_app$dock2 = electron.app.dock) === null || _app$dock2 === void 0 || _app$dock2.cancelBounce(this.bounceId);
      this.bounceId = null;
    }
    try {
      const browserWindow = await getRootWindow();
      if (browserWindow.isDestroyed()) {
        return;
      }
      if (process.platform !== 'darwin') {
        browserWindow.flashFrame(false);
      }
    } catch (error) {
    }
  }
  destroy() {
    if (process.platform === 'darwin' && this.bounceId !== null) {
      var _app$dock3;
      (_app$dock3 = electron.app.dock) === null || _app$dock3 === void 0 || _app$dock3.cancelBounce(this.bounceId);
      this.bounceId = null;
    }
  }
}
var attentionDrawing = new AttentionDrawingService();

const resolveIcon = async iconUrl => {
  if (!iconUrl) {
    return undefined;
  }
  if (/^data:/.test(iconUrl)) {
    return electron.nativeImage.createFromDataURL(iconUrl);
  }
  try {
    const {
      webContents
    } = await getRootWindow();
    const dataUri = await invoke(webContents, 'notifications/fetch-icon', iconUrl);
    return electron.nativeImage.createFromDataURL(dataUri);
  } catch (error) {
    console.error(error);
    return undefined;
  }
};
const notifications = new Map();
const notificationTypes = new Map();
const notificationCategories = new Map();
const createNotification = async (id, {
  title,
  subtitle,
  body,
  icon,
  silent,
  canReply,
  actions,
  requireInteraction,
  category
}, ipcMeta) => {
  const notification = new electron.Notification({
    title,
    subtitle,
    body: body !== null && body !== void 0 ? body : '',
    icon: await resolveIcon(icon),
    silent: silent !== null && silent !== void 0 ? silent : undefined,
    hasReply: canReply,
    actions: actions === null || actions === void 0 ? void 0 : actions.map(action => ({
      type: 'button',
      text: action.title
    })),
    ...(requireInteraction !== undefined && {
      requireInteraction
    })
  });
  notification.addListener('show', () => {
    dispatchSingle({
      type: NOTIFICATIONS_NOTIFICATION_SHOWN,
      payload: {
        id
      },
      ipcMeta
    });
    const notificationType = notificationTypes.get(id);
    if (notificationType === 'voice') {
      attentionDrawing.drawAttention(id);
    }
  });
  notification.addListener('close', () => {
    dispatchSingle({
      type: NOTIFICATIONS_NOTIFICATION_CLOSED,
      payload: {
        id
      },
      ipcMeta
    });
    notifications.delete(id);
    const notificationType = notificationTypes.get(id);
    if (notificationType === 'voice') {
      attentionDrawing.stopAttention(id);
    }
    notificationTypes.delete(id);
    notificationCategories.delete(id);
  });
  notification.addListener('click', () => {
    const serverUrl = (ipcMeta === null || ipcMeta === void 0 ? void 0 : ipcMeta.webContentsId) !== undefined ? getServerUrlByWebContentsId(ipcMeta.webContentsId) : undefined;
    const notificationCategory = notificationCategories.get(id);
    dispatchSingle({
      type: NOTIFICATIONS_NOTIFICATION_CLICKED,
      payload: {
        id,
        title,
        ...(serverUrl && {
          serverUrl
        }),
        ...(notificationCategory && {
          category: notificationCategory
        })
      },
      ipcMeta
    });
  });
  notification.addListener('reply', (_event, reply) => {
    dispatchSingle({
      type: NOTIFICATIONS_NOTIFICATION_REPLIED,
      payload: {
        id,
        reply
      },
      ipcMeta
    });
  });
  notification.addListener('action', (_event, index) => {
    dispatchSingle({
      type: NOTIFICATIONS_NOTIFICATION_ACTIONED,
      payload: {
        id,
        index
      },
      ipcMeta
    });
  });
  notifications.set(id, notification);
  if (category) {
    notificationCategories.set(id, category);
  }
  notification.show();
  return id;
};
const updateNotification = async (id, {
  title,
  body,
  silent,
  renotify: _renotify,
  icon,
  requireInteraction,
  notificationType
}) => {
  const notification = notifications.get(id);
  if (!notification) {
    return id;
  }
  if (title !== undefined) {
    notification.title = title;
  }
  if (body !== undefined) {
    notification.body = body;
  }
  if (silent !== undefined) {
    notification.silent = silent;
  }
  if (icon !== undefined) {
    const resolvedIcon = await resolveIcon(icon);
    if (resolvedIcon) {
      notification.icon = resolvedIcon;
    }
  }
  if (requireInteraction !== undefined) {
    notification.requireInteraction = requireInteraction;
  }
  let changedToVoice = false;
  if (notificationType !== undefined) {
    const previousType = notificationTypes.get(id);
    notificationTypes.set(id, notificationType);
    if (previousType === 'voice' && notificationType !== 'voice') {
      attentionDrawing.stopAttention(id);
    } else if (previousType !== 'voice' && notificationType === 'voice') {
      changedToVoice = true;
    }
  }
  notification.show();
  if (changedToVoice) {
    attentionDrawing.drawAttention(id);
  }
  return id;
};
const handleCreateEvent = async ({
  tag,
  ...options
}, ipcMeta) => {
  if (tag && notifications.has(tag)) {
    return updateNotification(tag, options);
  }
  const id = tag || Math.random().toString(36).slice(2);
  notificationTypes.set(id, options.notificationType || 'text');
  return createNotification(id, options, ipcMeta);
};
const setupNotifications = () => {
  listen(NOTIFICATIONS_CREATE_REQUESTED, async action => {
    if (!hasMeta(action)) {
      return;
    }
    dispatch({
      type: NOTIFICATIONS_CREATE_RESPONDED,
      payload: await handleCreateEvent(action.payload, action.ipcMeta),
      meta: {
        id: action.meta.id,
        response: true
      }
    });
  });
  listen(NOTIFICATIONS_NOTIFICATION_DISMISSED, action => {
    var _notifications$get;
    const notificationId = String(action.payload.id);
    const notificationType = notificationTypes.get(notificationId);
    (_notifications$get = notifications.get(notificationId)) === null || _notifications$get === void 0 || _notifications$get.close();
    if (notificationType === 'voice') {
      attentionDrawing.stopAttention(notificationId);
    }
    notificationTypes.delete(notificationId);
  });
};

/**
 * Checks if a version meets or exceeds a minimum required version
 * Safely handles various version string formats by normalizing with semver.coerce
 *
 * @param version The version to check
 * @param minimumVersion The minimum version required
 * @returns boolean Whether the version meets or exceeds the minimum required version
 */
function meetsMinimumVersion(version, minimumVersion) {
  var _coerce;
  if (!version) return false;

  // Coerce version to a valid semver format and use its normalized form
  const normalizedVersion = ((_coerce = semver$1.coerce(version)) === null || _coerce === void 0 ? void 0 : _coerce.version) || '0.0.0';
  return semver$1.gte(normalizedVersion, minimumVersion);
}

/* eslint-disable new-cap */
const getOutlookEvents = async (credentials, date) => {
  try {
    const {
      login,
      password,
      serverUrl
    } = credentials;
    const xhrApi = new xhr.XhrApi({
      decompress: true
    });
    xhrApi.useNtlmAuthentication(login, password);
    ewsJavascriptApi.ConfigurationApi.ConfigureXHR(xhrApi);
    const exchange = new ewsJavascriptApi.ExchangeService(ewsJavascriptApi.ExchangeVersion.Exchange2013);
    // This credentials object isn't used when ntlm is active, but the lib still requires it.
    exchange.Credentials = new ewsJavascriptApi.WebCredentials(login, password);
    exchange.Url = new ewsJavascriptApi.Uri(`${serverUrl}/ews/exchange.asmx`);
    const validatedDate = new Date(date);
    const folderId = new ewsJavascriptApi.FolderId(ewsJavascriptApi.WellKnownFolderName.Calendar);
    const minTime = new ewsJavascriptApi.DateTime(validatedDate.getFullYear(), validatedDate.getMonth() + 1, validatedDate.getDate());
    const maxTime = new ewsJavascriptApi.DateTime(validatedDate.getFullYear(), validatedDate.getMonth() + 1, validatedDate.getDate(), 23, 59, 59);
    const view = new ewsJavascriptApi.CalendarView(minTime, maxTime);
    let appointments = [];
    try {
      appointments = (await exchange.FindAppointments(folderId, view)).Items;
    } catch (error) {
      console.error(error);
      return Promise.reject(error);
    }
    // Filter out appointments that end exactly at midnight
    const filtered = appointments.filter(appointment => appointment.End > minTime);
    if (filtered.length === 0) {
      return [];
    }
    const propertySet = new ewsJavascriptApi.PropertySet(ewsJavascriptApi.BasePropertySet.FirstClassProperties);
    try {
      await exchange.LoadPropertiesForItems(filtered, propertySet);
    } catch (error) {
      return Promise.reject(error);
    }
    return filtered.map(appointment => {
      var _appointment$IsAllDay, _appointment$IsCancel, _appointment$JoinOnli, _appointment$Reminder;
      let description = '';
      try {
        var _appointment$Body;
        if ((_appointment$Body = appointment.Body) !== null && _appointment$Body !== void 0 && _appointment$Body.Text) {
          description = appointment.Body.Text;
        }
      } catch {
        // Ignore errors when the appointment body is missing.
      }

      // Check if the busy status is Busy
      // LegacyFreeBusyStatus enum: Free = 0, Tentative = 1, Busy = 2, OOF = 3
      const isBusy = appointment.LegacyFreeBusyStatus === ewsJavascriptApi.LegacyFreeBusyStatus.Busy;
      return {
        id: appointment.Id.UniqueId,
        subject: appointment.Subject,
        startTime: appointment.Start.ToISOString(),
        endTime: appointment.End.ToISOString(),
        description,
        isAllDay: (_appointment$IsAllDay = appointment.IsAllDayEvent) !== null && _appointment$IsAllDay !== void 0 ? _appointment$IsAllDay : false,
        isCanceled: (_appointment$IsCancel = appointment.IsCancelled) !== null && _appointment$IsCancel !== void 0 ? _appointment$IsCancel : false,
        meetingUrl: (_appointment$JoinOnli = appointment.JoinOnlineMeetingUrl) !== null && _appointment$JoinOnli !== void 0 ? _appointment$JoinOnli : undefined,
        reminderMinutesBeforeStart: (_appointment$Reminder = appointment.ReminderMinutesBeforeStart) !== null && _appointment$Reminder !== void 0 ? _appointment$Reminder : undefined,
        busy: isBusy
      };
    });
  } catch (error) {
    console.error(error);
    return Promise.reject(error);
  }
};

const getServerInformationByWebContentsId = webContentsId => {
  const {
    servers
  } = select(selectPersistableValues);
  const server = servers.find(server => server.webContentsId === webContentsId);
  return server || {};
};
function checkIfCredentialsAreNotEmpty(credentials) {
  return credentials.login.trim() !== '' && credentials.password.trim() !== '' && credentials.userId.trim() !== '' && credentials.serverUrl.trim() !== '';
}
function encryptedCredentials(credentials) {
  return {
    ...credentials,
    login: electron.safeStorage.encryptString(credentials.login).toString('base64'),
    password: electron.safeStorage.encryptString(credentials.password).toString('base64')
  };
}
function decryptedCredentials(credentials) {
  return {
    ...credentials,
    login: electron.safeStorage.decryptString(Buffer.from(credentials.login, 'base64')).toString(),
    password: electron.safeStorage.decryptString(Buffer.from(credentials.password, 'base64')).toString()
  };
}
async function listEventsFromRocketChatServer(serverUrl, userId, token) {
  try {
    const response = await axios__default.default.get(server(serverUrl).calendarEvents.list, {
      headers: {
        'Content-Type': 'application/json',
        'X-Auth-Token': token,
        'X-User-Id': userId
      },
      params: {
        date: new Date().toISOString()
      }
    });
    return response.data;
  } catch (error) {
    console.error('Error sending message:', error);
  }
}
async function createEventOnRocketChatServer(serverUrl, userId, token, event) {
  try {
    // Get server object to check version
    const {
      servers
    } = select(selectPersistableValues);
    const server$1 = servers.find(server => server.url === serverUrl);

    // Base payload
    const payload = {
      externalId: event.id,
      subject: event.subject,
      startTime: event.startTime,
      description: event.description,
      reminderMinutesBeforeStart: event.reminderMinutesBeforeStart
    };

    // Add endTime and busy only for server version 7.5.0 or higher
    if (server$1 !== null && server$1 !== void 0 && server$1.version && meetsMinimumVersion(server$1.version, '7.5.0')) {
      payload.endTime = event.endTime;
      payload.busy = event.busy;
    }
    await axios__default.default.post(server(serverUrl).calendarEvents.import, payload, {
      headers: {
        'Content-Type': 'application/json',
        'X-Auth-Token': token,
        'X-User-Id': userId
      }
    });
  } catch (error) {
    console.error('Error saving event on server:', error);
  }
}
async function updateEventOnRocketChatServer(serverUrl, userId, token, rocketChatEventId, event) {
  try {
    // Get server object to check version
    const {
      servers
    } = select(selectPersistableValues);
    const server$1 = servers.find(server => server.url === serverUrl);

    // Base payload
    const payload = {
      eventId: rocketChatEventId,
      subject: event.subject,
      startTime: event.startTime,
      description: event.description,
      reminderMinutesBeforeStart: event.reminderMinutesBeforeStart
    };

    // Add endTime and busy only for server version 7.5.0 or higher
    if (server$1 !== null && server$1 !== void 0 && server$1.version && meetsMinimumVersion(server$1.version, '7.5.0')) {
      payload.endTime = event.endTime;
      payload.busy = event.busy;
    }
    await axios__default.default.post(server(serverUrl).calendarEvents.update, payload, {
      headers: {
        'Content-Type': 'application/json',
        'X-Auth-Token': token,
        'X-User-Id': userId
      }
    });
  } catch (error) {
    console.error('Error updating event on server:', error);
  }
}
async function deleteEventOnRocketChatServer(serverUrl, userId, token, rocketChatEventId) {
  try {
    await axios__default.default.post(server(serverUrl).calendarEvents.delete, {
      eventId: rocketChatEventId
    }, {
      headers: {
        'Content-Type': 'application/json',
        'X-Auth-Token': token,
        'X-User-Id': userId
      }
    });
  } catch (error) {
    console.error('Error deleting event on server:', error);
  }
}
async function syncEventsWithRocketChatServer(serverUrl, credentials, token) {
  if (!checkIfCredentialsAreNotEmpty(credentials)) return;
  const eventsOnOutlookServer = await getOutlookEvents(credentials, new Date(Date.now()));
  const eventsOnRocketChatServer = await listEventsFromRocketChatServer(serverUrl, credentials.userId, token);
  const appointmentsFound = eventsOnOutlookServer.map(appointment => appointment.id);
  const externalEventsFromRocketChatServer = eventsOnRocketChatServer === null || eventsOnRocketChatServer === void 0 ? void 0 : eventsOnRocketChatServer.data.filter(({
    externalId
  }) => externalId);

  // Get server object to check version
  const {
    servers
  } = select(selectPersistableValues);
  const server = servers.find(server => server.url === serverUrl);
  for await (const appointment of eventsOnOutlookServer) {
    try {
      const alreadyOnRocketChatServer = externalEventsFromRocketChatServer.find(({
        externalId
      }) => externalId === appointment.id);
      const {
        subject,
        startTime,
        description,
        reminderMinutesBeforeStart
      } = appointment;

      // If the appointment is not in the rocket.chat calendar for today, add it.
      if (!alreadyOnRocketChatServer) {
        createEventOnRocketChatServer(serverUrl, credentials.userId, token, appointment);
        continue;
      }

      // If nothing on the event has changed, do nothing.
      if (alreadyOnRocketChatServer.subject === subject && alreadyOnRocketChatServer.startTime === startTime && alreadyOnRocketChatServer.description === description && alreadyOnRocketChatServer.reminderMinutesBeforeStart === reminderMinutesBeforeStart && (!(server !== null && server !== void 0 && server.version) || !meetsMinimumVersion(server.version, '7.5.0') || alreadyOnRocketChatServer.endTime === appointment.endTime && alreadyOnRocketChatServer.busy === appointment.busy)) {
        continue;
      }

      // If the appointment is in the rocket.chat calendar for today, but something has changed, update it.
      await updateEventOnRocketChatServer(serverUrl, credentials.userId, token, alreadyOnRocketChatServer._id, appointment);
    } catch (error) {
      console.error('Error syncing event:', error);
    }
  }
  if (!eventsOnRocketChatServer.data.length) {
    return;
  }
  for await (const event of eventsOnRocketChatServer.data) {
    if (!event.externalId || appointmentsFound.includes(event.externalId)) {
      continue;
    }
    try {
      await deleteEventOnRocketChatServer(serverUrl, credentials.userId, token, event._id);
    } catch (e) {
      console.error(e);
    }
  }
}
let recurringSyncTaskId;
let userAPIToken;
async function maybeSyncEvents(serverToSync) {
  if (!userAPIToken) throw new Error('No user token');
  if (!serverToSync.webContentsId) throw new Error('No webContentsId');
  const server = getServerInformationByWebContentsId(serverToSync.webContentsId);
  if (!server.outlookCredentials) throw new Error('No credentials');
  const credentials = electron.safeStorage.isEncryptionAvailable() ? decryptedCredentials(server.outlookCredentials) : server.outlookCredentials;
  if (!checkIfCredentialsAreNotEmpty(credentials)) throw new Error('Credentials are empty');
  try {
    await syncEventsWithRocketChatServer(server.url, credentials, userAPIToken);
    console.log('Recurring task executed successfully');
  } catch (e) {
    console.error('Error sending events to server', e);
  }
}
async function recurringSyncTask(serverToSync) {
  try {
    console.log('Executing recurring task');
    await maybeSyncEvents(serverToSync);
  } catch (error) {
    console.error('Error occurred:', error);
    clearInterval(recurringSyncTaskId);
  }
}
function startRecurringSyncTask(server) {
  if (!userAPIToken) return;
  recurringSyncTaskId = setInterval(() => recurringSyncTask(server), 60 * 60 * 1000); // minutes * seconds * milliseconds
}
const startOutlookCalendarUrlHandler = () => {
  handle('outlook-calendar/set-user-token', async (event, token, userId) => {
    userAPIToken = token;
    const server = getServerInformationByWebContentsId(event.id);
    if (!server) return;
    const {
      outlookCredentials
    } = server;
    if (!outlookCredentials) return;
    if (outlookCredentials.userId !== userId || !userAPIToken) return;
    if (!checkIfCredentialsAreNotEmpty(outlookCredentials)) return;
    startRecurringSyncTask(server);
    setImmediate(() => {
      try {
        maybeSyncEvents(server);
      } catch (e) {
        console.error('Failed to sync outlook events on startup.', e);
      }
    });
  });
  handle('outlook-calendar/clear-credentials', async event => {
    const server = getServerInformationByWebContentsId(event.id);
    if (!server) return;
    const {
      outlookCredentials
    } = server;
    if (!outlookCredentials) return;
    dispatch({
      type: OUTLOOK_CALENDAR_SAVE_CREDENTIALS,
      payload: {
        url: server.url,
        outlookCredentials: {
          userId: outlookCredentials.userId,
          serverUrl: outlookCredentials.serverUrl,
          login: '',
          password: ''
        }
      }
    });
  });
  handle('outlook-calendar/set-exchange-url', async (event, url, userId) => {
    const server = getServerInformationByWebContentsId(event.id);
    if (!server) return;
    const {
      outlookCredentials
    } = server;
    if ((outlookCredentials === null || outlookCredentials === void 0 ? void 0 : outlookCredentials.userId) !== userId || (outlookCredentials === null || outlookCredentials === void 0 ? void 0 : outlookCredentials.serverUrl) !== url) {
      dispatch({
        type: OUTLOOK_CALENDAR_SAVE_CREDENTIALS,
        payload: {
          url: server.url,
          outlookCredentials: {
            userId,
            serverUrl: url,
            login: '',
            password: ''
          }
        }
      });
    }
  });
  handle('outlook-calendar/has-credentials', async event => {
    const server = getServerInformationByWebContentsId(event.id);
    if (!server) return false;
    const {
      outlookCredentials
    } = server;
    if (!outlookCredentials) return false;
    return checkIfCredentialsAreNotEmpty(outlookCredentials);
  });
  handle('outlook-calendar/get-events', async (event, _date) => {
    const server = getServerInformationByWebContentsId(event.id);
    const {
      outlookCredentials
    } = server;
    if (
    // eslint-disable-next-line @typescript-eslint/prefer-optional-chain
    !outlookCredentials || !outlookCredentials.userId || !outlookCredentials.serverUrl) {
      return Promise.reject(new Error('No credentials'));
    }
    let credentials;
    let saveCredentials = false;
    if (!checkIfCredentialsAreNotEmpty(outlookCredentials)) {
      const response = await request({
        type: OUTLOOK_CALENDAR_ASK_CREDENTIALS,
        payload: {
          server,
          userId: outlookCredentials.userId,
          isEncryptionAvailable: electron.safeStorage.isEncryptionAvailable()
        }
      }, OUTLOOK_CALENDAR_SET_CREDENTIALS, OUTLOOK_CALENDAR_DIALOG_DISMISSED);
      if (response.dismissDialog === true) {
        return {
          status: 'canceled'
        };
      }
      if (!checkIfCredentialsAreNotEmpty(response === null || response === void 0 ? void 0 : response.outlookCredentials)) {
        return Promise.reject(new Error('Invalid credentials'));
      }
      credentials = response.outlookCredentials;
      saveCredentials = response.saveCredentials || false;
    } else {
      credentials = electron.safeStorage.isEncryptionAvailable() ? decryptedCredentials(outlookCredentials) : outlookCredentials;
    }
    try {
      await syncEventsWithRocketChatServer(server.url, credentials, userAPIToken);
    } catch (e) {
      console.error('Error syncing events with Rocket.Chat server', e);
      return Promise.reject(e);
    }
    if (saveCredentials) {
      startRecurringSyncTask(server);
      dispatch({
        type: OUTLOOK_CALENDAR_SAVE_CREDENTIALS,
        payload: {
          url: server.url,
          outlookCredentials: electron.safeStorage.isEncryptionAvailable() ? encryptedCredentials(credentials) : credentials
        }
      });
    }
    return {
      status: 'success'
    };
  });
};

const setupScreenSharing = () => {
  listen(WEBVIEW_SCREEN_SHARING_SOURCE_REQUESTED, requestAction => {
    if (!hasMeta(requestAction) || !requestAction.meta.id) {
      return;
    }
    const predicate = action => isResponseTo(requestAction.meta.id, WEBVIEW_SCREEN_SHARING_SOURCE_RESPONDED, SCREEN_SHARING_DIALOG_DISMISSED)(action);
    const unsubscribe = listen(predicate, responseAction => {
      var _requestAction$meta;
      unsubscribe();
      const sourceId = responseAction.type === WEBVIEW_SCREEN_SHARING_SOURCE_RESPONDED ? responseAction.payload : null;
      dispatch({
        type: WEBVIEW_SCREEN_SHARING_SOURCE_RESPONDED,
        payload: sourceId,
        meta: {
          response: true,
          id: (_requestAction$meta = requestAction.meta) === null || _requestAction$meta === void 0 ? void 0 : _requestAction$meta.id
        }
      });
    });
  });
};

const clearWebviewStorageKeepingLoginData = async guestWebContents => {
  if (!guestWebContents) return;
  await guestWebContents.session.clearCache();
  await guestWebContents.session.clearStorageData({
    storages: ['cookies', 'indexdb', 'filesystem', 'shadercache', 'websql', 'serviceworkers', 'cachestorage']
  });
  guestWebContents === null || guestWebContents === void 0 || guestWebContents.reloadIgnoringCache();
};
const clearWebviewStorageDeletingLoginData = async guestWebContents => {
  if (!guestWebContents) return;
  await guestWebContents.session.clearCache();
  await guestWebContents.session.clearStorageData();
  guestWebContents === null || guestWebContents === void 0 || guestWebContents.reloadIgnoringCache();
};
const handleClearCacheDialog = () => {
  listen(CLEAR_CACHE_DIALOG_KEEP_LOGIN_DATA_CLICKED, async action => {
    const guestWebContents = electron.webContents.fromId(action.payload);
    if (!guestWebContents) {
      return;
    }
    await clearWebviewStorageKeepingLoginData(guestWebContents);
  });
  listen(CLEAR_CACHE_DIALOG_DELETE_LOGIN_DATA_CLICKED, async action => {
    const guestWebContents = electron.webContents.fromId(action.payload);
    if (!guestWebContents) {
      return;
    }
    await clearWebviewStorageDeletingLoginData(guestWebContents);
  });
};

function getDefaultExportFromCjs (x) {
	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
}

const debug$1 = typeof process === 'object' && process.env && process.env.NODE_DEBUG && /\bsemver\b/i.test(process.env.NODE_DEBUG) ? (...args) => console.error('SEMVER', ...args) : () => {};
var debug_1 = debug$1;

// Note: this is the semver.org version of the spec that it implements
// Not necessarily the package version of this code.
const SEMVER_SPEC_VERSION = '2.0.0';
const MAX_LENGTH$1 = 256;
const MAX_SAFE_INTEGER$1 = Number.MAX_SAFE_INTEGER || /* istanbul ignore next */9007199254740991;

// Max safe segment length for coercion.
const MAX_SAFE_COMPONENT_LENGTH = 16;

// Max safe length for a build identifier. The max length minus 6 characters for
// the shortest version with a build 0.0.0+BUILD.
const MAX_SAFE_BUILD_LENGTH = MAX_LENGTH$1 - 6;
const RELEASE_TYPES = ['major', 'premajor', 'minor', 'preminor', 'patch', 'prepatch', 'prerelease'];
var constants = {
  MAX_LENGTH: MAX_LENGTH$1,
  MAX_SAFE_COMPONENT_LENGTH,
  MAX_SAFE_BUILD_LENGTH,
  MAX_SAFE_INTEGER: MAX_SAFE_INTEGER$1,
  RELEASE_TYPES,
  SEMVER_SPEC_VERSION,
  FLAG_INCLUDE_PRERELEASE: 0b001,
  FLAG_LOOSE: 0b010
};

var re$1 = {exports: {}};

(function (module, exports) {
	const {
	  MAX_SAFE_COMPONENT_LENGTH,
	  MAX_SAFE_BUILD_LENGTH,
	  MAX_LENGTH
	} = constants;
	const debug = debug_1;
	exports = module.exports = {};

	// The actual regexps go on exports.re
	const re = exports.re = [];
	const safeRe = exports.safeRe = [];
	const src = exports.src = [];
	const t = exports.t = {};
	let R = 0;
	const LETTERDASHNUMBER = '[a-zA-Z0-9-]';

	// Replace some greedy regex tokens to prevent regex dos issues. These regex are
	// used internally via the safeRe object since all inputs in this library get
	// normalized first to trim and collapse all extra whitespace. The original
	// regexes are exported for userland consumption and lower level usage. A
	// future breaking change could export the safer regex only with a note that
	// all input should have extra whitespace removed.
	const safeRegexReplacements = [['\\s', 1], ['\\d', MAX_LENGTH], [LETTERDASHNUMBER, MAX_SAFE_BUILD_LENGTH]];
	const makeSafeRegex = value => {
	  for (const [token, max] of safeRegexReplacements) {
	    value = value.split(`${token}*`).join(`${token}{0,${max}}`).split(`${token}+`).join(`${token}{1,${max}}`);
	  }
	  return value;
	};
	const createToken = (name, value, isGlobal) => {
	  const safe = makeSafeRegex(value);
	  const index = R++;
	  debug(name, index, value);
	  t[name] = index;
	  src[index] = value;
	  re[index] = new RegExp(value, isGlobal ? 'g' : undefined);
	  safeRe[index] = new RegExp(safe, isGlobal ? 'g' : undefined);
	};

	// The following Regular Expressions can be used for tokenizing,
	// validating, and parsing SemVer version strings.

	// ## Numeric Identifier
	// A single `0`, or a non-zero digit followed by zero or more digits.

	createToken('NUMERICIDENTIFIER', '0|[1-9]\\d*');
	createToken('NUMERICIDENTIFIERLOOSE', '\\d+');

	// ## Non-numeric Identifier
	// Zero or more digits, followed by a letter or hyphen, and then zero or
	// more letters, digits, or hyphens.

	createToken('NONNUMERICIDENTIFIER', `\\d*[a-zA-Z-]${LETTERDASHNUMBER}*`);

	// ## Main Version
	// Three dot-separated numeric identifiers.

	createToken('MAINVERSION', `(${src[t.NUMERICIDENTIFIER]})\\.` + `(${src[t.NUMERICIDENTIFIER]})\\.` + `(${src[t.NUMERICIDENTIFIER]})`);
	createToken('MAINVERSIONLOOSE', `(${src[t.NUMERICIDENTIFIERLOOSE]})\\.` + `(${src[t.NUMERICIDENTIFIERLOOSE]})\\.` + `(${src[t.NUMERICIDENTIFIERLOOSE]})`);

	// ## Pre-release Version Identifier
	// A numeric identifier, or a non-numeric identifier.

	createToken('PRERELEASEIDENTIFIER', `(?:${src[t.NUMERICIDENTIFIER]}|${src[t.NONNUMERICIDENTIFIER]})`);
	createToken('PRERELEASEIDENTIFIERLOOSE', `(?:${src[t.NUMERICIDENTIFIERLOOSE]}|${src[t.NONNUMERICIDENTIFIER]})`);

	// ## Pre-release Version
	// Hyphen, followed by one or more dot-separated pre-release version
	// identifiers.

	createToken('PRERELEASE', `(?:-(${src[t.PRERELEASEIDENTIFIER]}(?:\\.${src[t.PRERELEASEIDENTIFIER]})*))`);
	createToken('PRERELEASELOOSE', `(?:-?(${src[t.PRERELEASEIDENTIFIERLOOSE]}(?:\\.${src[t.PRERELEASEIDENTIFIERLOOSE]})*))`);

	// ## Build Metadata Identifier
	// Any combination of digits, letters, or hyphens.

	createToken('BUILDIDENTIFIER', `${LETTERDASHNUMBER}+`);

	// ## Build Metadata
	// Plus sign, followed by one or more period-separated build metadata
	// identifiers.

	createToken('BUILD', `(?:\\+(${src[t.BUILDIDENTIFIER]}(?:\\.${src[t.BUILDIDENTIFIER]})*))`);

	// ## Full Version String
	// A main version, followed optionally by a pre-release version and
	// build metadata.

	// Note that the only major, minor, patch, and pre-release sections of
	// the version string are capturing groups.  The build metadata is not a
	// capturing group, because it should not ever be used in version
	// comparison.

	createToken('FULLPLAIN', `v?${src[t.MAINVERSION]}${src[t.PRERELEASE]}?${src[t.BUILD]}?`);
	createToken('FULL', `^${src[t.FULLPLAIN]}$`);

	// like full, but allows v1.2.3 and =1.2.3, which people do sometimes.
	// also, 1.0.0alpha1 (prerelease without the hyphen) which is pretty
	// common in the npm registry.
	createToken('LOOSEPLAIN', `[v=\\s]*${src[t.MAINVERSIONLOOSE]}${src[t.PRERELEASELOOSE]}?${src[t.BUILD]}?`);
	createToken('LOOSE', `^${src[t.LOOSEPLAIN]}$`);
	createToken('GTLT', '((?:<|>)?=?)');

	// Something like "2.*" or "1.2.x".
	// Note that "x.x" is a valid xRange identifer, meaning "any version"
	// Only the first item is strictly required.
	createToken('XRANGEIDENTIFIERLOOSE', `${src[t.NUMERICIDENTIFIERLOOSE]}|x|X|\\*`);
	createToken('XRANGEIDENTIFIER', `${src[t.NUMERICIDENTIFIER]}|x|X|\\*`);
	createToken('XRANGEPLAIN', `[v=\\s]*(${src[t.XRANGEIDENTIFIER]})` + `(?:\\.(${src[t.XRANGEIDENTIFIER]})` + `(?:\\.(${src[t.XRANGEIDENTIFIER]})` + `(?:${src[t.PRERELEASE]})?${src[t.BUILD]}?` + `)?)?`);
	createToken('XRANGEPLAINLOOSE', `[v=\\s]*(${src[t.XRANGEIDENTIFIERLOOSE]})` + `(?:\\.(${src[t.XRANGEIDENTIFIERLOOSE]})` + `(?:\\.(${src[t.XRANGEIDENTIFIERLOOSE]})` + `(?:${src[t.PRERELEASELOOSE]})?${src[t.BUILD]}?` + `)?)?`);
	createToken('XRANGE', `^${src[t.GTLT]}\\s*${src[t.XRANGEPLAIN]}$`);
	createToken('XRANGELOOSE', `^${src[t.GTLT]}\\s*${src[t.XRANGEPLAINLOOSE]}$`);

	// Coercion.
	// Extract anything that could conceivably be a part of a valid semver
	createToken('COERCE', `${'(^|[^\\d])' + '(\\d{1,'}${MAX_SAFE_COMPONENT_LENGTH}})` + `(?:\\.(\\d{1,${MAX_SAFE_COMPONENT_LENGTH}}))?` + `(?:\\.(\\d{1,${MAX_SAFE_COMPONENT_LENGTH}}))?` + `(?:$|[^\\d])`);
	createToken('COERCERTL', src[t.COERCE], true);

	// Tilde ranges.
	// Meaning is "reasonably at or greater than"
	createToken('LONETILDE', '(?:~>?)');
	createToken('TILDETRIM', `(\\s*)${src[t.LONETILDE]}\\s+`, true);
	exports.tildeTrimReplace = '$1~';
	createToken('TILDE', `^${src[t.LONETILDE]}${src[t.XRANGEPLAIN]}$`);
	createToken('TILDELOOSE', `^${src[t.LONETILDE]}${src[t.XRANGEPLAINLOOSE]}$`);

	// Caret ranges.
	// Meaning is "at least and backwards compatible with"
	createToken('LONECARET', '(?:\\^)');
	createToken('CARETTRIM', `(\\s*)${src[t.LONECARET]}\\s+`, true);
	exports.caretTrimReplace = '$1^';
	createToken('CARET', `^${src[t.LONECARET]}${src[t.XRANGEPLAIN]}$`);
	createToken('CARETLOOSE', `^${src[t.LONECARET]}${src[t.XRANGEPLAINLOOSE]}$`);

	// A simple gt/lt/eq thing, or just "" to indicate "any version"
	createToken('COMPARATORLOOSE', `^${src[t.GTLT]}\\s*(${src[t.LOOSEPLAIN]})$|^$`);
	createToken('COMPARATOR', `^${src[t.GTLT]}\\s*(${src[t.FULLPLAIN]})$|^$`);

	// An expression to strip any whitespace between the gtlt and the thing
	// it modifies, so that `> 1.2.3` ==> `>1.2.3`
	createToken('COMPARATORTRIM', `(\\s*)${src[t.GTLT]}\\s*(${src[t.LOOSEPLAIN]}|${src[t.XRANGEPLAIN]})`, true);
	exports.comparatorTrimReplace = '$1$2$3';

	// Something like `1.2.3 - 1.2.4`
	// Note that these all use the loose form, because they'll be
	// checked against either the strict or loose comparator form
	// later.
	createToken('HYPHENRANGE', `^\\s*(${src[t.XRANGEPLAIN]})` + `\\s+-\\s+` + `(${src[t.XRANGEPLAIN]})` + `\\s*$`);
	createToken('HYPHENRANGELOOSE', `^\\s*(${src[t.XRANGEPLAINLOOSE]})` + `\\s+-\\s+` + `(${src[t.XRANGEPLAINLOOSE]})` + `\\s*$`);

	// Star ranges basically just allow anything at all.
	createToken('STAR', '(<|>)?=?\\s*\\*');
	// >=0.0.0 is like a star
	createToken('GTE0', '^\\s*>=\\s*0\\.0\\.0\\s*$');
	createToken('GTE0PRE', '^\\s*>=\\s*0\\.0\\.0-0\\s*$'); 
} (re$1, re$1.exports));

var reExports = re$1.exports;

// parse out just the options we care about
const looseOption = Object.freeze({
  loose: true
});
const emptyOpts = Object.freeze({});
const parseOptions$1 = options => {
  if (!options) {
    return emptyOpts;
  }
  if (typeof options !== 'object') {
    return looseOption;
  }
  return options;
};
var parseOptions_1 = parseOptions$1;

const numeric = /^[0-9]+$/;
const compareIdentifiers$1 = (a, b) => {
  const anum = numeric.test(a);
  const bnum = numeric.test(b);
  if (anum && bnum) {
    a = +a;
    b = +b;
  }
  return a === b ? 0 : anum && !bnum ? -1 : bnum && !anum ? 1 : a < b ? -1 : 1;
};
const rcompareIdentifiers = (a, b) => compareIdentifiers$1(b, a);
var identifiers = {
  compareIdentifiers: compareIdentifiers$1,
  rcompareIdentifiers
};

const debug = debug_1;
const {
  MAX_LENGTH,
  MAX_SAFE_INTEGER
} = constants;
const {
  safeRe: re,
  t: t$3
} = reExports;
const parseOptions = parseOptions_1;
const {
  compareIdentifiers
} = identifiers;
let SemVer$1 = class SemVer {
  constructor(version, options) {
    options = parseOptions(options);
    if (version instanceof SemVer) {
      if (version.loose === !!options.loose && version.includePrerelease === !!options.includePrerelease) {
        return version;
      } else {
        version = version.version;
      }
    } else if (typeof version !== 'string') {
      throw new TypeError(`Invalid version. Must be a string. Got type "${typeof version}".`);
    }
    if (version.length > MAX_LENGTH) {
      throw new TypeError(`version is longer than ${MAX_LENGTH} characters`);
    }
    debug('SemVer', version, options);
    this.options = options;
    this.loose = !!options.loose;
    // this isn't actually relevant for versions, but keep it so that we
    // don't run into trouble passing this.options around.
    this.includePrerelease = !!options.includePrerelease;
    const m = version.trim().match(options.loose ? re[t$3.LOOSE] : re[t$3.FULL]);
    if (!m) {
      throw new TypeError(`Invalid Version: ${version}`);
    }
    this.raw = version;

    // these are actually numbers
    this.major = +m[1];
    this.minor = +m[2];
    this.patch = +m[3];
    if (this.major > MAX_SAFE_INTEGER || this.major < 0) {
      throw new TypeError('Invalid major version');
    }
    if (this.minor > MAX_SAFE_INTEGER || this.minor < 0) {
      throw new TypeError('Invalid minor version');
    }
    if (this.patch > MAX_SAFE_INTEGER || this.patch < 0) {
      throw new TypeError('Invalid patch version');
    }

    // numberify any prerelease numeric ids
    if (!m[4]) {
      this.prerelease = [];
    } else {
      this.prerelease = m[4].split('.').map(id => {
        if (/^[0-9]+$/.test(id)) {
          const num = +id;
          if (num >= 0 && num < MAX_SAFE_INTEGER) {
            return num;
          }
        }
        return id;
      });
    }
    this.build = m[5] ? m[5].split('.') : [];
    this.format();
  }
  format() {
    this.version = `${this.major}.${this.minor}.${this.patch}`;
    if (this.prerelease.length) {
      this.version += `-${this.prerelease.join('.')}`;
    }
    return this.version;
  }
  toString() {
    return this.version;
  }
  compare(other) {
    debug('SemVer.compare', this.version, this.options, other);
    if (!(other instanceof SemVer)) {
      if (typeof other === 'string' && other === this.version) {
        return 0;
      }
      other = new SemVer(other, this.options);
    }
    if (other.version === this.version) {
      return 0;
    }
    return this.compareMain(other) || this.comparePre(other);
  }
  compareMain(other) {
    if (!(other instanceof SemVer)) {
      other = new SemVer(other, this.options);
    }
    return compareIdentifiers(this.major, other.major) || compareIdentifiers(this.minor, other.minor) || compareIdentifiers(this.patch, other.patch);
  }
  comparePre(other) {
    if (!(other instanceof SemVer)) {
      other = new SemVer(other, this.options);
    }

    // NOT having a prerelease is > having one
    if (this.prerelease.length && !other.prerelease.length) {
      return -1;
    } else if (!this.prerelease.length && other.prerelease.length) {
      return 1;
    } else if (!this.prerelease.length && !other.prerelease.length) {
      return 0;
    }
    let i = 0;
    do {
      const a = this.prerelease[i];
      const b = other.prerelease[i];
      debug('prerelease compare', i, a, b);
      if (a === undefined && b === undefined) {
        return 0;
      } else if (b === undefined) {
        return 1;
      } else if (a === undefined) {
        return -1;
      } else if (a === b) {
        continue;
      } else {
        return compareIdentifiers(a, b);
      }
    } while (++i);
  }
  compareBuild(other) {
    if (!(other instanceof SemVer)) {
      other = new SemVer(other, this.options);
    }
    let i = 0;
    do {
      const a = this.build[i];
      const b = other.build[i];
      debug('prerelease compare', i, a, b);
      if (a === undefined && b === undefined) {
        return 0;
      } else if (b === undefined) {
        return 1;
      } else if (a === undefined) {
        return -1;
      } else if (a === b) {
        continue;
      } else {
        return compareIdentifiers(a, b);
      }
    } while (++i);
  }

  // preminor will bump the version up to the next minor release, and immediately
  // down to pre-release. premajor and prepatch work the same way.
  inc(release, identifier, identifierBase) {
    switch (release) {
      case 'premajor':
        this.prerelease.length = 0;
        this.patch = 0;
        this.minor = 0;
        this.major++;
        this.inc('pre', identifier, identifierBase);
        break;
      case 'preminor':
        this.prerelease.length = 0;
        this.patch = 0;
        this.minor++;
        this.inc('pre', identifier, identifierBase);
        break;
      case 'prepatch':
        // If this is already a prerelease, it will bump to the next version
        // drop any prereleases that might already exist, since they are not
        // relevant at this point.
        this.prerelease.length = 0;
        this.inc('patch', identifier, identifierBase);
        this.inc('pre', identifier, identifierBase);
        break;
      // If the input is a non-prerelease version, this acts the same as
      // prepatch.
      case 'prerelease':
        if (this.prerelease.length === 0) {
          this.inc('patch', identifier, identifierBase);
        }
        this.inc('pre', identifier, identifierBase);
        break;
      case 'major':
        // If this is a pre-major version, bump up to the same major version.
        // Otherwise increment major.
        // 1.0.0-5 bumps to 1.0.0
        // 1.1.0 bumps to 2.0.0
        if (this.minor !== 0 || this.patch !== 0 || this.prerelease.length === 0) {
          this.major++;
        }
        this.minor = 0;
        this.patch = 0;
        this.prerelease = [];
        break;
      case 'minor':
        // If this is a pre-minor version, bump up to the same minor version.
        // Otherwise increment minor.
        // 1.2.0-5 bumps to 1.2.0
        // 1.2.1 bumps to 1.3.0
        if (this.patch !== 0 || this.prerelease.length === 0) {
          this.minor++;
        }
        this.patch = 0;
        this.prerelease = [];
        break;
      case 'patch':
        // If this is not a pre-release version, it will increment the patch.
        // If it is a pre-release it will bump up to the same patch version.
        // 1.2.0-5 patches to 1.2.0
        // 1.2.0 patches to 1.2.1
        if (this.prerelease.length === 0) {
          this.patch++;
        }
        this.prerelease = [];
        break;
      // This probably shouldn't be used publicly.
      // 1.0.0 'pre' would become 1.0.0-0 which is the wrong direction.
      case 'pre':
        {
          const base = Number(identifierBase) ? 1 : 0;
          if (!identifier && identifierBase === false) {
            throw new Error('invalid increment argument: identifier is empty');
          }
          if (this.prerelease.length === 0) {
            this.prerelease = [base];
          } else {
            let i = this.prerelease.length;
            while (--i >= 0) {
              if (typeof this.prerelease[i] === 'number') {
                this.prerelease[i]++;
                i = -2;
              }
            }
            if (i === -1) {
              // didn't increment anything
              if (identifier === this.prerelease.join('.') && identifierBase === false) {
                throw new Error('invalid increment argument: identifier already exists');
              }
              this.prerelease.push(base);
            }
          }
          if (identifier) {
            // 1.2.0-beta.1 bumps to 1.2.0-beta.2,
            // 1.2.0-beta.fooblz or 1.2.0-beta bumps to 1.2.0-beta.0
            let prerelease = [identifier, base];
            if (identifierBase === false) {
              prerelease = [identifier];
            }
            if (compareIdentifiers(this.prerelease[0], identifier) === 0) {
              if (isNaN(this.prerelease[1])) {
                this.prerelease = prerelease;
              }
            } else {
              this.prerelease = prerelease;
            }
          }
          break;
        }
      default:
        throw new Error(`invalid increment argument: ${release}`);
    }
    this.raw = this.format();
    if (this.build.length) {
      this.raw += `+${this.build.join('.')}`;
    }
    return this;
  }
};
var semver = SemVer$1;

const SemVer = semver;
const compare$1 = (a, b, loose) => new SemVer(a, loose).compare(new SemVer(b, loose));
var compare_1 = compare$1;

const compare = compare_1;
const gte = (a, b, loose) => compare(a, b, loose) >= 0;
var gte_1 = gte;

var semverGte = /*@__PURE__*/getDefaultExportFromCjs(gte_1);

const publicKey = `-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAvZ/T/RHOr6+yo/iMLUlf
agMiMLFxQR/5Qtc85ykMBvKZqbBGb9zU68VB9n54alrbZG5FdcHkSJXgJIBXF2bk
TGTfBi58JmltZirSWzvXoXnT4ieGNZv+BqnP9zzj9HXOVhVncbRmJPEIJOZfL9AQ
beix3rPgZx3ZepAaoMQnz11dZKDGzkMN75WkTdf324X3DeFgLVmjsYuAcLl/AJMA
uPKSSt0XOQUsfrT7rEqXIrj8rIJcWxIHICMRrwfjw2Qh+3pfIrh7XSzxlW4zCKBN
RpavrrCnpOFRfkC5T9eMKLgyapjufOtbjuzu25N3urBsg6oRFNzsGXWp1C7DwUO2
kwIDAQAB
-----END PUBLIC KEY-----`;
const decodeSupportedVersions = token => jwt__default.default.verify(token, publicKey, {
  algorithms: ['RS256']
});
const supportedVersionsStore = new ElectronStore__default.default({
  name: 'supportedVersions'
});
let builtinSupportedVersions;
const getBuiltinSupportedVersions = async () => {
  if (builtinSupportedVersions) return builtinSupportedVersions;
  try {
    const filePath = node_path.join(__dirname, 'supportedVersions.jwt');
    const encodedToken = await promises.readFile(filePath, 'utf8');
    builtinSupportedVersions = decodeSupportedVersions(encodedToken);
    return builtinSupportedVersions;
  } catch (e) {
    console.error('Error loading supportedVersions.jwt', e);
    return undefined;
  }
};
const logRequestError = description => error => {
  if (axios__default.default.isAxiosError(error)) {
    if (error.response) {
      console.error(`Couldn't load ${description}: ${error.response.status} ${error.response.data}`);
    } else {
      // Something happened in setting up the request that triggered an Error
      console.error(`Couldn't load ${description}: ${error.message}`);
    }
  } else {
    console.error('Fetching ${description} error:', error);
  }
  return undefined;
};
const getCacheKey = serverUrl => `supportedVersions:${serverUrl}`;
const loadFromCache = serverUrl => {
  try {
    const cached = supportedVersionsStore.get(getCacheKey(serverUrl));
    if (!cached) return undefined;
    return cached;
  } catch (error) {
    console.warn(`Error loading cache for ${serverUrl}:`, error);
    return undefined;
  }
};
const saveToCache = (serverUrl, data) => {
  try {
    supportedVersionsStore.set(getCacheKey(serverUrl), data);
  } catch (error) {
    console.warn(`Error saving cache for ${serverUrl}:`, error);
  }
};
const withRetries = async (fetchFn, maxAttempts = 3, delayMs = 2000) => {
  const attempt = async attemptNumber => {
    try {
      const result = await fetchFn();
      if (result !== undefined) {
        return result;
      }
    } catch (error) {
      // Log but continue to next attempt
      if (attemptNumber === maxAttempts) {
        // Last attempt failed
        return undefined;
      }
    }

    // If we haven't exhausted attempts, wait then try again
    if (attemptNumber < maxAttempts) {
      await new Promise(resolve => setTimeout(resolve, delayMs));
      return attempt(attemptNumber + 1);
    }
    return undefined;
  };
  return attempt(1);
};
const getCloudInfo = async (url, uniqueId) => {
  const domain = new URL(url).hostname;
  const response = await axios__default.default.get(supportedVersions({
    domain,
    uniqueId
  }));
  return response.data;
};
const getServerInfo = async url => {
  const response = await axios__default.default.get(server(url).info);
  return response.data;
};
const getUniqueId = async (url, version) => {
  var _coerce;
  const validVersion = ((_coerce = semver$1.coerce((version === null || version === void 0 ? void 0 : version.trim()) || '0.0.0')) === null || _coerce === void 0 ? void 0 : _coerce.version) || '0.0.0';
  const serverUrl = semverGte(validVersion, '7.0.0') ? server(url).uniqueId : server(url).setting('uniqueID');
  try {
    var _response$data;
    const response = await axios__default.default.get(serverUrl);
    const value = (_response$data = response.data) === null || _response$data === void 0 || (_response$data = _response$data.settings) === null || _response$data === void 0 || (_response$data = _response$data[0]) === null || _response$data === void 0 ? void 0 : _response$data.value;
    if (!value) {
      console.warn(`No unique ID found for server ${url}`);
      return null;
    }
    return value;
  } catch (error) {
    console.warn(`Error fetching unique ID for server ${url}:`, error);
    return null;
  }
};
const dispatchVersionUpdated = url => info => {
  dispatch({
    type: WEBVIEW_SERVER_VERSION_UPDATED,
    payload: {
      url,
      version: info.version
    }
  });
  return info;
};
const dispatchUniqueIdUpdated = url => uniqueID => {
  if (uniqueID) {
    dispatch({
      type: WEBVIEW_SERVER_UNIQUE_ID_UPDATED,
      payload: {
        url,
        uniqueID
      }
    });
  }
  return uniqueID;
};
const dispatchSupportedVersionsUpdated = (url, supportedVersions, {
  source
}) => {
  dispatch({
    type: WEBVIEW_SERVER_SUPPORTED_VERSIONS_UPDATED,
    payload: {
      url,
      supportedVersions,
      source
    }
  });
};
const updateSupportedVersionsData = async serverUrl => {
  const server = select(({
    servers
  }) => servers.find(server => server.url === serverUrl));
  if (!server) return;

  // Dispatch loading state
  dispatch({
    type: WEBVIEW_SERVER_SUPPORTED_VERSIONS_LOADING,
    payload: {
      url: serverUrl
    }
  });
  const builtinSupportedVersions = await getBuiltinSupportedVersions();

  // Fetch server info with retries (3x with 2s delays)
  const serverInfoResult = await withRetries(() => getServerInfo(server.url), 3, 2000);
  let serverEncoded;
  if (serverInfoResult) {
    var _serverInfoResult$sup;
    dispatchVersionUpdated(server.url)(serverInfoResult);
    serverEncoded = (_serverInfoResult$sup = serverInfoResult.supportedVersions) === null || _serverInfoResult$sup === void 0 ? void 0 : _serverInfoResult$sup.signed;

    // Try Server with retries (3x with 2s delays)
    if (serverEncoded) {
      try {
        const serverSupportedVersions = decodeSupportedVersions(serverEncoded);
        saveToCache(serverUrl, serverSupportedVersions);
        dispatchSupportedVersionsUpdated(server.url, serverSupportedVersions, {
          source: 'server'
        });
        return;
      } catch (error) {
        console.error('Error decoding server supported versions:', error);
        // Clear serverEncoded to allow cloud fallback
        serverEncoded = undefined;
      }
    }
  }
  const uniqueID = await getUniqueId(server.url, server.version || '').then(dispatchUniqueIdUpdated(server.url)).catch(logRequestError('unique ID'));

  // Try Cloud with retries (3x with 2s delays) if unique ID available
  if (!serverEncoded && uniqueID) {
    const cloudVersionsWithRetry = await withRetries(() => getCloudInfo(server.url, uniqueID), 3, 2000);
    if (cloudVersionsWithRetry !== null && cloudVersionsWithRetry !== void 0 && cloudVersionsWithRetry.signed) {
      try {
        const cloudSupportedVersions = decodeSupportedVersions(cloudVersionsWithRetry.signed);
        saveToCache(serverUrl, cloudSupportedVersions);
        dispatchSupportedVersionsUpdated(server.url, cloudSupportedVersions, {
          source: 'cloud'
        });
        return;
      } catch (error) {
        console.error('Error decoding cloud supported versions:', error);
      }
    }
  }

  // Try to load from cache
  const cachedVersions = loadFromCache(serverUrl);
  if (cachedVersions) {
    dispatchSupportedVersionsUpdated(server.url, cachedVersions, {
      source: 'cloud'
    });
    dispatch({
      type: WEBVIEW_SERVER_SUPPORTED_VERSIONS_ERROR,
      payload: {
        url: serverUrl
      }
    });
    return;
  }

  // Fall back to builtin (always available)
  if (builtinSupportedVersions) {
    saveToCache(serverUrl, builtinSupportedVersions);
    dispatchSupportedVersionsUpdated(server.url, builtinSupportedVersions, {
      source: 'builtin'
    });
    dispatch({
      type: WEBVIEW_SERVER_SUPPORTED_VERSIONS_ERROR,
      payload: {
        url: serverUrl
      }
    });
    return;
  }

  // No data available from any source
  dispatch({
    type: WEBVIEW_SERVER_SUPPORTED_VERSIONS_ERROR,
    payload: {
      url: serverUrl
    }
  });
};
function checkSupportedVersionServers() {
  listen(WEBVIEW_READY, async action => {
    updateSupportedVersionsData(action.payload.url);
  });
  listen(SUPPORTED_VERSION_DIALOG_DISMISS, async action => {
    updateSupportedVersionsData(action.payload.url);
  });
  listen(WEBVIEW_SERVER_RELOADED, async action => {
    updateSupportedVersionsData(action.payload.url);
  });
  electron.ipcMain.handle('refresh-supported-versions', async (_event, serverUrl) => {
    updateSupportedVersionsData(serverUrl);
  });
}

const setSpellCheckerLanguages = async languages => {
  await electron.app.whenReady();
  const filteredLanguages = Array.from(languages).filter(language => electron.session.defaultSession.availableSpellCheckerLanguages.includes(language));
  electron.session.defaultSession.setSpellCheckerLanguages(filteredLanguages);
  electron.webContents.getAllWebContents().forEach(webContents => {
    webContents.session.setSpellCheckerLanguages(filteredLanguages);
  });
};
const setupSpellChecking = async () => {
  setSpellCheckerLanguages(new Set(electron.session.defaultSession.getSpellCheckerLanguages()));
  listen(SPELL_CHECKING_TOGGLED, action => {
    const spellCheckerLanguages = new Set(action.payload ? electron.session.defaultSession.getSpellCheckerLanguages() : []);
    setSpellCheckerLanguages(spellCheckerLanguages);
  });
  listen(SPELL_CHECKING_LANGUAGE_TOGGLED, action => {
    const spellCheckerLanguages = new Set(electron.session.defaultSession.getSpellCheckerLanguages());
    if (action.payload.enabled) {
      spellCheckerLanguages.add(action.payload.name);
    } else {
      spellCheckerLanguages.delete(action.payload.name);
    }
    setSpellCheckerLanguages(spellCheckerLanguages);
  });
};

const handleCertificatesManager = () => {
  handle('certificatesManager/remove', async (_webContent, domain) => {
    const trustedCertificates = select(({
      trustedCertificates
    }) => trustedCertificates);
    const notTrustedCertificates = select(({
      notTrustedCertificates
    }) => notTrustedCertificates);
    if (trustedCertificates.hasOwnProperty(domain)) {
      delete trustedCertificates[domain];
      dispatch({
        type: TRUSTED_CERTIFICATES_UPDATED,
        payload: {
          ...trustedCertificates
        }
      });
    }
    if (notTrustedCertificates.hasOwnProperty(domain)) {
      delete notTrustedCertificates[domain];
      dispatch({
        type: NOT_TRUSTED_CERTIFICATES_UPDATED,
        payload: {
          ...notTrustedCertificates
        }
      });
    }
  });
};

class DockService extends Service {
  initialize() {
    if (process.platform !== 'darwin') {
      return;
    }
    this.watch(selectGlobalBadgeText, globalBadgeText => {
      var _app$dock;
      (_app$dock = electron.app.dock) === null || _app$dock === void 0 || _app$dock.setBadge(globalBadgeText);
    });
    this.watch(selectGlobalBadgeCount, (globalBadgeCount, prevGlobalBadgeCount) => {
      const {
        isFlashFrameEnabled
      } = select(({
        isFlashFrameEnabled
      }) => ({
        isFlashFrameEnabled
      }));
      if (globalBadgeCount <= 0 || (prevGlobalBadgeCount !== null && prevGlobalBadgeCount !== void 0 ? prevGlobalBadgeCount : 0) > 0) {
        return;
      }
      if (isFlashFrameEnabled) {
        var _app$dock2;
        (_app$dock2 = electron.app.dock) === null || _app$dock2 === void 0 || _app$dock2.bounce();
      }
    });
  }
}
var dock = new DockService();

const DESKTOP_CAPTURER_STALE_THRESHOLD = 3000;
const SOURCE_VALIDATION_CACHE_TTL = 30000;
const DESTRUCTION_CHECK_INTERVAL = 50;
const DEVTOOLS_TIMEOUT = 2000;
const WEBVIEW_CHECK_INTERVAL = 100;
const SCREEN_SHARING_REQUEST_TIMEOUT = 60000; // 60 seconds timeout

let videoCallWindow = null;
let isVideoCallWindowDestroying = false;
let pendingVideoCallUrl = null;

// Screen sharing request tracking
let activeScreenSharingListener = null;
let activeScreenSharingRequestId = null;
let screenSharingTimeout = null;
let isScreenSharingRequestPending = false;

// Helper function to log URL changes
const setPendingVideoCallUrl = (url, reason) => {
  const previous = pendingVideoCallUrl;
  pendingVideoCallUrl = url;
  console.log(`Video call window: pendingVideoCallUrl updated - ${reason}`, {
    previous,
    new: url,
    timestamp: new Date().toISOString()
  });
};
let desktopCapturerCache = null;
let desktopCapturerPromise = null;
const sourceValidationCache = new Set();
let sourceValidationCacheTimestamp = 0;
let videoCallWindowCreationCount = 0;
let videoCallWindowDestructionCount = 0;
const logVideoCallWindowStats = () => {
  console.log('Video call window stats:', {
    created: videoCallWindowCreationCount,
    destroyed: videoCallWindowDestructionCount,
    currentInstance: videoCallWindow ? 'active' : 'none',
    cacheStatus: desktopCapturerCache ? 'cached' : 'empty',
    promiseStatus: desktopCapturerPromise ? 'pending' : 'none'
  });
};
const refreshDesktopCapturerCache = options => {
  if (desktopCapturerPromise) return;
  desktopCapturerPromise = (async () => {
    try {
      const sources = await electron.desktopCapturer.getSources(options);
      const validSources = sources.filter(source => {
        if (!source.name || source.name.trim() === '') {
          return false;
        }
        const now = Date.now();
        const cacheExpired = now - sourceValidationCacheTimestamp > SOURCE_VALIDATION_CACHE_TTL;
        if (!cacheExpired && sourceValidationCache.has(source.id)) {
          return true;
        }
        if (source.thumbnail.isEmpty()) {
          return false;
        }
        if (cacheExpired) {
          sourceValidationCache.clear();
          sourceValidationCacheTimestamp = now;
        }
        sourceValidationCache.add(source.id);
        return true;
      });
      desktopCapturerCache = {
        sources: validSources,
        timestamp: Date.now()
      };
      return validSources;
    } catch (error) {
      var _desktopCapturerCache;
      console.error('Background cache refresh failed:', error);
      return ((_desktopCapturerCache = desktopCapturerCache) === null || _desktopCapturerCache === void 0 ? void 0 : _desktopCapturerCache.sources) || [];
    } finally {
      desktopCapturerPromise = null;
    }
  })();
};
const handleDesktopCapturerGetSources = () => {
  handle('desktop-capturer-get-sources', async (_webContents, opts) => {
    try {
      const options = Array.isArray(opts) ? opts[0] : opts;
      if (desktopCapturerCache) {
        const isStale = Date.now() - desktopCapturerCache.timestamp > DESKTOP_CAPTURER_STALE_THRESHOLD;
        if (isStale && !desktopCapturerPromise) {
          refreshDesktopCapturerCache(options);
        }
        return desktopCapturerCache.sources;
      }
      if (desktopCapturerPromise) {
        return await desktopCapturerPromise;
      }
      refreshDesktopCapturerCache(options);
      if (desktopCapturerPromise) {
        return await desktopCapturerPromise;
      }
      return [];
    } catch (error) {
      var _desktopCapturerCache2;
      console.error('Error in desktop capturer handler:', error);
      return ((_desktopCapturerCache2 = desktopCapturerCache) === null || _desktopCapturerCache2 === void 0 ? void 0 : _desktopCapturerCache2.sources) || [];
    }
  });
};
const fetchVideoCallWindowState = async browserWindow => {
  return {
    focused: browserWindow.isFocused(),
    visible: browserWindow.isVisible(),
    maximized: false,
    minimized: false,
    fullscreen: false,
    normal: true,
    bounds: browserWindow.getNormalBounds()
  };
};
const cleanupVideoCallWindow = () => {
  if (videoCallWindow && !videoCallWindow.isDestroyed() && !isVideoCallWindowDestroying) {
    console.log('Cleaning up video call window resources');
    isVideoCallWindowDestroying = true;
    try {
      // Set permission handler with additional safety
      if (videoCallWindow.webContents && !videoCallWindow.webContents.isDestroyed()) {
        videoCallWindow.webContents.session.setPermissionRequestHandler(() => false);
        videoCallWindow.webContents.executeJavaScript('void 0').catch(() => {
          // Ignore errors during cleanup
        });
      }
      try {
        const allWebContents = electron.webContents.getAllWebContents();
        const webviewContents = allWebContents.find(wc => {
          var _videoCallWindow;
          return wc.hostWebContents === ((_videoCallWindow = videoCallWindow) === null || _videoCallWindow === void 0 ? void 0 : _videoCallWindow.webContents);
        });
        if (webviewContents && !webviewContents.isDestroyed()) {
          console.log('Stopping webview JavaScript execution before window cleanup');
          webviewContents.session.setPermissionRequestHandler(() => false);
          webviewContents.loadURL('about:blank').catch(() => {});
        }
      } catch (error) {
        console.log('Could not clean webview contents, continuing with window cleanup');
      }

      // Clean up screen sharing listener before removing window listeners
      cleanupScreenSharingListener();
      videoCallWindow.removeAllListeners();

      // Use setImmediate to ensure this happens after current event loop
      // This prevents timing issues during app initialization
      setImmediate(() => {
        if (videoCallWindow && !videoCallWindow.isDestroyed()) {
          videoCallWindow.close();
        }
      });
    } catch (error) {
      console.error('Error during video call window cleanup:', error);
      if (videoCallWindow && !videoCallWindow.isDestroyed()) {
        try {
          videoCallWindow.removeAllListeners();
          setImmediate(() => {
            if (videoCallWindow && !videoCallWindow.isDestroyed()) {
              videoCallWindow.close();
            }
          });
        } catch (fallbackError) {
          console.error('Error in fallback cleanup:', fallbackError);
        }
      }
    }
  }

  // Use setTimeout to ensure this cleanup happens after any window events are processed
  setTimeout(() => {
    videoCallWindow = null;
    isVideoCallWindowDestroying = false;
    videoCallWindowDestructionCount++;
    console.log('Video call window cleanup completed');
    logVideoCallWindowStats();
  }, 10);
};
const cleanupScreenSharingListener = () => {
  if (activeScreenSharingListener) {
    electron.ipcMain.removeListener('video-call-window/screen-sharing-source-responded', activeScreenSharingListener);
    activeScreenSharingListener = null;
  }
  if (screenSharingTimeout) {
    clearTimeout(screenSharingTimeout);
    screenSharingTimeout = null;
  }
  activeScreenSharingRequestId = null;
  isScreenSharingRequestPending = false;
};
const removeScreenSharingListenerOnly = () => {
  if (activeScreenSharingListener) {
    electron.ipcMain.removeListener('video-call-window/screen-sharing-source-responded', activeScreenSharingListener);
    activeScreenSharingListener = null;
  }
  if (screenSharingTimeout) {
    clearTimeout(screenSharingTimeout);
    screenSharingTimeout = null;
  }
};
const markScreenSharingComplete = () => {
  activeScreenSharingRequestId = null;
  isScreenSharingRequestPending = false;
};

// Internal picker handler function - encapsulates the internal picker logic
const createInternalPickerHandler = () => {
  return cb => {
    // Prevent concurrent requests
    if (isScreenSharingRequestPending) {
      console.warn('Screen sharing request already pending, ignoring concurrent request');
      cb({
        video: false
      });
      return;
    }
    if (!videoCallWindow || videoCallWindow.isDestroyed()) {
      console.warn('Screen sharing request rejected - video call window not available');
      cb({
        video: false
      });
      return;
    }

    // Clean up any existing listener
    cleanupScreenSharingListener();

    // Generate unique request ID
    const requestId = `${Date.now()}-${Math.random().toString(36).substring(2, 11)}`;
    activeScreenSharingRequestId = requestId;
    isScreenSharingRequestPending = true;

    // Flag to prevent double-invocation of callback
    let callbackInvoked = false;

    // Create the listener function
    const listener = async (_event, sourceId) => {
      // Ignore responses for different requests
      if (activeScreenSharingRequestId !== requestId) {
        console.warn('Screen sharing response received for different request, ignoring');
        return;
      }

      // Guard against double-invocation (race with timeout)
      if (callbackInvoked) {
        console.warn('Screen sharing callback already invoked, ignoring duplicate');
        return;
      }
      callbackInvoked = true;

      // Remove listener and clear timeout
      removeScreenSharingListenerOnly();
      if (!sourceId) {
        cb({
          video: false
        });
        markScreenSharingComplete();
        return;
      }
      try {
        const sources = await electron.desktopCapturer.getSources({
          types: ['window', 'screen']
        });
        const selectedSource = sources.find(s => s.id === sourceId);
        if (!selectedSource) {
          console.warn('Selected screen sharing source no longer available:', sourceId);
          cb({
            video: false
          });
          markScreenSharingComplete();
          return;
        }
        cb({
          video: selectedSource
        });
        markScreenSharingComplete();
      } catch (error) {
        console.error('Error validating screen sharing source:', error);
        cb({
          video: false
        });
        markScreenSharingComplete();
      }
    };

    // Store listener for cleanup
    activeScreenSharingListener = listener;

    // Set timeout to prevent orphaned listeners
    screenSharingTimeout = setTimeout(() => {
      if (activeScreenSharingRequestId !== requestId) {
        console.warn('Screen sharing timeout fired for different request, ignoring');
        return;
      }
      if (callbackInvoked) {
        console.warn('Screen sharing callback already invoked by listener, ignoring timeout');
        return;
      }
      callbackInvoked = true;
      console.warn('Screen sharing request timed out, cleaning up listener');
      removeScreenSharingListenerOnly();
      cb({
        video: false
      });
      markScreenSharingComplete();
    }, SCREEN_SHARING_REQUEST_TIMEOUT);

    // Register listener
    electron.ipcMain.once('video-call-window/screen-sharing-source-responded', listener);

    // Send request to open picker
    videoCallWindow.webContents.send('video-call-window/open-screen-picker');
  };
};
const setupWebviewHandlers = webContents => {
  // Track attached webviews that need handler setup
  const pendingWebviews = [];
  let screenPickerReady = false;
  let provider = null;

  // Function to set up display media handler for a webview
  const setupDisplayMediaHandler = webviewWebContents => {
    if (!provider) return;
    const currentProvider = provider; // Capture for closure
    try {
      // useSystemPicker is an experimental macOS 15+ option; not available on other platforms.
      // We set it to false unconditionally and use the callback handler on all platforms to
      // enable custom source selection (including PipeWire on Wayland via XDG portal).
      webviewWebContents.session.setDisplayMediaRequestHandler((_request, cb) => {
        try {
          currentProvider.handleDisplayMediaRequest(cb);
        } catch (error) {
          console.error('Error in screen picker handler:', error);
          cb({
            video: false
          });
        }
      }, {
        useSystemPicker: false
      } // Always false - portal handled via callback on Linux
      );
    } catch (error) {
      console.error('Error setting up display media request handler:', error);
    }
  };

  // Register listener SYNCHRONOUSLY before async work
  const handleDidAttachWebview = (_event, webviewWebContents) => {
    if (screenPickerReady && provider) {
      setupDisplayMediaHandler(webviewWebContents);
    } else {
      pendingWebviews.push(webviewWebContents);
    }
  };
  webContents.removeAllListeners('did-attach-webview');
  webContents.on('did-attach-webview', handleDidAttachWebview);

  // Load screen picker module asynchronously
  Promise.resolve().then(function () { return require('./index-E_iq-HFp.js'); }).then(screenPickerModule => {
    const {
      createScreenPicker,
      InternalPickerProvider
    } = screenPickerModule;
    provider = createScreenPicker();
    if (provider instanceof InternalPickerProvider) {
      provider.setHandleRequestHandler(createInternalPickerHandler());
    }
    screenPickerReady = true;

    // Set up handlers for any webviews that attached while loading
    for (const webviewWebContents of pendingWebviews) {
      if (!webviewWebContents.isDestroyed()) {
        setupDisplayMediaHandler(webviewWebContents);
      }
    }
    pendingWebviews.length = 0;
  }).catch(error => {
    console.error('Error loading screen picker module:', error);
    // Don't prevent webview from loading if screen picker setup fails
  });
};
const startVideoCallWindowHandler = () => {
  handle('video-call-window/screen-recording-is-permission-granted', async () => {
    if (process__default.default.platform === 'darwin') {
      const permission = electron.systemPreferences.getMediaAccessStatus('screen');
      return permission === 'granted';
    }
    return true;
  });
  handle('video-call-window/open-screen-picker', async _webContents => {
    if (videoCallWindow && !videoCallWindow.isDestroyed()) {
      videoCallWindow.webContents.send('video-call-window/open-screen-picker');
      return {
        success: true
      };
    }
    console.warn('Video call window: Cannot open screen picker - window not available');
    return {
      success: false
    };
  });
  handle('video-call-window/open-window', async (_webContents, url) => {
    console.log('Video call window: Open-window handler called with URL:', url);
    if (isVideoCallWindowDestroying) {
      console.log('Waiting for video call window destruction to complete...');
      await new Promise(resolve => {
        const checkDestructionComplete = () => {
          if (!isVideoCallWindowDestroying) {
            resolve();
          } else {
            setTimeout(checkDestructionComplete, DESTRUCTION_CHECK_INTERVAL);
          }
        };
        checkDestructionComplete();
      });
    }
    if (videoCallWindow && !videoCallWindow.isDestroyed()) {
      console.log('Closing existing video call window to create fresh one');
      videoCallWindow.close();
      videoCallWindow = null;
      if (isVideoCallWindowDestroying) {
        await new Promise(resolve => {
          const checkClosed = () => {
            if (!isVideoCallWindowDestroying) {
              resolve();
            } else {
              setTimeout(checkClosed, DESTRUCTION_CHECK_INTERVAL);
            }
          };
          checkClosed();
        });
      }
    }
    const validUrl = new URL(url);
    const allowedProtocols = ['http:', 'https:'];
    console.log('Video call window: URL validation - hostname:', validUrl.hostname, 'protocol:', validUrl.protocol);
    if (validUrl.hostname.match(/(\.)?g\.co$/)) {
      console.log('Video call window: Google URL detected, opening externally instead of internal window');
      openExternal(validUrl.toString());
      return;
    }
    if (allowedProtocols.includes(validUrl.protocol)) {
      const mainWindow = await getRootWindow();
      const winBounds = await mainWindow.getNormalBounds();
      const centeredWindowPosition = {
        x: winBounds.x + winBounds.width / 2,
        y: winBounds.y + winBounds.height / 2
      };
      const actualScreen = electron.screen.getDisplayNearestPoint({
        x: centeredWindowPosition.x,
        y: centeredWindowPosition.y
      });
      const state = select(state => ({
        videoCallWindowState: state.videoCallWindowState,
        isVideoCallWindowPersistenceEnabled: state.isVideoCallWindowPersistenceEnabled,
        isAutoOpenEnabled: state.isVideoCallDevtoolsAutoOpenEnabled
      }));
      let {
        x,
        y,
        width,
        height
      } = state.videoCallWindowState.bounds;
      if (!state.isVideoCallWindowPersistenceEnabled || !x || !y || width === 0 || height === 0 || !isInsideSomeScreen({
        x,
        y,
        width,
        height
      })) {
        width = Math.round(actualScreen.workAreaSize.width * 0.8);
        height = Math.round(actualScreen.workAreaSize.height * 0.8);
        x = Math.round((actualScreen.workArea.width - width) / 2 + actualScreen.workArea.x);
        y = Math.round((actualScreen.workArea.height - height) / 2 + actualScreen.workArea.y);
      }
      console.log('Creating new video call window');
      videoCallWindowCreationCount++;
      logVideoCallWindowStats();
      const additionalArgs = [];
      if (process__default.default.platform === 'win32') {
        const sessionName = process__default.default.env.SESSIONNAME;
        const isRdpSession = typeof sessionName === 'string' && sessionName !== 'Console';
        const {
          readSetting
        } = await Promise.resolve().then(function () { return readSetting$1; });
        const isScreenCaptureFallbackEnabled = readSetting('isVideoCallScreenCaptureFallbackEnabled');
        if (isScreenCaptureFallbackEnabled || isRdpSession) {
          additionalArgs.push('--disable-features=WebRtcAllowWgcDesktopCapturer,WebRtcAllowWgcScreenCapturer');
          console.log('Video call window: Explicitly passing WGC disable flags to webview via additionalArguments', {
            isRdpSession,
            isScreenCaptureFallbackEnabled
          });
        }
      }
      videoCallWindow = new electron.BrowserWindow({
        width,
        height,
        x,
        y,
        webPreferences: {
          nodeIntegration: true,
          nodeIntegrationInSubFrames: true,
          contextIsolation: false,
          webviewTag: true,
          experimentalFeatures: false,
          offscreen: false,
          disableHtmlFullscreenWindowResize: true,
          backgroundThrottling: true,
          v8CacheOptions: 'bypassHeatCheck',
          spellcheck: false,
          ...(additionalArgs.length > 0 && {
            additionalArguments: additionalArgs
          })
        },
        show: false,
        frame: true,
        transparent: false,
        skipTaskbar: false
      });
      videoCallWindow.webContents.on('will-navigate', (event, url) => {
        if (url.toLowerCase().startsWith('smb://')) {
          event.preventDefault();
        }
      });
      videoCallWindow.webContents.setWindowOpenHandler(({
        url
      }) => {
        if (url.toLowerCase().startsWith('smb://')) {
          return {
            action: 'deny'
          };
        }
        return {
          action: 'allow'
        };
      });
      if (state.isVideoCallWindowPersistenceEnabled) {
        const fetchAndDispatchWindowState = debounce(async () => {
          if (videoCallWindow && !videoCallWindow.isDestroyed()) {
            dispatchLocal({
              type: VIDEO_CALL_WINDOW_STATE_CHANGED,
              payload: await fetchVideoCallWindowState(videoCallWindow)
            });
          }
        }, 1000);
        videoCallWindow.addListener('show', fetchAndDispatchWindowState);
        videoCallWindow.addListener('hide', fetchAndDispatchWindowState);
        videoCallWindow.addListener('focus', fetchAndDispatchWindowState);
        videoCallWindow.addListener('blur', fetchAndDispatchWindowState);
        videoCallWindow.addListener('maximize', fetchAndDispatchWindowState);
        videoCallWindow.addListener('unmaximize', fetchAndDispatchWindowState);
        videoCallWindow.addListener('minimize', fetchAndDispatchWindowState);
        videoCallWindow.addListener('restore', fetchAndDispatchWindowState);
        videoCallWindow.addListener('resize', fetchAndDispatchWindowState);
        videoCallWindow.addListener('move', fetchAndDispatchWindowState);
      }
      videoCallWindow.on('closed', () => {
        console.log('Video call window closed - destroying completely');

        // Clean up screen sharing listener
        cleanupScreenSharingListener();

        // Use setTimeout to ensure cleanup happens after any potential app lifecycle events
        // This prevents crashes during first launch when timing is critical
        setTimeout(() => {
          try {
            videoCallWindow = null;
            isVideoCallWindowDestroying = false;
            videoCallWindowDestructionCount++;
            logVideoCallWindowStats();
          } catch (error) {
            console.error('Error during video call window closed event handling:', error);
          }
        }, 50); // Small delay to let app state stabilize
      });
      videoCallWindow.on('close', _event => {
        if (!isVideoCallWindowDestroying) {
          isVideoCallWindowDestroying = true;
          console.log('Video call window close initiated - preventing JS execution');

          // Clean up screen sharing listener
          cleanupScreenSharingListener();
          try {
            if (videoCallWindow && !videoCallWindow.isDestroyed()) {
              videoCallWindow.webContents.session.setPermissionRequestHandler(() => false);
              videoCallWindow.webContents.executeJavaScript('void 0').catch(() => {});
            }
          } catch (error) {
            console.log('Error during close preparation:', error);
          }
        }
      });
      videoCallWindow.webContents.on('did-fail-load', (_event, errorCode, errorDescription, validatedURL, isMainFrame) => {
        console.error('Video call window failed to load:', {
          errorCode,
          errorDescription,
          validatedURL,
          isMainFrame
        });
        if (isMainFrame) {
          console.error('Main frame failed to load, this may indicate issues on low-power devices');
        }
      });
      videoCallWindow.webContents.on('dom-ready', () => {
        var _videoCallWindow2;
        (_videoCallWindow2 = videoCallWindow) === null || _videoCallWindow2 === void 0 || _videoCallWindow2.webContents.executeJavaScript(`
          if (typeof process !== 'undefined' && process.env && "production" === 'development') {
            console.log('Video call window: JavaScript execution test successful');
          }
          window.videoCallWindowJSWorking = true;
          setTimeout(() => {
            const rootElement = document.getElementById('root');
            const hasReactContent = rootElement && (
              rootElement.hasChildNodes() || 
              rootElement.innerHTML.trim() !== ''
            );
            
            if (!hasReactContent) {
              console.warn('Video call window: React may not have rendered - possible initialization issue');
            } else if (typeof process !== 'undefined' && process.env && "production" === 'development') {
              console.log('Video call window: React content detected successfully');
            }
          }, 5000);
        `).catch(error => {
          console.error('Video call window: JavaScript execution test failed:', error);
        });
      });
      videoCallWindow.webContents.on('console-message', (_event, level, message, line, sourceId) => {
        const logPrefix = 'Video call window console:';
        switch (level) {
          case 0:
            console.log(`${logPrefix} [INFO]`, message, `(${sourceId}:${line})`);
            break;
          case 1:
            console.warn(`${logPrefix} [WARN]`, message, `(${sourceId}:${line})`);
            break;
          case 2:
            console.error(`${logPrefix} [ERROR]`, message, `(${sourceId}:${line})`);
            break;
          default:
            console.log(`${logPrefix} [${level}]`, message, `(${sourceId}:${line})`);
        }
      });
      const htmlPath = path__default.default.join(electron.app.getAppPath(), 'app/video-call-window.html');
      console.log('Video call window: Loading HTML file from:', htmlPath);
      videoCallWindow.loadFile(htmlPath, {
        query: {
          url,
          autoOpenDevtools: String(state.isAutoOpenEnabled)
        }
      }).catch(error => {
        console.error('Video call window: Failed to load HTML file:', error);
        console.error('This may indicate build issues or file system problems on low-power devices');
      });
      videoCallWindow.once('ready-to-show', () => {
        if (videoCallWindow && !videoCallWindow.isDestroyed()) {
          videoCallWindow.setTitle(packageJsonInformation.productName);
          console.log('Video call window: Window ready, waiting for renderer to signal ready state');
          console.log('Video call window: Current pending URL:', pendingVideoCallUrl);
          videoCallWindow.show();
        }
      });
      const {
        webContents
      } = videoCallWindow;

      // Setup webview handlers (listener registered synchronously, module loads async)
      setupWebviewHandlers(webContents);

      // Set the pending URL after window is created to prevent race condition with cleanup
      setPendingVideoCallUrl(url, 'open-window-after-creation');
      console.log('Video call window: Set pending URL after window creation:', url);
      webContents.setWindowOpenHandler(({
        url
      }) => {
        console.log('Video call window - new window requested:', url);
        if (url.toLowerCase().startsWith('smb://')) {
          return {
            action: 'deny'
          };
        }
        if (url.startsWith('http://') || url.startsWith('https://')) {
          openExternal(url);
          return {
            action: 'deny'
          };
        }
        return {
          action: 'allow'
        };
      });
      webContents.on('will-navigate', (event, url) => {
        console.log('Video call window will-navigate:', url);

        // Check for close pages and handle them specially to prevent crashes
        if (url.includes('/close.html') || url.includes('/close2.html')) {
          console.log('Video call window: Navigation to close page detected, will handle gracefully');
          // Don't prevent navigation, but note it for safer handling
        }
        try {
          const parsedUrl = new URL(url);
          if (!['http:', 'https:', 'file:', 'data:', 'about:'].includes(parsedUrl.protocol)) {
            console.log('External protocol detected in video call window:', parsedUrl.protocol);
            event.preventDefault();
            isProtocolAllowed(url).then(allowed => {
              if (allowed) {
                openExternal(url);
              }
            });
          }
        } catch (e) {
          console.warn('Failed to parse URL in video call window:', url, e);
        }
      });
      webContents.session.setPermissionRequestHandler(async (_webContents, permission, callback, details) => {
        console.log('Video call window permission request', permission, details);
        switch (permission) {
          case 'media':
            {
              const {
                mediaTypes = []
              } = details;
              try {
                await handleMediaPermissionRequest(mediaTypes, videoCallWindow, 'initiateCall', callback);
              } catch (error) {
                console.error('Error handling media permission request in video call window:', error);
                callback(false);
              }
              return;
            }
          case 'geolocation':
          case 'notifications':
          case 'midiSysex':
          case 'pointerLock':
          case 'fullscreen':
          case 'screen-wake-lock':
          case 'system-wake-lock':
            callback(true);
            return;
          case 'openExternal':
            {
              callback(true);
              return;
            }
          default:
            callback(false);
        }
      });
    }
  });
  handle('video-call-window/close-requested', async () => {
    console.log('Video call window: Close requested via navigation to close page');

    // Add safety check and delay to prevent crashes during first launch
    if (videoCallWindow && !videoCallWindow.isDestroyed()) {
      // Use setImmediate to ensure this happens after any pending navigation events
      setImmediate(() => {
        try {
          if (videoCallWindow && !videoCallWindow.isDestroyed() && !isVideoCallWindowDestroying) {
            console.log('Video call window: Proceeding with close after navigation delay');
            videoCallWindow.close();
          } else {
            console.log('Video call window: Already destroyed or being destroyed, skipping close');
          }
        } catch (error) {
          console.error('Error closing video call window after close page navigation:', error);
        }
      });
      return {
        success: true
      };
    }
    console.log('Video call window: Already destroyed, cannot close');
    return {
      success: false
    };
  });
  handle('video-call-window/open-webview-dev-tools', async () => {
    if (!videoCallWindow || videoCallWindow.isDestroyed()) {
      console.warn('Video call window not available for dev tools');
      return false;
    }
    try {
      const webviewWebContents = await new Promise(resolve => {
        const checkForWebview = () => {
          const allWebContents = electron.webContents.getAllWebContents();
          const webviewContents = allWebContents.find(wc => {
            var _videoCallWindow3;
            return wc.hostWebContents === ((_videoCallWindow3 = videoCallWindow) === null || _videoCallWindow3 === void 0 ? void 0 : _videoCallWindow3.webContents);
          });
          if (webviewContents) {
            resolve(webviewContents);
          } else {
            setTimeout(checkForWebview, WEBVIEW_CHECK_INTERVAL);
          }
        };
        checkForWebview();
        setTimeout(() => resolve(null), DEVTOOLS_TIMEOUT);
      });
      if (webviewWebContents && !webviewWebContents.isDestroyed()) {
        console.log('Opening developer tools for video call webview');
        webviewWebContents.openDevTools();
        return true;
      }
      console.warn('Video call webview webContents not found or destroyed');
      return false;
    } catch (error) {
      console.error('Error opening webview developer tools:', error);
      return false;
    }
  });
};
const openVideoCallWebviewDevTools = async () => {
  if (!videoCallWindow || videoCallWindow.isDestroyed()) {
    console.warn('Video call window not available for dev tools');
    return false;
  }
  try {
    const webviewWebContents = await new Promise(resolve => {
      const checkForWebview = () => {
        const allWebContents = electron.webContents.getAllWebContents();
        const webviewContents = allWebContents.find(wc => {
          var _videoCallWindow4;
          return wc.hostWebContents === ((_videoCallWindow4 = videoCallWindow) === null || _videoCallWindow4 === void 0 ? void 0 : _videoCallWindow4.webContents);
        });
        if (webviewContents) {
          resolve(webviewContents);
        } else {
          setTimeout(checkForWebview, WEBVIEW_CHECK_INTERVAL);
        }
      };
      checkForWebview();
      setTimeout(() => resolve(null), DEVTOOLS_TIMEOUT);
    });
    if (webviewWebContents && !webviewWebContents.isDestroyed()) {
      console.log('Opening developer tools for video call webview');
      webviewWebContents.openDevTools();
      return true;
    }
    console.warn('Video call webview webContents not found or destroyed');
    return false;
  } catch (error) {
    console.error('Error opening webview developer tools:', error);
    return false;
  }
};
const cleanupVideoCallResources = () => {
  console.log('Cleaning up all video call resources');
  desktopCapturerCache = null;
  desktopCapturerPromise = null;
  sourceValidationCache.clear();
  sourceValidationCacheTimestamp = 0;
  isVideoCallWindowDestroying = false;
  cleanupVideoCallWindow();
};
handle('video-call-window/test-ipc', async () => {
  console.log('Video call window: IPC test request received');
  return {
    success: true,
    timestamp: Date.now()
  };
});
handle('video-call-window/handshake', async () => {
  console.log('Video call window: Handshake request received');
  return {
    success: true,
    timestamp: Date.now()
  };
});
handle('video-call-window/renderer-ready', async () => {
  console.log('Video call window: Renderer signals ready state');
  if (!videoCallWindow || videoCallWindow.isDestroyed()) {
    console.error('Video call window: Window not available when renderer ready');
    throw new Error('Video call window not available');
  }
  console.log('Video call window: Renderer is ready to request URL');
  return {
    success: true
  };
});
handle('video-call-window/request-url', async () => {
  console.log('Video call window: Renderer requesting pending URL');
  if (!videoCallWindow || videoCallWindow.isDestroyed()) {
    console.error('Video call window: Window not available when requesting URL');
    return {
      success: false,
      url: null,
      autoOpenDevtools: false
    };
  }
  if (!pendingVideoCallUrl) {
    console.error('Video call window: No pending URL available');
    return {
      success: false,
      url: null,
      autoOpenDevtools: false
    };
  }
  const state = select(state => ({
    isAutoOpenEnabled: state.isVideoCallDevtoolsAutoOpenEnabled
  }));
  console.log('Video call window: Providing URL to renderer:', pendingVideoCallUrl);
  return {
    success: true,
    url: pendingVideoCallUrl,
    autoOpenDevtools: state.isAutoOpenEnabled
  };
});
handle('video-call-window/url-received', async () => {
  console.log('Video call window: URL received confirmation from renderer');
  return {
    success: true
  };
});
handle('video-call-window/webview-created', async () => {
  console.log('Video call window: Webview created confirmation');
  return {
    success: true
  };
});
handle('video-call-window/webview-loading', async () => {
  console.log('Video call window: Webview started loading');
  return {
    success: true
  };
});
handle('video-call-window/webview-ready', async () => {
  console.log('Video call window: Webview finished loading');
  return {
    success: true
  };
});
handle('video-call-window/webview-failed', async (_webContents, error) => {
  console.error('Video call window: Webview failed to load:', error);
  return {
    success: true
  };
});
handle('video-call-window/get-language', async () => {
  console.log('Video call window: Language request received');

  // Import the i18n service to get the current language
  try {
    const {
      getLanguage
    } = await Promise.resolve().then(function () { return main; });
    console.log('Video call window: Providing language:', getLanguage);
    return {
      success: true,
      language: getLanguage
    };
  } catch (error) {
    console.error('Video call window: Failed to get language:', error);
    return {
      success: true,
      language: fallbackLng
    };
  }
});
handle('video-call-window/prewarm-capturer-cache', async () => {
  refreshDesktopCapturerCache({
    types: ['window', 'screen']
  });
  return {
    success: true
  };
});

const t$2 = i18next__default.default.t.bind(i18next__default.default);
const on = (condition, getMenuItems) => condition ? getMenuItems() : [];
const selectAddServersDeps = reselect.createStructuredSelector({
  isAddNewServersEnabled: ({
    isAddNewServersEnabled
  }) => isAddNewServersEnabled
});
const createAppMenu = reselect.createSelector(selectAddServersDeps, ({
  isAddNewServersEnabled
}) => ({
  id: 'appMenu',
  label: process.platform === 'darwin' ? electron.app.name : t$2('menus.fileMenu'),
  submenu: [...on(process.platform === 'darwin', () => [{
    id: 'about',
    label: t$2('menus.about', {
      appName: electron.app.name
    }),
    click: async () => {
      const browserWindow = await getRootWindow();
      if (!browserWindow.isVisible()) {
        browserWindow.showInactive();
      }
      browserWindow.focus();
      dispatch({
        type: MENU_BAR_ABOUT_CLICKED
      });
    }
  }, {
    type: 'separator'
  }, {
    id: 'services',
    label: t$2('menus.services'),
    role: 'services'
  }, {
    type: 'separator'
  }, {
    id: 'hide',
    label: t$2('menus.hide', {
      appName: electron.app.name
    }),
    role: 'hide'
  }, {
    id: 'hideOthers',
    label: t$2('menus.hideOthers'),
    role: 'hideOthers'
  }, {
    id: 'unhide',
    label: t$2('menus.unhide'),
    role: 'unhide'
  }, {
    type: 'separator'
  }]), ...on(process.platform !== 'darwin' && isAddNewServersEnabled, () => [{
    id: 'addNewServer',
    label: t$2('menus.addNewServer'),
    accelerator: 'CommandOrControl+N',
    click: async () => {
      const browserWindow = await getRootWindow();
      if (!browserWindow.isVisible()) {
        browserWindow.showInactive();
      }
      browserWindow.focus();
      dispatch({
        type: MENU_BAR_ADD_NEW_SERVER_CLICKED
      });
    }
  }, {
    type: 'separator'
  }]), {
    id: 'disableGpu',
    label: t$2('menus.disableGpu'),
    enabled: !electron.app.commandLine.hasSwitch('disable-gpu'),
    click: () => {
      relaunchApp('--disable-gpu');
    }
  }, {
    type: 'separator'
  }, {
    id: 'quit',
    label: t$2('menus.quit', {
      appName: electron.app.name
    }),
    accelerator: 'CommandOrControl+Q',
    click: () => {
      electron.app.quit();
    }
  }]
}));
const createEditMenu = reselect.createSelector(_ => undefined, () => ({
  id: 'editMenu',
  label: t$2('menus.editMenu'),
  submenu: [{
    id: 'undo',
    label: t$2('menus.undo'),
    role: 'undo'
  }, {
    id: 'redo',
    label: t$2('menus.redo'),
    role: 'redo'
  }, {
    type: 'separator'
  }, {
    id: 'cut',
    label: t$2('menus.cut'),
    role: 'cut'
  }, {
    id: 'copy',
    label: t$2('menus.copy'),
    role: 'copy'
  }, {
    id: 'paste',
    label: t$2('menus.paste'),
    role: 'paste'
  }, {
    id: 'selectAll',
    label: t$2('menus.selectAll'),
    role: 'selectAll'
  }]
}));
const selectViewDeps = reselect.createStructuredSelector({
  currentView: ({
    currentView
  }) => currentView,
  isSideBarEnabled: ({
    isSideBarEnabled
  }) => isSideBarEnabled,
  isTrayIconEnabled: ({
    isTrayIconEnabled
  }) => isTrayIconEnabled,
  isMenuBarEnabled: ({
    isMenuBarEnabled
  }) => isMenuBarEnabled,
  rootWindowState: ({
    rootWindowState
  }) => rootWindowState
});
const getCurrentView = async () => {
  const browserWindow = await getRootWindow();
  if (!browserWindow.isVisible()) {
    browserWindow.showInactive();
  }
  browserWindow.focus();
  return select(({
    currentView
  }) => currentView);
};
const getCurrentViewWebcontents = async () => {
  const currentView = await getCurrentView();
  const url = typeof currentView === 'object' ? currentView.url : null;
  if (!url) {
    return null;
  }
  return getWebContentsByServerUrl(url);
};
const createViewMenu = reselect.createSelector(selectViewDeps, ({
  currentView,
  isSideBarEnabled,
  isTrayIconEnabled,
  isMenuBarEnabled,
  rootWindowState
}) => ({
  id: 'viewMenu',
  label: t$2('menus.viewMenu'),
  submenu: [{
    id: 'reload',
    label: t$2('menus.reload'),
    accelerator: 'CommandOrControl+R',
    enabled: typeof currentView === 'object' && !!currentView.url,
    click: async () => {
      const guestWebContents = await getCurrentViewWebcontents();
      guestWebContents === null || guestWebContents === void 0 || guestWebContents.reload();
      const currentView = await getCurrentView();
      if (typeof currentView === 'object' && !!currentView.url) {
        dispatch({
          type: WEBVIEW_SERVER_RELOADED,
          payload: {
            url: currentView.url
          }
        });
      }
    }
  }, {
    id: 'reloadClearingCache',
    label: t$2('menus.reloadClearingCache'),
    enabled: typeof currentView === 'object' && !!currentView.url,
    click: async () => {
      const guestWebContents = await getCurrentViewWebcontents();
      if (guestWebContents) dispatch({
        type: CLEAR_CACHE_TRIGGERED,
        payload: guestWebContents.id
      });
      const currentView = await getCurrentView();
      if (typeof currentView === 'object' && !!currentView.url) {
        dispatch({
          type: WEBVIEW_SERVER_RELOADED,
          payload: {
            url: currentView.url
          }
        });
      }
    }
  }, {
    id: 'openDevTools',
    label: t$2('menus.openDevTools'),
    enabled: typeof currentView === 'object' && !!currentView.url,
    accelerator: process.platform === 'darwin' ? 'Command+Alt+I' : 'Ctrl+Shift+I',
    click: async () => {
      const guestWebContents = await getCurrentViewWebcontents();
      guestWebContents === null || guestWebContents === void 0 || guestWebContents.toggleDevTools();
    }
  }, {
    id: 'openDevToolsOnAllWindows',
    label: t$2('menus.openDevToolsOnAllWindows'),
    enabled: typeof currentView === 'object' && !!currentView.url,
    accelerator: process.platform === 'darwin' ? 'Command+Alt+G' : 'Ctrl+Shift+G',
    click: async () => {
      const windows = electron.BrowserWindow.getAllWindows();
      windows.forEach(window => {
        window.webContents.toggleDevTools();
      });
    }
  }, {
    type: 'separator'
  }, {
    id: 'back',
    label: t$2('menus.back'),
    enabled: typeof currentView === 'object' && !!currentView.url,
    accelerator: process.platform === 'darwin' ? 'Command+[' : 'Alt+Left',
    click: async () => {
      const guestWebContents = await getCurrentViewWebcontents();
      guestWebContents === null || guestWebContents === void 0 || guestWebContents.goBack();
    }
  }, {
    id: 'forward',
    label: t$2('menus.forward'),
    enabled: typeof currentView === 'object' && !!currentView.url,
    accelerator: process.platform === 'darwin' ? 'Command+]' : 'Alt+Right',
    click: async () => {
      const guestWebContents = await getCurrentViewWebcontents();
      guestWebContents === null || guestWebContents === void 0 || guestWebContents.goForward();
    }
  }, {
    type: 'separator'
  }, {
    id: 'showTrayIcon',
    label: t$2('menus.showTrayIcon'),
    type: 'checkbox',
    checked: isTrayIconEnabled,
    accelerator: process.platform === 'darwin' ? 'Shift+Command+T' : 'Ctrl+Shift+T',
    click: ({
      checked
    }) => {
      setTimeout(() => {
        dispatch({
          type: MENU_BAR_TOGGLE_IS_TRAY_ICON_ENABLED_CLICKED,
          payload: checked
        });
      }, 10);
    }
  }, ...on(process.platform === 'darwin', () => [{
    id: 'showFullScreen',
    label: t$2('menus.showFullScreen'),
    type: 'checkbox',
    checked: rootWindowState.fullscreen,
    accelerator: 'Control+Command+F',
    click: async ({
      checked: enabled
    }) => {
      const browserWindow = await getRootWindow();
      if (!browserWindow.isVisible()) {
        browserWindow.showInactive();
      }
      browserWindow.focus();
      browserWindow.setFullScreen(enabled);
    }
  }]), ...on(process.platform !== 'darwin', () => [{
    id: 'showMenuBar',
    label: t$2('menus.showMenuBar'),
    type: 'checkbox',
    checked: isMenuBarEnabled,
    enabled: !isMenuBarEnabled || isSideBarEnabled,
    accelerator: process.platform === 'darwin' ? 'Shift+Command+M' : 'Ctrl+Shift+M',
    click: async ({
      checked
    }) => {
      const browserWindow = await getRootWindow();
      if (!browserWindow.isVisible()) {
        browserWindow.showInactive();
      }
      browserWindow.focus();
      dispatch({
        type: MENU_BAR_TOGGLE_IS_MENU_BAR_ENABLED_CLICKED,
        payload: checked
      });
    }
  }]), {
    id: 'showServerList',
    label: t$2('menus.showServerList'),
    type: 'checkbox',
    checked: isSideBarEnabled,
    enabled: !isSideBarEnabled || isMenuBarEnabled,
    accelerator: process.platform === 'darwin' ? 'Shift+Command+S' : 'Ctrl+Shift+S',
    click: async ({
      checked
    }) => {
      const browserWindow = await getRootWindow();
      if (!browserWindow.isVisible()) {
        browserWindow.showInactive();
      }
      browserWindow.focus();
      dispatch({
        type: MENU_BAR_TOGGLE_IS_SIDE_BAR_ENABLED_CLICKED,
        payload: checked
      });
    }
  }, {
    type: 'separator'
  }, {
    id: 'resetZoom',
    label: t$2('menus.resetZoom'),
    accelerator: 'CommandOrControl+0',
    click: async () => {
      const guestWebContents = await getCurrentViewWebcontents();
      guestWebContents === null || guestWebContents === void 0 || guestWebContents.setZoomLevel(0);
    }
  }, {
    id: 'zoomIn',
    label: t$2('menus.zoomIn'),
    accelerator: 'CommandOrControl+=',
    click: async () => {
      const guestWebContents = await getCurrentViewWebcontents();
      if (!guestWebContents) {
        return;
      }
      const zoomLevel = guestWebContents === null || guestWebContents === void 0 ? void 0 : guestWebContents.getZoomLevel();
      if (zoomLevel >= 9) {
        return;
      }
      guestWebContents.setZoomLevel(zoomLevel + 1);
    }
  }, {
    id: 'zoomOut',
    label: t$2('menus.zoomOut'),
    accelerator: 'CommandOrControl+-',
    click: async () => {
      const guestWebContents = await getCurrentViewWebcontents();
      if (!guestWebContents) {
        return;
      }
      const zoomLevel = guestWebContents.getZoomLevel();
      if (zoomLevel <= -9) {
        return;
      }
      guestWebContents.setZoomLevel(zoomLevel - 1);
    }
  }]
}));
const selectWindowDeps = reselect.createStructuredSelector({
  servers: ({
    servers
  }) => servers,
  currentView: ({
    currentView
  }) => currentView,
  isShowWindowOnUnreadChangedEnabled: ({
    isShowWindowOnUnreadChangedEnabled
  }) => isShowWindowOnUnreadChangedEnabled,
  isAddNewServersEnabled: ({
    isAddNewServersEnabled
  }) => isAddNewServersEnabled
});
const createWindowMenu = reselect.createSelector(selectWindowDeps, ({
  servers,
  currentView,
  isShowWindowOnUnreadChangedEnabled,
  isAddNewServersEnabled
}) => ({
  id: 'windowMenu',
  label: t$2('menus.windowMenu'),
  role: 'windowMenu',
  submenu: [...on(process.platform === 'darwin' && isAddNewServersEnabled, () => [{
    id: 'addNewServer',
    label: t$2('menus.addNewServer'),
    accelerator: 'CommandOrControl+N',
    click: async () => {
      const browserWindow = await getRootWindow();
      if (!browserWindow.isVisible()) {
        browserWindow.showInactive();
      }
      browserWindow.focus();
      dispatch({
        type: MENU_BAR_ADD_NEW_SERVER_CLICKED
      });
    }
  }, {
    type: 'separator'
  }]), ...on(servers.length > 0, () => [...servers.map((server, i) => {
    var _server$title;
    return {
      id: server.url,
      type: typeof currentView === 'object' && currentView.url === server.url ? 'checkbox' : 'normal',
      label: (_server$title = server.title) === null || _server$title === void 0 ? void 0 : _server$title.replace(/&/g, '&&'),
      checked: typeof currentView === 'object' && currentView.url === server.url,
      accelerator: `CommandOrControl+${i + 1}`,
      click: async () => {
        const browserWindow = await getRootWindow();
        if (!browserWindow.isVisible()) {
          browserWindow.showInactive();
        }
        browserWindow.focus();
        setTimeout(() => {
          dispatch({
            type: MENU_BAR_SELECT_SERVER_CLICKED,
            payload: server.url
          });
        }, 100);
      }
    };
  }), {
    type: 'separator'
  }]), {
    id: 'downloads',
    label: t$2('menus.downloads'),
    checked: currentView === 'downloads',
    accelerator: 'CommandOrControl+D',
    click: async () => {
      const browserWindow = await getRootWindow();
      if (!browserWindow.isVisible()) {
        browserWindow.showInactive();
      }
      browserWindow.focus();
      dispatch({
        type: SIDE_BAR_DOWNLOADS_BUTTON_CLICKED
      });
    }
  }, {
    id: 'settings',
    label: t$2('menus.settings'),
    checked: currentView === 'settings',
    click: async () => {
      const browserWindow = await getRootWindow();
      if (!browserWindow.isVisible()) {
        browserWindow.showInactive();
      }
      browserWindow.focus();
      dispatch({
        type: SIDE_BAR_SETTINGS_BUTTON_CLICKED
      });
    }
  }, {
    id: 'showOnUnreadMessage',
    type: 'checkbox',
    label: t$2('menus.showOnUnreadMessage'),
    checked: isShowWindowOnUnreadChangedEnabled,
    click: async ({
      checked
    }) => {
      const browserWindow = await getRootWindow();
      if (!browserWindow.isVisible()) {
        browserWindow.showInactive();
      }
      browserWindow.focus();
      dispatch({
        type: MENU_BAR_TOGGLE_IS_SHOW_WINDOW_ON_UNREAD_CHANGED_ENABLED_CLICKED,
        payload: checked
      });
    }
  }, {
    type: 'separator'
  }, {
    id: 'minimize',
    role: 'minimize',
    label: t$2('menus.minimize'),
    accelerator: 'CommandOrControl+M'
  }, {
    id: 'close',
    role: 'close',
    label: t$2('menus.close'),
    accelerator: 'CommandOrControl+W'
  }]
}));
const selectHelpDeps = reselect.createStructuredSelector({
  isDeveloperModeEnabled: ({
    isDeveloperModeEnabled
  }) => isDeveloperModeEnabled,
  isVideoCallDevtoolsAutoOpenEnabled: ({
    isVideoCallDevtoolsAutoOpenEnabled
  }) => isVideoCallDevtoolsAutoOpenEnabled
});
const createHelpMenu = reselect.createSelector(selectHelpDeps, ({
  isDeveloperModeEnabled,
  isVideoCallDevtoolsAutoOpenEnabled
}) => ({
  id: 'helpMenu',
  label: t$2('menus.helpMenu'),
  role: 'help',
  submenu: [{
    id: 'documentation',
    label: t$2('menus.documentation'),
    click: () => {
      openExternal(docs.index);
    }
  }, {
    id: 'reportIssue',
    label: t$2('menus.reportIssue'),
    click: () => {
      openExternal(docs.newIssue);
    }
  }, {
    type: 'separator'
  }, {
    id: 'reload-window',
    label: t$2('menus.reload'),
    accelerator: 'CommandOrControl+Shift+R',
    click: async () => {
      const guestWebContents = await getCurrentViewWebcontents();
      if (guestWebContents) dispatch({
        type: CLEAR_CACHE_TRIGGERED,
        payload: guestWebContents.id
      });
      const currentView = await getCurrentView();
      if (typeof currentView === 'object' && !!currentView.url) {
        dispatch({
          type: WEBVIEW_SERVER_RELOADED,
          payload: {
            url: currentView.url
          }
        });
      }
    }
  }, {
    id: 'toggleDevTools',
    label: t$2('menus.toggleDevTools'),
    accelerator: 'CommandOrControl+Shift+D',
    click: async () => {
      const browserWindow = await getRootWindow();
      if (!browserWindow.isVisible()) {
        browserWindow.showInactive();
      }
      browserWindow.focus();
      browserWindow.webContents.toggleDevTools();
    }
  }, {
    id: 'developerMode',
    type: 'checkbox',
    label: t$2('menus.developerMode'),
    checked: isDeveloperModeEnabled,
    click: async ({
      checked
    }) => {
      const browserWindow = await getRootWindow();
      if (!browserWindow.isVisible()) {
        browserWindow.showInactive();
      }
      browserWindow.focus();
      dispatch({
        type: MENU_BAR_TOGGLE_IS_DEVELOPER_MODE_ENABLED_CLICKED,
        payload: checked
      });
    }
  }, {
    id: 'videoCallToolsSubmenu',
    label: t$2('menus.videoCallTools'),
    submenu: [{
      id: 'videoCallDevTools',
      label: t$2('menus.videoCallDevTools'),
      click: async () => {
        const browserWindow = await getRootWindow();
        if (!browserWindow.isVisible()) {
          browserWindow.showInactive();
        }
        browserWindow.focus();
        try {
          const success = await openVideoCallWebviewDevTools();
          if (!success) {
            console.log('No video call window available for developer tools');
          }
        } catch (error) {
          console.error('Error opening video call developer tools:', error);
        }
      }
    }, {
      id: 'videoCallDevToolsAutoOpen',
      type: 'checkbox',
      label: t$2('menus.videoCallDevToolsAutoOpen'),
      checked: isVideoCallDevtoolsAutoOpenEnabled,
      click: async ({
        checked
      }) => {
        const browserWindow = await getRootWindow();
        if (!browserWindow.isVisible()) {
          browserWindow.showInactive();
        }
        browserWindow.focus();
        dispatch({
          type: MENU_BAR_TOGGLE_IS_VIDEO_CALL_DEVTOOLS_AUTO_OPEN_ENABLED_CLICKED,
          payload: checked
        });
      }
    }]
  }, {
    id: 'openConfigFolder',
    label: t$2('menus.openConfigFolder'),
    click: async () => {
      electron.shell.showItemInFolder(path__default.default.join(electron.app.getPath('userData'), 'config.json'));
    }
  }, {
    type: 'separator'
  }, {
    id: 'clearTrustedCertificates',
    label: t$2('menus.clearTrustedCertificates'),
    click: async () => {
      const browserWindow = await getRootWindow();
      if (!browserWindow.isVisible()) {
        browserWindow.showInactive();
      }
      browserWindow.focus();
      dispatch({
        type: CERTIFICATES_CLEARED
      });
    }
  }, ...on(!process.mas, () => [{
    id: 'resetAppData',
    label: t$2('menus.resetAppData'),
    click: async () => {
      const permitted = await askForAppDataReset();
      if (permitted) {
        relaunchApp('--reset-app-data');
      }
    }
  }]), {
    type: 'separator'
  }, {
    id: 'learnMore',
    label: t$2('menus.learnMore'),
    click: () => {
      openExternal(rocketchat.site);
    }
  }, ...on(process.platform !== 'darwin', () => [{
    id: 'about',
    label: t$2('menus.about', {
      appName: electron.app.name
    }),
    click: async () => {
      const browserWindow = await getRootWindow();
      if (!browserWindow.isVisible()) {
        browserWindow.showInactive();
      }
      browserWindow.focus();
      dispatch({
        type: MENU_BAR_ABOUT_CLICKED
      });
    }
  }])]
}));
const selectMenuBarTemplate = reselect.createSelector([createAppMenu, createEditMenu, createViewMenu, createWindowMenu, createHelpMenu], (...menus) => menus);
const selectMenuBarTemplateAsJson = reselect.createSelector(_state => selectMenuBarTemplate, template => JSON.stringify(template));
class MenuBarService extends Service {
  initialize() {
    this.watch(selectMenuBarTemplateAsJson, async () => {
      const menuBarTemplate = select(selectMenuBarTemplate);
      const menu = electron.Menu.buildFromTemplate(menuBarTemplate);
      if (process.platform === 'darwin') {
        electron.Menu.setApplicationMenu(menu);
        return;
      }
      electron.Menu.setApplicationMenu(null);
      (await getRootWindow()).setMenu(menu);
    });
  }
}
var menuBar = new MenuBarService();

const t$1 = i18next__default.default.t.bind(i18next__default.default);
const ids = ['bold', 'italic', 'strike', 'inline_code', 'multi_line'];
const createTouchBar = () => {
  const serverSelectionScrubber = new electron.TouchBar.TouchBarScrubber({
    selectedStyle: 'background',
    mode: 'free',
    continuous: false,
    items: [],
    select: async index => {
      const browserWindow = await getRootWindow();
      if (!browserWindow.isVisible()) {
        browserWindow.showInactive();
      }
      browserWindow.focus();
      const url = select(({
        servers
      }) => servers[index].url);
      dispatch({
        type: TOUCH_BAR_SELECT_SERVER_TOUCHED,
        payload: url
      });
    }
  });
  const serverSelectionPopover = new electron.TouchBar.TouchBarPopover({
    label: t$1('touchBar.selectServer'),
    icon: undefined,
    items: new electron.TouchBar({
      items: [serverSelectionScrubber]
    }),
    showCloseButton: true
  });
  const messageBoxFormattingButtons = new electron.TouchBar.TouchBarSegmentedControl({
    mode: 'buttons',
    segments: ids.map(id => ({
      icon: electron.nativeImage.createFromPath(`${electron.app.getAppPath()}/app/images/touch-bar/${id}.png`),
      enabled: false
    })),
    change: async selectedIndex => {
      const browserWindow = await getRootWindow();
      if (!browserWindow.isVisible()) {
        browserWindow.showInactive();
      }
      browserWindow.focus();
      dispatch({
        type: TOUCH_BAR_FORMAT_BUTTON_TOUCHED,
        payload: ids[selectedIndex]
      });
    }
  });
  const touchBar = new electron.TouchBar({
    items: [serverSelectionPopover, new electron.TouchBar.TouchBarSpacer({
      size: 'flexible'
    }), messageBoxFormattingButtons, new electron.TouchBar.TouchBarSpacer({
      size: 'flexible'
    })]
  });
  getRootWindow().then(browserWindow => browserWindow.setTouchBar(touchBar));
  return [touchBar, serverSelectionPopover, serverSelectionScrubber, messageBoxFormattingButtons];
};
const updateServerSelectionPopover = (serverSelectionPopover, currentServer) => {
  var _currentServer$title;
  serverSelectionPopover.label = (_currentServer$title = currentServer === null || currentServer === void 0 ? void 0 : currentServer.title) !== null && _currentServer$title !== void 0 ? _currentServer$title : t$1('touchBar.selectServer');
  serverSelectionPopover.icon = currentServer !== null && currentServer !== void 0 && currentServer.favicon ? electron.nativeImage.createFromDataURL(currentServer === null || currentServer === void 0 ? void 0 : currentServer.favicon) : electron.nativeImage.createEmpty();
};
const updateServerSelectionScrubber = (serverSelectionScrubber, servers) => {
  serverSelectionScrubber.items = servers.map(server => {
    var _server$title;
    return {
      label: (_server$title = server.title) === null || _server$title === void 0 ? void 0 : _server$title.padEnd(30),
      icon: server.favicon ? electron.nativeImage.createFromDataURL(server.favicon) : undefined
    };
  });
};
const toggleMessageFormattingButtons = (messageBoxFormattingButtons, isEnabled) => {
  messageBoxFormattingButtons.segments.forEach(segment => {
    segment.enabled = isEnabled;
  });
};
const selectCurrentServer = ({
  servers,
  currentView
}) => {
  var _servers$find;
  return typeof currentView === 'object' ? (_servers$find = servers.find(({
    url
  }) => url === currentView.url)) !== null && _servers$find !== void 0 ? _servers$find : null : null;
};
class TouchBarService extends Service {
  initialize() {
    if (process.platform !== 'darwin') {
      return;
    }
    const [touchBar, serverSelectionPopover, serverSelectionScrubber, messageBoxFormattingButtons] = createTouchBar();
    this.watch(selectCurrentServer, currentServer => {
      updateServerSelectionPopover(serverSelectionPopover, currentServer);
      getRootWindow().then(browserWindow => browserWindow.setTouchBar(touchBar));
    });
    this.watch(({
      servers
    }) => servers, servers => {
      updateServerSelectionScrubber(serverSelectionScrubber, servers);
      getRootWindow().then(browserWindow => browserWindow.setTouchBar(touchBar));
    });
    this.watch(({
      isMessageBoxFocused
    }) => isMessageBoxFocused !== null && isMessageBoxFocused !== void 0 ? isMessageBoxFocused : false, isMessageBoxFocused => {
      toggleMessageFormattingButtons(messageBoxFormattingButtons, isMessageBoxFocused);
      getRootWindow().then(browserWindow => browserWindow.setTouchBar(touchBar));
    });
  }
}
var touchBar = new TouchBarService();

const t = i18next__default.default.t.bind(i18next__default.default);
const selectIsRootWindowVisible = ({
  rootWindowState: {
    visible
  }
}) => visible;
const selectHasHideOnTrayNotificationShown = ({
  hasHideOnTrayNotificationShown
}) => hasHideOnTrayNotificationShown;
const createTrayIcon = () => {
  const image = getTrayIconPath({
    platform: process.platform,
    badge: undefined
  });
  const trayIcon = new electron.Tray(electron.nativeImage.createEmpty());
  if (process.platform !== 'darwin') {
    trayIcon.addListener('click', async () => {
      const isRootWindowVisible = select(selectIsRootWindowVisible);
      const browserWindow = await getRootWindow();
      if (isRootWindowVisible) {
        browserWindow.hide();
        return;
      }
      browserWindow.show();
    });
  }
  trayIcon.addListener('balloon-click', async () => {
    const isRootWindowVisible = select(selectIsRootWindowVisible);
    const browserWindow = await getRootWindow();
    if (isRootWindowVisible) {
      browserWindow.hide();
      return;
    }
    browserWindow.show();
  });
  trayIcon.addListener('right-click', (_event, bounds) => {
    trayIcon.popUpContextMenu(undefined, bounds);
  });
  trayIcon.setImage(electron.nativeImage.createFromPath(image));
  return trayIcon;
};
const updateTrayIconImage = (trayIcon, badge) => {
  const image = getTrayIconPath({
    platform: process.platform,
    badge
  });
  trayIcon.setImage(electron.nativeImage.createFromPath(image));
};
const updateTrayIconTitle = (trayIcon, globalBadge) => {
  const title = Number.isInteger(globalBadge) ? String(globalBadge) : '';
  trayIcon.setTitle(title);
};
const updateTrayIconToolTip = (trayIcon, globalBadge) => {
  if (globalBadge === '•') {
    trayIcon.setToolTip(t('tray.tooltip.unreadMessage', {
      appName: electron.app.name
    }));
    return;
  }
  if (Number.isInteger(globalBadge)) {
    trayIcon.setToolTip(t('tray.tooltip.unreadMention', {
      appName: electron.app.name,
      count: globalBadge
    }));
    return;
  }
  trayIcon.setToolTip(t('tray.tooltip.noUnreadMessage', {
    appName: electron.app.name
  }));
};
const warnStillRunning = trayIcon => {
  if (process.platform !== 'win32') {
    return;
  }
  const hasHideOnTrayNotificationShown = select(selectHasHideOnTrayNotificationShown);
  if (!hasHideOnTrayNotificationShown) {
    trayIcon.displayBalloon({
      icon: getAppIconPath({
        platform: process.platform
      }),
      title: t('tray.balloon.stillRunning.title', {
        appName: electron.app.name
      }),
      content: t('tray.balloon.stillRunning.content', {
        appName: electron.app.name
      })
    });
    dispatch({
      type: SET_HAS_TRAY_MINIMIZE_NOTIFICATION_SHOWN,
      payload: true
    });
  }
};
const manageTrayIcon = async () => {
  const trayIcon = createTrayIcon();
  const unwatchGlobalBadge = watch(selectGlobalBadge, globalBadge => {
    updateTrayIconImage(trayIcon, globalBadge);
    updateTrayIconTitle(trayIcon, globalBadge);
    updateTrayIconToolTip(trayIcon, globalBadge);
  });
  let firstTrayIconBalloonShown = false;
  const unwatchIsRootWindowVisible = watch(selectIsRootWindowVisible, (isRootWindowVisible, prevIsRootWindowVisible) => {
    const menuTemplate = [{
      label: isRootWindowVisible ? t('tray.menu.hide') : t('tray.menu.show'),
      click: async () => {
        const isRootWindowVisible = select(selectIsRootWindowVisible);
        const browserWindow = await getRootWindow();
        if (isRootWindowVisible) {
          browserWindow.hide();
          return;
        }
        browserWindow.show();
      }
    }, {
      label: t('tray.menu.quit'),
      click: () => {
        electron.app.quit();
      }
    }];
    const menu = electron.Menu.buildFromTemplate(menuTemplate);
    trayIcon.setContextMenu(menu);
    if (prevIsRootWindowVisible && !isRootWindowVisible && process.platform === 'win32' && !firstTrayIconBalloonShown) {
      warnStillRunning(trayIcon);
      firstTrayIconBalloonShown = true;
    }
  });
  return () => {
    unwatchGlobalBadge();
    unwatchIsRootWindowVisible();
    trayIcon.destroy();
  };
};
class TrayIconService extends Service {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "tearDownPromise", null);
  }
  initialize() {
    this.watch(({
      isTrayIconEnabled
    }) => isTrayIconEnabled !== null && isTrayIconEnabled !== void 0 ? isTrayIconEnabled : true, isTrayIconEnabled => {
      if (!this.tearDownPromise && isTrayIconEnabled) {
        this.tearDownPromise = manageTrayIcon();
      } else if (this.tearDownPromise && !isTrayIconEnabled) {
        this.tearDownPromise.then(cleanUp => cleanUp());
        this.tearDownPromise = null;
      }
    });
  }
  destroy() {
    var _this$tearDownPromise;
    (_this$tearDownPromise = this.tearDownPromise) === null || _this$tearDownPromise === void 0 || _this$tearDownPromise.then(cleanUp => cleanUp());
    this.tearDownPromise = null;
  }
}
var trayIcon = new TrayIconService();

const readJsonObject = async filePath => {
  try {
    const content = await fs__namespace.default.promises.readFile(filePath, 'utf8');
    const json = JSON.parse(content);
    return json && typeof json === 'object' && !Array.isArray(json) ? json : {};
  } catch (error) {
    return {};
  }
};
const readAppJsonObject = async basename => {
  const filePath = path__default.default.join(electron.app.getAppPath(), electron.app.getAppPath().endsWith('app.asar') ? '..' : '.', basename);
  return readJsonObject(filePath);
};
const readUserJsonObject = async basename => {
  const filePath = path__default.default.join(electron.app.getPath('userData'), basename);
  return readJsonObject(filePath);
};
const loadAppConfiguration = async () => readAppJsonObject('update.json');
const loadUserConfiguration = async () => readUserJsonObject('update.json');
const mergeConfigurations = (defaultConfiguration, appConfiguration, userConfiguration) => {
  const configuration = {
    ...defaultConfiguration,
    ...(typeof appConfiguration.forced === 'boolean' && {
      isEachUpdatesSettingConfigurable: !appConfiguration.forced
    }),
    ...(typeof appConfiguration.canUpdate === 'boolean' && {
      isUpdatingEnabled: appConfiguration.canUpdate
    }),
    ...(typeof appConfiguration.autoUpdate === 'boolean' && {
      doCheckForUpdatesOnStartup: appConfiguration.autoUpdate
    }),
    ...(typeof appConfiguration.skip === 'string' && {
      skippedUpdateVersion: appConfiguration.skip
    }),
    ...(typeof appConfiguration.channel === 'string' && {
      updateChannel: appConfiguration.channel
    })
  };
  if (typeof userConfiguration.autoUpdate === 'boolean' && (configuration.isEachUpdatesSettingConfigurable || typeof appConfiguration.autoUpdate === 'undefined')) {
    configuration.doCheckForUpdatesOnStartup = userConfiguration.autoUpdate;
  }
  if (typeof userConfiguration.skip === 'string' && (configuration.isEachUpdatesSettingConfigurable || typeof appConfiguration.skip === 'undefined')) {
    configuration.skippedUpdateVersion = userConfiguration.skip;
  }
  if (typeof userConfiguration.channel === 'string' && (configuration.isEachUpdatesSettingConfigurable || typeof appConfiguration.channel === 'undefined')) {
    configuration.updateChannel = userConfiguration.channel;
  }
  return configuration;
};
const loadConfiguration = async () => {
  const defaultConfiguration = select(({
    isUpdatingEnabled,
    doCheckForUpdatesOnStartup,
    skippedUpdateVersion,
    isReportEnabled,
    isFlashFrameEnabled,
    isHardwareAccelerationEnabled,
    isInternalVideoChatWindowEnabled,
    isVideoCallScreenCaptureFallbackEnabled,
    updateChannel
  }) => ({
    isUpdatingAllowed: process.platform === 'linux' && !!process.env.APPIMAGE || process.platform === 'win32' && !process.windowsStore || process.platform === 'darwin' && !process.mas,
    isEachUpdatesSettingConfigurable: true,
    isUpdatingEnabled,
    doCheckForUpdatesOnStartup,
    skippedUpdateVersion,
    isReportEnabled,
    isFlashFrameEnabled,
    isHardwareAccelerationEnabled,
    isInternalVideoChatWindowEnabled,
    isVideoCallScreenCaptureFallbackEnabled,
    updateChannel
  }));
  const appConfiguration = await loadAppConfiguration();
  const userConfiguration = await loadUserConfiguration();
  return mergeConfigurations(defaultConfiguration, appConfiguration, userConfiguration);
};
const setupUpdates = async () => {
  electronUpdater.autoUpdater.autoDownload = false;
  const {
    isUpdatingAllowed,
    isEachUpdatesSettingConfigurable,
    isUpdatingEnabled,
    doCheckForUpdatesOnStartup,
    skippedUpdateVersion,
    isReportEnabled,
    isFlashFrameEnabled,
    isHardwareAccelerationEnabled,
    isInternalVideoChatWindowEnabled,
    isVideoCallScreenCaptureFallbackEnabled,
    updateChannel
  } = await loadConfiguration();
  dispatch({
    type: UPDATES_READY,
    payload: {
      isUpdatingAllowed,
      isEachUpdatesSettingConfigurable,
      isUpdatingEnabled,
      doCheckForUpdatesOnStartup,
      skippedUpdateVersion,
      isReportEnabled,
      isFlashFrameEnabled,
      isHardwareAccelerationEnabled,
      isInternalVideoChatWindowEnabled,
      isVideoCallScreenCaptureFallbackEnabled,
      updateChannel
    }
  });
  if (!isUpdatingAllowed || !isUpdatingEnabled) {
    return;
  }

  // Set initial channel
  electronUpdater.autoUpdater.channel = updateChannel;

  // Enable prerelease updates for alpha and beta channels
  if (updateChannel === 'alpha' || updateChannel === 'beta') {
    electronUpdater.autoUpdater.allowPrerelease = true;
  }

  // Listen for channel changes
  listen(ABOUT_DIALOG_UPDATE_CHANNEL_CHANGED, async action => {
    const newChannel = action.payload;
    electronUpdater.autoUpdater.channel = newChannel;

    // Enable prerelease updates for alpha and beta channels
    electronUpdater.autoUpdater.allowPrerelease = newChannel === 'alpha' || newChannel === 'beta';
    dispatch({
      type: UPDATES_CHANNEL_CHANGED,
      payload: newChannel
    });
  });
  electronUpdater.autoUpdater.addListener('checking-for-update', () => {
    dispatch({
      type: UPDATES_CHECKING_FOR_UPDATE
    });
  });
  electronUpdater.autoUpdater.addListener('update-available', ({
    version
  }) => {
    const skippedUpdateVersion = select(({
      skippedUpdateVersion
    }) => skippedUpdateVersion);
    if (skippedUpdateVersion === version) {
      dispatch({
        type: UPDATES_NEW_VERSION_NOT_AVAILABLE
      });
      return;
    }
    dispatch({
      type: UPDATES_NEW_VERSION_AVAILABLE,
      payload: version
    });
  });
  electronUpdater.autoUpdater.addListener('update-not-available', () => {
    dispatch({
      type: UPDATES_NEW_VERSION_NOT_AVAILABLE
    });
  });
  const nativeUpdateDownloadedCallback = () => {
    electron.autoUpdater.removeListener('update-downloaded', nativeUpdateDownloadedCallback);
    electron.autoUpdater.quitAndInstall();
  };
  electronUpdater.autoUpdater.addListener('update-downloaded', async () => {
    const response = await askUpdateInstall();
    if (response === AskUpdateInstallResponse.INSTALL_LATER) {
      await warnAboutInstallUpdateLater();
      return;
    }
    try {
      setImmediate(() => {
        electron.app.removeAllListeners('window-all-closed');
        if (process.platform === 'darwin') {
          const allBrowserWindows = electron.BrowserWindow.getAllWindows();
          allBrowserWindows.forEach(browserWindow => {
            browserWindow.removeAllListeners('close');
            browserWindow.destroy();
          });
          electron.autoUpdater.checkForUpdates();
          electron.autoUpdater.on('update-downloaded', nativeUpdateDownloadedCallback);
        } else {
          electronUpdater.autoUpdater.quitAndInstall(true, true);
        }
      });
    } catch (error) {
      error instanceof Error && dispatch({
        type: UPDATES_ERROR_THROWN,
        payload: {
          message: error.message,
          stack: error.stack,
          name: error.name
        }
      });
    }
  });
  electronUpdater.autoUpdater.addListener('error', error => {
    dispatch({
      type: UPDATES_ERROR_THROWN,
      payload: {
        message: error.message,
        stack: error.stack,
        name: error.name
      }
    });
  });
  if (doCheckForUpdatesOnStartup) {
    try {
      await electronUpdater.autoUpdater.checkForUpdates();
    } catch (error) {
      error instanceof Error && dispatch({
        type: UPDATES_ERROR_THROWN,
        payload: {
          message: error.message,
          stack: error.stack,
          name: error.name
        }
      });
    }
  }
  listen(UPDATES_CHECK_FOR_UPDATES_REQUESTED, async () => {
    try {
      setTimeout(() => {
        electronUpdater.autoUpdater.checkForUpdates();
      }, 100);
    } catch (error) {
      error instanceof Error && dispatch({
        type: UPDATES_ERROR_THROWN,
        payload: {
          message: error.message,
          stack: error.stack,
          name: error.name
        }
      });
    }
  });
  listen(UPDATE_DIALOG_SKIP_UPDATE_CLICKED, async action => {
    await warnAboutUpdateSkipped();
    dispatch({
      type: UPDATE_SKIPPED,
      payload: action.payload
    });
  });
  listen(UPDATE_DIALOG_INSTALL_BUTTON_CLICKED, async () => {
    await warnAboutUpdateDownload();
    try {
      electronUpdater.autoUpdater.downloadUpdate();
    } catch (error) {
      error instanceof Error && dispatch({
        type: UPDATES_ERROR_THROWN,
        payload: {
          message: error.message,
          stack: error.stack,
          name: error.name
        }
      });
    }
  });
};

const SYSTEM_LOCKING_SCREEN = 'system/locking-screen';
const SYSTEM_SUSPENDING = 'system/suspending';

const setupPowerMonitor = () => {
  electron.powerMonitor.addListener('suspend', () => {
    dispatch({
      type: SYSTEM_SUSPENDING
    });
  });
  electron.powerMonitor.addListener('lock-screen', () => {
    dispatch({
      type: SYSTEM_LOCKING_SCREEN
    });
  });
  handle('power-monitor/get-system-idle-state', async (_webContents, idleThreshold) => electron.powerMonitor.getSystemIdleState(idleThreshold));
};

const start = async () => {
  performElectronStartup();

  // Set up GPU crash handler BEFORE whenReady to catch early GPU failures
  setupGpuCrashHandler();
  await electron.app.whenReady();
  createMainReduxStore();

  // Initialize screen capture fallback state after store is available
  initializeScreenCaptureFallbackState();

  // Set up electron-dl with our download tracking callbacks
  setupElectronDlWithTracking();
  const localStorage = await exportLocalStorage();
  await mergePersistableValues(localStorage);
  await setupServers(localStorage);
  i18n.setUp();
  await i18n.wait();
  setupApp();
  setupMainErrorHandling();
  createRootWindow();
  startOutlookCalendarUrlHandler();
  attachGuestWebContentsEvents();
  await showRootWindow();

  // React DevTools is currently incompatible with Electron 10
  // if ("production" === 'development') {
  //   installDevTools();
  // }
  watchMachineTheme();
  setupNotifications();
  attentionDrawing.setUp();
  setupScreenSharing();
  startVideoCallWindowHandler();
  await setupSpellChecking();
  setupDeepLinks();
  await setupNavigation();
  setupPowerMonitor();
  await setupUpdates();
  setupDownloads();
  handleCertificatesManager();
  dock.setUp();
  menuBar.setUp();
  touchBar.setUp();
  trayIcon.setUp();
  electron.app.addListener('before-quit', () => {
    dock.tearDown();
    menuBar.tearDown();
    touchBar.tearDown();
    trayIcon.tearDown();
    attentionDrawing.tearDown();
    cleanupVideoCallResources();
  });
  watchAndPersistChanges();
  handleJitsiDesktopCapturerGetSources();
  handleDesktopCapturerGetSources();
  handleClearCacheDialog();
  startDocumentViewerHandler();
  checkSupportedVersionServers();
  await processDeepLinksInArgs();
  console.log('Application initialization completed successfully');
};
start();

exports._defineProperty = _defineProperty;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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